/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.writer.cfsdatabasewriter;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.utils.DatabaseUtils;

public class TicketCategoryWriter
implements DataWriter {
    private ConnectionPool sqlDriver = null;
    private Connection db = null;
    private int level0Id = -1;
    private int level1Id = -1;
    private int level2Id = -1;
    private int level3Id = -1;
    private int level = 0;
    private String driver = null;
    private String url = null;
    private String user = null;
    private String pass = null;

    public void setDriver(String tmp) {
        this.driver = tmp;
    }

    public void setUrl(String tmp) {
        this.url = tmp;
    }

    public void setUser(String tmp) {
        this.user = tmp;
    }

    public void setPass(String tmp) {
        this.pass = tmp;
    }

    public void setAutoCommit(boolean flag) {
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "Ticket Category Writer";
    }

    public String getDescription() {
        return "Inserts data directly into a Centric CRM database";
    }

    public String getLastResponse() {
        return null;
    }

    public boolean isConfigured() {
        if (this.url == null) {
            return false;
        }
        try {
            this.sqlDriver = new ConnectionPool();
            this.sqlDriver.setForceClose(false);
            this.sqlDriver.setMaxConnections(1);
            ConnectionElement thisElement = new ConnectionElement(this.url, this.user, this.pass);
            thisElement.setDriver(this.driver);
            this.db = this.sqlDriver.getConnection(thisElement);
        }
        catch (SQLException e) {
            logger.info("Could not get database connection" + e.toString());
            return false;
        }
        return true;
    }

    public boolean save(DataRecord record) {
        try {
            int parentId = -1;
            parentId = DatabaseUtils.getNextSeq(this.db, "ticket_category_id_seq");
            PreparedStatement pst = this.db.prepareStatement("INSERT INTO ticket_category (" + (parentId > -1 ? "id, " : "") + "cat_level, parent_cat_code, description, " + DatabaseUtils.addQuotes(this.db, "level") + ", enabled) " + "VALUES " + "(" + (parentId > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
            int i = 0;
            if (parentId > -1) {
                pst.setInt(++i, parentId);
            }
            int catLevel = Integer.parseInt(record.getValue("catLevel"));
            pst.setInt(++i, catLevel);
            switch (catLevel) {
                case 0: {
                    pst.setInt(++i, 0);
                    break;
                }
                case 1: {
                    pst.setInt(++i, this.level0Id);
                    break;
                }
                case 2: {
                    pst.setInt(++i, this.level1Id);
                    break;
                }
                case 3: {
                    pst.setInt(++i, this.level2Id);
                    break;
                }
            }
            pst.setString(++i, record.getValue("description"));
            pst.setInt(++i, this.level++);
            pst.setBoolean(++i, true);
            pst.execute();
            pst.close();
            parentId = DatabaseUtils.getCurrVal(this.db, "ticket_category_id_seq", parentId);
            switch (catLevel) {
                case 0: {
                    this.level0Id = parentId;
                    break;
                }
                case 1: {
                    this.level1Id = parentId;
                    break;
                }
                case 2: {
                    this.level2Id = parentId;
                    break;
                }
                case 3: {
                    this.level3Id = parentId;
                    break;
                }
            }
        }
        catch (Exception ex) {
            logger.info(ex.toString());
            return false;
        }
        return true;
    }

    public boolean commit() {
        return true;
    }

    public boolean rollback() {
        return true;
    }

    public boolean load(DataRecord record) {
        return false;
    }

    public boolean close() {
        if (this.db != null) {
            try {
                this.db.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public void initialize() {
    }
}

