/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.transfer.writer.cfshttpxmlwriter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.aspcfs.apps.transfer.DataField;
import org.aspcfs.apps.transfer.DataRecord;
import org.aspcfs.apps.transfer.DataWriter;
import org.aspcfs.modules.service.base.TransactionStatus;
import org.aspcfs.utils.HTTPUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CFSHttpXMLWriter
implements DataWriter {
    private String url = null;
    private String id = null;
    private String code = null;
    private int systemId = -1;
    private int clientId = -1;
    private String username = null;
    private ArrayList transaction = new ArrayList();
    private ArrayList transactionMeta = new ArrayList();
    private boolean autoCommit = true;
    private int transactionCount = 0;
    private String lastResponse = null;
    private boolean ignoreClientId = false;

    public ArrayList getTransactionMeta() {
        return this.transactionMeta;
    }

    public void setTransactionMeta(ArrayList tmp) {
        this.transactionMeta = tmp;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String tmp) {
        this.username = tmp;
    }

    public void setUrl(String tmp) {
        this.url = tmp != null && tmp.indexOf("ProcessPacket.do") == -1 ? tmp + "/ProcessPacket.do" : tmp;
    }

    public void setId(String tmp) {
        this.id = tmp;
    }

    public void setCode(String tmp) {
        this.code = tmp;
    }

    public void setSystemId(int tmp) {
        this.systemId = tmp;
    }

    public void setSystemId(String tmp) {
        this.systemId = Integer.parseInt(tmp);
    }

    public void setClientId(int tmp) {
        this.clientId = tmp;
    }

    public void setClientId(String tmp) {
        this.clientId = Integer.parseInt(tmp);
    }

    public void setAutoCommit(boolean flag) {
        this.autoCommit = flag;
        if (this.autoCommit && this.transaction.size() > 0) {
            this.commit();
        }
    }

    public void setIgnoreClientId(boolean tmp) {
        this.ignoreClientId = tmp;
    }

    public void setIgnoreClientId(String tmp) {
        this.ignoreClientId = "true".equals(tmp);
    }

    public boolean getIgnoreClientId() {
        return this.ignoreClientId;
    }

    public String getUrl() {
        return this.url;
    }

    public String getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public int getSystemId() {
        return this.systemId;
    }

    public int getClientId() {
        return this.clientId;
    }

    public double getVersion() {
        return 1.0;
    }

    public String getName() {
        return "Centric CRM Web XML Data Writer";
    }

    public String getDescription() {
        return "Writes data to Centric CRM using the XML HTTP Web API";
    }

    public String getLastResponse() {
        return this.lastResponse;
    }

    public boolean isConfigured() {
        if (this.url == null || this.id == null || this.code == null || this.systemId == -1) {
            logger.info("Not configured correctly");
            return false;
        }
        if (this.ignoreClientId) {
            return true;
        }
        if (this.clientId == -1) {
            this.clientId = this.retrieveNewClientId();
            if (this.clientId == -1) {
                return false;
            }
        }
        return true;
    }

    public int retrieveNewClientId() {
        this.ignoreClientId = true;
        if (!this.isConfigured()) {
            return -1;
        }
        DataRecord clientRecord = new DataRecord();
        clientRecord.setName("syncClient");
        clientRecord.setAction("insert");
        clientRecord.addField("id", "-1");
        clientRecord.addField("type", "Java Centric CRM Http XML Writer");
        clientRecord.addField("code", this.code);
        clientRecord.addField("version", String.valueOf(this.getVersion()));
        this.save(clientRecord);
        try {
            System.out.println("CFSHttpXMLWriter-> " + this.lastResponse);
            XMLUtils responseXML = new XMLUtils(this.lastResponse, true);
            this.clientId = Integer.parseInt(XMLUtils.getNodeText(responseXML.getFirstElement("id")));
            this.ignoreClientId = true;
            return this.clientId;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            return -1;
        }
    }

    public boolean save(DataRecord record) {
        this.transaction.add(record);
        if (this.autoCommit) {
            return this.commit();
        }
        return true;
    }

    public boolean hasMetaInfo() {
        return this.transactionMeta != null && this.transactionMeta.size() > 0;
    }

    public boolean commit() {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.newDocument();
            Element app = document.createElement("app");
            document.appendChild(app);
            Element auth = document.createElement("authentication");
            app.appendChild(auth);
            Element authId = document.createElement("id");
            authId.appendChild(document.createTextNode(this.id));
            auth.appendChild(authId);
            if (this.username != null) {
                Element authUsername = document.createElement("username");
                authUsername.appendChild(document.createTextNode(this.username));
                auth.appendChild(authUsername);
            }
            Element authCode = document.createElement("code");
            authCode.appendChild(document.createTextNode(this.code));
            auth.appendChild(authCode);
            Element authSystemId = document.createElement("systemId");
            authSystemId.appendChild(document.createTextNode(String.valueOf(this.systemId)));
            auth.appendChild(authSystemId);
            if (this.clientId > -1) {
                Element authClientId = document.createElement("clientId");
                authClientId.appendChild(document.createTextNode(String.valueOf(this.clientId)));
                auth.appendChild(authClientId);
            }
            Element trans = document.createElement("transaction");
            trans.setAttribute("id", String.valueOf(++this.transactionCount));
            app.appendChild(trans);
            if (this.hasMetaInfo()) {
                Element meta = document.createElement("meta");
                trans.appendChild(meta);
                for (String prop : this.transactionMeta) {
                    Element property = document.createElement("property");
                    property.appendChild(document.createTextNode(prop));
                    meta.appendChild(property);
                }
            }
            Iterator dataRecordItems = this.transaction.iterator();
            int recordCount = 0;
            while (dataRecordItems.hasNext()) {
                DataRecord record = (DataRecord)dataRecordItems.next();
                Element meta = document.createElement("meta");
                if (++recordCount == 1 && !this.hasMetaInfo()) {
                    trans.appendChild(meta);
                }
                Element object = document.createElement(record.getName());
                object.setAttribute("action", record.getAction());
                if (record.getShareKey()) {
                    object.setAttribute("shareKey", "true");
                }
                trans.appendChild(object);
                for (DataField thisField : record) {
                    if (recordCount == 1 && !this.hasMetaInfo()) {
                        Element property = document.createElement("property");
                        property.appendChild(document.createTextNode(thisField.getName()));
                        meta.appendChild(property);
                    }
                    Element field = null;
                    field = thisField.hasAlias() ? document.createElement(thisField.getAlias()) : document.createElement(thisField.getName());
                    if (thisField.hasValueLookup()) {
                        field.setAttribute("lookup", thisField.getValueLookup());
                    }
                    if (thisField.hasValue()) {
                        field.appendChild(document.createCDATASection(thisField.getValue()));
                    }
                    object.appendChild(field);
                }
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("object-validation", "false");
            this.lastResponse = HTTPUtils.sendPacket(this.url, XMLUtils.toString(document), headers);
            if (this.responseStatus(this.lastResponse) == 1) {
                return false;
            }
            this.transaction.clear();
            this.setAutoCommit(true);
        }
        catch (Exception ex) {
            logger.info(ex.toString());
            ex.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    protected int responseStatus(String lastResponse) {
        try {
            XMLUtils xmlUtils = new XMLUtils(lastResponse);
            Element element = xmlUtils.getDocumentElement();
            if (element != null) {
                TransactionStatus status = new TransactionStatus(XMLUtils.getFirstElement(element, "response"));
                return status.getStatusCode();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 1;
    }

    public boolean rollback() {
        this.transaction.clear();
        return true;
    }

    public boolean load(DataRecord record) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.newDocument();
            Element app = document.createElement("app");
            document.appendChild(app);
            Element auth = document.createElement("authentication");
            app.appendChild(auth);
            Element authId = document.createElement("id");
            authId.appendChild(document.createTextNode(this.id));
            auth.appendChild(authId);
            if (this.username != null) {
                Element authUsername = document.createElement("username");
                authUsername.appendChild(document.createTextNode(this.username));
                auth.appendChild(authUsername);
            }
            Element authCode = document.createElement("code");
            authCode.appendChild(document.createTextNode(this.code));
            auth.appendChild(authCode);
            Element authSystemId = document.createElement("systemId");
            authSystemId.appendChild(document.createTextNode(String.valueOf(this.systemId)));
            auth.appendChild(authSystemId);
            if (this.clientId > -1) {
                Element authClientId = document.createElement("clientId");
                authClientId.appendChild(document.createTextNode(String.valueOf(this.clientId)));
                auth.appendChild(authClientId);
            }
            Element transaction = document.createElement("transaction");
            transaction.setAttribute("id", String.valueOf(++this.transactionCount));
            app.appendChild(transaction);
            Element meta = document.createElement("meta");
            transaction.appendChild(meta);
            if (this.hasMetaInfo()) {
                for (String prop : this.transactionMeta) {
                    Element property = document.createElement("property");
                    property.appendChild(document.createTextNode(prop));
                    meta.appendChild(property);
                }
            }
            Element object = document.createElement(record.getName());
            object.setAttribute("action", record.getAction());
            transaction.appendChild(object);
            for (DataField thisField : record) {
                if (!this.hasMetaInfo()) {
                    Element property = document.createElement("property");
                    property.appendChild(document.createTextNode(thisField.getName()));
                    meta.appendChild(property);
                    continue;
                }
                if (!thisField.hasValue()) continue;
                Element field = document.createElement(thisField.getName());
                field.appendChild(document.createTextNode(thisField.getValue()));
                object.appendChild(field);
            }
            this.lastResponse = HTTPUtils.sendPacket(this.url, XMLUtils.toString(document));
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            this.lastResponse = "Exception: " + e.getMessage();
        }
        return true;
    }

    public boolean close() {
        return true;
    }

    public void initialize() {
    }
}

