/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.users;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.utils.AppUtils;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.SiteUtils;

public class UserCleanup {
    private HashMap config = new HashMap();
    private ArrayList taskList = new ArrayList();
    public static final String fs = System.getProperty("file.separator");
    public static final String lf = System.getProperty("line.separator");

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: UserCleanup [config file]");
            System.out.println("ExitValue: 2");
            System.exit(0);
        }
        System.setProperty("DEBUG", "2");
        UserCleanup thisCleanup = new UserCleanup();
        thisCleanup.execute(args);
        System.exit(0);
    }

    public static void doTask(String[] args) {
        if (args.length == 0) {
            System.out.println("Usage: UserCleanup [config file]");
            System.out.println("ExitValue: 2");
        } else {
            UserCleanup thisCleanup = new UserCleanup();
            thisCleanup.execute(args);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("UserCleanup ExitValue: 0");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String[] args) {
        String filename = args[0];
        this.taskList.add("org.aspcfs.apps.users.task.ProcessUserCleanup");
        AppUtils.loadConfig(filename, this.config);
        if (this.config.containsKey("FILELIBRARY")) {
            String baseName = (String)this.config.get("GATEKEEPER.URL");
            String dbUser = (String)this.config.get("GATEKEEPER.USER");
            String dbPass = (String)this.config.get("GATEKEEPER.PASSWORD");
            Connection db = null;
            try {
                SiteList siteList = SiteUtils.getSiteList(this.config);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("UserCleanup-> Processing each site");
                }
                for (Site thisSite : siteList) {
                    Class.forName(thisSite.getDatabaseDriver());
                    db = DatabaseUtils.getConnection(thisSite.getDatabaseUrl(), thisSite.getDatabaseUsername(), thisSite.getDatabasePassword());
                    baseName = thisSite.getSiteCode();
                    Iterator classes = this.taskList.iterator();
                    while (classes.hasNext()) {
                        try {
                            Class<?> thisClass = Class.forName((String)classes.next());
                            Class[] paramClass = new Class[]{Class.forName("java.sql.Connection"), Class.forName("java.lang.String")};
                            Constructor<?> constructor = thisClass.getConstructor(paramClass);
                            Object[] paramObject = new Object[]{db, args[1]};
                            Object theTask = constructor.newInstance(paramObject);
                            theTask = null;
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.out);
                        }
                    }
                    db.close();
                }
            }
            catch (Exception exc) {
                exc.printStackTrace(System.out);
                System.err.println("UserCleanup-> Error: " + exc.toString());
            }
            finally {
                if (db != null) {
                    try {
                        db.close();
                        db = null;
                    }
                    catch (Exception e) {}
                }
            }
        }
    }
}

