/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.users.task;

import com.zeroio.iteam.base.AssignmentList;
import java.sql.Connection;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.accounts.base.RevenueList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.contacts.base.CallList;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.pipeline.base.OpportunityList;
import org.aspcfs.modules.troubletickets.base.TicketList;

public class ProcessUserCleanup {
    public static final String fs = System.getProperty("file.separator");

    public ProcessUserCleanup(Connection db, String url) throws Exception {
        ProcessUserCleanup temp = new ProcessUserCleanup(db, (SystemStatus)null);
        temp = null;
    }

    public ProcessUserCleanup(Connection db, SystemStatus thisSystem) throws Exception {
        UserList users = null;
        UserList expiredUsers = null;
        UserList disabledUsers = null;
        disabledUsers = new UserList();
        disabledUsers.setEnabled(0);
        disabledUsers.buildList(db);
        expiredUsers = new UserList();
        expiredUsers.setExpired(1);
        expiredUsers.buildList(db);
        users = new UserList();
        if (disabledUsers.size() > 0) {
            users.addAll(disabledUsers);
        }
        if (expiredUsers.size() > 0) {
            users.addAll(expiredUsers);
        }
        boolean flag = false;
        for (User thisUser : users) {
            if (this.checkUser(db, thisUser.getId())) {
                if (thisUser.getHidden()) continue;
                thisUser.setHidden(true);
                thisUser.update(db);
                flag = true;
                continue;
            }
            if (!thisUser.getHidden()) continue;
            thisUser.setHidden(false);
            thisUser.update(db);
            flag = true;
        }
        if (flag) {
            try {
                if (thisSystem != null) {
                    thisSystem.updateHierarchy(db);
                }
                System.out.println("ExitValue: 0");
            }
            catch (Exception e) {
                System.out.println("ExitValue: 1");
            }
        }
    }

    public boolean checkUser(Connection db, int userId) throws Exception {
        int valid = 0;
        OrganizationList sourceAccounts = null;
        ContactList sourceContacts = null;
        UserList sourceUsers = null;
        TicketList sourceOpenTickets = null;
        RevenueList sourceRevenue = null;
        AssignmentList sourceAssignments = null;
        OpportunityList sourceOpportunities = null;
        OpportunityList sourceOpenOpportunities = null;
        CallList sourceActivities = null;
        sourceAccounts = new OrganizationList();
        sourceAccounts.setOwnerId(userId);
        sourceAccounts.buildList(db);
        valid += sourceAccounts.size();
        sourceContacts = new ContactList();
        sourceContacts.setOwner(userId);
        sourceContacts.setIncludeAllSites(true);
        sourceContacts.setBuildDetails(false);
        sourceContacts.setBuildTypes(false);
        sourceContacts.buildList(db);
        valid += sourceContacts.size();
        sourceUsers = new UserList();
        sourceUsers.setManagerId(userId);
        sourceUsers.buildList(db);
        valid += sourceUsers.size();
        sourceOpenTickets = new TicketList();
        sourceOpenTickets.setAssignedTo(userId);
        sourceOpenTickets.setIncludeAllSites(true);
        sourceOpenTickets.setOnlyOpen(true);
        sourceOpenTickets.buildList(db);
        valid += sourceOpenTickets.size();
        sourceRevenue = new RevenueList();
        sourceRevenue.setOwner(userId);
        sourceRevenue.buildList(db);
        valid += sourceRevenue.size();
        sourceAssignments = new AssignmentList();
        sourceAssignments.setAssignmentsForUser(userId);
        sourceAssignments.setIncompleteOnly(true);
        sourceAssignments.buildList(db);
        valid += sourceAssignments.size();
        sourceOpportunities = new OpportunityList();
        sourceOpportunities.setOwner(userId);
        sourceOpportunities.buildList(db);
        valid += sourceOpportunities.size();
        sourceOpenOpportunities = new OpportunityList();
        sourceOpenOpportunities.setOwner(userId);
        sourceOpenOpportunities.setQueryOpenOnly(true);
        sourceOpenOpportunities.buildList(db);
        valid += sourceOpenOpportunities.size();
        sourceActivities = new CallList();
        sourceActivities.setOwner(userId);
        sourceActivities.buildList(db);
        return (valid += sourceActivities.size()) == 0;
    }
}

