/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.apps.workFlowManager.BusinessProcessComponent;
import org.aspcfs.apps.workFlowManager.BusinessProcessComponentList;
import org.aspcfs.apps.workFlowManager.ProcessParameter;
import org.aspcfs.apps.workFlowManager.ProcessParameterList;
import org.aspcfs.apps.workFlowManager.ScheduledEvent;
import org.aspcfs.apps.workFlowManager.ScheduledEventList;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class BusinessProcess {
    public static final int OBJECT_EVENT = 1;
    public static final int SCHEDULED_EVENT = 2;
    private int id = -1;
    private String name = null;
    private String description = null;
    private int type = 1;
    private int linkModuleId = -1;
    private String linkModule = null;
    private int startId = -1;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private boolean enabled = false;
    private BusinessProcessComponentList components = null;
    private ProcessParameterList parameters = null;
    private ScheduledEventList events = null;
    private boolean buildScheduledEvents = false;
    private boolean isApplication = false;

    public BusinessProcess() {
    }

    public BusinessProcess(Connection db, int processId) throws SQLException {
        this.queryRecord(db, processId);
    }

    public BusinessProcess(Element processElement) {
        this.buildBusinessProcess(processElement);
    }

    public BusinessProcess(Element processElement, boolean isApp) {
        this.setIsApplication(isApp);
        this.buildBusinessProcess(processElement);
    }

    public void buildBusinessProcess(Element processElement) {
        Element parameters;
        this.setName(processElement.getAttribute("name"));
        this.setDescription(processElement.getAttribute("description"));
        this.setType(processElement.getAttribute("type"));
        this.linkModule = processElement.getAttribute("module");
        this.setStartId(processElement.getAttribute("startId"));
        this.setEntered(processElement.getAttribute("entered"));
        this.setModified(processElement.getAttribute("modified"));
        this.setEnabled(processElement.getAttribute("enabled"));
        this.components = new BusinessProcessComponentList();
        Element componentElements = XMLUtils.getFirstElement(processElement, "components");
        if (componentElements != null) {
            ArrayList componentNodes = XMLUtils.getElements(componentElements, "component");
            for (Element componentElement : componentNodes) {
                BusinessProcessComponent thisComponent = new BusinessProcessComponent(componentElement);
                this.components.put(new Integer(thisComponent.getId()), thisComponent);
            }
            this.linkComponents();
        }
        if ((parameters = XMLUtils.getFirstElement(processElement, "parameters")) != null) {
            ArrayList parameterNodes = XMLUtils.getElements(parameters, "parameter");
            for (Element parameterElement : parameterNodes) {
                String parameterEnabled = parameterElement.getAttribute("enabled");
                if (parameterEnabled == null || parameterEnabled.equals("false")) continue;
                ProcessParameter thisParameter = new ProcessParameter(parameterElement);
                if (this.parameters == null) {
                    this.parameters = new ProcessParameterList();
                }
                this.parameters.add(thisParameter);
            }
        }
    }

    public BusinessProcess(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        this.type = tmp == null ? 1 : ("OBJECT_EVENT".equals(tmp) ? 1 : ("SCHEDULED_EVENT".equals(tmp) ? 2 : Integer.parseInt(tmp)));
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public String getLinkModule() {
        return this.linkModule;
    }

    public void setLinkModule(String tmp) {
        this.linkModule = tmp;
    }

    public void setStartId(int tmp) {
        this.startId = tmp;
    }

    public void setStartId(String tmp) {
        this.startId = DatabaseUtils.parseInt(tmp, -1);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = !"OFF".equalsIgnoreCase(tmp) && !"FALSE".equalsIgnoreCase(tmp) && !"0".equals(tmp);
    }

    public void setComponents(BusinessProcessComponentList tmp) {
        this.components = tmp;
    }

    public void setParameters(ProcessParameterList tmp) {
        this.parameters = tmp;
    }

    public void setEvents(ScheduledEventList tmp) {
        this.events = tmp;
    }

    public void setBuildScheduledEvents(boolean tmp) {
        this.buildScheduledEvents = tmp;
    }

    public void setBuildScheduledEvents(String tmp) {
        this.buildScheduledEvents = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public int getStartId() {
        return this.startId;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public BusinessProcessComponentList getComponents() {
        return this.components;
    }

    public ProcessParameterList getParameters() {
        return this.parameters;
    }

    public ScheduledEventList getEvents() {
        return this.events;
    }

    public boolean getBuildScheduledEvents() {
        return this.buildScheduledEvents;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    public boolean getIsApplication() {
        return this.isApplication;
    }

    public void setIsApplication(boolean tmp) {
        this.isApplication = tmp;
    }

    public void setIsApplication(String tmp) {
        this.isApplication = DatabaseUtils.parseBoolean(tmp);
    }

    public BusinessProcessComponent getComponent(int componentId) {
        return (BusinessProcessComponent)this.components.get(new Integer(componentId));
    }

    private void linkComponents() {
        for (BusinessProcessComponent thisComponent : this.components.values()) {
            BusinessProcessComponent parent;
            thisComponent.setProcessType(this.type);
            if (thisComponent.getParentId() <= 0 || (parent = (BusinessProcessComponent)this.components.get(new Integer(thisComponent.getParentId()))) == null) continue;
            parent.addChild(thisComponent);
            thisComponent.setParent(parent);
        }
    }

    public void queryRecord(Connection db, int processId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT * FROM business_process WHERE process_id = ? ");
        pst.setInt(1, processId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("process_id");
        this.name = rs.getString("process_name");
        this.description = rs.getString("description");
        this.type = rs.getInt("type_id");
        this.linkModuleId = rs.getInt("link_module_id");
        this.startId = rs.getInt("component_start_id");
        this.enabled = rs.getBoolean("enabled");
    }

    public void buildResources(Connection db) throws SQLException {
        this.components = new BusinessProcessComponentList();
        this.components.setProcessId(this.id);
        this.components.buildList(db);
        this.linkComponents();
        this.parameters = new ProcessParameterList();
        this.parameters.setProcessId(this.id);
        this.parameters.buildList(db);
        if (this.buildScheduledEvents) {
            this.events = new ScheduledEventList();
            this.events.setBusinessProcessId(this.id);
            this.events.buildList(db);
        }
    }

    public void insert(Connection db) throws SQLException {
        if (this.isApplication) {
            return;
        }
        boolean autoCommit = db.getAutoCommit();
        try {
            if (autoCommit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("SELECT process_id FROM business_process WHERE process_name = ? ");
            pst.setString(1, this.name);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                this.id = DatabaseUtils.getInt(rs, "process_id");
            }
            rs.close();
            pst.close();
            if (this.linkModuleId == -1 && this.linkModule != null && !this.linkModule.equals("")) {
                this.linkModuleId = PermissionCategory.lookupId(db, Integer.parseInt(this.linkModule));
            }
            if (this.id == -1) {
                this.id = DatabaseUtils.getNextSeq(db, "business_process_process_id_seq");
                pst = db.prepareStatement("INSERT INTO business_process (" + (this.id > -1 ? "process_id, " : "") + "process_name, description, type_id, link_module_id, " + "component_start_id, enabled) VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?)");
                int i = 0;
                if (this.id > -1) {
                    pst.setInt(++i, this.id);
                }
                pst.setString(++i, this.name);
                pst.setString(++i, this.description);
                pst.setInt(++i, this.type);
                pst.setInt(++i, this.linkModuleId);
                DatabaseUtils.setInt(pst, ++i, -1);
                pst.setBoolean(++i, this.enabled);
                pst.execute();
                pst.close();
                this.id = DatabaseUtils.getCurrVal(db, "business_process_process_id_seq", this.id);
                if (this.getType() == 2 && this.getEvents() != null && this.getEvents().size() > 0) {
                    for (ScheduledEvent event : this.getEvents()) {
                        event.setProcessId(this.getId());
                        event.insert(db);
                    }
                }
                if (this.parameters != null) {
                    this.parameters.setProcessId(this.id);
                    this.parameters.insert(db);
                }
                BusinessProcessComponent startComponent = (BusinessProcessComponent)this.components.get(new Integer(this.startId));
                startComponent.setProcessId(this.id);
                startComponent.insert(db);
                this.insertChildren(db, startComponent);
                pst = db.prepareStatement("UPDATE business_process SET component_start_id = ? WHERE process_id = ? ");
                pst.setInt(1, startComponent.getId());
                pst.setInt(2, this.id);
                pst.executeUpdate();
                pst.close();
            }
            if (autoCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (autoCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (autoCommit) {
                db.setAutoCommit(true);
            }
        }
    }

    private void insertChildren(Connection db, BusinessProcessComponent component) throws SQLException {
        if (component.getChildren() != null) {
            for (BusinessProcessComponent child : component.getAllChildren()) {
                child.setProcessId(this.id);
                child.setParentId(component.getId());
                child.insert(db);
                this.insertChildren(db, child);
            }
        }
    }

    public void delete(Connection db) throws SQLException {
        boolean autoCommit = db.getAutoCommit();
        if (autoCommit) {
            db.setAutoCommit(false);
        }
        try {
            PreparedStatement pst = db.prepareStatement("SELECT process_id FROM business_process WHERE process_name = ? ");
            pst.setString(1, this.name);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                this.id = rs.getInt("process_id");
            }
            rs.close();
            pst.close();
            this.parameters = new ProcessParameterList();
            this.parameters.setProcessId(this.id);
            this.parameters.buildList(db);
            this.parameters.delete(db);
            this.events = new ScheduledEventList();
            this.events.setBusinessProcessId(this.getId());
            this.events.buildList(db);
            this.events.delete(db);
            BusinessProcessComponent startComponent = (BusinessProcessComponent)this.components.get(new Integer(this.startId));
            this.deleteComponentChildren(db, startComponent);
            pst = db.prepareStatement("DELETE  FROM business_process_hook WHERE process_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE  FROM business_process WHERE process_id = ? ");
            pst.setInt(1, this.id);
            pst.execute();
            pst.close();
            if (autoCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (autoCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (autoCommit) {
                db.setAutoCommit(true);
            }
        }
    }

    private void deleteComponentChildren(Connection db, BusinessProcessComponent component) throws SQLException {
        if (component.getChildren() != null) {
            for (BusinessProcessComponent child : component.getAllChildren()) {
                child.setProcessId(this.id);
                child.setParentId(component.getId());
                this.deleteComponentChildren(db, child);
            }
            component.delete(db);
        }
    }
}

