/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.apps.workFlowManager.ComponentParameter;
import org.aspcfs.apps.workFlowManager.ComponentParameterList;
import org.aspcfs.apps.workFlowManager.ComponentResult;
import org.aspcfs.apps.workFlowManager.LibraryComponent;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class BusinessProcessComponent {
    private int id = -1;
    private int parentId = 0;
    private int parentResult = -1;
    private int processId = -1;
    private int componentId = -1;
    private boolean enabled = true;
    private int processType = -1;
    private ComponentParameterList parameters = null;
    private BusinessProcessComponent parent = null;
    private HashMap children = null;
    private String name = null;
    private String className = null;
    private String description = null;

    public BusinessProcessComponent() {
    }

    public BusinessProcessComponent(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public BusinessProcessComponent(Element componentElement) {
        this.setId(componentElement.getAttribute("id"));
        this.setParentId(componentElement.getAttribute("parent"));
        this.setParentResult(componentElement.getAttribute("if"));
        this.setClassName(componentElement.getAttribute("class"));
        this.setName(this.className);
        this.setDescription(componentElement.getAttribute("description"));
        this.setEnabled(componentElement.getAttribute("enabled"));
        Element parameters = XMLUtils.getFirstElement(componentElement, "parameters");
        if (parameters != null) {
            ArrayList parameterNodes = XMLUtils.getElements(parameters, "parameter");
            for (Element parameterElement : parameterNodes) {
                String parameterEnabled = parameterElement.getAttribute("enabled");
                ComponentParameter thisParameter = new ComponentParameter(parameterElement);
                if (this.parameters == null) {
                    this.parameters = new ComponentParameterList();
                }
                this.parameters.add(thisParameter);
            }
        }
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = DatabaseUtils.parseInt(tmp, -1);
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = DatabaseUtils.parseInt(tmp, 0);
    }

    public void setParentResult(int tmp) {
        this.parentResult = tmp;
    }

    public void setParentResult(String tmp) {
        this.parentResult = "false".equals(tmp) ? 0 : ("true".equals(tmp) ? 1 : -1);
    }

    public void setProcessId(int tmp) {
        this.processId = tmp;
    }

    public void setProcessId(String tmp) {
        this.processId = Integer.parseInt(tmp);
    }

    public void setComponentId(int tmp) {
        this.componentId = tmp;
    }

    public void setProcessType(int tmp) {
        this.processType = tmp;
    }

    public void setProcessType(String tmp) {
        this.processType = Integer.parseInt(tmp);
    }

    public void setComponentId(String tmp) {
        this.componentId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setClassName(String tmp) {
        this.className = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp) || tmp == null || "".equals(tmp);
    }

    public void setParameters(ComponentParameterList tmp) {
        this.parameters = tmp;
    }

    public void setParent(BusinessProcessComponent tmp) {
        this.parent = tmp;
    }

    public void setChildren(HashMap tmp) {
        this.children = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public int getParentResult() {
        return this.parentResult;
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public int getProcessType() {
        return this.processType;
    }

    public String getName() {
        return this.name;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public ComponentParameterList getParameters() {
        return this.parameters;
    }

    public BusinessProcessComponent getParent() {
        return this.parent;
    }

    public HashMap getChildren() {
        if (this.children == null) {
            this.children = new HashMap();
        }
        return this.children;
    }

    public ArrayList getChildren(boolean result) {
        ArrayList listToReturn = new ArrayList();
        if (this.children != null) {
            ArrayList matching;
            ArrayList indifferent = (ArrayList)this.children.get(new Integer(-1));
            if (indifferent != null) {
                listToReturn.addAll(indifferent);
            }
            if ((matching = (ArrayList)this.children.get(new Integer(result ? 1 : 0))) != null) {
                listToReturn.addAll(matching);
            }
        }
        return listToReturn;
    }

    public ArrayList getAllChildren() {
        ArrayList listToReturn = new ArrayList();
        if (this.children != null) {
            for (ArrayList resultChildren : this.children.values()) {
                listToReturn.addAll(resultChildren);
            }
        }
        return listToReturn;
    }

    public boolean hasParameters() {
        return this.parameters != null && this.parameters.size() > 0;
    }

    public void addChild(BusinessProcessComponent childComponent) {
        ArrayList<BusinessProcessComponent> results;
        if (this.children == null) {
            this.children = new HashMap();
        }
        if ((results = (ArrayList<BusinessProcessComponent>)this.children.get(new Integer(childComponent.getParentResult()))) == null) {
            results = new ArrayList<BusinessProcessComponent>();
            this.children.put(new Integer(childComponent.getParentResult()), results);
        }
        results.add(childComponent);
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.processId = rs.getInt("process_id");
        this.componentId = rs.getInt("component_id");
        this.parentId = DatabaseUtils.getInt(rs, "parent_id", 0);
        this.parentResult = DatabaseUtils.getInt(rs, "parent_result_id");
        this.enabled = rs.getBoolean("enabled");
        this.name = rs.getString("component_name");
        this.className = rs.getString("class_name");
        this.description = rs.getString("description");
    }

    protected void buildResources(Connection db) throws SQLException {
        this.parameters = new ComponentParameterList();
        this.parameters.setComponentId(this.id);
        this.parameters.buildList(db);
    }

    public void insert(Connection db) throws SQLException {
        PreparedStatement pst;
        if (this.componentId == -1) {
            try {
                Object classRef = Class.forName(this.className).newInstance();
                this.description = ObjectUtils.getParam(classRef, "description");
                classRef = null;
            }
            catch (Exception classEx) {
                this.description = this.className;
            }
            LibraryComponent libraryComponent = new LibraryComponent();
            libraryComponent.setName(this.name);
            libraryComponent.setTypeId(this.processType);
            libraryComponent.setClassName(this.className);
            libraryComponent.setDescription(this.description);
            libraryComponent.setEnabled(true);
            libraryComponent.insert(db);
            this.componentId = libraryComponent.getId();
        }
        boolean doInsert = false;
        if (this.parent != null) {
            if (this.parentResult > -1) {
                ComponentResult result = new ComponentResult();
                result.setComponentId(this.parent.getComponentId());
                result.setReturnId(this.parentResult);
                result.setDescription(this.parentResult == 1 ? "Yes" : "No");
                result.setReturnId(this.parentResult == 1 ? 1 : 0);
                result.setLevel(this.parentResult == 1 ? 0 : 1);
                result.setEnabled(true);
                result.insert(db);
                doInsert = true;
            } else {
                pst = db.prepareStatement("SELECT id FROM business_process_component WHERE process_id = ? AND component_id = ? AND parent_id = ? AND parent_result_id IS NULL ");
                pst.setInt(1, this.processId);
                pst.setInt(2, this.componentId);
                pst.setInt(3, this.parent.getId());
                ResultSet rs = pst.executeQuery();
                if (rs.next()) {
                    this.id = rs.getInt("id");
                    doInsert = false;
                } else {
                    doInsert = true;
                }
                rs.close();
                pst.close();
            }
        } else {
            doInsert = true;
        }
        if (doInsert) {
            this.id = DatabaseUtils.getNextSeq(db, "business_process_compone_id_seq");
            pst = db.prepareStatement("INSERT INTO business_process_component (" + (this.id > -1 ? "id, " : "") + "process_id, component_id, parent_id, parent_result_id, enabled) " + "VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?)");
            int i = 0;
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.processId);
            pst.setInt(++i, this.componentId);
            if (this.parent != null) {
                pst.setInt(++i, this.parent.getId());
            } else {
                pst.setNull(++i, 4);
            }
            DatabaseUtils.setInt(pst, ++i, this.parentResult);
            pst.setBoolean(++i, this.enabled);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "business_process_compone_id_seq", this.id);
            if (this.parameters != null) {
                this.parameters.setComponentId(this.id);
                this.parameters.insert(db);
            }
        }
    }

    public void delete(Connection db) throws SQLException {
        this.parameters = new ComponentParameterList();
        this.parameters.setComponentId(this.id);
        this.parameters.buildList(db);
        this.parameters.delete(db);
        System.out.println(" Deleting parameter list ");
        PreparedStatement pst = db.prepareStatement("DELETE FROM business_process_component WHERE id = ? ");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("=[Business Process Component]================================\r\n");
        sb.append(" id: " + this.id + "\r\n");
        sb.append(" parentId: " + this.parentId + "\r\n");
        sb.append(" parentResult: " + this.parentResult + "\r\n");
        sb.append(" processId: " + this.processId + "\r\n");
        sb.append(" componentId: " + this.componentId + "\r\n");
        sb.append(" enabled: " + this.enabled + "\r\n");
        sb.append(" processType: " + this.processType + "\r\n");
        sb.append(" name: " + this.name + "\r\n");
        sb.append(" className: " + this.className + "\r\n");
        sb.append(" description: " + this.description + "\r\n");
        if (this.children != null) {
            sb.append(" children:");
            for (BusinessProcessComponent child : this.children.keySet()) {
                sb.append(" " + child.getId());
            }
            sb.append("\r\n");
        }
        return sb.toString();
    }
}

