/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.apps.workFlowManager.BusinessProcessComponent;
import org.aspcfs.utils.DatabaseUtils;

public class BusinessProcessComponentList
extends HashMap {
    private int enabled = -1;
    private int processId = -1;
    private int componentId = -1;

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setProcessId(int tmp) {
        this.processId = tmp;
    }

    public void setProcessId(String tmp) {
        this.processId = Integer.parseInt(tmp);
    }

    public void setComponentId(int tmp) {
        this.componentId = tmp;
    }

    public void setComponentId(String tmp) {
        this.componentId = Integer.parseInt(tmp);
    }

    public int getEnabled() {
        return this.enabled;
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public void buildList(Connection db) throws SQLException {
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT c.id, c.process_id, c.component_id, c.parent_id, c.parent_result_id, c.enabled, cl.component_name, cl.class_name, cl.description FROM business_process_component c, " + DatabaseUtils.getTableName(db, "business_process_component_library") + " cl " + "WHERE c.id > 0 " + "AND c.component_id = cl.component_id ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY id ");
        PreparedStatement pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            BusinessProcessComponent thisComponent = new BusinessProcessComponent(rs);
            this.put(new Integer(thisComponent.getId()), thisComponent);
        }
        rs.close();
        pst.close();
        for (BusinessProcessComponent thisComponent : this.values()) {
            thisComponent.buildResources(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.processId > -1) {
            sqlFilter.append("AND process_id = ? ");
        }
        if (this.componentId > -1) {
            sqlFilter.append("AND component_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.processId > -1) {
            pst.setInt(++i, this.processId);
        }
        if (this.componentId > -1) {
            pst.setInt(++i, this.componentId);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        return i;
    }
}

