/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.apps.workFlowManager.BusinessProcessList;
import org.aspcfs.apps.workFlowManager.ScheduledEventList;
import org.aspcfs.controller.objectHookManager.ObjectHookList;
import org.w3c.dom.Element;

public class BusinessProcessImporter {
    private ObjectHookList hooks = null;
    private BusinessProcessList processes = null;
    private ScheduledEventList events = null;

    public ObjectHookList getHooks() {
        return this.hooks;
    }

    public void setHooks(ObjectHookList tmp) {
        this.hooks = tmp;
    }

    public BusinessProcessList getProcesses() {
        return this.processes;
    }

    public void setProcesses(BusinessProcessList tmp) {
        this.processes = tmp;
    }

    public ScheduledEventList getEvents() {
        return this.events;
    }

    public void setEvents(ScheduledEventList tmp) {
        this.events = tmp;
    }

    public synchronized boolean deleteProcesses(Connection db) throws SQLException {
        this.processes = new BusinessProcessList();
        this.processes.buildList(db);
        this.processes.delete(db);
        this.processes = null;
        return true;
    }

    public int parseXML(Element element) {
        this.processes.parse(element, false);
        int finalSize = this.processes.values().size();
        this.events.parse(element);
        this.events.buildResources(this.processes);
        this.hooks.parse(element, false);
        return finalSize;
    }

    public synchronized int execute(Connection db, Element element) throws SQLException {
        int numberOfProcesses;
        if (this.processes == null) {
            this.processes = new BusinessProcessList();
        }
        if (this.hooks == null) {
            this.hooks = new ObjectHookList();
        }
        if (this.events == null) {
            this.events = new ScheduledEventList();
        }
        if ((numberOfProcesses = this.parseXML(element)) > 0) {
            this.processes.insert(db);
            this.hooks.insert(db);
        }
        return numberOfProcesses;
    }

    public int buildEventList(Connection db) throws SQLException {
        this.events = new ScheduledEventList();
        this.events.buildList(db);
        return this.events.size();
    }
}

