/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.apps.workFlowManager.BusinessProcess;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class BusinessProcessList
extends HashMap {
    private int enabled = -1;
    private int typeId = -1;
    private int linkModuleId = -1;
    private boolean isApplication = false;
    private boolean buildScheduledEvents = false;

    public BusinessProcessList() {
    }

    public BusinessProcessList(Element processes) {
        this.process(processes, false);
    }

    public BusinessProcessList(Element processes, boolean isApp) {
        this.setIsApplication(isApp);
        this.process(processes, isApp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public void setBuildScheduledEvents(boolean tmp) {
        this.buildScheduledEvents = tmp;
    }

    public void setBuildScheduledEvents(String tmp) {
        this.buildScheduledEvents = DatabaseUtils.parseBoolean(tmp);
    }

    public int getEnabled() {
        return this.enabled;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public boolean getBuildScheduledEvents() {
        return this.buildScheduledEvents;
    }

    public boolean getIsApplication() {
        return this.isApplication;
    }

    public void setIsApplication(boolean tmp) {
        this.isApplication = tmp;
    }

    public void setIsApplication(String tmp) {
        this.isApplication = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean buildList(File xmlFile) {
        try {
            XMLUtils xml = new XMLUtils(xmlFile);
            return this.parse(xml.getDocumentElement(), false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public boolean buildList(File xmlFile, boolean isApp) {
        try {
            XMLUtils xml = new XMLUtils(xmlFile);
            return this.parse(xml.getDocumentElement(), isApp);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public boolean parse(Element element, boolean isApp) {
        if (element == null) {
            return false;
        }
        try {
            Element processes = XMLUtils.getFirstElement(element, "processes");
            if (processes != null) {
                this.process(processes, isApp);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    private void process(Element processes, boolean isApp) {
        ArrayList processNodes = XMLUtils.getElements(processes, "process");
        for (Element processElement : processNodes) {
            BusinessProcess thisProcess = new BusinessProcess(processElement, isApp);
            this.put(thisProcess.getName(), thisProcess);
            if (System.getProperty("DEBUG") == null) continue;
            System.out.println("BusinessProcessList-> Added: " + thisProcess.getName());
        }
    }

    public void buildList(Connection db) throws SQLException {
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT process_id, process_name, description, type_id, link_module_id, component_start_id, enabled FROM business_process WHERE process_id > 0 ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY process_id ");
        PreparedStatement pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            BusinessProcess thisProcess = new BusinessProcess(rs);
            this.put(thisProcess.getName(), thisProcess);
        }
        rs.close();
        pst.close();
        for (BusinessProcess thisProcess : this.values()) {
            thisProcess.setBuildScheduledEvents(this.buildScheduledEvents);
            thisProcess.buildResources(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.typeId > -1) {
            sqlFilter.append("AND type_id = ? ");
        }
        if (this.linkModuleId > -1) {
            sqlFilter.append("AND link_module_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.typeId > -1) {
            pst.setInt(++i, this.typeId);
        }
        if (this.linkModuleId > -1) {
            pst.setInt(++i, this.linkModuleId);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        return i;
    }

    public void insert(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            for (BusinessProcess thisProcess : this.values()) {
                if (thisProcess.getIsApplication()) continue;
                thisProcess.insert(db);
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }

    public void delete(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            for (BusinessProcess thisProcess : this.values()) {
                thisProcess.delete(db);
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }

    public void deleteUserProcesses(Connection db) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            Iterator processes = this.values().iterator();
            while (processes.hasNext()) {
                BusinessProcess thisProcess = (BusinessProcess)processes.next();
                if (thisProcess.getIsApplication()) continue;
                thisProcess.delete(db);
                processes.remove();
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }
}

