/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.apps.workFlowManager.BusinessProcess;
import org.aspcfs.apps.workFlowManager.WorkflowManager;
import org.aspcfs.utils.HTTPUtils;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.XMLUtils;

public class ComponentContext
extends HashMap {
    public static final int TEXT_ENCODING = 0;
    public static final int XML_ENCODING = 1;
    public static final int HTML_ENCODING = 2;
    private WorkflowManager manager = null;
    private String processName = null;
    private BusinessProcess process = null;
    private Object previousObject = null;
    private Object thisObject = null;
    private AbstractList objects = null;

    public void setProcessName(String tmp) {
        this.processName = tmp;
    }

    public void setProcess(BusinessProcess tmp) {
        this.process = tmp;
    }

    public void setPreviousObject(Object tmp) {
        this.previousObject = tmp;
    }

    public void setThisObject(Object tmp) {
        this.thisObject = tmp;
    }

    public void setObjects(AbstractList tmp) {
        this.objects = tmp;
    }

    public void setManager(WorkflowManager tmp) {
        this.manager = tmp;
    }

    public String getProcessName() {
        return this.processName;
    }

    public BusinessProcess getProcess() {
        return this.process;
    }

    public Object getPreviousObject() {
        return this.previousObject;
    }

    public Object getThisObject() {
        return this.thisObject;
    }

    public AbstractList getObjects() {
        return this.objects;
    }

    public void setParameter(String parameterName, String value) {
        if (value != null) {
            this.put(parameterName, value);
        }
    }

    public boolean isUpdate() {
        return this.thisObject != null && this.previousObject != null;
    }

    public boolean isInsert() {
        return this.thisObject != null && this.previousObject == null;
    }

    public boolean isDelete() {
        return this.thisObject == null && this.previousObject != null;
    }

    public String getClassName() {
        if (this.thisObject != null) {
            return this.thisObject.getClass().getName();
        }
        if (this.previousObject != null) {
            return this.previousObject.getClass().getName();
        }
        return null;
    }

    public int getParameterAsInt(String parameterName) {
        try {
            return Integer.parseInt(this.getParameter(parameterName));
        }
        catch (Exception e) {
            return -1;
        }
    }

    public boolean getParameterAsBoolean(String parameterName) {
        try {
            return Boolean.valueOf(this.getParameter(parameterName));
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getParameter(String parameterName) {
        return this.getParameter(parameterName, this.thisObject, this.previousObject);
    }

    public String getParameter(String parameterName, Object thisObject, Object previousObject) {
        String param = (String)this.get(parameterName);
        if (param != null) {
            if (param.indexOf("${") > -1) {
                Template template = new Template();
                template.setText(param);
                ArrayList templateVariables = template.getVariables();
                for (String variable : templateVariables) {
                    String value = this.retrieveContextValue(variable, thisObject, previousObject);
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ComponentContext-> " + parameterName + ": ${" + variable + "} = " + value);
                    }
                    template.addParseElement("${" + variable + "}", value);
                }
                return template.getParsedText();
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ComponentContext-> " + parameterName + ": " + param);
            }
            return param;
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ComponentContext-> " + parameterName + ": not found");
        }
        return null;
    }

    public void setAttribute(String parameterName, Object value) {
        this.put(parameterName, value);
    }

    public Object getAttribute(String parameterName) {
        if (this.containsKey(parameterName)) {
            return this.get(parameterName);
        }
        return null;
    }

    public String retrieveContextValue(String param) {
        return this.retrieveContextValue(param, this.thisObject, this.previousObject);
    }

    public String retrieveContextValue(String param, Object thisObject, Object previousObject) {
        int encoding = 0;
        if (param.indexOf(":xml") > -1) {
            encoding = 1;
            param = param.substring(0, param.indexOf(":xml"));
        } else if (param.indexOf(":html") > -1) {
            encoding = 2;
            param = param.substring(0, param.indexOf(":html"));
        }
        String value = null;
        if (param.indexOf(".") > -1) {
            if (param.indexOf("process.") == 0) {
                value = (String)this.getAttribute(param);
            } else if (param.indexOf("objects.size") == 0) {
                value = this.objects != null ? String.valueOf(this.objects.size()) : "0";
            } else if (param.indexOf("this.") == 0) {
                value = ObjectUtils.getParam(thisObject, param.substring(5));
            } else if (param.indexOf("previous.") == 0) {
                value = ObjectUtils.getParam(previousObject, param.substring(9));
            } else {
                Object paramObject = this.getAttribute(param.substring(0, param.indexOf(".")));
                value = ObjectUtils.getParam(paramObject, param.substring(param.indexOf(".") + 1));
            }
        } else {
            value = ObjectUtils.getParam(thisObject, param);
        }
        if (value != null) {
            switch (encoding) {
                case 1: {
                    value = XMLUtils.toXMLValue(value);
                    break;
                }
                case 2: {
                    value = HTTPUtils.toHtmlValue(value);
                    break;
                }
            }
        }
        return value;
    }

    public boolean hasParameter(String parameterName) {
        return this.containsKey(parameterName);
    }

    public boolean hasObjects() {
        return this.objects != null;
    }

    public boolean execute(String component) {
        try {
            System.out.println("ComponentContext-> NOT IMPLEMENTED");
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

