/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.apps.workFlowManager.LibraryComponentParameter;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class ComponentParameter {
    private int id = -1;
    private int componentId = -1;
    private int parameterId = -1;
    private String value = null;
    private boolean enabled = true;
    private String name = null;

    public ComponentParameter() {
    }

    public ComponentParameter(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ComponentParameter(Element parameterElement) {
        this.setName(parameterElement.getAttribute("name"));
        String newValue = parameterElement.getAttribute("value");
        if ((newValue == null || "".equals(newValue)) && (newValue = XMLUtils.getNodeText(parameterElement)) == null) {
            newValue = "";
        }
        this.setValue(newValue);
        this.setEnabled(parameterElement.getAttribute("enabled"));
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setComponentId(int tmp) {
        this.componentId = tmp;
    }

    public void setComponentId(String tmp) {
        this.componentId = Integer.parseInt(tmp);
    }

    public void setParameterId(int tmp) {
        this.parameterId = tmp;
    }

    public void setParameterId(String tmp) {
        this.parameterId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setValue(String tmp) {
        this.value = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp) || tmp == null || "".equals(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public int getParameterId() {
        return this.parameterId;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.componentId = rs.getInt("component_id");
        this.parameterId = rs.getInt("parameter_id");
        this.value = rs.getString("param_value");
        this.enabled = rs.getBoolean("enabled");
        this.name = rs.getString("param_name");
    }

    public void insert(Connection db) throws SQLException {
        if (this.parameterId == -1) {
            LibraryComponentParameter libraryParam = new LibraryComponentParameter();
            libraryParam.setComponentId(this.componentId);
            libraryParam.setName(this.name);
            libraryParam.setDescription(null);
            libraryParam.setDefaultValue(this.value);
            libraryParam.setEnabled(true);
            libraryParam.insert(db);
            this.parameterId = libraryParam.getId();
        }
        int i = 0;
        this.id = DatabaseUtils.getNextSeq(db, "business_process_comp_pa_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO " + DatabaseUtils.getTableName(db, "business_process_component_parameter") + " " + "(" + (this.id > -1 ? "id, " : "") + "component_id, parameter_id, param_value, enabled) VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?) ");
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.componentId);
        pst.setInt(++i, this.parameterId);
        pst.setString(++i, this.value);
        pst.setBoolean(++i, this.enabled);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "business_process_comp_pa_id_seq", this.id);
    }

    public void delete(Connection db) throws SQLException {
        System.out.println(" Deleting component parameter");
        PreparedStatement pst = db.prepareStatement("DELETE FROM " + DatabaseUtils.getTableName(db, "business_process_component_parameter") + " " + "WHERE id = ? ");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
    }
}

