/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.apps.workFlowManager.ComponentParameter;
import org.aspcfs.utils.DatabaseUtils;

public class ComponentParameterList
extends ArrayList {
    private int componentId = -1;
    private int enabled = -1;

    public void setComponentId(int tmp) {
        this.componentId = tmp;
    }

    public void setComponentId(String tmp) {
        this.componentId = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public int getComponentId() {
        return this.componentId;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void buildList(Connection db) throws SQLException {
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT p.id, p.component_id, p.parameter_id, p.param_value, p.enabled, pl.param_name FROM " + DatabaseUtils.getTableName(db, "business_process_component_parameter") + " p, " + DatabaseUtils.getTableName(db, "business_process_parameter_library") + " pl " + "WHERE p.id > 0 " + "AND p.parameter_id = pl.parameter_id ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY id ");
        PreparedStatement pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ComponentParameter thisParameter = new ComponentParameter(rs);
            this.add(thisParameter);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.componentId > -1) {
            sqlFilter.append("AND p.component_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND p.enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.componentId > -1) {
            pst.setInt(++i, this.componentId);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        return i;
    }

    public void insert(Connection db) throws SQLException {
        for (ComponentParameter param : this) {
            param.setComponentId(this.componentId);
            param.insert(db);
        }
    }

    public void delete(Connection db) throws SQLException {
        for (ComponentParameter tmpComponentParameter : this) {
            tmpComponentParameter.delete(db);
        }
    }
}

