/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class ComponentResult {
    private int id = -1;
    private int componentId = -1;
    private int returnId = -1;
    private String description = null;
    private int level = -1;
    private boolean enabled = false;

    public ComponentResult() {
    }

    public ComponentResult(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setComponentId(int tmp) {
        this.componentId = tmp;
    }

    public void setComponentId(String tmp) {
        this.componentId = Integer.parseInt(tmp);
    }

    public void setReturnId(int tmp) {
        this.returnId = tmp;
    }

    public void setReturnId(String tmp) {
        this.returnId = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public int getReturnId() {
        return this.returnId;
    }

    public String getDescription() {
        return this.description;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("result_id");
        this.componentId = rs.getInt("component_id");
        this.returnId = rs.getInt("return_id");
        this.description = rs.getString("description");
        this.level = rs.getInt("level");
        this.enabled = rs.getBoolean("enabled");
    }

    public void insert(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT result_id FROM " + DatabaseUtils.getTableName(db, "business_process_component_result_lookup") + " " + "WHERE component_id = ? " + "AND return_id = ?");
        pst.setInt(1, this.componentId);
        pst.setInt(2, this.returnId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.id = rs.getInt("result_id");
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            this.id = DatabaseUtils.getNextSeq(db, "business_process_comp_re_id_seq");
            pst = db.prepareStatement("INSERT INTO " + DatabaseUtils.getTableName(db, "business_process_component_result_lookup") + " " + "(" + (this.id > -1 ? "result_id, " : "") + "component_id, return_id, description, " + DatabaseUtils.addQuotes(db, "level") + ", enabled) " + "VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?)");
            int i = 0;
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setInt(++i, this.componentId);
            pst.setInt(++i, this.returnId);
            pst.setString(++i, this.description);
            pst.setInt(++i, this.level);
            pst.setBoolean(++i, this.enabled);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "business_process_comp_re_id_seq", this.id);
        }
    }
}

