/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class LibraryComponent {
    private int id = -1;
    private String name = null;
    private int typeId = -1;
    private String className = null;
    private String description = null;
    private boolean enabled = false;

    public LibraryComponent() {
    }

    public LibraryComponent(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setClassName(String tmp) {
        this.className = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("component_id");
        this.name = rs.getString("component_name");
        this.typeId = rs.getInt("type_id");
        this.className = rs.getString("class_name");
        this.description = rs.getString("description");
        this.enabled = rs.getBoolean("enabled");
    }

    public void insert(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT component_id FROM " + DatabaseUtils.getTableName(db, "business_process_component_library") + " " + "WHERE component_name = ? " + "AND type_id = ?");
        pst.setString(1, this.name);
        pst.setInt(2, this.typeId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.id = rs.getInt("component_id");
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            this.id = DatabaseUtils.getNextSeq(db, "business_process_com_lb_id_seq");
            pst = db.prepareStatement("INSERT INTO " + DatabaseUtils.getTableName(db, "business_process_component_library") + " " + "(" + (this.id > -1 ? "component_id, " : "") + "component_name, type_id, class_name, description, enabled) " + "VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?)");
            int i = 0;
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setString(++i, this.name);
            pst.setInt(++i, this.typeId);
            pst.setString(++i, this.className);
            pst.setString(++i, this.description);
            pst.setBoolean(++i, this.enabled);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "business_process_com_lb_id_seq", this.id);
        }
    }
}

