/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class LibraryComponentParameter {
    private int id = -1;
    private int componentId = -1;
    private String name = null;
    private String description = null;
    private String defaultValue = null;
    private boolean enabled = false;

    public LibraryComponentParameter() {
    }

    public LibraryComponentParameter(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setComponentId(int tmp) {
        this.componentId = tmp;
    }

    public void setComponentId(String tmp) {
        this.componentId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setDefaultValue(String tmp) {
        this.defaultValue = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getComponentId() {
        return this.componentId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("component_id");
        this.componentId = rs.getInt("component_id");
        this.name = rs.getString("param_name");
        this.description = rs.getString("description");
        this.defaultValue = rs.getString("default_value");
        this.enabled = rs.getBoolean("enabled");
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "business_process_pa_lib_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO " + DatabaseUtils.getTableName(db, "business_process_parameter_library") + " " + "(" + (this.id > -1 ? "parameter_id, " : "") + "component_id, param_name, description, default_value, enabled) VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.componentId);
        pst.setString(++i, this.name);
        pst.setString(++i, this.description);
        pst.setString(++i, this.defaultValue);
        pst.setBoolean(++i, this.enabled);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "business_process_pa_lib_id_seq", this.id);
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM " + DatabaseUtils.getTableName(db, "business_process_parameter_library") + " " + "WHERE component_id = ? ");
        pst.setInt(1, this.componentId);
        pst.execute();
        pst.close();
    }
}

