/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class ProcessParameter {
    private int id = -1;
    private int processId = -1;
    private String name = null;
    private String value = null;
    private boolean enabled = true;

    public ProcessParameter() {
    }

    public ProcessParameter(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public ProcessParameter(Element parameterElement) {
        this.setName(parameterElement.getAttribute("name"));
        String newValue = parameterElement.getAttribute("value");
        if ((newValue == null || "".equals(newValue)) && (newValue = XMLUtils.getNodeText(parameterElement)) == null) {
            newValue = "";
        }
        this.setValue(newValue);
        this.setEnabled(parameterElement.getAttribute("enabled"));
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setProcessId(int tmp) {
        this.processId = tmp;
    }

    public void setProcessId(String tmp) {
        this.processId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setValue(String tmp) {
        this.value = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp) || tmp == null || "".equals(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getProcessId() {
        return this.processId;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.processId = rs.getInt("process_id");
        this.name = rs.getString("param_name");
        this.value = rs.getString("param_value");
        this.enabled = rs.getBoolean("enabled");
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "business_process_param_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO business_process_parameter (" + (this.id > -1 ? "id, " : "") + "process_id, param_name, param_value, enabled) " + "VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?)");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.processId);
        pst.setString(++i, this.name);
        pst.setString(++i, this.value);
        pst.setBoolean(++i, this.enabled);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "business_process_param_id_seq", this.id);
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM business_process_parameter WHERE id = ? ");
        pst.setInt(1, this.id);
        pst.execute();
        pst.close();
    }
}

