/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.apps.workFlowManager.ProcessParameter;

public class ProcessParameterList
extends ArrayList {
    private int processId = -1;
    private int enabled = -1;

    public void setProcessId(int tmp) {
        this.processId = tmp;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void buildList(Connection db) throws SQLException {
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT id, process_id, param_name, param_value, enabled FROM business_process_parameter WHERE id > 0 ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY param_name ");
        PreparedStatement pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ProcessParameter thisParameter = new ProcessParameter(rs);
            this.add(thisParameter);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.processId > -1) {
            sqlFilter.append("AND process_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.processId > -1) {
            pst.setInt(++i, this.processId);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection db) throws SQLException {
        boolean autoCommit = db.getAutoCommit();
        try {
            if (autoCommit) {
                db.setAutoCommit(false);
            }
            for (ProcessParameter parameter : this) {
                parameter.setProcessId(this.processId);
                parameter.insert(db);
            }
            if (autoCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (autoCommit) {
                db.rollback();
            }
        }
        finally {
            if (autoCommit) {
                db.setAutoCommit(true);
            }
        }
    }

    public void delete(Connection db) throws SQLException {
        for (ProcessParameter tmpProcessParameter : this) {
            tmpProcessParameter.delete(db);
        }
    }
}

