/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.apps.workFlowManager.BusinessProcess;
import org.aspcfs.apps.workFlowManager.BusinessProcessList;
import org.aspcfs.apps.workFlowManager.ScheduledEventList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;
import org.w3c.dom.Element;

public class ScheduledEvent
implements Serializable {
    private int id = -1;
    private String second = null;
    private String minute = null;
    private String hour = null;
    private String dayOfMonth = null;
    private String month = null;
    private String dayOfWeek = null;
    private String year = null;
    private String task = null;
    private String extraInfo = null;
    private boolean enabled = true;
    Timestamp entered = null;
    private int processId = -1;

    public ScheduledEvent() {
    }

    public ScheduledEvent(Element actionElement) {
        this.setSecond(actionElement.getAttribute("second"));
        this.setMinute(actionElement.getAttribute("minute"));
        this.setHour(actionElement.getAttribute("hour"));
        this.setDayOfMonth(actionElement.getAttribute("dayOfMonth"));
        this.setMonth(actionElement.getAttribute("month"));
        this.setDayOfWeek(actionElement.getAttribute("dayOfWeek"));
        this.setYear(actionElement.getAttribute("year"));
        this.setTask(actionElement.getAttribute("process"));
        this.setEnabled(actionElement.getAttribute("enabled"));
    }

    public ScheduledEvent(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setSecond(String tmp) {
        this.second = tmp;
    }

    public void setMinute(String tmp) {
        this.minute = tmp;
    }

    public void setHour(String tmp) {
        this.hour = tmp;
    }

    public void setDayOfMonth(String tmp) {
        this.dayOfMonth = tmp;
    }

    public void setMonth(String tmp) {
        this.month = tmp;
    }

    public void setDayOfWeek(String tmp) {
        this.dayOfWeek = tmp;
    }

    public void setYear(String tmp) {
        this.year = tmp;
    }

    public void setTask(String tmp) {
        this.task = tmp;
    }

    public void setExtraInfo(String tmp) {
        this.extraInfo = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setProcessId(int tmp) {
        this.processId = tmp;
    }

    public void setProcessId(String tmp) {
        this.processId = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getSecond() {
        return this.second;
    }

    public String getMinute() {
        return this.minute;
    }

    public String getHour() {
        return this.hour;
    }

    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    public String getMonth() {
        return this.month;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public String getYear() {
        return this.year;
    }

    public String getTask() {
        return this.task;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getProcessId() {
        return this.processId;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("event_id");
        this.second = rs.getString("second");
        this.minute = rs.getString("minute");
        this.hour = rs.getString("hour");
        this.dayOfMonth = rs.getString("dayofmonth");
        this.month = rs.getString("month");
        this.dayOfWeek = rs.getString("dayofweek");
        this.year = rs.getString("year");
        this.task = rs.getString("task");
        this.extraInfo = rs.getString("extrainfo");
        this.enabled = rs.getBoolean("enabled");
        this.entered = rs.getTimestamp("entered");
        this.processId = rs.getInt("process_id");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (!this.minute.equals("*") && this.minute.indexOf("*/") > -1) {
            String minuteRepeat = this.minute.substring(this.minute.indexOf("*/") + 2);
            ScheduledEvent.appendNext(sb, "Every " + ("1".equals(minuteRepeat) ? "" : minuteRepeat + " ") + "minute" + ("1".equals(minuteRepeat) ? "" : "s"));
        }
        if (!this.hour.equals("*")) {
            if (this.hour.indexOf("*/") > -1) {
                String hourRepeat = this.hour.substring(this.hour.indexOf("*/") + 2);
                ScheduledEvent.appendNext(sb, "Every " + ("1".equals(hourRepeat) ? "" : hourRepeat + " ") + "hour" + ("1".equals(hourRepeat) ? "" : "s"));
            }
            if (this.hour.indexOf("-") > -1) {
                String leftRange = this.hour.substring(0, this.hour.indexOf("-"));
                String rightRange = this.hour.substring(this.hour.indexOf("-") + 1);
                ScheduledEvent.appendNext(sb, ScheduledEvent.to12Hr(leftRange, null) + " - " + ScheduledEvent.to12Hr(rightRange, null));
            }
        }
        int actualMinute = StringUtils.parseInt(this.minute, -1);
        int actualHour = StringUtils.parseInt(this.hour, -1);
        if (actualHour > -1 && actualMinute > -1) {
            ScheduledEvent.appendNext(sb, "at " + ScheduledEvent.to12Hr(this.hour, this.minute));
        } else if (actualHour > -1) {
            ScheduledEvent.appendNext(sb, "During the hour of " + ScheduledEvent.to12Hr(this.hour, null));
        }
        int actualmonth = StringUtils.parseInt(this.month, -1);
        int actualDayOfMonth = StringUtils.parseInt(this.dayOfMonth, -1);
        int actualYear = StringUtils.parseInt(this.year, -1);
        if (actualmonth > -1 && actualDayOfMonth > -1 && actualYear > -1) {
            ScheduledEvent.appendNext(sb, "on " + actualmonth + "/" + actualDayOfMonth + "/" + actualYear);
        }
        return sb.toString();
    }

    private static void appendNext(StringBuffer sb, String text) {
        if (sb.length() > 0) {
            sb.append("; ");
        }
        sb.append(text);
    }

    private static String to12Hr(String hourValue, String minuteValue) {
        int hour;
        StringBuffer sb = new StringBuffer();
        if (hourValue != null) {
            hour = StringUtils.parseInt(hourValue, -1);
            if (hour == 0) {
                sb.append("12");
            } else if (hour >= 1 && hour <= 12) {
                sb.append(hour);
            } else if (hour >= 13 && hour <= 23) {
                sb.append(hour - 12);
            }
        }
        if (minuteValue != null) {
            sb.append(":");
            int minute = StringUtils.parseInt(minuteValue, 0);
            if (minute >= 0 && minute <= 9) {
                sb.append("0" + minute);
            } else if (minute >= 10 && minute <= 59) {
                sb.append(minute);
            }
        }
        if (hourValue != null) {
            sb.append(" ");
            hour = StringUtils.parseInt(hourValue, -1);
            if (hour >= 0 && hour <= 11) {
                sb.append("AM");
            } else if (hour >= 12 && hour <= 23) {
                sb.append("PM");
            }
        }
        return sb.toString();
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        if (this.getId() != -1) {
            return this.update(db) == 1;
        }
        this.id = DatabaseUtils.getNextSeq(db, "business_process_e_event_id_seq");
        StringBuffer sql = new StringBuffer("INSERT INTO business_process_events( ");
        if (this.id > -1) {
            sql.append("event_id, ");
        }
        if (this.getSecond() != null && !"".equals(this.getSecond())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "second") + ", ");
        }
        if (this.getMinute() != null && !"".equals(this.getMinute())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "minute") + ", ");
        }
        if (this.getHour() != null && !"".equals(this.getHour())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "hour") + ", ");
        }
        if (this.getDayOfMonth() != null && !"".equals(this.getDayOfMonth())) {
            sql.append("dayofmonth, ");
        }
        if (this.getMonth() != null && !"".equals(this.getMonth())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "month") + ", ");
        }
        if (this.getDayOfWeek() != null && !"".equals(this.getDayOfWeek())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "dayofweek") + ", ");
        }
        if (this.getYear() != null && !"".equals(this.getYear())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "year") + ", ");
        }
        if (this.getTask() != null && !"".equals(this.getTask())) {
            sql.append("task, ");
        }
        if (this.getExtraInfo() != null && !"".equals(this.getExtraInfo())) {
            sql.append("extrainfo, ");
        }
        if (this.getEnabled()) {
            sql.append("enabled, ");
        }
        if (this.getEntered() != null) {
            sql.append("entered, ");
        }
        sql.append("process_id) VALUES( ");
        if (this.id > -1) {
            sql.append("?, ");
        }
        if (this.getSecond() != null && !"".equals(this.getSecond())) {
            sql.append("?, ");
        }
        if (this.getMinute() != null && !"".equals(this.getMinute())) {
            sql.append("?, ");
        }
        if (this.getHour() != null && !"".equals(this.getHour())) {
            sql.append("?, ");
        }
        if (this.getDayOfMonth() != null && !"".equals(this.getDayOfMonth())) {
            sql.append("?, ");
        }
        if (this.getMonth() != null && !"".equals(this.getMonth())) {
            sql.append("?, ");
        }
        if (this.getDayOfWeek() != null && !"".equals(this.getDayOfWeek())) {
            sql.append("?, ");
        }
        if (this.getYear() != null && !"".equals(this.getYear())) {
            sql.append("?, ");
        }
        if (this.getTask() != null && !"".equals(this.getTask())) {
            sql.append("?, ");
        }
        if (this.getExtraInfo() != null && !"".equals(this.getExtraInfo())) {
            sql.append("?, ");
        }
        if (this.getEnabled()) {
            sql.append("?, ");
        }
        if (this.getEntered() != null) {
            sql.append("?, ");
        }
        sql.append("?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.getSecond() != null && !"".equals(this.getSecond())) {
            pst.setString(++i, this.getSecond());
        }
        if (this.getMinute() != null && !"".equals(this.getMinute())) {
            pst.setString(++i, this.getMinute());
        }
        if (this.getHour() != null && !"".equals(this.getHour())) {
            pst.setString(++i, this.getHour());
        }
        if (this.getDayOfMonth() != null && !"".equals(this.getDayOfMonth())) {
            pst.setString(++i, this.getDayOfMonth());
        }
        if (this.getMonth() != null && !"".equals(this.getMonth())) {
            pst.setString(++i, this.getMonth());
        }
        if (this.getDayOfWeek() != null && !"".equals(this.getDayOfWeek())) {
            pst.setString(++i, this.getDayOfWeek());
        }
        if (this.getYear() != null && !"".equals(this.getYear())) {
            pst.setString(++i, this.getYear());
        }
        if (this.getTask() != null && !"".equals(this.getTask())) {
            pst.setString(++i, this.getTask());
        }
        if (this.getExtraInfo() != null && !"".equals(this.getExtraInfo())) {
            pst.setString(++i, this.getExtraInfo());
        }
        if (this.getEnabled()) {
            pst.setBoolean(++i, this.getEnabled());
        }
        if (this.getEntered() != null) {
            DatabaseUtils.setTimestamp(pst, ++i, this.getEntered());
        }
        pst.setInt(++i, this.getProcessId());
        result = pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "business_process_e_event_id_seq", this.id);
        return result;
    }

    public int update(Connection db) throws SQLException {
        int result = -1;
        if (this.getId() != -1) {
            return result;
        }
        StringBuffer sql = new StringBuffer("UPDATE business_process_events SET ");
        if (this.getSecond() != null && !"".equals(this.getSecond())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "second") + " = ?, ");
        }
        if (this.getMinute() != null && !"".equals(this.getMinute())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "minute") + " = ?, ");
        }
        if (this.getHour() != null && !"".equals(this.getHour())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "hour") + " = ?, ");
        }
        if (this.getDayOfMonth() != null && !"".equals(this.getDayOfMonth())) {
            sql.append("dayofmonth = ?, ");
        }
        if (this.getMonth() != null && !"".equals(this.getMonth())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "month") + " = ?, ");
        }
        if (this.getDayOfWeek() != null && !"".equals(this.getDayOfWeek())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "dayofweek") + " = ?, ");
        }
        if (this.getYear() != null && !"".equals(this.getYear())) {
            sql.append("" + DatabaseUtils.addQuotes(db, "year") + " = ?, ");
        }
        if (this.getTask() != null && !"".equals(this.getTask())) {
            sql.append("task = ?, ");
        }
        if (this.getExtraInfo() != null && !"".equals(this.getExtraInfo())) {
            sql.append("extrainfo = ?, ");
        }
        if (this.getEnabled()) {
            sql.append("enabled = ?, ");
        }
        sql.append("WHERE process_id = ? ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.getSecond() != null && !"".equals(this.getSecond())) {
            pst.setString(++i, this.getSecond());
        }
        if (this.getMinute() != null && !"".equals(this.getMinute())) {
            pst.setString(++i, this.getMinute());
        }
        if (this.getHour() != null && !"".equals(this.getHour())) {
            pst.setString(++i, this.getHour());
        }
        if (this.getDayOfMonth() != null && !"".equals(this.getDayOfMonth())) {
            pst.setString(++i, this.getDayOfMonth());
        }
        if (this.getMonth() != null && !"".equals(this.getMonth())) {
            pst.setString(++i, this.getMonth());
        }
        if (this.getDayOfWeek() != null && !"".equals(this.getDayOfWeek())) {
            pst.setString(++i, this.getDayOfWeek());
        }
        if (this.getYear() != null && !"".equals(this.getYear())) {
            pst.setString(++i, this.getYear());
        }
        if (this.getTask() != null && !"".equals(this.getTask())) {
            pst.setString(++i, this.getTask());
        }
        if (this.getExtraInfo() != null && !"".equals(this.getExtraInfo())) {
            pst.setString(++i, this.getExtraInfo());
        }
        if (this.getEnabled()) {
            pst.setBoolean(++i, this.getEnabled());
        }
        pst.setInt(++i, this.getProcessId());
        result = pst.executeUpdate();
        pst.close();
        return result;
    }

    public boolean delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM business_process_events WHERE event_id = ? ");
        pst.setInt(1, this.getId());
        pst.execute();
        pst.close();
        return true;
    }

    public void buildResources(BusinessProcessList processList) {
        BusinessProcess process = (BusinessProcess)processList.get(this.getTask());
        if (process != null) {
            if (process.getEvents() == null) {
                process.setEvents(new ScheduledEventList());
            }
            process.getEvents().add(this);
        }
    }

    public boolean isDuplicate(ScheduledEvent event) {
        int resultCount = 0;
        if (!this.getTask().equals(event.getTask())) {
            ++resultCount;
        }
        if (resultCount == 0 && !this.getSecond().equals(event.getSecond())) {
            ++resultCount;
        }
        if (resultCount == 0 && !this.getMinute().equals(event.getMinute())) {
            ++resultCount;
        }
        if (resultCount == 0 && !this.getHour().equals(event.getHour())) {
            ++resultCount;
        }
        if (resultCount == 0 && !this.getDayOfMonth().equals(event.getDayOfMonth())) {
            ++resultCount;
        }
        if (resultCount == 0 && !this.getMonth().equals(event.getMonth())) {
            ++resultCount;
        }
        if (resultCount == 0 && !this.getDayOfWeek().equals(event.getDayOfWeek())) {
            ++resultCount;
        }
        if (resultCount == 0 && !this.getYear().equals(event.getYear())) {
            ++resultCount;
        }
        return resultCount == 0;
    }
}

