/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.apps.workFlowManager.BusinessProcessList;
import org.aspcfs.apps.workFlowManager.ScheduledEvent;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class ScheduledEventList
extends ArrayList {
    private int businessProcessId = -1;
    private int enabled = -1;

    public void setBusinessProcessId(int tmp) {
        this.businessProcessId = tmp;
    }

    public void setBusinessProcessId(String tmp) {
        this.businessProcessId = Integer.parseInt(tmp);
    }

    public int getBusinessProcessId() {
        return this.businessProcessId;
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public int getEnabled() {
        return this.enabled;
    }

    public boolean buildList(File xmlFile) {
        try {
            XMLUtils xml = new XMLUtils(xmlFile);
            return this.parse(xml.getDocumentElement());
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public boolean parse(Element element) {
        if (element == null) {
            return false;
        }
        try {
            Element schedules = XMLUtils.getFirstElement(element, "schedules");
            if (schedules != null) {
                ArrayList scheduleNotes = XMLUtils.getElements(schedules, "schedule");
                for (Element scheduleElement : scheduleNotes) {
                    Element events = XMLUtils.getFirstElement(scheduleElement, "events");
                    if (events == null) continue;
                    ArrayList eventNodes = XMLUtils.getElements(events, "event");
                    for (Element eventElement : eventNodes) {
                        ScheduledEvent thisEvent = new ScheduledEvent(eventElement);
                        int value = -1;
                        if (value != -1) {
                            ScheduledEvent tempEvent = (ScheduledEvent)this.remove(value);
                            if (tempEvent.getProcessId() != -1) {
                                thisEvent.setProcessId(tempEvent.getProcessId());
                            }
                            if (tempEvent.getEntered() != null) {
                                thisEvent.setEntered(tempEvent.getEntered());
                            }
                            thisEvent.setId(value);
                        }
                        this.add(thisEvent);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public int hasDuplicateEvents(ScheduledEvent event) {
        for (ScheduledEvent thisEvent : this) {
            if (!event.isDuplicate(thisEvent) || thisEvent.getId() == -1) continue;
            return thisEvent.getId();
        }
        return -1;
    }

    public void buildResources(BusinessProcessList list) {
        for (ScheduledEvent event : this) {
            event.buildResources(list);
        }
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = true;
        for (ScheduledEvent event : this) {
            result = event.insert(db) && result;
        }
        return result;
    }

    public void buildList(Connection db) throws SQLException {
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT event_id, " + DatabaseUtils.addQuotes(db, "second") + ", " + DatabaseUtils.addQuotes(db, "minute") + ", " + DatabaseUtils.addQuotes(db, "hour") + ", " + "dayofmonth, " + DatabaseUtils.addQuotes(db, "month") + ", " + DatabaseUtils.addQuotes(db, "dayofweek") + ", " + DatabaseUtils.addQuotes(db, "year") + ", task, extrainfo, " + "enabled, entered, process_id " + "FROM business_process_events " + "WHERE event_id > 0 ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY event_id ");
        PreparedStatement pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ScheduledEvent thisEvent = new ScheduledEvent(rs);
            this.add(thisEvent);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.businessProcessId > -1) {
            sqlFilter.append("AND process_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.businessProcessId > -1) {
            pst.setInt(++i, this.businessProcessId);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        return i;
    }

    void delete(Connection db) throws SQLException {
        for (ScheduledEvent tmpScheduledEvent : this) {
            tmpScheduledEvent.delete(db);
        }
    }
}

