/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.apps.workFlowManager;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.aspcfs.apps.workFlowManager.BusinessProcess;
import org.aspcfs.apps.workFlowManager.BusinessProcessComponent;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentParameter;
import org.aspcfs.apps.workFlowManager.ProcessParameter;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;

public class WorkflowManager {
    Map classes = new HashMap();

    public void execute(ComponentContext context) throws Exception {
        BusinessProcessComponent startComponent;
        if (System.getProperty("DEBUG") != null) {
            System.out.println("WorkflowManager-> Executing Business Process");
        }
        WorkflowManager.populateProcessParameters(context);
        int startId = context.getProcess().getStartId();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("WorkflowManager-> Business Process Start: " + startId);
        }
        if ((startComponent = context.getProcess().getComponent(startId)).getEnabled()) {
            if (context.getProcess().getType() == 2) {
                WorkflowManager.loadAnchors(context);
            }
            boolean startResult = this.executeComponent(context, startComponent);
            this.processChildren(context, startComponent, startResult);
            if (context.getProcess().getType() == 2) {
                WorkflowManager.saveAnchors(context);
            }
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("WorkflowManager-> Business Process End");
        }
    }

    private void processChildren(ComponentContext context, BusinessProcessComponent bpc, boolean previousResult) throws Exception {
        for (BusinessProcessComponent child : bpc.getChildren(previousResult)) {
            if (!child.getEnabled()) continue;
            boolean result = this.executeComponent(context, child);
            this.processChildren(context, child, result);
        }
    }

    private boolean executeComponent(ComponentContext context, BusinessProcessComponent component) throws Exception {
        if (System.getProperty("DEBUG") != null) {
            System.out.print("WorkflowManager-> Executing: " + component.getClassName() + " " + component.getDescription() + "? ");
        }
        Object classRef = null;
        if (this.classes.containsKey(component.getClassName())) {
            classRef = this.classes.get(component.getClassName());
        } else {
            try {
                classRef = Class.forName(component.getClassName()).newInstance();
                this.classes.put(component.getClassName(), classRef);
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("WorkflowManager-> Class Not Found Exception. MESSAGE = " + cnfe.getMessage());
            }
            catch (InstantiationException ie) {
                System.out.println("WorkflowManager-> Instantiation Exception. MESSAGE = " + ie.getMessage());
            }
            catch (IllegalAccessException iae) {
                System.out.println("WorkflowManager-> Illegal Argument Exception. MESSAGE = " + iae.getMessage());
            }
        }
        Object result = null;
        try {
            if (context == null) {
                System.out.println("WorkflowManager-> Context is null");
            }
            if (classRef == null) {
                System.out.println("WorkflowManager-> Class ref is null");
            }
            WorkflowManager.populateComponentParameters(context, component);
            Method method = classRef.getClass().getMethod("execute", context.getClass());
            result = method.invoke(classRef, context);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println("WorkflowManager-> Exception while trying to execute component " + component.getClassName() + " error: " + e.getMessage());
        }
        if (result instanceof Boolean) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println((Boolean)result);
            }
            return (Boolean)result;
        }
        if (result instanceof Integer) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println((Integer)result);
            }
            return (Integer)result == 1;
        }
        System.out.println("WorkflowManager-> Component did not return an acceptable result");
        return false;
    }

    private static void populateProcessParameters(ComponentContext context) {
        BusinessProcess thisProcess = context.getProcess();
        if (thisProcess.hasParameters()) {
            for (ProcessParameter thisParameter : thisProcess.getParameters()) {
                if (!thisParameter.getEnabled()) continue;
                context.setParameter(thisParameter.getName(), thisParameter.getValue());
            }
        }
    }

    private static void populateComponentParameters(ComponentContext context, BusinessProcessComponent component) {
        if (component.hasParameters()) {
            for (ComponentParameter thisParameter : component.getParameters()) {
                if (!thisParameter.getEnabled()) continue;
                context.setParameter(thisParameter.getName(), thisParameter.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void loadAnchors(ComponentContext context) {
        System.out.println("WorkflowManager-> loadAnchors");
        Connection db = null;
        try {
            context.setParameter("process.nextAnchor", new Timestamp(new Date().getTime()).toString());
            db = ObjectHookComponent.getConnection(context);
            PreparedStatement pst = db.prepareStatement("SELECT anchor FROM business_process_log WHERE process_name = ? ");
            pst.setString(1, context.getProcess().getName());
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                context.setParameter("process.lastAnchor", rs.getTimestamp("anchor").toString());
            }
            rs.close();
            pst.close();
        }
        catch (Exception exception) {
            ObjectHookComponent.freeConnection(context, db);
            catch (Throwable throwable) {
                ObjectHookComponent.freeConnection(context, db);
                throw throwable;
            }
        }
        ObjectHookComponent.freeConnection(context, db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveAnchors(ComponentContext context) {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("WorkflowManager-> saveAnchors: " + context.getProcess().getName());
        }
        Connection db = null;
        try {
            db = ObjectHookComponent.getConnection(context);
            PreparedStatement pst = db.prepareStatement("UPDATE business_process_log SET anchor = ? WHERE process_name = ? AND anchor = ? ");
            if (context.hasParameter("process.nextAnchor")) {
                pst.setTimestamp(1, Timestamp.valueOf(context.getParameter("process.nextAnchor")));
            } else {
                pst.setNull(1, 91);
            }
            pst.setString(2, context.getProcess().getName());
            if (context.hasParameter("process.lastAnchor")) {
                pst.setTimestamp(3, Timestamp.valueOf(context.getParameter("process.lastAnchor")));
            } else {
                pst.setNull(3, 91);
            }
            int count = pst.executeUpdate();
            pst.close();
            if (count == 0) {
                pst = db.prepareStatement("INSERT INTO business_process_log (process_name, anchor) VALUES (?, ?) ");
                pst.setString(1, context.getProcess().getName());
                if (context.hasParameter("process.nextAnchor")) {
                    pst.setTimestamp(2, Timestamp.valueOf(context.getParameter("process.nextAnchor")));
                } else {
                    pst.setNull(2, 91);
                }
                pst.execute();
                pst.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            ObjectHookComponent.freeConnection(context, db);
        }
    }
}

