/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller;

import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.hooks.CustomHook;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.servlet.ServletContext;
import org.aspcfs.controller.ImportManager;
import org.aspcfs.controller.ScheduledJobs;
import org.aspcfs.modules.setup.utils.Prefs;
import org.aspcfs.modules.system.base.ApplicationVersion;
import org.aspcfs.modules.website.base.Icelet;
import org.aspcfs.modules.website.base.IceletList;
import org.aspcfs.modules.website.base.IceletPropertyMap;
import org.aspcfs.utils.Dictionary;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.XMLUtils;
import org.jcrontab.Crontab;
import org.quartz.Scheduler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ApplicationPrefs {
    public static final String fs = System.getProperty("file.separator");
    public static final String ls = System.getProperty("line.separator");
    public static final String GENERATED_MESSAGE = "### GENERATED BY org.aspcfs.controller.ApplicationPrefs";
    private Map prefs = new LinkedHashMap();
    private String filename = null;
    private Map dictionaries = new HashMap();
    private HashMap icelets = new HashMap();

    public ApplicationPrefs() {
    }

    public ApplicationPrefs(ServletContext context) {
        try {
            String dir = Prefs.retrieveContextPrefName(context);
            Preferences prefs = Preferences.userNodeForPackage(Prefs.class);
            String fileLibrary = prefs.get(dir, null);
            if (fileLibrary == null) {
                File testDirectory;
                System.out.println("ApplicationPrefs-> prefs not found...");
                String os = System.getProperty("os.name");
                File systemOverrideFile = null;
                systemOverrideFile = os.startsWith("Windows") ? new File("c:\\CentricCRM\\fileLibrary\\path.txt") : (os.startsWith("Mac") ? new File("/Library/Application Support/CentricCRM/fileLibrary/path.txt") : ((testDirectory = new File("/opt")).exists() ? new File("/opt/centric_crm/fileLibrary/path.txt") : new File("/var/lib/centric_crm/fileLibrary/path.txt")));
                if (systemOverrideFile.exists()) {
                    try {
                        BufferedReader in = new BufferedReader(new FileReader(systemOverrideFile));
                        String line = in.readLine();
                        if (line != null && line.startsWith("#")) {
                            line = in.readLine();
                        }
                        fileLibrary = line;
                        in.close();
                    }
                    catch (Exception e) {
                        System.out.println("ApplicationPrefs-> Using systemOverrideFile EXCEPTION: " + e.getMessage());
                    }
                } else {
                    fileLibrary = context.getRealPath("/") + "WEB-INF" + fs + "fileLibrary" + fs;
                    File propertyFile = new File(fileLibrary + "build.properties");
                    if (propertyFile.exists()) {
                        Prefs.savePref(dir, fileLibrary);
                    } else {
                        fileLibrary = prefs.get("cfs.fileLibrary", null);
                        if (fileLibrary != null) {
                            Prefs.savePref(dir, fileLibrary);
                            Prefs.savePref("cfs.fileLibrary", null);
                        }
                    }
                }
            }
            context.setAttribute("SiteCode", (Object)prefs.get("cfs.gatekeeper.sitecode", "cfs"));
            System.out.println("ApplicationPrefs-> Using file library at: " + fileLibrary);
            if (fileLibrary != null) {
                this.load(fileLibrary + "build.properties");
                this.add("FILELIBRARY", fileLibrary);
            }
            this.populateContext(context);
            this.loadApplicationDictionary(context);
            this.loadApplicationIcelets(context);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public ApplicationPrefs(String filename) {
        this.load(filename);
    }

    public void setFilename(String tmp) {
        this.filename = tmp;
    }

    public String getFilename() {
        return this.filename;
    }

    public Map getPrefs() {
        return this.prefs;
    }

    public Map getLocalizationPrefs(String language) {
        if (this.dictionaries == null) {
            return new HashMap();
        }
        if (this.dictionaries.containsKey(language)) {
            return ((Dictionary)this.dictionaries.get(language)).getLocalizationPrefs();
        }
        return ((Dictionary)this.dictionaries.get("en_US")).getLocalizationPrefs();
    }

    public void load(String filename) {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ApplicationPrefs-> Loading prefs: " + filename);
        }
        this.filename = filename;
        try {
            this.prefs.clear();
            BufferedReader in = new BufferedReader(new FileReader(filename));
            String line = null;
            int count = 0;
            while ((line = in.readLine()) != null) {
                ++count;
                if (!line.startsWith("#") && line.indexOf("=") > 0) {
                    String param = line.substring(0, line.indexOf("="));
                    String value = "";
                    if (line.indexOf("=") + 1 < line.length()) {
                        value = line.substring(line.indexOf("=") + 1);
                    }
                    this.add(param, value);
                    continue;
                }
                if (line.startsWith(GENERATED_MESSAGE)) continue;
                this.add("#" + count, line);
            }
            in.close();
        }
        catch (Exception e) {
            System.out.println("ApplicationPrefs-> EXCEPTION: " + e.getMessage());
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ApplicationPrefs-> Loaded items: " + this.prefs.size());
        }
    }

    public String get(String param) {
        return (String)this.prefs.get(param);
    }

    public boolean has(String param) {
        return this.prefs.containsKey(param);
    }

    public void clear() {
        this.prefs.clear();
    }

    public void add(String param, String value) {
        if (param != null) {
            if (value != null) {
                this.prefs.put(param, value);
            } else {
                this.prefs.remove(param);
            }
        }
    }

    public boolean save() {
        if (this.filename != null) {
            return this.save(this.filename);
        }
        return false;
    }

    public boolean save(String filename) {
        try {
            System.out.println("ApplicationPrefs-> Saving prefs: " + filename);
            BufferedWriter out = new BufferedWriter(new FileWriter(filename));
            out.write("### GENERATED BY org.aspcfs.controller.ApplicationPrefs on " + new Date() + " ###" + ls);
            this.add("VERSION", "Centric CRM 4.1.1 (2007-03-12)");
            this.add("APP_VERSION", "2007-03-12");
            this.add("DB_VERSION", "2007-03-12");
            for (String param : this.prefs.keySet()) {
                String value = (String)this.prefs.get(param);
                if (param.startsWith("#")) {
                    out.write(value + ls);
                    continue;
                }
                out.write(param + "=" + value + ls);
            }
            out.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void populateContext(ServletContext context) {
        Crontab crontab;
        ConnectionPool cp;
        if (this.has("DEBUGLEVEL")) {
            System.setProperty("DEBUG", this.get("DEBUGLEVEL"));
        }
        context.setAttribute("SKIN", (Object)"blue");
        if (this.has("CONTROL")) {
            context.setAttribute("cfs.setup", (Object)"true");
        }
        if (this.has("WEB-INF") && !this.get("WEB-INF").equals(context.getRealPath("/") + "WEB-INF" + fs)) {
            this.add("WEB-INF", context.getRealPath("/") + "WEB-INF" + fs);
            this.save();
        }
        if ((cp = (ConnectionPool)context.getAttribute("ConnectionPool")) != null) {
            if (this.has("CONNECTION_POOL.DEBUG")) {
                cp.setDebug(this.get("CONNECTION_POOL.DEBUG"));
            }
            if (this.has("CONNECTION_POOL.TEST_CONNECTIONS")) {
                cp.setTestConnections(this.get("CONNECTION_POOL.TEST_CONNECTIONS"));
            }
            if (this.has("CONNECTION_POOL.ALLOW_SHRINKING")) {
                cp.setAllowShrinking(this.get("CONNECTION_POOL.ALLOW_SHRINKING"));
            }
            if (this.has("CONNECTION_POOL.MAX_CONNECTIONS")) {
                cp.setMaxConnections(this.get("CONNECTION_POOL.MAX_CONNECTIONS"));
            }
            if (this.has("CONNECTION_POOL.MAX_IDLE_TIME.SECONDS")) {
                cp.setMaxIdleTimeSeconds(this.get("CONNECTION_POOL.MAX_IDLE_TIME.SECONDS"));
            }
            if (this.has("CONNECTION_POOL.MAX_DEAD_TIME.SECONDS")) {
                cp.setMaxDeadTimeSeconds(this.get("CONNECTION_POOL.MAX_DEAD_TIME.SECONDS"));
            }
        }
        if (this.has("PROXYSERVER") && "true".equals(this.get("PROXYSERVER"))) {
            System.getProperties().put("proxySet", "true");
            System.getProperties().put("http.proxyHost", this.get("PROXYSERVER.HOST"));
            System.getProperties().put("http.proxyPort", this.get("PROXYSERVER.PORT"));
        } else {
            System.getProperties().put("proxySet", "false");
        }
        if ("template0".equals(this.get("LAYOUT.TEMPLATE"))) {
            this.add("LAYOUT.TEMPLATE", "template1");
        }
        if (!this.has("LAYOUT.TEMPLATE")) {
            this.add("LAYOUT.TEMPLATE", "template1");
        }
        if (!this.has("LAYOUT.JSP.WELCOME")) {
            this.add("LAYOUT.JSP.WELCOME", "welcome.jsp");
        }
        if (!this.has("LAYOUT.JSP.LOGIN")) {
            this.add("LAYOUT.JSP.LOGIN", "login.jsp");
        }
        if (!this.has("SYSTEM.CURRENCY")) {
            this.add("SYSTEM.CURRENCY", "USD");
        }
        if (!this.has("SYSTEM.LANGUAGE")) {
            this.add("SYSTEM.LANGUAGE", "en_US");
        }
        if (!this.has("SYSTEM.COUNTRY")) {
            this.add("SYSTEM.COUNTRY", "UNITED STATES");
        }
        System.setProperty("CURRENCY", this.get("SYSTEM.CURRENCY"));
        String[] locale = this.get("SYSTEM.LANGUAGE").split("_");
        if (locale[0] != null) {
            System.setProperty("LANGUAGE", locale[0]);
        }
        if (locale.length > 1 && locale[1] != null) {
            System.setProperty("COUNTRY", locale[1]);
        }
        this.addParameter(context, "ForceSSL", this.get("FORCESSL"), "false");
        this.addParameter(context, "GlobalPWInfo", this.get("WEBSERVER.PASSWORD"), "#notspecified");
        this.addParameter(context, "WEBSERVER.ASPMODE", this.get("WEBSERVER.ASPMODE"));
        this.addParameter(context, "MailServer", this.get("MAILSERVER"));
        this.addParameter(context, "FaxServer", this.get("FAXSERVER"));
        this.addParameter(context, "FaxEnabled", this.get("FAXENABLED"));
        CustomHook.populateApplicationPrefs((ServletContext)context, (ApplicationPrefs)this);
        ImportManager importManager = (ImportManager)context.getAttribute("ImportManager");
        if (importManager == null) {
            if (this.has("IMPORT_QUEUE_MAX")) {
                importManager = new ImportManager(cp, Integer.parseInt(this.get("IMPORT_QUEUE_MAX")));
                context.setAttribute("ImportManager", (Object)importManager);
            } else {
                importManager = new ImportManager(cp, 1);
                context.setAttribute("ImportManager", (Object)importManager);
            }
        }
        if ((crontab = (Crontab)context.getAttribute("Crontab")) == null && "true".equals(this.get("CRON.ENABLED"))) {
            try {
                System.out.println("ApplicationPrefs-> Starting CRON");
                crontab = Crontab.getInstance();
                Properties jcronProperties = new Properties();
                jcronProperties.setProperty("org.jcrontab.Crontab.refreshFrequency", "3");
                jcronProperties.setProperty("org.jcrontab.data.datasource", "org.aspcfs.jcrontab.datasource.CFSDatasource");
                jcronProperties.setProperty("org.jcrontab.data.GenericSQLSource.driver", this.get("GATEKEEPER.DRIVER"));
                jcronProperties.setProperty("org.jcrontab.data.GenericSQLSource.url", this.get("GATEKEEPER.URL"));
                jcronProperties.setProperty("org.jcrontab.data.GenericSQLSource.username", this.get("GATEKEEPER.USER"));
                jcronProperties.setProperty("org.jcrontab.data.GenericSQLSource.password", this.get("GATEKEEPER.PASSWORD"));
                if (this.has("GATEKEEPER.DATABASE")) {
                    jcronProperties.setProperty("org.jcrontab.data.GenericSQLSource.database", this.get("GATEKEEPER.DATABASE"));
                }
                jcronProperties.setProperty("org.jcrontab.path.DefaultFilePath", StringUtils.toString(this.get("FILELIBRARY")));
                jcronProperties.setProperty("org.jcrontab.data.SystemLanguage", StringUtils.toString(this.get("SYSTEM.LANGUAGE")));
                if (this.has("WEBSERVER.URL")) {
                    jcronProperties.setProperty("org.jcrontab.path.WebServerUrl", this.get("WEBSERVER.URL"));
                } else {
                    jcronProperties.setProperty("org.jcrontab.path.WebServerUrl", "127.0.0.1");
                }
                jcronProperties.setProperty("org.jcrontab.log.Logger", "org.jcrontab.log.DebugLogger");
                crontab.setConnectionPool((Object)cp);
                crontab.setServletContext(context);
                crontab.init(jcronProperties);
                context.setAttribute("Crontab", (Object)crontab);
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            Scheduler scheduler = (Scheduler)context.getAttribute("Scheduler");
            if (scheduler != null) {
                try {
                    scheduler.getContext().setAllowsTransientData(true);
                    scheduler.getContext().put((Object)"ServletContext", (Object)context);
                    scheduler.getContext().put((Object)"ConnectionPool", context.getAttribute("ConnectionPool"));
                    scheduler.getContext().put((Object)"ApplicationPrefs", (Object)this);
                    scheduler.getContext().put((Object)"IndexArray", new Vector());
                    scheduler.getContext().put((Object)"webPageAccessLog", new Vector());
                    scheduler.getContext().put((Object)"webProductAccessLog", new Vector());
                    scheduler.getContext().put((Object)"webProductEmailLog", new Vector());
                    scheduler.getContext().put((Object)"SystemStatus", context.getAttribute("SystemStatus"));
                    scheduler.getContext().put("ApplicationPath", context.getRealPath("/"));
                    scheduler.start();
                    ScheduledJobs.addJobs(scheduler);
                }
                catch (Exception e) {
                    e.printStackTrace(System.out);
                    System.out.println("ApplicationPrefs-> Scheduler Error: " + e.getMessage());
                }
            }
        }
    }

    private void addParameter(ServletContext context, String param, String value) {
        this.addParameter(context, param, value, null);
    }

    private void addParameter(ServletContext context, String param, String value, String defaultValue) {
        if (value != null) {
            context.setAttribute(param, (Object)value);
        } else if (defaultValue != null) {
            context.setAttribute(param, (Object)defaultValue);
        } else {
            context.removeAttribute(param);
        }
    }

    public static String getPref(ServletContext context, String param) {
        ApplicationPrefs prefs = (ApplicationPrefs)context.getAttribute("applicationPrefs");
        if (prefs != null) {
            return prefs.get(param);
        }
        return null;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String name : this.prefs.keySet()) {
            String value = (String)this.prefs.get(name);
            sb.append(name + "=" + value + ls);
        }
        return sb.toString();
    }

    public boolean isUpgradeable() {
        return ApplicationVersion.isOutOfDate(this);
    }

    public void loadApplicationDictionary(ServletContext context) {
        String language = this.get("SYSTEM.LANGUAGE");
        if (language == null) {
            language = "en_US";
        }
        this.addDictionary(context, language);
    }

    public synchronized void addDictionary(ServletContext context, String language) {
        if (language == null) {
            System.out.println("ApplicationPrefs-> addDictionary: language cannot be null");
        } else if (!this.dictionaries.containsKey(language)) {
            String languagePath = context.getRealPath("/") + "WEB-INF" + fs + "languages" + fs;
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ApplicationPrefs-> Loading dictionary: " + language);
            }
            try {
                Dictionary dictionary = new Dictionary(languagePath, "en_US");
                if (!"en_US".equals(language)) {
                    dictionary.load(languagePath, language);
                }
                this.dictionaries.put(language, dictionary);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                System.out.println("ApplicationPrefs-> Language Error: " + e.getMessage());
            }
        }
    }

    public void loadApplicationIcelets(ServletContext context) {
        this.icelets.clear();
        String language = this.get("SYSTEM.LANGUAGE");
        if (language == null) {
            language = "en_US";
        }
        this.addIcelets(context, language);
    }

    public synchronized void addIcelets(ServletContext context, String language) {
        if (language == null) {
            System.out.println("ApplicationPrefs-> addDictionary: language cannot be null");
        }
        HashMap iceletMap = null;
        if (!this.icelets.containsKey(language)) {
            String languagePath = context.getRealPath("/") + "WEB-INF" + fs + "icelets" + fs;
            try {
                File configFile;
                if (language != null && !"en_US".equals(language) && !"".equals(language.trim()) && (configFile = new File(languagePath + "icelet_" + language + ".xml")).exists()) {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ApplicationPrefs-> Loading icelets: " + language);
                    }
                    iceletMap = IceletList.load(languagePath + "icelet_" + language + ".xml");
                    this.icelets.put(language, iceletMap);
                }
                if (iceletMap == null && !this.icelets.containsKey("en_US")) {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ApplicationPrefs-> Loading icelets (default): en_US");
                    }
                    iceletMap = IceletList.load(languagePath + "icelet_en_US.xml");
                    this.icelets.put("en_US", iceletMap);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                System.out.println("ApplicationPrefs-> Language Error: " + e.getMessage());
            }
        }
    }

    public String getLabel(String section, String parameter, String language) {
        return this.getValue(section, parameter, "value", language);
    }

    public String getLabel(String parameter, String language) {
        return this.getLabel("system.fields.label", parameter, language);
    }

    public String getValue(String section, String parameter, String tagName, String language) {
        Node param;
        if (this.dictionaries == null) {
            return null;
        }
        Dictionary dictionary = (Dictionary)this.dictionaries.get(language);
        if (dictionary == null) {
            return null;
        }
        Map prefGroup = (Map)dictionary.getLocalizationPrefs().get(section);
        if (prefGroup != null && (param = (Node)prefGroup.get(parameter)) != null) {
            return XMLUtils.getNodeText(XMLUtils.getFirstChild((Element)param, tagName));
        }
        return null;
    }

    public HashMap getIcelets(String language) {
        if (this.icelets == null) {
            return null;
        }
        return (HashMap)this.icelets.get(language);
    }

    public Icelet getIceletFromClass(String language, String className) {
        HashMap iceletMap;
        if (this.icelets == null) {
            return null;
        }
        if (this.icelets.containsKey(language) && (iceletMap = (HashMap)this.icelets.get(language)) != null) {
            return (Icelet)((Object)iceletMap.get(className));
        }
        return null;
    }

    public IceletPropertyMap getIceletPrefs(String language, String className) {
        Icelet icelet;
        HashMap iceletMap;
        if (this.icelets == null) {
            return null;
        }
        if (this.icelets.containsKey(language) && (iceletMap = (HashMap)this.icelets.get(language)) != null && (icelet = (Icelet)((Object)iceletMap.get(className))) != null) {
            return icelet.getIceletPropertyMap();
        }
        return null;
    }

    public static String getRealPath(ServletContext context) {
        String dir = context.getRealPath("/");
        if (dir != null && !dir.endsWith(fs)) {
            dir = dir + fs;
        }
        return dir;
    }
}

