/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller;

import com.darkhorseventures.database.ConnectionPool;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.pluto.OptionalContainerServices;
import org.apache.pluto.PortletContainer;
import org.apache.pluto.PortletContainerFactory;
import org.apache.pluto.RequiredContainerServices;
import org.aspcfs.apps.workFlowManager.WorkflowManager;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.website.framework.IceletContainerServices;
import org.aspcfs.modules.website.framework.IceletManager;
import org.jcrontab.Crontab;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class ContextListener
implements ServletContextListener {
    public static final String fs = System.getProperty("file.separator");

    public void contextInitialized(ServletContextEvent event) {
        ServletContext context = event.getServletContext();
        System.out.println("ContextListener-> Initializing");
        try {
            ConnectionPool cp = new ConnectionPool();
            cp.setTestConnections(false);
            cp.setAllowShrinking(true);
            cp.setMaxConnections(10);
            cp.setMaxIdleTime(60000);
            cp.setMaxDeadTime(300000);
            context.setAttribute("ConnectionPool", (Object)cp);
        }
        catch (SQLException e) {
            System.err.println(e.toString());
        }
        Hashtable systemStatus = new Hashtable();
        context.setAttribute("SystemStatus", systemStatus);
        try {
            WorkflowManager wfManager = new WorkflowManager();
            context.setAttribute("WorkflowManager", (Object)wfManager);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        try {
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory();
            Scheduler scheduler = schedulerFactory.getScheduler();
            context.setAttribute("Scheduler", (Object)scheduler);
            scheduler.getContext().put((Object)"SystemStatus", systemStatus);
            System.out.println("ContextListener-> Scheduler added");
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        try {
            IceletContainerServices containerServices = new IceletContainerServices();
            PortletContainerFactory portletFactory = PortletContainerFactory.getInstance();
            PortletContainer portletContainer = portletFactory.createContainer("PortletContainer", (RequiredContainerServices)containerServices, (OptionalContainerServices)containerServices);
            portletContainer.init(context);
            context.setAttribute("PortletContainer", (Object)portletContainer);
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        System.out.println("ContextListener-> Initialized");
    }

    public void contextDestroyed(ServletContextEvent event) {
        PortletContainer container;
        Crontab crontab;
        ServletContext context = event.getServletContext();
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ContextListener-> Shutting down");
        }
        if ((crontab = (Crontab)context.getAttribute("Crontab")) != null) {
            crontab.uninit(200);
            context.removeAttribute("Crontab");
            System.out.println("ContextListener-> CRON stopped");
        }
        try {
            Scheduler scheduler = (Scheduler)context.getAttribute("Scheduler");
            if (scheduler != null) {
                scheduler.shutdown(true);
                context.removeAttribute("Scheduler");
                System.out.println("ContextListener-> Scheduler stopped");
            }
        }
        catch (Exception e) {
            System.err.println(e.toString());
        }
        WorkflowManager wfManager = (WorkflowManager)context.getAttribute("WorkflowManager");
        if (wfManager != null) {
            context.removeAttribute("WorkflowManager");
        }
        if ((container = (PortletContainer)context.getAttribute("PortletContainer")) != null) {
            try {
                container.destroy();
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
            context.removeAttribute("PortletContainer");
        }
        IceletManager.destroy(context);
        Hashtable systemStatusList = (Hashtable)context.getAttribute("SystemStatus");
        if (systemStatusList != null) {
            for (SystemStatus thisSystem : systemStatusList.values()) {
                thisSystem.stopServers();
            }
            systemStatusList.clear();
        }
        context.removeAttribute("SystemStatus");
        context.removeAttribute("DynamicFormList");
        context.removeAttribute("DynamicFormConfig");
        context.removeAttribute("ContainerMenu");
        context.removeAttribute("ContainerMenuConfig");
        ConnectionPool cp = (ConnectionPool)context.getAttribute("ConnectionPool");
        if (cp != null) {
            cp.closeAllConnections();
            cp.destroy();
            context.removeAttribute("ConnectionPool");
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("DestroyHook-> Shutdown complete");
        }
    }
}

