/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller;

import com.zeroio.controller.Tracker;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.aspcfs.controller.SessionManager;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.controller.UserSession;
import org.aspcfs.modules.login.beans.UserBean;

public class ContextSessionListener
implements HttpSessionAttributeListener,
HttpSessionListener {
    public void sessionCreated(HttpSessionEvent event) {
    }

    public void sessionDestroyed(HttpSessionEvent event) {
    }

    public void attributeAdded(HttpSessionBindingEvent event) {
        ServletContext context = event.getSession().getServletContext();
        if ("User".equals(event.getName())) {
            SystemStatus systemStatus;
            UserBean thisUser = (UserBean)((Object)event.getValue());
            thisUser.setSessionId(event.getSession().getId());
            Hashtable systems = (Hashtable)context.getAttribute("SystemStatus");
            if (systems != null && thisUser.getConnectionElement() != null && (systemStatus = (SystemStatus)systems.get(thisUser.getConnectionElement().getUrl())) != null) {
                Tracker tracker = ((SystemStatus)((Hashtable)context.getAttribute("SystemStatus")).get(thisUser.getConnectionElement().getUrl())).getTracker();
                tracker.add(thisUser.getSessionId(), thisUser);
            }
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent se) {
        ServletContext context = se.getSession().getServletContext();
        try {
            SystemStatus systemStatus;
            Hashtable systems;
            int userId;
            UserBean thisUser;
            if (se.getName().equals("User") && (thisUser = (UserBean)((Object)se.getValue())) != null && (userId = thisUser.getActualUserId()) > -2 && (systems = (Hashtable)context.getAttribute("SystemStatus")) != null && (systemStatus = (SystemStatus)systems.get(thisUser.getConnectionElement().getUrl())) != null) {
                UserSession thisSession;
                SessionManager thisManager = systemStatus.getSessionManager();
                if (thisManager != null && (thisSession = thisManager.getUserSession(userId)) != null && thisSession.getId().equals(thisUser.getSessionId())) {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ContextSessionListener-> Session for user " + userId + " ended");
                    }
                    thisManager.removeUser(userId);
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ContextSessionListener-> User removed from valid user list");
                    }
                }
                Tracker tracker = systemStatus.getTracker();
                tracker.remove(thisUser.getSessionId());
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println("ContextSessionListener-> attributeRemoved Error: " + e.toString());
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
        ServletContext context = event.getSession().getServletContext();
        if ("User".equals(event.getName())) {
            UserBean thisUser = (UserBean)((Object)event.getValue());
            thisUser.setSessionId(event.getSession().getId());
            Tracker tracker = ((SystemStatus)((Hashtable)context.getAttribute("SystemStatus")).get(thisUser.getConnectionElement().getUrl())).getTracker();
            tracker.remove(event.getSession().getId());
            tracker.add(thisUser.getSessionId(), thisUser);
        }
    }
}

