/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.servlets.ControllerGlobalItemsHook;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.TimeZone;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.RecentItem;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.tasks.base.TaskList;
import org.aspcfs.utils.DatabaseUtils;

public class GlobalItemsHook
implements ControllerGlobalItemsHook {
    public String generateItems(Servlet servlet, HttpServletRequest request) {
        ConnectionElement ce = (ConnectionElement)request.getSession().getAttribute("ConnectionElement");
        if (ce == null) {
            return null;
        }
        Hashtable systems = (Hashtable)servlet.getServletConfig().getServletContext().getAttribute("SystemStatus");
        if (systems == null) {
            return null;
        }
        SystemStatus systemStatus = (SystemStatus)systems.get(ce.getUrl());
        if (systemStatus == null) {
            return null;
        }
        UserBean thisUser = (UserBean)((Object)request.getSession().getAttribute("User"));
        if (thisUser == null) {
            return null;
        }
        TimeZone timeZone = TimeZone.getTimeZone(thisUser.getUserRecord().getTimeZone());
        int userId = thisUser.getUserId();
        int departmentId = thisUser.getUserRecord().getContact().getDepartment();
        int contactId = thisUser.getUserRecord().getContact().getId();
        Calendar today = Calendar.getInstance(timeZone);
        today.set(10, 0);
        today.set(12, 0);
        today.set(13, 0);
        today.set(14, 0);
        Calendar tomorrow = Calendar.getInstance(timeZone);
        tomorrow.set(10, 0);
        tomorrow.set(12, 0);
        tomorrow.set(13, 0);
        tomorrow.set(14, 0);
        tomorrow.add(5, 1);
        StringBuffer items = new StringBuffer();
        if (systemStatus.hasPermission(userId, "globalitems-search-view")) {
            items.append("<!-- Site Search --><table class=\"globalItem\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\"><form action='Search.do?command=SiteSearch' method='post'><tr><th>" + systemStatus.getLabel("search.header") + "</th></tr>" + "<tr>" + "<td nowrap>" + "<img src=\"images/icons/stock_zoom-16.gif\" border=\"0\" align=\"absmiddle\" height=\"16\" width=\"16\"/> " + "<input type='text' size='10' name='searchSearchText'>" + "<input type='submit' value='" + systemStatus.getLabel("search.go") + "' name='Search'>" + "</td>" + "</tr>" + "</form>" + "</table>");
        }
        if (!systemStatus.hasField("global.quickactions") && systemStatus.hasPermission(userId, "globalitems-search-view")) {
            items.append("<!-- Quick Action --><script language='javascript' type='text/javascript' src='javascript/popURL.js'></script><script language='javascript' type='text/javascript' src='javascript/quickAction.js'></script><table class=\"globalItem\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\"><tr><th>" + systemStatus.getLabel("quickactions.header") + "</th></tr>" + "<tr>" + "<td nowrap>" + "<img src=\"images/icons/stock_hyperlink-target-16.gif\" border=\"0\" align=\"absmiddle\" height=\"16\" width=\"16\"/> " + "<select name='quickAction' onChange='javascript:quickAction(this.options[this.selectedIndex].value);this.selectedIndex = 0'>");
            items.append("<option value='0'>" + systemStatus.getLabel("quickactions.select") + "</option>");
            if (systemStatus.hasPermission(userId, "accounts-accounts-add")) {
                items.append("<option value='account'>" + systemStatus.getLabel("quickactions.addAccount") + "</option>");
            }
            if (systemStatus.hasPermission(userId, "contacts-external_contacts-calls-add")) {
                items.append("<option value='call'>" + systemStatus.getLabel("quickactions.logActivity") + "</option>");
            }
            if (systemStatus.hasPermission(userId, "contacts-external_contacts-calls-add")) {
                items.append("<option value='schedule'>" + systemStatus.getLabel("quickactions.scheduleActivity") + "</option>");
            }
            if (systemStatus.hasPermission(userId, "contacts-external_contacts-add")) {
                items.append("<option value='contact'>" + systemStatus.getLabel("quickactions.addContact") + "</option>");
            }
            if (systemStatus.hasPermission(userId, "myhomepage-tasks-add")) {
                items.append("<option value='task'>" + systemStatus.getLabel("quickactions.addTask") + "</option>");
            }
            if (systemStatus.hasPermission(userId, "tickets-tickets-add")) {
                items.append("<option value='ticket'>" + systemStatus.getLabel("quickactions.addTicket") + "</option>");
            }
            items.append("</select></td></tr></form></table>");
        }
        if (systemStatus.hasPermission(userId, "globalitems-myitems-view")) {
            ConnectionPool sqlDriver = (ConnectionPool)servlet.getServletConfig().getServletContext().getAttribute("ConnectionPool");
            Connection db = null;
            items.append("<!-- My Items --><table class=\"globalItem\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\"><tr><th>" + systemStatus.getLabel("myitems.header") + "</th></tr>" + "<tr>" + "<td nowrap>");
            try {
                int taskCount;
                int ticketCount;
                int myItems = 0;
                db = sqlDriver.getConnection(ce);
                String sql = null;
                PreparedStatement pst = null;
                ResultSet rs = null;
                if (systemStatus.hasPermission(userId, "contacts-external_contacts-calls-view")) {
                    int callCount = 0;
                    sql = "SELECT COUNT(*) as callcount FROM call_log WHERE alertdate >= ? AND alertdate < ? AND enteredby = ?";
                    pst = db.prepareStatement(sql);
                    pst.setTimestamp(1, new Timestamp(today.getTimeInMillis()));
                    pst.setTimestamp(2, new Timestamp(tomorrow.getTimeInMillis()));
                    pst.setInt(3, userId);
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        callCount = rs.getInt("callcount");
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("GlobalItemsHook-> Calls: " + callCount);
                        }
                    }
                    rs.close();
                    pst.close();
                    if (callCount > 0) {
                        items.append("<a href='MyCFS.do?command=Home' class='s'>" + systemStatus.getLabel("myitems.pendingActivities") + "</a> (" + GlobalItemsHook.paint(callCount) + ")<br>");
                        ++myItems;
                    }
                }
                if (systemStatus.hasPermission(userId, "projects-view")) {
                    int activityCount = 0;
                    sql = "SELECT count(*) as activitycount FROM project_assignments WHERE complete_date IS NULL AND user_assign_id = ?";
                    pst = db.prepareStatement(sql);
                    pst.setInt(1, userId);
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        activityCount = rs.getInt("activitycount");
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("GlobalItemsHook-> Activities: " + activityCount);
                        }
                    }
                    rs.close();
                    pst.close();
                    if (activityCount > 0) {
                        items.append("<a href='ProjectManagement.do?command=Overview' class='s'>" + systemStatus.getLabel("myitems.assignedActivities") + "</a> (" + GlobalItemsHook.paint(activityCount) + ")<br>");
                        ++myItems;
                    }
                }
                if (systemStatus.hasPermission(userId, "tickets-view")) {
                    ticketCount = 0;
                    sql = "SELECT COUNT(*) as ticketcount FROM ticket WHERE assigned_to = ? AND closed IS NULL AND ticketid NOT IN (SELECT ticket_id FROM ticketlink_project) ";
                    pst = db.prepareStatement(sql);
                    pst.setInt(1, userId);
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        ticketCount = rs.getInt("ticketcount");
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("GlobalItemsHook-> Tickets: " + ticketCount);
                        }
                    }
                    rs.close();
                    pst.close();
                    if (ticketCount > 0) {
                        items.append("<a href='TroubleTickets.do?command=Home' class='s'>" + systemStatus.getLabel("myitems.assignedTickets") + "</a> (" + GlobalItemsHook.paint(ticketCount) + ")<br>");
                        ++myItems;
                    }
                }
                if (systemStatus.hasPermission(userId, "myhomepage-action-plans-view")) {
                    int i = 0;
                    int planCount = 0;
                    sql = "SELECT count(*) AS plancount FROM action_plan_work apw WHERE apw.enabled = ? AND apw.plan_work_id IN (SELECT aphw.plan_work_id FROM action_phase_work aphw WHERE aphw.phase_work_id IN (SELECT phase_work_id FROM action_item_work aiw WHERE aiw.start_date IS NOT NULL AND aiw.end_date IS NULL AND (aiw.owner = ? OR aiw.action_step_id IN (SELECT s.step_id FROM action_step s WHERE (s.permission_type = ? AND s.role_id IN (SELECT role_id FROM " + DatabaseUtils.addQuotes(db, "access") + " WHERE user_id = ? ))) " + "OR aiw.action_step_id IN (SELECT s.step_id FROM action_step s " + "WHERE s.permission_type = ? AND s.department_id IN (SELECT department FROM contact WHERE user_id = ? )) " + "OR aiw.action_step_id IN (SELECT s.step_id FROM action_step s " + "WHERE s.permission_type = ? AND s.group_id IN (SELECT group_id from user_group_map WHERE user_id = ? )) " + ")) " + "AND aphw.start_date IS NOT NULL AND aphw.end_date IS NULL AND aphw.status_id IS NULL ) ";
                    pst = db.prepareStatement(sql);
                    pst.setBoolean(++i, true);
                    pst.setInt(++i, userId);
                    pst.setInt(++i, 2);
                    pst.setInt(++i, userId);
                    pst.setInt(++i, 3);
                    pst.setInt(++i, userId);
                    pst.setInt(++i, 8);
                    pst.setInt(++i, userId);
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        planCount = rs.getInt("plancount");
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("GlobalItemsHook-> Action Plans: " + planCount);
                        }
                    }
                    rs.close();
                    pst.close();
                    if (planCount > 0) {
                        items.append("<a href='MyActionPlans.do?command=View' class='s'>" + systemStatus.getLabel("actionPlan.myWaitingActionPlans") + "</a> (" + GlobalItemsHook.paint(planCount) + ")<br>");
                        ++myItems;
                    }
                }
                if (systemStatus.hasPermission(userId, "tickets-view")) {
                    ticketCount = 0;
                    sql = "SELECT COUNT(*) as ticketcount FROM ticket WHERE assigned_to = ? AND closed IS NULL AND ticketid IN (SELECT ticket_id FROM ticketlink_project) ";
                    pst = db.prepareStatement(sql);
                    pst.setInt(1, userId);
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        ticketCount = rs.getInt("ticketcount");
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("GlobalItemsHook-> Tickets: " + ticketCount);
                        }
                    }
                    rs.close();
                    pst.close();
                    if (ticketCount > 0) {
                        items.append("<a href='ProjectManagement.do?' class='s'>" + systemStatus.getLabel("myitems.assignedProjectTickets") + "</a> (" + GlobalItemsHook.paint(ticketCount) + ")<br>");
                        ++myItems;
                    }
                }
                if (systemStatus.hasPermission(userId, "tickets-view")) {
                    ticketCount = 0;
                    sql = "SELECT COUNT(*) as ticketcount FROM ticket WHERE (assigned_to = -1 OR assigned_to IS NULL) AND closed IS NULL AND (department_code = ? OR department_code in (0, -1)) AND ticketid NOT IN (SELECT ticket_id FROM ticketlink_project) ";
                    pst = db.prepareStatement(sql);
                    pst.setInt(1, departmentId);
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        ticketCount = rs.getInt("ticketcount");
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("GlobalItemsHook-> Tickets (Unassigned): " + ticketCount);
                        }
                    }
                    rs.close();
                    pst.close();
                    if (ticketCount > 0) {
                        items.append("<a href='TroubleTickets.do?command=Home' class='s'>" + systemStatus.getLabel("myitems.unassignedTickets") + "</a> (" + GlobalItemsHook.paint(ticketCount) + ")<br>");
                        ++myItems;
                    }
                }
                if (systemStatus.hasPermission(userId, "myhomepage-inbox-view")) {
                    int inboxCount = 0;
                    sql = "SELECT COUNT(*) as inboxcount FROM cfsinbox_message m, cfsinbox_messagelink ml WHERE m.id = ml.id AND ml.sent_to = ? AND m.delete_flag = ? AND ml.status IN (0) ";
                    pst = db.prepareStatement(sql);
                    pst.setInt(1, contactId);
                    pst.setBoolean(2, false);
                    rs = pst.executeQuery();
                    if (rs.next()) {
                        inboxCount = rs.getInt("inboxcount");
                    }
                    rs.close();
                    pst.close();
                    if (inboxCount > 0) {
                        items.append("<a href='MyCFSInbox.do?command=Inbox&return=1' class='s'>" + systemStatus.getLabel("myitems.inbox") + "</a> (" + GlobalItemsHook.paint(inboxCount) + " " + systemStatus.getLabel("myitems.inbox.new") + ")<br>");
                        ++myItems;
                    }
                }
                if (systemStatus.hasPermission(userId, "myhomepage-tasks-view") && (taskCount = TaskList.queryPendingCount(db, userId)) > 0) {
                    items.append("<a href='MyTasks.do?command=ListTasks' class='s'>" + systemStatus.getLabel("myitems.tasks") + "</a> (" + GlobalItemsHook.paint(taskCount) + " " + systemStatus.getLabel("myitems.tasks.incomplete") + ")<br>");
                    ++myItems;
                }
                if (myItems == 0) {
                    items.append(systemStatus.getLabel("myitems.noItems") + "<br />&nbsp;<br />");
                }
            }
            catch (Exception e) {
                System.out.println("GlobalItemsHook Error-> " + e.toString());
                e.printStackTrace(System.out);
            }
            sqlDriver.free(db);
            items.append("</td></tr></table>");
        }
        if (systemStatus.hasPermission(userId, "globalitems-recentitems-view")) {
            items.append("<!-- Recent Items --><table class=\"globalItem\" width=\"100%\" cellpadding=\"0\" cellspacing=\"0\"><tr><th>" + systemStatus.getLabel("myitems.recentItems") + "</th></tr>" + "<tr>" + "<td>");
            ArrayList recentItems = (ArrayList)request.getSession().getAttribute("RecentItems");
            if (recentItems != null) {
                Iterator i = recentItems.iterator();
                while (i.hasNext()) {
                    RecentItem thisItem = (RecentItem)i.next();
                    items.append(thisItem.getHtml());
                    if (!i.hasNext()) continue;
                    items.append("<br>");
                }
            } else {
                items.append(systemStatus.getLabel("myitems.noRecentItems") + "<br>&nbsp;<br>");
            }
            items.append("</td></tr></table>");
        }
        if (items.length() > 0) {
            return items.toString();
        }
        return "";
    }

    private static String paint(int count) {
        if (count > 0) {
            return "<font color=\"red\">" + count + "</font>";
        }
        return "" + count;
    }
}

