/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.aspcfs.modules.base.Import;
import org.aspcfs.utils.ObjectUtils;

public class ImportManager {
    private Vector available = new Vector();
    private Vector busy = new Vector();
    private int maxItems = 2;
    private ConnectionPool connectionPool = null;

    public ImportManager() {
    }

    public ImportManager(ConnectionPool connectionPool) {
        this.connectionPool = connectionPool;
    }

    public ImportManager(ConnectionPool connectionPool, int maxItems) {
        this.connectionPool = connectionPool;
        this.maxItems = maxItems;
    }

    public void setAvailable(Vector tmp) {
        this.available = tmp;
    }

    public void setBusy(Vector tmp) {
        this.busy = tmp;
    }

    public void setMaxItems(int tmp) {
        this.maxItems = tmp;
    }

    public void setMaxItems(String tmp) {
        this.maxItems = Integer.parseInt(tmp);
    }

    public void setConnectionPool(ConnectionPool tmp) {
        this.connectionPool = tmp;
    }

    public Vector getAvailable() {
        return this.available;
    }

    public Vector getBusy() {
        return this.busy;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    public boolean isRunning(int importId) {
        return this.getImport(importId) != null;
    }

    public boolean add(Object thisImport) {
        Import importObj = (Import)((Object)thisImport);
        if (this.isRunning(importObj.getId())) {
            return false;
        }
        this.process(thisImport, 0);
        return true;
    }

    public synchronized void process(Object thisImport, int status) {
        try {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ImportManager -> Processing Import \"" + ((Import)((Object)thisImport)).getName() + "\"");
            }
            if (this.busy.size() < this.maxItems) {
                ObjectUtils.setParam(thisImport, "manager", this);
                Method method = thisImport.getClass().getMethod("start", null);
                method.invoke(thisImport, (Object[])null);
                ((Import)((Object)thisImport)).setStatusId(3);
                this.busy.add(thisImport);
                if (status == 1) {
                    this.available.remove(thisImport);
                }
            } else if (status == 0) {
                this.available.add(thisImport);
                ((Import)((Object)thisImport)).setStatusId(2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Connection getConnection(ConnectionElement ce) throws SQLException {
        if (ce != null) {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ImportManager-> got ce clone");
            }
            ConnectionElement thisElement = (ConnectionElement)ce.clone();
            thisElement.setAllowCloseOnIdle(false);
            return this.connectionPool.getConnection(thisElement);
        }
        return null;
    }

    public void free(Connection db) {
        if (db != null) {
            this.connectionPool.free(db);
        }
    }

    public void free(Object thisImport) {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ImportManager -> Completed Import " + ((Import)((Object)thisImport)).getId());
        }
        if (thisImport != null) {
            this.busy.remove(thisImport);
            thisImport = null;
        }
        this.processNextImport();
    }

    public void processNextImport() {
        if (this.available.size() > 0) {
            this.process(this.available.firstElement(), 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(int importId) {
        block7: {
            Object importClass = this.getImport(importId);
            try {
                if (importClass == null) break block7;
                ImportManager importManager = this;
                synchronized (importManager) {
                    if (((Import)((Object)importClass)).getStatusId() == 2) {
                        this.available.remove(importClass);
                        this.processNextImport();
                    } else {
                        Method method = importClass.getClass().getMethod("cancel", null);
                        method.invoke(importClass, (Object[])null);
                    }
                }
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public Object getImport(int importId) {
        Import thisImport = null;
        boolean found = false;
        Iterator i = this.available.iterator();
        while (i.hasNext() && !found) {
            Import tmpObj = (Import)((Object)i.next());
            Import tmp = tmpObj;
            if (tmp.getId() != importId) continue;
            thisImport = tmpObj;
            found = true;
        }
        if (!found) {
            Iterator j = this.busy.iterator();
            while (j.hasNext() && !found) {
                Import tmpObj = (Import)((Object)j.next());
                Import tmp = tmpObj;
                if (tmp.getId() != importId) continue;
                thisImport = tmpObj;
                found = true;
            }
        }
        return thisImport;
    }
}

