/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.framework.servlets.ControllerMainMenuHook;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.aspcfs.controller.MainMenuItem;
import org.aspcfs.controller.SubmenuItem;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.beans.ModuleBean;
import org.aspcfs.modules.login.beans.UserBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MainMenuHook
implements ControllerMainMenuHook {
    private ArrayList menuItems;
    private File file;
    private ServletContext context;

    public String executeControllerMainMenu(ServletConfig config) {
        this.context = config.getServletContext();
        this.menuItems = new ArrayList();
        if (config.getInitParameter("ModuleConfig") != null) {
            this.file = new File(this.context.getRealPath("/WEB-INF/" + config.getInitParameter("ModuleConfig")));
            this.load();
        }
        return "";
    }

    public void reload() {
        if (this.menuItems != null) {
            this.menuItems.clear();
            this.load();
        }
    }

    public void load() {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("MainMenuHook-> Loading menu configuration");
        }
        if (this.file == null) {
            return;
        }
        try {
            Document document = this.parseDocument();
            this.parseAllMenus(document);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void generateMenu(HttpServletRequest request, String actionPath) {
        ModuleBean thisModule;
        UserBean thisUser = (UserBean)((Object)request.getSession().getAttribute("User"));
        if (thisUser == null) {
            return;
        }
        ConnectionElement ce = (ConnectionElement)request.getSession().getAttribute("ConnectionElement");
        SystemStatus systemStatus = null;
        if (ce != null) {
            systemStatus = (SystemStatus)((Hashtable)this.context.getAttribute("SystemStatus")).get(ce.getUrl());
        }
        if ((thisModule = (ModuleBean)request.getAttribute("ModuleBean")) == null) {
            thisModule = new ModuleBean();
            request.setAttribute("ModuleBean", (Object)thisModule);
        }
        int menuWidth = 0;
        StringBuffer menuTops = new StringBuffer();
        StringBuffer menu = new StringBuffer();
        StringBuffer graphicMenu = new StringBuffer();
        StringBuffer smallMenu = new StringBuffer();
        ArrayList<String> smallMenuList = new ArrayList<String>();
        for (MainMenuItem thisMenu : this.menuItems) {
            if (!"".equals(thisMenu.getPermission()) && (systemStatus == null || !systemStatus.hasPermission(thisUser.getUserId(), thisMenu.getPermission()))) continue;
            String pageTitle = null;
            String shortHtml = null;
            String longHtml = null;
            if (systemStatus != null) {
                pageTitle = systemStatus.getMenuProperty(thisMenu.getPageTitle(), "page_title");
                shortHtml = systemStatus.getMenuProperty(thisMenu.getPageTitle(), "menu_title");
                longHtml = systemStatus.getMenuProperty(thisMenu.getPageTitle(), "page_title");
            }
            if (thisModule.getMenuKey() != null && thisMenu.hasActionName(thisModule.getMenuKey()) || thisModule.getMenuKey() == null && thisMenu.hasActionName(actionPath)) {
                if (pageTitle != null) {
                    thisModule.setName(pageTitle);
                } else {
                    thisModule.setName(thisMenu.getPageTitle());
                }
                menuTops.append("<th class=\"mtab-ls\"><img border=\"0\" src=\"images/blank.gif\" /></th><th class=\"mtab-rs\"><img border=\"0\" src=\"images/blank.gif\" /></th>");
                menu.append("<th colspan=\"2\" class=\"menutabs-th\" nowrap>");
                menu.append("<a href=\"" + thisMenu.getLink() + "\">");
                if (shortHtml != null) {
                    menu.append(shortHtml);
                } else {
                    menu.append(thisMenu.getShortHtml());
                }
                menu.append("</a>");
                menu.append("</th>");
                graphicMenu.append("<a href='" + thisMenu.getLink() + "'><img border='0' src='images/" + thisMenu.getGraphicOn() + "' width='" + thisMenu.getGraphicWidth() + "' height='" + thisMenu.getGraphicHeight() + "'></a>");
                if (longHtml != null) {
                    smallMenuList.add("<a " + MainMenuHook.addSelectedClass(thisMenu) + "href='" + thisMenu.getLink() + "'>" + longHtml + "</a>");
                } else {
                    smallMenuList.add("<a " + MainMenuHook.addSelectedClass(thisMenu) + "href='" + thisMenu.getLink() + "'>" + thisMenu.getLongHtml() + "</a>");
                }
                for (SubmenuItem thisItem : thisMenu.getSubmenuItems()) {
                    SubmenuItem newItem = new SubmenuItem(thisItem);
                    if (newItem.getName().equals(thisModule.getSubmenuKey())) {
                        newItem.setIsActive(true);
                        newItem.setHtmlClass("submenuItemSelected");
                    }
                    thisModule.addMenuItem(newItem);
                }
            } else {
                menuTops.append("<td class=\"mtab-l\"><img border=\"0\" src=\"images/blank.gif\" /></td><td class=\"mtab-r\"><img border=\"0\" src=\"images/blank.gif\" /></td>");
                menu.append("<td class=\"menutabs-td\" colspan=\"2\" nowrap");
                if (thisMenu.getShortHtmlRollover()) {
                    menu.append(" class=\"menutabUnselectedLinkOff\"");
                    menu.append(" onmouseover=\"swapClass(this,'menutabUnselectedLinkOn')\" onmouseout=\"swapClass(this,'menutabUnselectedLinkOff')\"");
                }
                menu.append(">");
                menu.append("<a href=\"" + thisMenu.getLink() + "\">");
                if (shortHtml != null) {
                    menu.append(shortHtml);
                } else {
                    menu.append(thisMenu.getShortHtml());
                }
                menu.append("</a>");
                menu.append("</td>");
                graphicMenu.append("<a href='" + thisMenu.getLink() + "'");
                if (thisMenu.hasGraphicRollover()) {
                    if (shortHtml != null) {
                        graphicMenu.append(" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('" + shortHtml + "','','images/" + thisMenu.getGraphicRollover() + "',1)\"");
                    } else {
                        graphicMenu.append(" onMouseOut=\"MM_swapImgRestore()\" onMouseOver=\"MM_swapImage('" + thisMenu.getShortHtml() + "','','images/" + thisMenu.getGraphicRollover() + "',1)\"");
                    }
                }
                graphicMenu.append(">");
                graphicMenu.append("<img ");
                graphicMenu.append("border='0' ");
                graphicMenu.append("src='images/" + thisMenu.getGraphicOff() + "' ");
                graphicMenu.append("width='" + thisMenu.getGraphicWidth() + "' ");
                graphicMenu.append("height='" + thisMenu.getGraphicHeight() + "' ");
                graphicMenu.append(">");
                graphicMenu.append("</a>");
                if (pageTitle != null) {
                    smallMenuList.add("<a " + MainMenuHook.addNormalClass(thisMenu) + "href='" + thisMenu.getLink() + "'>" + pageTitle + "</a>");
                } else {
                    smallMenuList.add("<a " + MainMenuHook.addNormalClass(thisMenu) + "href='" + thisMenu.getLink() + "'>" + thisMenu.getLongHtml() + "</a>");
                }
            }
            menuWidth += Integer.parseInt(thisMenu.getGraphicWidth());
        }
        Iterator i = smallMenuList.iterator();
        while (i.hasNext()) {
            String tmp = (String)i.next();
            if (i.hasNext()) {
                smallMenu.append(tmp + " | ");
                continue;
            }
            smallMenu.append(tmp);
        }
        String[] theMenus = new String[]{menu.toString(), "<td width=\"" + menuWidth + "\" nowrap>" + graphicMenu.toString() + "</td>", smallMenu.toString(), menu.toString(), menuTops.toString()};
        request.setAttribute("MainMenu", (Object)theMenus[0]);
        request.setAttribute("MainMenuGraphic", (Object)theMenus[1]);
        request.setAttribute("MainMenuWidth", (Object)String.valueOf(menuWidth));
        request.setAttribute("MainMenuSmall", (Object)theMenus[2]);
        request.setAttribute("MainMenuTableCells", (Object)theMenus[3]);
        request.setAttribute("MainMenuTops", (Object)theMenus[4]);
    }

    private Document parseDocument() throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(this.file);
        return document;
    }

    private void parseAllMenus(Document document) {
        this.menuItems.clear();
        NodeList menuTags = document.getElementsByTagName("menu");
        for (int i = 0; i < menuTags.getLength(); ++i) {
            Element menuTag = (Element)menuTags.item(i);
            MainMenuItem thisMenu = this.parseMenu(menuTag);
            this.menuItems.add(thisMenu);
        }
    }

    private MainMenuItem parseMenu(Element e) {
        MainMenuItem mainItem = new MainMenuItem();
        ArrayList submenuTable = mainItem.getSubmenuItems();
        NodeList children = e.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            if (children.item(i).getNodeType() != 1) continue;
            Element child = (Element)children.item(i);
            String childName = child.getTagName();
            if (childName.equals("action")) {
                mainItem.addActionName(child.getAttribute("name"));
                continue;
            }
            if (childName.equals("page")) {
                mainItem.setPageTitle(child.getAttribute("title"));
                continue;
            }
            if (childName.equals("permission")) {
                mainItem.setPermission(child.getAttribute("value"));
                continue;
            }
            if (childName.equals("long_html")) {
                mainItem.setLongHtml(child.getAttribute("value"));
                mainItem.setLongHtmlRollover(child.getAttribute("rollover"));
                continue;
            }
            if (childName.equals("short_html")) {
                mainItem.setShortHtml(child.getAttribute("value"));
                mainItem.setShortHtmlRollover(child.getAttribute("rollover"));
                continue;
            }
            if (childName.equals("link")) {
                mainItem.setLink(child.getAttribute("value"));
                mainItem.setClassNormal(child.getAttribute("classNormal"));
                mainItem.setClassSelected(child.getAttribute("classSelected"));
                continue;
            }
            if (childName.equals("graphic")) {
                mainItem.setGraphicWidth(child.getAttribute("width"));
                mainItem.setGraphicHeight(child.getAttribute("height"));
                mainItem.setGraphicOn(child.getAttribute("on"));
                mainItem.setGraphicOff(child.getAttribute("off"));
                mainItem.setGraphicRollover(child.getAttribute("rollover"));
                continue;
            }
            if (!childName.equals("submenu")) continue;
            SubmenuItem submenuItem = new SubmenuItem();
            submenuItem.setName(child.getAttribute("name"));
            NodeList submenu = child.getChildNodes();
            int submenuLen = submenu.getLength();
            for (int j = 0; j < submenuLen; ++j) {
                if (submenu.item(j).getNodeType() != 1) continue;
                Element submenuChild = (Element)submenu.item(j);
                String tagName = submenuChild.getTagName();
                if (tagName.equals("permission")) {
                    submenuItem.setPermission(submenuChild.getAttribute("value"));
                    continue;
                }
                if (tagName.equals("long_html")) {
                    submenuItem.setLongHtml(submenuChild.getAttribute("value"));
                    continue;
                }
                if (tagName.equals("short_html")) {
                    submenuItem.setShortHtml(submenuChild.getAttribute("value"));
                    continue;
                }
                if (tagName.equals("link")) {
                    submenuItem.setLink(submenuChild.getAttribute("value"));
                    continue;
                }
                if (!tagName.equals("graphic")) continue;
                submenuItem.setGraphicWidth(submenuChild.getAttribute("width"));
                submenuItem.setGraphicHeight(submenuChild.getAttribute("height"));
                submenuItem.setGraphicOn(submenuChild.getAttribute("on"));
                submenuItem.setGraphicOff(submenuChild.getAttribute("off"));
                submenuItem.setGraphicRollover(submenuChild.getAttribute("rollover"));
            }
            submenuTable.add(submenuItem);
        }
        return mainItem;
    }

    private static String addNormalClass(MainMenuItem thisItem) {
        if (thisItem.getClassNormal() != null && !"".equals(thisItem.getClassNormal())) {
            return "class=\"" + thisItem.getClassNormal() + "\" ";
        }
        return "";
    }

    private static String addSelectedClass(MainMenuItem thisItem) {
        if (thisItem.getClassSelected() != null && !"".equals(thisItem.getClassSelected())) {
            return "class=\"" + thisItem.getClassSelected() + "\" ";
        }
        return "";
    }
}

