/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.Assignment;
import com.zeroio.iteam.base.AssignmentList;
import com.zeroio.iteam.base.FileFolder;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.Issue;
import com.zeroio.iteam.base.IssueCategory;
import com.zeroio.iteam.base.IssueReply;
import com.zeroio.iteam.base.NewsArticle;
import com.zeroio.iteam.base.Project;
import com.zeroio.iteam.base.Requirement;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.accounts.base.Revenue;
import org.aspcfs.modules.accounts.base.RevenueList;
import org.aspcfs.modules.actionlist.base.ActionLists;
import org.aspcfs.modules.actionplans.base.ActionItemWorkNote;
import org.aspcfs.modules.actionplans.base.ActionPhase;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkNote;
import org.aspcfs.modules.actionplans.base.ActionStep;
import org.aspcfs.modules.admin.base.AccessType;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.Role;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserGroup;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.admin.base.Viewpoint;
import org.aspcfs.modules.assets.base.Asset;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.modules.base.Import;
import org.aspcfs.modules.communications.base.Campaign;
import org.aspcfs.modules.communications.base.InstantCampaign;
import org.aspcfs.modules.communications.base.Message;
import org.aspcfs.modules.communications.base.Recipient;
import org.aspcfs.modules.communications.base.SearchCriteriaElement;
import org.aspcfs.modules.communications.base.SurveyQuestion;
import org.aspcfs.modules.contacts.base.Call;
import org.aspcfs.modules.contacts.base.CallList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactImport;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.documents.base.DocumentStoreTeamMemberList;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.pipeline.base.OpportunityList;
import org.aspcfs.modules.pipeline.beans.OpportunityBean;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogImport;
import org.aspcfs.modules.products.base.ProductCatalogPricing;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.modules.products.base.ProductOption;
import org.aspcfs.modules.products.configurator.Configurator;
import org.aspcfs.modules.products.configurator.NumericalConfigurator;
import org.aspcfs.modules.products.configurator.StringConfigurator;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.modules.quotes.base.QuoteCondition;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.quotes.base.QuoteNote;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteRemark;
import org.aspcfs.modules.relationships.base.Relationship;
import org.aspcfs.modules.reports.base.Criteria;
import org.aspcfs.modules.reports.base.Parameter;
import org.aspcfs.modules.servicecontracts.base.ServiceContract;
import org.aspcfs.modules.servicecontracts.base.ServiceContractHours;
import org.aspcfs.modules.setup.beans.DatabaseBean;
import org.aspcfs.modules.setup.beans.ServerBean;
import org.aspcfs.modules.tasks.base.Task;
import org.aspcfs.modules.tasks.base.TaskCategory;
import org.aspcfs.modules.tasks.base.TaskList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketActivityLog;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraft;
import org.aspcfs.modules.troubletickets.base.TicketCategoryDraftAssignment;
import org.aspcfs.modules.troubletickets.base.TicketCategoryList;
import org.aspcfs.modules.troubletickets.base.TicketDefect;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.modules.troubletickets.base.TicketLog;
import org.aspcfs.modules.troubletickets.base.TicketReplacementPart;
import org.aspcfs.modules.troubletickets.base.TicketTask;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.ObjectUtils;
import org.aspcfs.utils.StringUtils;

public class ObjectValidator {
    private static int REQUIRED_FIELD = 2004090301;
    private static int IS_BEFORE_TODAY = 2004090302;
    private static int PUBLIC_ACCESS_REQUIRED = 2004090303;
    private static int INVALID_DATE = 2004090801;
    private static int INVALID_NUMBER = 2004091001;
    private static int INVALID_EMAIL = 2004091002;
    private static int INVALID_NOT_REQUIRED_DATE = 2004091003;
    private static int INVALID_EMAIL_NOT_REQUIRED = 2005060801;
    private static int PAST_DATE = 2006110117;

    public static boolean validate(SystemStatus systemStatus, Connection db, Object object) throws SQLException {
        Configurator configurator;
        ProductCatalogPricing pricing;
        Parameter parameter;
        Import thisImport;
        Object assignment;
        Object thisCategory;
        Task thisTask;
        GenericBean thisNote;
        GenericBean bean;
        block342: {
            Campaign campaign;
            ServiceContractHours thisContractHours;
            TicketLog thisTicketLog;
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ObjectValidator-> Checking object: " + object.getClass().getName());
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.accounts.base.Organization")) {
                Organization organization = (Organization)((Object)object);
                if (organization.getIsIndividual()) {
                    if (organization.getNameLast() == null || "".equals(organization.getNameLast().trim())) {
                        ObjectValidator.addError(systemStatus, object, "nameLast", REQUIRED_FIELD);
                    }
                } else if (organization.getName() == null || "".equals(organization.getName().trim())) {
                    ObjectValidator.addError(systemStatus, object, "name", REQUIRED_FIELD);
                }
                ObjectValidator.checkWarning(systemStatus, object, "alertDate", IS_BEFORE_TODAY);
                if (organization.getYearStarted() > Calendar.getInstance().get(1)) {
                    ObjectValidator.addWarning(systemStatus, object, "yearStarted", "object.validation.afterCurrentYear");
                }
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.contacts.base.Contact")) {
                Contact thisContact = (Contact)((Object)object);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "company", 255);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "title", 80);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "nameLast", 80);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "nameSalutation", 80);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "nameFirst", 80);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "nameMiddle", 80);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "nameSuffix", 80);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "employeeId", 80);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "startOfDay", 10);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "endOfDay", 10);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "url", 100);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "orgName", 255);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "comments", 255);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "additionalNames", 255);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "nickname", 80);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "role", 255);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "secretWord", 255);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "accountNumber", 50);
                if (thisContact.getOrgId() > 0 && thisContact.getSiteId() != Organization.getOrganizationSiteId(db, thisContact.getOrgId())) {
                    ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.contact.siteIncompatibleWithAccount");
                }
                if (thisContact.getNameLast() == null || thisContact.getNameLast().trim().equals("")) {
                    if (thisContact.getOrgId() == -1) {
                        if (thisContact.getCompany() == null || thisContact.getCompanyOnly().trim().equals("")) {
                            ObjectValidator.addError(systemStatus, object, "nameLast", REQUIRED_FIELD);
                            ObjectValidator.addError(systemStatus, object, "lastCompany", "object.validation.contact.lastCompanyRequired");
                        }
                    } else {
                        ObjectValidator.addError(systemStatus, object, "nameLast", REQUIRED_FIELD);
                    }
                }
                if (thisContact.getSiteId() < -1) {
                    ObjectValidator.addError(systemStatus, object, "siteId", REQUIRED_FIELD);
                }
                if (thisContact.getAccessType() != -1) {
                    AccessType thisType = new AccessType(db, thisContact.getAccessType());
                    if (thisContact.getOrgId() > 0 && thisType.getRuleId() != 626030334) {
                        ObjectValidator.addError(systemStatus, object, "accountAccess", PUBLIC_ACCESS_REQUIRED);
                    }
                    if (thisType.getRuleId() == 626030333 && thisContact.getOwner() != thisContact.getEnteredBy()) {
                        ObjectValidator.addError(systemStatus, object, "accessReassign", "object.validation.OwnerMustBeEnteredBy");
                    }
                } else {
                    ObjectValidator.addError(systemStatus, object, "access", REQUIRED_FIELD);
                }
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.troubletickets.base.Ticket")) {
                UserGroup group;
                User user;
                Ticket thisTicket = (Ticket)((Object)object);
                if (thisTicket.getProblem() == null || thisTicket.getProblem().trim().equals("")) {
                    ObjectValidator.addError(systemStatus, object, "problem", REQUIRED_FIELD);
                }
                if (thisTicket.getCloseIt() && (thisTicket.getSolution() == null || thisTicket.getSolution().trim().equals(""))) {
                    ObjectValidator.addError(systemStatus, object, "solution", "object.validation.ticket.solutionRequired");
                }
                if (thisTicket.getContactId() == -1) {
                    ObjectValidator.addError(systemStatus, object, "contactId", "object.validation.ticket.contactRequired");
                }
                if (thisTicket.getOrgId() == -1) {
                    ObjectValidator.addError(systemStatus, object, "orgId", "object.validation.ticket.organizationRequired");
                }
                if (thisTicket.getEstimatedResolutionDate() != null && thisTicket.getAssignedDate() != null && thisTicket.getEstimatedResolutionDate().before(thisTicket.getAssignedDate())) {
                    ObjectValidator.addError(systemStatus, object, "estimatedResolutionDate", "object.validation.ticket.estResolutionBeforeAssignment");
                }
                TicketCategoryList categoryList = new TicketCategoryList();
                categoryList.setExclusiveToSite(true);
                categoryList.setSiteId(thisTicket.getSiteId());
                categoryList.buildList(db);
                if (thisTicket.getCatCode() > 0 && categoryList.getValueFromId(thisTicket.getCatCode()) == null) {
                    ObjectValidator.addError(systemStatus, object, "catCode", "tickets.invalidCategorySelected.text");
                }
                if (thisTicket.getSubCat1() > 0 && categoryList.getValueFromId(thisTicket.getSubCat1()) == null) {
                    ObjectValidator.addError(systemStatus, object, "subCat1", "tickets.invalidCategorySelected.text");
                }
                if (thisTicket.getSubCat2() > 0 && categoryList.getValueFromId(thisTicket.getSubCat2()) == null) {
                    ObjectValidator.addError(systemStatus, object, "subCat2", "tickets.invalidCategorySelected.text");
                }
                if (thisTicket.getSubCat3() > 0 && categoryList.getValueFromId(thisTicket.getSubCat3()) == null) {
                    ObjectValidator.addError(systemStatus, object, "subCat3", "tickets.invalidCategorySelected.text");
                }
                if (thisTicket.getAssignedTo() > -1 && (user = new User(db, thisTicket.getAssignedTo())).getSiteId() != -1 && thisTicket.getSiteId() != user.getSiteId() && thisTicket.getProjectId() == -1) {
                    ObjectValidator.addError(systemStatus, object, "assignedTo", "tickets.ticketCategoryDraftAssignment.invalidUserAssignment.text");
                }
                if (thisTicket.getUserGroupId() > -1 && (group = new UserGroup(db, thisTicket.getUserGroupId())).getSiteId() != -1 && group.getSiteId() != thisTicket.getSiteId()) {
                    ObjectValidator.addError(systemStatus, object, "userGroupId", "tickets.ticketCategoryDraftAssignment.invalidUserGroupAssignment.text");
                }
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.troubletickets.base.TicketLog") && ((thisTicketLog = (TicketLog)((Object)object)).getTicketId() == -1 || thisTicketLog.getEntryText() == null || thisTicketLog.getEntryText().trim().equals("") || thisTicketLog.getEnteredBy() == -1 || thisTicketLog.getModifiedBy() == -1)) {
                return false;
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.troubletickets.base.TicketActivityLog")) {
                TicketActivityLog thisLog = (TicketActivityLog)((Object)object);
                if (thisLog.getFollowUpRequired() || thisLog.getAlertDate() != null && !"".equals(thisLog.getAlertDate()) || thisLog.getFollowUpDescription() != null && !"".equals(thisLog.getFollowUpDescription())) {
                    if (!thisLog.getFollowUpRequired()) {
                        ObjectValidator.addError(systemStatus, object, "followUpRequired", REQUIRED_FIELD);
                    }
                    ObjectValidator.checkError(systemStatus, object, "alertDate", INVALID_DATE);
                    ObjectValidator.checkError(systemStatus, object, "followUpDescription", REQUIRED_FIELD);
                } else if (!(thisLog.getFollowUpRequired() || thisLog.getAlertDate() != null && !"".equals(thisLog.getAlertDate()) || thisLog.getFollowUpDescription() != null && !"".equals(thisLog.getFollowUpDescription()) || thisLog.getTicketPerDayDescriptionList() != null && thisLog.getTicketPerDayDescriptionList().size() != 0)) {
                    ObjectValidator.addError(systemStatus, object, "action", "object.validation.actionError.blankFormCanNotBeSaved");
                }
                ObjectValidator.checkWarning(systemStatus, object, "alertDate", IS_BEFORE_TODAY);
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.pipeline.base.OpportunityHeader")) {
                OpportunityHeader oppHeader = (OpportunityHeader)((Object)object);
                if (oppHeader.getManager() == -1) {
                    ObjectValidator.addError(systemStatus, object, "manager", "object.validation.pipeline.noManagerSelected.text");
                }
                if (oppHeader.getDescription() == null || "".equals(oppHeader.getDescription().trim())) {
                    ObjectValidator.addError(systemStatus, object, "description", REQUIRED_FIELD);
                }
                if (oppHeader.getContactLink() == -1 && oppHeader.getAccountLink() == -1) {
                    ObjectValidator.addError(systemStatus, object, "acctContact", "object.validation.opportunity.accountContactRequired");
                }
                if (oppHeader.getContactLink() != -1 || oppHeader.getAccountLink() != -1) {
                    int managerSiteId;
                    int oppSiteId = -1;
                    oppSiteId = oppHeader.getContactLink() != -1 ? Contact.getContactSiteId(db, oppHeader.getContactLink()) : Organization.getOrganizationSiteId(db, oppHeader.getAccountLink());
                    if (oppSiteId != -1 && oppHeader.getManager() != -1 && (managerSiteId = systemStatus.getUser(oppHeader.getManager()).getSiteId()) != -1 && managerSiteId != oppSiteId) {
                        ObjectValidator.addError(systemStatus, object, "manager", "object.validation.opportunity.permissionNotAllowedForThisSite");
                    }
                    if (oppSiteId == -1 && oppHeader.getManager() != -1 && (managerSiteId = systemStatus.getUser(oppHeader.getManager()).getSiteId()) != -1) {
                        ObjectValidator.addError(systemStatus, object, "manager", "object.validation.opportunity.permissionNotAllowedForThisSite");
                    }
                }
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.pipeline.beans.OpportunityBean")) {
                bean = (OpportunityBean)((Object)object);
                OpportunityComponent oppComponent = bean.getComponent();
                OpportunityHeader oppHeader = bean.getHeader();
                AccessTypeList accessTypes = systemStatus.getAccessTypeList(db, 804051057);
                if (oppHeader.getAccessType() == accessTypes.getCode(626030335) && oppHeader.getManager() != -1) {
                    User userRecord = systemStatus.getUser(oppHeader.getManager());
                    userRecord.setBuildHierarchy(true);
                    userRecord.buildResources(db);
                    UserList shortChildList = userRecord.getShortChildList();
                    UserList fullChildList = userRecord.getFullChildList(shortChildList, new UserList());
                    fullChildList.add(userRecord);
                    Iterator iterator = fullChildList.iterator();
                    boolean flag = false;
                    while (iterator.hasNext()) {
                        User tempUser = (User)((Object)iterator.next());
                        if (tempUser.getId() != oppComponent.getOwner()) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) {
                        ObjectValidator.addError(systemStatus, object, "owner", "object.validation.pipeline.invalidOwner.text");
                    }
                }
                if (oppComponent != null) {
                    int ownerSiteId = -1;
                    if (oppComponent.getOwner() != -1) {
                        ownerSiteId = systemStatus.getUser(oppComponent.getOwner()).getSiteId();
                        if (oppHeader.getContactLink() != -1 || oppHeader.getAccountLink() != -1) {
                            int oppSiteId = -1;
                            oppSiteId = oppHeader.getContactLink() != -1 ? Contact.getContactSiteId(db, oppHeader.getContactLink()) : Organization.getOrganizationSiteId(db, oppHeader.getAccountLink());
                            if (oppSiteId != -1 && ownerSiteId != -1 && ownerSiteId != oppSiteId) {
                                ObjectValidator.addError(systemStatus, object, "owner", "object.validation.opportunity.permissionNotAllowedForThisSite");
                            }
                            if (oppSiteId == -1 && ownerSiteId != -1) {
                                ObjectValidator.addError(systemStatus, object, "owner", "object.validation.opportunity.permissionNotAllowedForThisSite");
                            }
                        }
                    }
                }
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.pipeline.base.OpportunityComponent")) {
                OpportunityComponent oppComponent = (OpportunityComponent)((Object)object);
                User owner = null;
                if (oppComponent.getOwner() == -1) {
                    ObjectValidator.addError(systemStatus, object, "owner", "object.validation.pipeline.noOwnerSelected.text");
                }
                if (oppComponent.getOwner() != -1 && systemStatus != null) {
                    owner = systemStatus.getUser(oppComponent.getOwner());
                }
                if (owner != null && owner.getExpires() != null && owner.getExpires().before(new Timestamp(Calendar.getInstance().getTimeInMillis()))) {
                    ObjectValidator.addWarning(systemStatus, object, "owner", "object.validation.expiredUser");
                }
                if (owner != null && !owner.getEnabled()) {
                    ObjectValidator.addWarning(systemStatus, object, "owner", "object.validation.disabledUser");
                }
                if (!systemStatus.hasField("pipeline-compDescription") && (oppComponent.getDescription() == null || "".equals(oppComponent.getDescription().trim()))) {
                    ObjectValidator.addError(systemStatus, object, "componentDescription", REQUIRED_FIELD);
                }
                if (oppComponent.getCloseProb() == 0.0) {
                    ObjectValidator.addError(systemStatus, object, "closeProb", REQUIRED_FIELD);
                } else if (oppComponent.getCloseProb() > 1.0) {
                    ObjectValidator.addError(systemStatus, object, "closeProb", "object.validation.opportunityComponent.closeProbNotGTOneHundred");
                } else if (oppComponent.getCloseProb() < 0.0) {
                    ObjectValidator.addError(systemStatus, object, "closeProb", "object.validation.opportunityComponent.closeProbNotLTZero");
                }
                if (!systemStatus.hasField("pipeline-lowEstimate") && !systemStatus.hasField("opportunity.lowEstimateCanNotBeZero") && oppComponent.getLow() > oppComponent.getHigh()) {
                    ObjectValidator.addError(systemStatus, object, "low", "object.validation.opportunityComponent.lowNotGTHigh");
                }
                if (oppComponent.getCloseDate() == null || oppComponent.getCloseDateString().trim().equals("")) {
                    ObjectValidator.addError(systemStatus, object, "closeDate", REQUIRED_FIELD);
                }
                if (!systemStatus.hasField("pipeline-bestGuessEstimate") && oppComponent.getGuess() == 0.0) {
                    ObjectValidator.addError(systemStatus, object, "guess", REQUIRED_FIELD);
                }
                if (systemStatus.hasField("opportunity.lowEstimateCanNotBeZero")) {
                    if (oppComponent.getLow() == 0.0) {
                        ObjectValidator.addError(systemStatus, object, "low", REQUIRED_FIELD);
                    }
                    if (oppComponent.getLow() < oppComponent.getGuess()) {
                        ObjectValidator.addError(systemStatus, object, "guess", "object.validation.opportunityComponent.lowNotGTGuess");
                    }
                }
                if (oppComponent.getGuess() == 0.0) {
                    ObjectValidator.addError(systemStatus, object, "guess", REQUIRED_FIELD);
                }
                if (!systemStatus.hasField("opportunity.termsAndUnits")) {
                    if (oppComponent.getTerms() == 0.0) {
                        ObjectValidator.addError(systemStatus, object, "terms", REQUIRED_FIELD);
                    } else if (oppComponent.getTerms() < 0.0) {
                        ObjectValidator.addError(systemStatus, object, "terms", "object.validation.opportunityComponent.termsNotLTZero");
                    }
                    if (oppComponent.getUnits() == null) {
                        ObjectValidator.addError(systemStatus, object, "terms", "object.validation.opportunityComponent.unitsNotNull");
                    }
                    if (oppComponent.getType() == null) {
                        ObjectValidator.addError(systemStatus, object, "terms", REQUIRED_FIELD);
                    }
                }
                if (!systemStatus.hasField("opportunity.source") && oppComponent.getType() == null) {
                    ObjectValidator.addError(systemStatus, object, "terms", REQUIRED_FIELD);
                }
                ObjectValidator.checkWarning(systemStatus, object, "alertDate", IS_BEFORE_TODAY);
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.pipeline.base.OpportunityReport")) {
                ObjectValidator.checkError(systemStatus, object, "subject", REQUIRED_FIELD);
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.contacts.base.Call")) {
                Call call = (Call)((Object)object);
                User callOwner = null;
                if (call.getOwner() != -1 && systemStatus != null) {
                    callOwner = systemStatus.getUser(call.getOwner());
                }
                if (callOwner != null && !callOwner.getEnabled()) {
                    ObjectValidator.addWarning(systemStatus, object, "owner", "object.validation.disabledUser");
                }
                if (callOwner != null && callOwner.getExpires() != null && callOwner.getExpires().after(new Timestamp(Calendar.getInstance().getTimeInMillis()))) {
                    ObjectValidator.addWarning(systemStatus, object, "owner", "object.validation.expiredUser");
                }
                if (call.getFollowupContactId() == -1 && call.getContactId() == -1 && call.getOrgId() == -1 && call.getOppHeaderId() == -1) {
                    ObjectValidator.addError(systemStatus, object, "link", "object.validation.call.notAssociated");
                }
                if (call.getLength() < 0) {
                    ObjectValidator.addError(systemStatus, object, "length", "object.validation.call.lengthNotLTZero");
                }
                if (call.getAlertDate() != null || call.getHasFollowup()) {
                    if ("".equals(StringUtils.toString(call.getAlertText().trim()))) {
                        ObjectValidator.addError(systemStatus, object, "description", REQUIRED_FIELD);
                    }
                    if (call.getAlertCallTypeId() < 1) {
                        ObjectValidator.addError(systemStatus, object, "followupType", REQUIRED_FIELD);
                    }
                    if (call.getPriorityId() == -1) {
                        ObjectValidator.addError(systemStatus, object, "priority", REQUIRED_FIELD);
                    }
                    if (call.getAlertDate() == null) {
                        ObjectValidator.addError(systemStatus, object, "alertDate", REQUIRED_FIELD);
                    }
                } else {
                    call.setPriorityId(-1);
                }
                ObjectValidator.checkWarning(systemStatus, object, "alertDate", IS_BEFORE_TODAY);
            }
            if (object.getClass().getName().equals("com.zeroio.iteam.base.FileItem")) {
                FileItem fileItem = (FileItem)object;
                ObjectValidator.checkError(systemStatus, object, "subject", REQUIRED_FIELD);
                ObjectValidator.checkError(systemStatus, object, "filename", REQUIRED_FIELD);
                if (fileItem.getLinkModuleId() == -1 || fileItem.getLinkItemId() == -1) {
                    ObjectValidator.addError(systemStatus, object, "action", "object.validation.noId");
                }
            }
            if (object.getClass().getName().equals("com.zeroio.iteam.base.FileFolder")) {
                FileFolder fileFolder = (FileFolder)object;
                if (fileFolder.getLinkModuleId() == -1 || fileFolder.getLinkItemId() == -1) {
                    ObjectValidator.addError(systemStatus, object, "action", "object.validation.noId");
                }
                ObjectValidator.checkError(systemStatus, object, "subject", REQUIRED_FIELD);
                ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "subject", 255);
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.servicecontracts.base.ServiceContract")) {
                ServiceContract thisContract = (ServiceContract)((Object)object);
                ObjectValidator.checkError(systemStatus, object, "serviceContractNumber", REQUIRED_FIELD);
                boolean initialStartDateExists = true;
                boolean currentStartDateExists = true;
                boolean currentEndDateExists = true;
                if (thisContract.getInitialStartDate() == null) {
                    ObjectValidator.addError(systemStatus, object, "initialStartDate", REQUIRED_FIELD);
                    initialStartDateExists = false;
                }
                if (thisContract.getCurrentStartDate() == null) {
                    currentStartDateExists = false;
                }
                if (thisContract.getCurrentEndDate() == null) {
                    currentEndDateExists = false;
                }
                if (currentEndDateExists) {
                    if (currentStartDateExists && thisContract.getCurrentEndDate().before(thisContract.getCurrentStartDate())) {
                        ObjectValidator.addError(systemStatus, object, "currentEndDate", "object.validation.serviceContract.currentEndDateNotGTCurrentContractDate");
                    }
                    if (initialStartDateExists && !currentStartDateExists && thisContract.getCurrentEndDate().before(thisContract.getInitialStartDate())) {
                        ObjectValidator.addError(systemStatus, object, "currentEndDate", "object.validation.serviceContract.currentEndDateNotLTInitialContractDate");
                    }
                }
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.servicecontracts.base.ServiceContractHours") && (thisContractHours = (ServiceContractHours)((Object)object)).getAdjustmentReason() == -1) {
                ObjectValidator.addError(systemStatus, object, "adjustmentReason", REQUIRED_FIELD);
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.assets.base.Asset")) {
                Asset asset = (Asset)((Object)object);
                ObjectValidator.checkError(systemStatus, object, "serialNumber", REQUIRED_FIELD);
                if (asset.getDateListed() == null) {
                    ObjectValidator.addError(systemStatus, object, "dateListed", REQUIRED_FIELD);
                }
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.troubletickets.base.TicketMaintenanceNote")) {
                ObjectValidator.checkError(systemStatus, object, "descriptionOfService", REQUIRED_FIELD);
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.troubletickets.base.TicketReplacementPart")) {
                TicketReplacementPart replacement = (TicketReplacementPart)((Object)object);
                if (replacement.getPartNumber() != null && !"".equals(replacement.getPartNumber())) {
                    ObjectValidator.checkError(systemStatus, object, "partDescription", REQUIRED_FIELD);
                }
                if (replacement.getPartDescription() != null && !"".equals(replacement.getPartDescription())) {
                    ObjectValidator.checkError(systemStatus, object, "partNumber", "partNumber", REQUIRED_FIELD);
                }
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.communications.base.Campaign")) {
                campaign = (Campaign)((Object)object);
                if (campaign.getType() == 1 && campaign.getActiveDate() != null && campaign.getActiveDate().before(new Date())) {
                    ObjectValidator.addError(systemStatus, object, "activeDate", PAST_DATE);
                }
                ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.communications.base.InstantCampaign")) {
                campaign = (InstantCampaign)((Object)object);
                if (((InstantCampaign)campaign).getInstantMessage() != null) {
                    ObjectValidator.checkError(systemStatus, (Object)((InstantCampaign)campaign).getInstantMessage(), "messageSubject", REQUIRED_FIELD);
                    ObjectValidator.checkError(systemStatus, (Object)((InstantCampaign)campaign).getInstantMessage(), "replyTo", INVALID_EMAIL);
                }
                ObjectValidator.checkError(systemStatus, object, "cc", INVALID_EMAIL_NOT_REQUIRED);
                ObjectValidator.checkError(systemStatus, object, "bcc", INVALID_EMAIL_NOT_REQUIRED);
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.communications.base.SearchCriteriaList")) {
                // empty if block
            }
            if (object.getClass().getName().equals("org.aspcfs.modules.communications.base.SearchCriteriaElement")) {
                SearchCriteriaElement element = (SearchCriteriaElement)object;
                StringTokenizer splitted = new StringTokenizer(element.getText(), "[*^|]");
                if (splitted.countTokens() > 1) {
                    ObjectValidator.addError(systemStatus, object, "text", REQUIRED_FIELD);
                }
                if (element.getFieldId() == 4) {
                    try {
                        Timestamp tmp = DateUtils.getUserToServerDateTime(null, 3, 1, element.getText(), new Locale(System.getProperty("LANGUAGE"), System.getProperty("COUNTRY")));
                        String date = null;
                        if (tmp == null) {
                            ObjectValidator.addError(systemStatus, object, "text", INVALID_DATE);
                            break block342;
                        }
                        date = tmp.toString();
                        try {
                            date = new java.sql.Date(Timestamp.valueOf(date).getTime()).toString();
                            Locale locale = new Locale(System.getProperty("LANGUAGE"), System.getProperty("COUNTRY"));
                            SimpleDateFormat localeFormatter = new SimpleDateFormat("yyyy-MM-dd", locale);
                            localeFormatter.applyPattern("yyyy-MM-dd");
                            localeFormatter.setLenient(false);
                            localeFormatter.parse(date);
                        }
                        catch (ParseException e1) {
                            ObjectValidator.addError(systemStatus, object, "text", INVALID_DATE);
                        }
                    }
                    catch (Exception e) {
                        ObjectValidator.addError(systemStatus, object, "text", INVALID_DATE);
                    }
                } else if (element.getFieldId() == 5) {
                    ObjectValidator.checkError(systemStatus, object, "text", INVALID_NUMBER);
                } else if (element.getFieldId() == 6) {
                    ObjectValidator.checkError(systemStatus, object, "text", INVALID_NUMBER);
                } else if (element.getFieldId() != 8 || element.getFieldId() != 11) {
                    ObjectValidator.checkError(systemStatus, object, "text", REQUIRED_FIELD);
                }
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.communications.beans.SearchFormBean")) {
            ObjectValidator.checkError(systemStatus, object, "groupName", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "searchCriteriaText", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.communications.base.Message")) {
            Message message = (Message)((Object)object);
            if ((message.getName() == null || message.getName().trim().equals("")) && !message.getDisableNameValidation()) {
                ObjectValidator.addError(systemStatus, object, "name", REQUIRED_FIELD);
            }
            ObjectValidator.checkError(systemStatus, object, "messageSubject", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "replyTo", INVALID_EMAIL);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.communications.base.Survey")) {
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.communications.base.SurveyQuestion")) {
            SurveyQuestion question = (SurveyQuestion)object;
            if (question.getRequired() && question.getDescription() == null || "".equals(question.getDescription().trim())) {
                ObjectValidator.addError(systemStatus, object, "description", REQUIRED_FIELD);
            }
            if (question.getType() == -1) {
                ObjectValidator.addError(systemStatus, object, "action", "object.validation.formIncomplete");
                ObjectValidator.addError(systemStatus, object, "type", REQUIRED_FIELD);
            }
            ObjectValidator.checkError(systemStatus, object, "questionText", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("com.zeroio.iteam.base.Project")) {
            Project project = (Project)object;
            ObjectValidator.checkError(systemStatus, object, "title", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "shortDescription", REQUIRED_FIELD);
            if (project.getRequestDate() == null) {
                ObjectValidator.addError(systemStatus, object, "requestDate", REQUIRED_FIELD);
            }
            if (project.getEstimatedCloseDate() != null && project.getRequestDate() != null && project.getEstimatedCloseDate().before(project.getRequestDate())) {
                ObjectValidator.addWarning(systemStatus, object, "estimatedCloseDate", "object.validation.project.estimatedCloseDateNotLTRequestDate");
            }
        }
        if (object.getClass().getName().equals("com.zeroio.iteam.base.NewsArticle")) {
            NewsArticle newsArticle = (NewsArticle)object;
            if (newsArticle.getProjectId() == -1) {
                ObjectValidator.addError(systemStatus, object, "action", "object.validation.project.projectIdRequired");
            }
            if (newsArticle.getIntro() != null) {
                ObjectValidator.checkError(systemStatus, object, "subject", REQUIRED_FIELD);
                if (newsArticle.getIntro() == null || newsArticle.getIntro().equals("") || newsArticle.getIntro().equals(" \r\n<br />\r\n ")) {
                    ObjectValidator.addError(systemStatus, object, "intro", REQUIRED_FIELD);
                }
                if (newsArticle.getEndDate() != null && newsArticle.getStartDate() != null && newsArticle.getEndDate().before(newsArticle.getStartDate())) {
                    ObjectValidator.addWarning(systemStatus, object, "endDate", "object.validation.project.endDateNotLTStartDate");
                }
            } else if (newsArticle.getMessage() == null || newsArticle.getMessage().equals("") || newsArticle.getMessage().equals(" \r\n<br />\r\n ")) {
                ObjectValidator.addError(systemStatus, object, "message", REQUIRED_FIELD);
            }
        }
        if (object.getClass().getName().equals("com.zeroio.iteam.base.IssueCategory")) {
            IssueCategory category = (IssueCategory)object;
            ObjectValidator.checkError(systemStatus, object, "subject", REQUIRED_FIELD);
            if (category.getProjectId() == -1) {
                ObjectValidator.addError(systemStatus, object, "action", "object.validation.project.projectIdRequired");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.actionplans.base.ActionPlanWork")) {
            ActionPlanWork planWork = (ActionPlanWork)((Object)object);
            if (planWork.getActionPlanId() == -1) {
                ObjectValidator.addError(systemStatus, object, "actionPlan", REQUIRED_FIELD);
            }
            ObjectValidator.checkError(systemStatus, object, "assignedTo", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "managerId", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.actionplans.base.ActionPlanWorkNote")) {
            thisNote = (ActionPlanWorkNote)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "description", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "submitted", REQUIRED_FIELD);
            if (thisNote.getDescription() != null && thisNote.getDescription().length() > 300) {
                ObjectValidator.addError(systemStatus, object, "description", "object.validation.exceedsMaxLength.300.text");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.actionplans.base.ActionItemWorkNote")) {
            thisNote = (ActionItemWorkNote)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "description", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "submitted", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.tasks.base.Task")) {
            thisTask = (Task)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "description", REQUIRED_FIELD);
            if (thisTask.getCategoryId() == -1 && thisTask.getOwner() == -1) {
                ObjectValidator.addError(systemStatus, object, "owner", REQUIRED_FIELD);
            }
            if (thisTask.getSharing() == 1 && thisTask.getOwner() != thisTask.getModifiedBy()) {
                ObjectValidator.addError(systemStatus, object, "sharing", "object.validation.task.ownerPersonal");
            }
            ObjectValidator.checkWarning(systemStatus, object, "dueDate", IS_BEFORE_TODAY);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.troubletickets.base.TicketTask")) {
            thisTask = (TicketTask)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "description", REQUIRED_FIELD);
            if (thisTask.getCategoryId() == -1 && thisTask.getOwner() == -1) {
                ObjectValidator.addError(systemStatus, object, "owner", REQUIRED_FIELD);
            }
            ObjectValidator.checkWarning(systemStatus, object, "dueDate", IS_BEFORE_TODAY);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.tasks.base.TaskCategory")) {
            thisCategory = (TaskCategory)((Object)object);
            if (thisCategory.getLinkModuleId() == -1 || thisCategory.getLinkItemId() == -1) {
                ObjectValidator.addError(systemStatus, object, "linkModuleId", REQUIRED_FIELD);
            }
            ObjectValidator.checkError(systemStatus, object, "description", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("com.zeroio.iteam.base.Requirement")) {
            Requirement requirement = (Requirement)object;
            if (requirement.getProjectId() == -1) {
                ObjectValidator.addError(systemStatus, object, "action", "object.validation.project.projectIdRequired");
            }
            ObjectValidator.checkError(systemStatus, object, "shortDescription", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "description", REQUIRED_FIELD);
            if (requirement.getDeadline() != null && requirement.getStartDate() != null && requirement.getDeadline().before(requirement.getStartDate())) {
                ObjectValidator.addWarning(systemStatus, object, "deadline", "object.validation.project.requirements.deadlineNotLTStartDate");
            }
        }
        if (object.getClass().getName().equals("com.zeroio.iteam.base.Assignment")) {
            assignment = (Assignment)object;
            if (assignment.getProjectId() == -1) {
                ObjectValidator.addError(systemStatus, object, "action", "object.validation.project.projectIdRequired");
            }
            ObjectValidator.checkError(systemStatus, object, "role", REQUIRED_FIELD);
            if (assignment.getStatusId() < 1) {
                ObjectValidator.addError(systemStatus, object, "statusId", REQUIRED_FIELD);
            }
            if (assignment.getRequirementId() == -1) {
                ObjectValidator.addError(systemStatus, object, "requirementId", REQUIRED_FIELD);
            }
        }
        if (object.getClass().getName().equals("com.zeroio.iteam.base.AssignmentFolder")) {
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.mycfs.base.CFSNote")) {
            ObjectValidator.checkError(systemStatus, object, "body", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "subject", "messageSubject", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.accounts.base.Revenue")) {
            Revenue revenue = (Revenue)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "description", REQUIRED_FIELD);
            if (revenue.getAmount() == 0.0) {
                ObjectValidator.addError(systemStatus, object, "amount", REQUIRED_FIELD);
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.base.CustomFieldCategory")) {
            thisCategory = (CustomFieldCategory)object;
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            if (((CustomFieldCategory)thisCategory).getModuleId() == -1) {
                ObjectValidator.addError(systemStatus, object, "action", "object.validation.formDataMissing");
            }
            if (((CustomFieldCategory)thisCategory).getId() != -1 && !((CustomFieldCategory)thisCategory).getAllowMultipleRecords() && ((CustomFieldCategory)thisCategory).hasMultipleRecords(db)) {
                ObjectValidator.addError(systemStatus, object, "allowMultipleRecords", "object.validation.customFieldCategory.hasMultipleRecords");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.base.CustomFieldGroup")) {
            CustomFieldGroup group = (CustomFieldGroup)object;
            if (group.getCategoryId() == -1) {
                ObjectValidator.addError(systemStatus, object, "action", "object.validation.formDataMissing");
            }
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.base.CustomField")) {
            CustomField thisField = (CustomField)object;
            if (thisField.getGroupId() == -1) {
                ObjectValidator.addError(systemStatus, object, "recordId", "object.validation.customField.groupIdNotPresent");
            }
            if (thisField.getType() == -1) {
                ObjectValidator.addError(systemStatus, object, "type", "object.validation.customField.typeNotPresent");
            }
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            if (thisField.getLengthRequired()) {
                if (thisField.getParameter("maxlength").equals("")) {
                    ObjectValidator.addError(systemStatus, object, "maxLength", "object.validation.customField.maxLength");
                } else {
                    try {
                        if (Integer.parseInt(thisField.getParameter("maxlength")) > 255) {
                            ObjectValidator.addError(systemStatus, object, "maxLength", "object.validation.customField.maxLengthTooHigh");
                        }
                    }
                    catch (Exception e) {
                        ObjectValidator.addError(systemStatus, object, "maxLength", "object.validation.customField.maxLengthNumber");
                    }
                }
            }
            if (thisField.getValidateData()) {
                if (thisField.getRecordId() == -1) {
                    ObjectValidator.addError(systemStatus, object, "recordId", "object.validation.customField.recordIdNotPresent");
                    thisField.setError(systemStatus.getLabel("object.validation.customField.recordIdNotPresent"));
                }
                if (thisField.getType() == -1) {
                    ObjectValidator.addError(systemStatus, object, "type", "object.validation.customField.typeNotPresent");
                    thisField.setError(systemStatus.getLabel("object.validation.customField.typeNotPresent"));
                }
                if (thisField.getRequired() && (thisField.getEnteredValue() == null || thisField.getEnteredValue().equals(""))) {
                    ObjectValidator.addError(systemStatus, object, "enteredValue", REQUIRED_FIELD);
                    thisField.setError(systemStatus.getLabel("object.validation.required"));
                }
                if (thisField.getType() == 2 && thisField.getRequired() && thisField.getSelectedItemId() == -1) {
                    ObjectValidator.addError(systemStatus, object, "selectedItemId", REQUIRED_FIELD);
                    thisField.setError(systemStatus.getLabel("object.validation.required"));
                }
                if (thisField.getRequired() && thisField.getType() == 23 && (thisField.getEnteredValue() == null || "".equals(thisField.getEnteredValue().trim()) || "-1".equals(thisField.getEnteredValue().trim()) || "--".equals(thisField.getEnteredValue().trim()))) {
                    ObjectValidator.addError(systemStatus, object, "enteredValue", REQUIRED_FIELD);
                    thisField.setError(systemStatus.getLabel("object.validation.required"));
                }
                if (thisField.getEnteredValue() != null && !thisField.getEnteredValue().equals("")) {
                    boolean testFlag;
                    if (thisField.getType() == 9) {
                        try {
                            int testNumber = Integer.parseInt(thisField.getEnteredValue());
                            thisField.setEnteredNumber(testNumber);
                            thisField.setEnteredDouble(Double.parseDouble("" + testNumber));
                        }
                        catch (Exception e) {
                            ObjectValidator.addError(systemStatus, object, "enteredValue", "object.validation.incorrectWholeNumberFormat");
                            thisField.setError(systemStatus.getLabel("object.validation.incorrectWholeNumberFormat"));
                        }
                    }
                    if (thisField.getType() == 10) {
                        try {
                            double testNumber = Double.parseDouble(thisField.getEnteredValue());
                            thisField.setEnteredDouble(testNumber);
                        }
                        catch (Exception e) {
                            ObjectValidator.addError(systemStatus, object, "enteredValue", INVALID_NUMBER);
                            thisField.setError(systemStatus.getLabel("object.validation.incorrectNumberFormat"));
                        }
                    }
                    if (thisField.getType() == 11) {
                        try {
                            double testNumber = Double.parseDouble(thisField.getEnteredValue());
                            thisField.setEnteredDouble(testNumber);
                        }
                        catch (Exception e) {
                            ObjectValidator.addError(systemStatus, object, "enteredValue", INVALID_NUMBER);
                            thisField.setError(systemStatus.getLabel("object.validation.incorrectNumberFormat"));
                        }
                    }
                    if (thisField.getRequired() && thisField.getType() == 4 && !(testFlag = DatabaseUtils.parseBoolean(thisField.getEnteredValue()))) {
                        ObjectValidator.addError(systemStatus, object, "enteredValue", REQUIRED_FIELD);
                        thisField.setError(systemStatus.getLabel("object.validation.required"));
                    }
                    if (thisField.getType() == 12) {
                        try {
                            Locale locale = new Locale(System.getProperty("LANGUAGE"), System.getProperty("COUNTRY"));
                            NumberFormat nf = NumberFormat.getInstance(locale);
                            thisField.setEnteredDouble(nf.parse(thisField.getEnteredValue()).doubleValue());
                            Double tmpDouble = new Double(thisField.getEnteredDouble());
                            thisField.setEnteredValue(tmpDouble.toString());
                        }
                        catch (Exception e) {
                            ObjectValidator.addError(systemStatus, object, "enteredValue", INVALID_NUMBER);
                            thisField.setError(systemStatus.getLabel("object.validation.incorrectNumberFormat"));
                        }
                    }
                    if (thisField.getType() == 8) {
                        try {
                            Locale locale = new Locale(System.getProperty("LANGUAGE"), System.getProperty("COUNTRY"));
                            DateFormat localeFormatter = DateFormat.getDateInstance(3, locale);
                            localeFormatter.setLenient(false);
                            localeFormatter.parse(thisField.getEnteredValue());
                        }
                        catch (ParseException e) {
                            ObjectValidator.addError(systemStatus, object, "enteredValue", INVALID_DATE);
                            thisField.setError(systemStatus.getLabel("object.validation.incorrectDateFormat"));
                        }
                    }
                    if (thisField.getType() == 13 && !ObjectValidator.checkError(systemStatus, object, "enteredValue", INVALID_EMAIL_NOT_REQUIRED)) {
                        thisField.setError(systemStatus.getLabel("object.validation.communications.fullEmailAddress"));
                    }
                    if (thisField.getType() == 14 && thisField.getEnteredValue().indexOf(".") < 0) {
                        ObjectValidator.addError(systemStatus, object, "enteredValue", "object.validation.customField.incorrectUrlFormat");
                        thisField.setError(systemStatus.getLabel("object.validation.customField.incorrectUrlFormat"));
                    }
                }
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.admin.base.Role")) {
            Role role = (Role)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "role", REQUIRED_FIELD);
            ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "role", 80);
            ObjectValidator.checkError(systemStatus, object, "description", REQUIRED_FIELD);
            if (role.isDuplicate(db)) {
                ObjectValidator.addError(systemStatus, object, "role", "object.validation.roleNameAlreadyInUse");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.admin.base.Viewpoint")) {
            Viewpoint view = (Viewpoint)((Object)object);
            if (view.getVpUserId() == -1) {
                ObjectValidator.addError(systemStatus, object, "Contact", REQUIRED_FIELD);
            }
            if (view.getVpUserId() == view.getUserId()) {
                ObjectValidator.addError(systemStatus, object, "Contact", "object.validation.ownViewpointNotAllowed");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.setup.base.RegistrationBean")) {
            ObjectValidator.checkError(systemStatus, object, "profile", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "nameFirst", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "nameLast", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "company", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "email", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("com.zeroio.iteam.base.Invitation")) {
            ObjectValidator.checkError(systemStatus, object, "email", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "firstName", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "lastName", REQUIRED_FIELD);
            return false;
        }
        if (object.getClass().getName().equals("com.zeroio.iteam.base.FileItemVersion")) {
            ObjectValidator.checkError(systemStatus, object, "subject", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "filename", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("com.zeroio.iteam.base.Issue")) {
            Issue issue = (Issue)object;
            ObjectValidator.checkError(systemStatus, object, "subject", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "body", REQUIRED_FIELD);
            if (issue.getProjectId() == -1) {
                ObjectValidator.addError(systemStatus, object, "action", "object.validation.project.projectIdRequired");
            }
            if (issue.getCategoryId() == -1) {
                ObjectValidator.addError(systemStatus, object, "categoryId", REQUIRED_FIELD);
            }
        }
        if (object.getClass().getName().equals("com.zeroio.iteam.base.IssueReply")) {
            IssueReply issueReply = (IssueReply)object;
            ObjectValidator.checkError(systemStatus, object, "subject", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "body", REQUIRED_FIELD);
            if (issueReply.getIssueId() == -1) {
                ObjectValidator.addError(systemStatus, object, "action", "object.validation.issueIdNotSpecified");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.actionlist.base.ActionList")) {
            ObjectValidator.checkError(systemStatus, object, "description", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.base.Import")) {
            thisImport = (Import)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            if (thisImport.getType() < 0) {
                ObjectValidator.addError(systemStatus, object, "type", REQUIRED_FIELD);
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.contacts.base.ContactImport")) {
            thisImport = (ContactImport)object;
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            if (thisImport.getType() < 0) {
                ObjectValidator.addError(systemStatus, object, "type", REQUIRED_FIELD);
            }
            if (thisImport.getSiteId() == -2) {
                ObjectValidator.addError(systemStatus, object, "siteId", REQUIRED_FIELD);
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.communications.base.Recipient")) {
            Recipient recipient = (Recipient)((Object)object);
            if (recipient.getCampaignId() == -1) {
                ObjectValidator.addError(systemStatus, object, "campaign", REQUIRED_FIELD);
            }
            if (recipient.getContactId() == -1) {
                ObjectValidator.addError(systemStatus, object, "contact", REQUIRED_FIELD);
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.reports.base.Criteria")) {
            Criteria criteria = (Criteria)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "subject", REQUIRED_FIELD);
            if (criteria.getReportId() == -1) {
                ObjectValidator.addError(systemStatus, object, "reportId", REQUIRED_FIELD);
            }
            if (criteria.getOwner() == -1) {
                ObjectValidator.addError(systemStatus, object, "owner", REQUIRED_FIELD);
            }
            if (criteria.getEnteredBy() == -1) {
                ObjectValidator.addError(systemStatus, object, "enteredBy", REQUIRED_FIELD);
            }
            if (criteria.getModifiedBy() == -1) {
                ObjectValidator.addError(systemStatus, object, "modifiedBy", REQUIRED_FIELD);
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.reports.base.Parameter") && (parameter = (Parameter)((Object)object)).getCriteriaId() == -1) {
            ObjectValidator.addError(systemStatus, object, "criteriaId", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.setup.beans.DatabaseBean")) {
            bean = (DatabaseBean)((Object)object);
            if (!bean.isEmbedded()) {
                ObjectValidator.checkError(systemStatus, object, "ip", REQUIRED_FIELD);
                if (bean.getPort() <= 0) {
                    ObjectValidator.addError(systemStatus, object, "port", REQUIRED_FIELD);
                }
            }
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "user", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.setup.beans.ServerBean")) {
            bean = (ServerBean)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "url", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "email", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "emailAddress", REQUIRED_FIELD);
            if (bean.getTimeZone() == null || "".equals(bean.getTimeZone().trim()) || "-1".equals(bean.getTimeZone())) {
                ObjectValidator.addError(systemStatus, object, "timeZone", REQUIRED_FIELD);
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.setup.beans.UserSetupBean")) {
            ObjectValidator.checkError(systemStatus, object, "nameFirst", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "nameLast", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "email", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "username", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "password1", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "password2", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.products.base.ProductCatalog")) {
            ProductCatalog productCatalog = (ProductCatalog)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            if (productCatalog.getStartDate() != null && productCatalog.getExpirationDate() != null && productCatalog.getStartDate().after(productCatalog.getExpirationDate())) {
                ObjectValidator.addError(systemStatus, object, "startDate", "object.validation.startAfterExpiration");
            }
            if (productCatalog.getStartDate() == null && productCatalog.getExpirationDate() != null) {
                ObjectValidator.addError(systemStatus, object, "startDate", "object.validation.startAfterExpiration");
            }
            if (productCatalog.getActive() && (productCatalog.getActivePrice() == null || productCatalog.getActivePrice().getPriceAmount() <= 0.0)) {
                ObjectValidator.addWarning(systemStatus, object, "active", "object.validation.product.activePriceNotFound");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.products.base.ProductCatalogImport")) {
            thisImport = (ProductCatalogImport)object;
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            if (thisImport.getType() < 0) {
                ObjectValidator.addError(systemStatus, object, "type", REQUIRED_FIELD);
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.products.base.ProductOption")) {
            ProductOption option = (ProductOption)((Object)object);
            if (option.getStartDate() != null && option.getEndDate() != null && option.getStartDate().after(option.getEndDate())) {
                ObjectValidator.addError(systemStatus, object, "startDate", "object.validation.productPricing.startDateNotGTExpirationDate");
            }
            if (option.getStartDate() == null && option.getEndDate() != null) {
                ObjectValidator.addError(systemStatus, object, "startDate", "object.validation.productPricing.startDateNotGTExpirationDate");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.products.base.ProductCategory")) {
            ProductCategory productCategory = (ProductCategory)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            if (productCategory.getStartDate() != null && productCategory.getExpirationDate() != null && productCategory.getStartDate().after(productCategory.getExpirationDate())) {
                ObjectValidator.addError(systemStatus, object, "startDate", "object.validation.startAfterExpiration");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.documents.base.DocumentStore")) {
            ObjectValidator.checkError(systemStatus, object, "title", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "shortDescription", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "requestDate", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.quotes.base.Quote")) {
            Quote quote = (Quote)((Object)object);
            if (quote.getOrgId() == -1) {
                ObjectValidator.addError(systemStatus, object, "orgId", REQUIRED_FIELD);
            }
            if (quote.getContactId() == -1) {
                ObjectValidator.addError(systemStatus, object, "contactId", REQUIRED_FIELD);
            }
            if (quote.getCloseIt() && quote.getStatusId() == -1) {
                ObjectValidator.addError(systemStatus, object, "statusId", "object.validation.quoteClosedWithoutExplanation");
            }
            ObjectValidator.checkError(systemStatus, object, "shortDescription", REQUIRED_FIELD);
            if (quote.getHeaderId() != -1) {
                String allowMultipleVersion;
                String allowMultipleQuotes = systemStatus.getValue(Quote.QUOTE_CONFIG_NAME, Quote.MULTIPLE_QUOTE_CONFIG_PARAM);
                if (allowMultipleQuotes != null && !Quote.allowMultipleQuotesPerOpportunity(allowMultipleQuotes)) {
                    QuoteList tmpQuoteList = new QuoteList();
                    tmpQuoteList.setHeaderId(quote.getHeaderId());
                    tmpQuoteList.buildList(db);
                    if (quote.getId() == -1) {
                        if (tmpQuoteList.size() > 0) {
                            ObjectValidator.addError(systemStatus, object, "headerId", "object.validation.opportunityHasQuotes");
                        }
                    } else {
                        for (Quote tmpQuote : tmpQuoteList) {
                            if (tmpQuote.getId() == quote.getId()) continue;
                            ObjectValidator.addError(systemStatus, object, "headerId", "object.validation.opportunityHasQuotes");
                        }
                    }
                }
                if ((allowMultipleVersion = systemStatus.getValue(Quote.QUOTE_CONFIG_NAME, Quote.MULTIPLE_VERSION_CONFIG_PARAM)) != null && quote.getVersionNumber() > 1) {
                    ObjectValidator.addError(systemStatus, object, "headerId", "object.validation.noMultipleVersionQuoteForOpportunity");
                }
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.quotes.base.QuoteProduct")) {
            QuoteProduct product = (QuoteProduct)((Object)object);
            if (product.getProductId() == -1) {
                ObjectValidator.addError(systemStatus, object, "productId", "object.validation.emptyQuoteProduct");
            }
            if (product.getQuoteId() == -1) {
                ObjectValidator.addError(systemStatus, object, "quoteId", "object.validation.quoteProductWithoutQuote");
            }
            if (product.getQuantity() < 0) {
                ObjectValidator.addError(systemStatus, object, "quantity", "object.validation.negativeQuoteProductQuantity");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.quotes.base.QuoteProductBean")) {
            // empty if block
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.quotes.base.QuoteProductOption")) {
            // empty if block
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.quotes.base.QuoteCondition")) {
            QuoteCondition condition = (QuoteCondition)((Object)object);
            if (condition.getConditionName() == null || "".equals(condition.getConditionName().trim())) {
                ObjectValidator.addError(systemStatus, object, "description", REQUIRED_FIELD);
            }
            if (condition.getConditionName().length() > 300) {
                ObjectValidator.addError(systemStatus, object, "description", "object.validation.descriptionNotGT300Characters");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.quotes.base.QuoteRemark")) {
            QuoteRemark remark = (QuoteRemark)((Object)object);
            if (remark.getRemarkName() == null || "".equals(remark.getRemarkName().trim())) {
                ObjectValidator.addError(systemStatus, object, "description", REQUIRED_FIELD);
            }
            if (remark.getRemarkName().length() > 300) {
                ObjectValidator.addError(systemStatus, object, "description", "object.validation.descriptionNotGT300Characters");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.quotes.base.QuoteNote")) {
            QuoteNote note = (QuoteNote)((Object)object);
            if (note.getQuoteId() == -1) {
                ObjectValidator.addError(systemStatus, object, "quoteId", REQUIRED_FIELD);
            }
            ObjectValidator.checkError(systemStatus, object, "notes", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.admin.base.CustomListView")) {
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.products.base.ProductCatalogPricing") && (pricing = (ProductCatalogPricing)((Object)object)).getStartDate() != null && pricing.getExpirationDate() != null && pricing.getStartDate().after(pricing.getExpirationDate())) {
            ObjectValidator.addError(systemStatus, object, "startDate", "object.validation.productPricing.startDateNotGTExpirationDate");
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.products.configurator.NumericalConfigurator")) {
            configurator = (NumericalConfigurator)object;
            boolean valid = true;
            if (((NumericalConfigurator)configurator).getMinNum() != -1 && ((NumericalConfigurator)configurator).getMaxNum() != -1 && ((NumericalConfigurator)configurator).getMinNum() > ((NumericalConfigurator)configurator).getMaxNum()) {
                configurator.getPropertyList().getOptionProperty("number_max").setErrorMsg(systemStatus.getLabel("object.validation.maxNumberNotLTMinNumber"));
                valid = false;
            }
            if (((NumericalConfigurator)configurator).getMinNum() != -1 && ((NumericalConfigurator)configurator).getDefaultNum() < ((NumericalConfigurator)configurator).getMinNum() && configurator.getPropertyList().getOptionProperty("number_default") != null) {
                configurator.getPropertyList().getOptionProperty("number_default").setErrorMsg(systemStatus.getLabel("object.validation.defaultNumberNotLTMinNumber"));
                valid = false;
            }
            if (((NumericalConfigurator)configurator).getMaxNum() != -1 && ((NumericalConfigurator)configurator).getDefaultNum() > ((NumericalConfigurator)configurator).getMaxNum() && configurator.getPropertyList().getOptionProperty("number_default") != null) {
                configurator.getPropertyList().getOptionProperty("number_default").setErrorMsg(systemStatus.getLabel("object.validation.defaultNumberNotGTMaxNumber"));
                valid = false;
            }
            return valid;
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.products.configurator.StringConfigurator")) {
            configurator = (StringConfigurator)object;
            boolean valid = true;
            if (((StringConfigurator)configurator).getDefaultText().length() < ((StringConfigurator)configurator).getMinChars() && configurator.getPropertyList().getOptionProperty("text_default") != null) {
                configurator.getPropertyList().getOptionProperty("text_default").setErrorMsg(systemStatus.getLabel("object.validation.defaultTextLengthNotLTMinChars"));
                valid = false;
            }
            if (((StringConfigurator)configurator).getDefaultText().length() > ((StringConfigurator)configurator).getMaxChars() && configurator.getPropertyList().getOptionProperty("text_default") != null) {
                configurator.getPropertyList().getOptionProperty("text_default").setErrorMsg(systemStatus.getLabel("object.validation.defaultTextLengthNotGTMaxChars"));
                valid = false;
            }
            return valid;
        }
        if (object.getClass().getName().equals("com.zeroio.iteam.base.Thumbnail")) {
            ObjectValidator.checkError(systemStatus, object, "filename", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.relationships.base.Relationship")) {
            int toSiteId;
            int fromSiteId;
            Relationship relationship = (Relationship)((Object)object);
            if (relationship.getObjectIdMapsFrom() == -1 || relationship.getObjectIdMapsTo() == -1) {
                ObjectValidator.addError(systemStatus, object, "objectIdMapsTo", "relationships.bothObjectsAreRequired");
            } else if (relationship.getObjectIdMapsFrom() == relationship.getObjectIdMapsTo()) {
                ObjectValidator.addError(systemStatus, object, "objectIdMapsTo", "relationships.orgCanNotBeRelatedToItself");
            }
            if (relationship.getCategoryIdMapsFrom() == 42420034 && relationship.getCategoryIdMapsTo() == 42420034 && (fromSiteId = Organization.getOrganizationSiteId(db, relationship.getObjectIdMapsFrom())) != (toSiteId = Organization.getOrganizationSiteId(db, relationship.getObjectIdMapsTo()))) {
                ObjectValidator.addError(systemStatus, object, "objectIdMapsTo", "relationships.orgFromDifferentSitesCanNotBeRelated");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.contacts.base.ContactHistory")) {
            ObjectValidator.checkError(systemStatus, object, "description", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.actionplans.base.ActionPlan")) {
            ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "name", 255);
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.actionplans.base.ActionPhase")) {
            ActionPhase phase = (ActionPhase)((Object)object);
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            if (phase.getId() != -1 && phase.getId() == phase.getParentId()) {
                ObjectValidator.addError(systemStatus, object, "parentId", "object.validation.actionObjectCanNotBeItsOwnParentError.text");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.actionplans.base.ActionStep")) {
            ObjectValidator.checkError(systemStatus, object, "description", REQUIRED_FIELD);
            ActionStep step = (ActionStep)((Object)object);
            if (step.getId() != -1 && step.getId() == step.getParentId()) {
                ObjectValidator.addError(systemStatus, object, "parentId", "object.validation.actionObjectCanNotBeItsOwnParentError.text");
            }
            if (step.getPermissionType() == 8 && (step.getUserGroupId() == -1 || step.getDepartmentId() > -1 || step.getRoleId() > -1)) {
                ObjectValidator.addError(systemStatus, object, "userGroupId", "object.validation.invalidUserGroupIdError.text");
            }
            if (step.getPermissionType() == 3 && (step.getUserGroupId() > -1 || step.getDepartmentId() == -1 || step.getRoleId() > -1)) {
                ObjectValidator.addError(systemStatus, object, "departmentId", "object.validation.invalidDepartmentIdError.text");
            }
            if (step.getPermissionType() == 2 && (step.getUserGroupId() > -1 || step.getDepartmentId() > -1 || step.getRoleId() == -1)) {
                ObjectValidator.addError(systemStatus, object, "roleId", "object.validation.invalidRoleIdError.text");
            }
            if (!step.getDisplayInPlanList() && step.getPlanListLabel() != null && !"".equals(step.getPlanListLabel()) || step.getDisplayInPlanList() && (step.getPlanListLabel() == null || "".equals(step.getPlanListLabel()))) {
                ObjectValidator.addError(systemStatus, object, "displayInPlanList", "object.validation.required");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.admin.base.User")) {
            User user = (User)((Object)object);
            int userId = user.getId();
            OrganizationList sourceAccounts = new OrganizationList();
            sourceAccounts.setOwnerId(userId);
            sourceAccounts.buildList(db);
            if (sourceAccounts.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            ContactList sourcePublicContacts = new ContactList();
            sourcePublicContacts.setOwner(userId);
            sourcePublicContacts.setLeadsOnly(0);
            sourcePublicContacts.setEmployeesOnly(0);
            sourcePublicContacts.setBuildDetails(false);
            sourcePublicContacts.setBuildTypes(false);
            sourcePublicContacts.setRuleId(626030334);
            sourcePublicContacts.setExcludeAccountContacts(true);
            sourcePublicContacts.setIncludeAllSites(true);
            sourcePublicContacts.buildList(db);
            if (sourcePublicContacts.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            ContactList sourceHierarchyContacts = new ContactList();
            sourceHierarchyContacts.setOwner(userId);
            sourceHierarchyContacts.setLeadsOnly(0);
            sourceHierarchyContacts.setEmployeesOnly(0);
            sourceHierarchyContacts.setBuildDetails(false);
            sourceHierarchyContacts.setBuildTypes(false);
            sourceHierarchyContacts.setRuleId(626030335);
            sourceHierarchyContacts.setIncludeAllSites(true);
            sourceHierarchyContacts.buildList(db);
            if (sourceHierarchyContacts.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            ContactList sourceAccountContacts = new ContactList();
            sourceAccountContacts.setOwner(userId);
            sourceAccountContacts.setLeadsOnly(0);
            sourceAccountContacts.setEmployeesOnly(0);
            sourceAccountContacts.setBuildDetails(false);
            sourceAccountContacts.setBuildTypes(false);
            sourceAccountContacts.setWithAccountsOnly(true);
            sourceAccountContacts.setIncludeAllSites(true);
            sourceAccountContacts.buildList(db);
            if (sourceAccountContacts.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            ContactList sourceLeads = new ContactList();
            sourceLeads.setOwner(userId);
            sourceLeads.setLeadsOnly(1);
            sourceLeads.setEmployeesOnly(0);
            sourceLeads.setBuildDetails(false);
            sourceLeads.setBuildTypes(false);
            sourceLeads.setIncludeAllSites(true);
            sourceLeads.buildList(db);
            if (sourceLeads.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            UserList sourceUsers = new UserList();
            sourceUsers.setManagerId(userId);
            sourceUsers.buildList(db);
            if (sourceUsers.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            TicketList sourceOpenTickets = new TicketList();
            sourceOpenTickets.setAssignedTo(userId);
            sourceOpenTickets.setIncludeAllSites(true);
            sourceOpenTickets.setOnlyOpen(true);
            sourceOpenTickets.buildList(db);
            if (sourceOpenTickets.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            TaskList incompleteTicketTasks = new TaskList();
            incompleteTicketTasks.setOwner(userId);
            incompleteTicketTasks.setHasLinkedTicket(1);
            incompleteTicketTasks.setComplete(0);
            incompleteTicketTasks.buildList(db);
            if (incompleteTicketTasks.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            RevenueList sourceRevenue = new RevenueList();
            sourceRevenue.setOwner(userId);
            sourceRevenue.buildList(db);
            if (sourceRevenue.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            AssignmentList sourceAssignments = new AssignmentList();
            sourceAssignments.setAssignmentsForUser(userId);
            sourceAssignments.setIncompleteOnly(true);
            sourceAssignments.buildList(db);
            if (sourceAssignments.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            OpportunityList managingOpportunities = new OpportunityList();
            managingOpportunities.setManager(userId);
            managingOpportunities.setQueryOpenOnly(true);
            managingOpportunities.setControlledHierarchyOnly(0);
            AccessTypeList accessTypeList = systemStatus.getAccessTypeList(db, 804051057);
            managingOpportunities.setAccessType(accessTypeList.getCode(626030334));
            managingOpportunities.buildList(db);
            if (managingOpportunities.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            OpportunityList sourceOpportunities = new OpportunityList();
            sourceOpportunities.setOwner(userId);
            sourceOpportunities.buildList(db);
            if (sourceOpportunities.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            OpportunityList sourceOpenOpportunities = new OpportunityList();
            sourceOpenOpportunities.setOwner(userId);
            sourceOpenOpportunities.setQueryOpenOnly(true);
            sourceOpenOpportunities.buildList(db);
            if (sourceOpenOpportunities.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            DocumentStoreTeamMemberList sourceDocumentStoreTeamMemberList = new DocumentStoreTeamMemberList();
            sourceDocumentStoreTeamMemberList.setForDocumentStoreUser(userId);
            sourceDocumentStoreTeamMemberList.setMemberType("user");
            sourceDocumentStoreTeamMemberList.setUserLevel(1);
            sourceDocumentStoreTeamMemberList.buildList(db);
            if (sourceDocumentStoreTeamMemberList.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            CallList sourcePendingActivities = new CallList();
            sourcePendingActivities.setOwner(userId);
            sourcePendingActivities.setOnlyPending(true);
            sourcePendingActivities.buildList(db);
            if (sourcePendingActivities.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
            ActionLists sourceActionLists = new ActionLists();
            sourceActionLists.setOwner(userId);
            sourceActionLists.setInProgressOnly(true);
            sourceActionLists.buildList(db);
            if (sourceActionLists.size() > 0) {
                ObjectValidator.addError(systemStatus, object, "siteId", "object.validation.userHasAssociations.text");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.admin.base.UserGroup")) {
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.troubletickets.base.TicketDefect")) {
            ObjectValidator.checkError(systemStatus, object, "title", REQUIRED_FIELD);
            ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "title", 255);
            ObjectValidator.checkError(systemStatus, object, "startDate", INVALID_DATE);
            ObjectValidator.checkError(systemStatus, object, "endDate", INVALID_NOT_REQUIRED_DATE);
            TicketDefect defect = (TicketDefect)((Object)object);
            if (defect.getStartDate() != null && defect.getEndDate() != null && defect.getStartDate().after(defect.getEndDate())) {
                ObjectValidator.addError(systemStatus, object, "endDate", "object.validation.project.estimatedEndDateNotLTStartDate");
            }
            if (defect.getSiteId() == -2) {
                ObjectValidator.addError(systemStatus, object, "siteId", REQUIRED_FIELD);
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.service.base.SyncClient")) {
            ObjectValidator.checkError(systemStatus, object, "type", REQUIRED_FIELD);
            ObjectValidator.checkError(systemStatus, object, "code", REQUIRED_FIELD);
            ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "type", 100);
            ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "code", 255);
            ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "version", 50);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.troubletickets.base.KnowledgeBase")) {
            ObjectValidator.checkError(systemStatus, object, "title", REQUIRED_FIELD);
            ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "title", 255);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.troubletickets.base.TicketCategoryDraftAssignment")) {
            assignment = (TicketCategoryDraftAssignment)((Object)object);
            if (assignment.getCategoryId() == -1) {
                ObjectValidator.addError(systemStatus, object, "categoryId", REQUIRED_FIELD);
            } else {
                TicketCategoryDraft draftCategory = new TicketCategoryDraft(db, assignment.getCategoryId(), "ticket_category");
                if (assignment.getAssignedTo() > -1) {
                    User user = new User(db, assignment.getAssignedTo());
                    if (draftCategory.getSiteId() != user.getSiteId() && user.getSiteId() != -1) {
                        ObjectValidator.addError(systemStatus, object, "assignedTo", "tickets.ticketCategoryDraftAssignment.invalidUserAssignment.text");
                    }
                }
                if (assignment.getUserGroupId() > -1) {
                    UserGroup group = new UserGroup(db, assignment.getUserGroupId());
                    if (draftCategory.getSiteId() != group.getSiteId() && group.getSiteId() != -1) {
                        ObjectValidator.addError(systemStatus, object, "userGroupId", "tickets.ticketCategoryDraftAssignment.invalidUserGroupAssignment.text");
                    }
                }
                if (assignment.getAssignedTo() == -1 && assignment.getUserGroupId() == -1 && assignment.getDepartmentId() == -1) {
                    ObjectValidator.addError(systemStatus, object, "categoryId", "tickets.ticketCategoryDraftAssignment.invalidAssignment.text");
                }
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.website.base.Site")) {
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "name", 300);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.website.base.Tab")) {
            ObjectValidator.checkError(systemStatus, object, "displayText", REQUIRED_FIELD);
            ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "displayText", 300);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.website.base.PageGroup")) {
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "name", 300);
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.website.base.Page")) {
            ObjectValidator.checkError(systemStatus, object, "name", REQUIRED_FIELD);
            ObjectValidator.checkLength(systemStatus, object, "object.validation.exceedsLengthLimit", "name", 300);
        }
        try {
            Map customValidators = systemStatus.getCustomValidators();
            Set keySet = customValidators.keySet();
            for (String validator : keySet) {
                Class<?> customValidatorClass = Class.forName(validator);
                Class[] argTypes = new Class[]{Class.forName("org.aspcfs.controller.SystemStatus"), Class.forName("java.sql.Connection"), Class.forName("java.lang.Object")};
                Object[] params = new Object[]{systemStatus, db, object};
                Method method = customValidatorClass.getMethod("validate", argTypes);
                method.invoke(customValidatorClass, params);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean validate(SystemStatus systemStatus, Connection db, Object object, HashMap map) throws SQLException {
        String parseItem;
        if (System.getProperty("DEBUG") != null) {
            System.out.println("ObjectValidator-> Checking object: " + object.getClass().getName());
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.troubletickets.base.TicketReplacementPart")) {
            parseItem = (String)map.get("parseItem");
            String partNumber = (String)map.get("partNumber");
            String partDescription = (String)map.get("partDescription");
            if (partNumber != null && !"".equals(partNumber) && (partDescription == null || "".equals(partDescription))) {
                ObjectValidator.addError(systemStatus, object, "partDescription" + parseItem, REQUIRED_FIELD);
                System.out.println("Adding Errror -->-0> partDescription is required");
            }
            if (partDescription != null && !"".equals(partDescription) && (partNumber == null || "".equals(partNumber))) {
                ObjectValidator.addError(systemStatus, object, "partNumber" + parseItem, REQUIRED_FIELD);
                System.out.println("Adding Errror -->-0> partNumber is required");
            }
        }
        if (object.getClass().getName().equals("org.aspcfs.modules.troubletickets.base.TicketPerDayDescription")) {
            parseItem = (String)map.get("parseItem");
            String descriptionOfService = (String)map.get("descriptionOfService");
            if (descriptionOfService == null || "".equals(descriptionOfService.trim())) {
                ObjectValidator.addError(systemStatus, object, "descriptionOfService" + parseItem, REQUIRED_FIELD);
                ObjectValidator.addError(systemStatus, object, "action", "object.validation.genericActionError");
            }
            String activityDateTimeZone = (String)map.get("activityDateTimeZone");
            String activityDate = (String)map.get("activityDate");
            HttpServletRequest request = (HttpServletRequest)map.get("request");
            UserBean userBean = (UserBean)((Object)request.getSession().getAttribute("User"));
            User user = userBean.getUserRecord();
            try {
                Timestamp tmp = DateUtils.getUserToServerDateTime(TimeZone.getTimeZone(activityDateTimeZone), 3, 1, activityDate, user.getLocale());
                if (tmp == null) {
                    ObjectValidator.addError(systemStatus, object, "activityDate" + parseItem, INVALID_DATE);
                    ObjectValidator.addError(systemStatus, object, "action", "object.validation.genericActionError");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean checkError(SystemStatus systemStatus, Object object, String field, int errorType) {
        boolean returnValue;
        block30: {
            returnValue = true;
            if (errorType == REQUIRED_FIELD) {
                String result = ObjectUtils.getParam(object, field);
                if (result == null || "".equals(result.trim())) {
                    returnValue = false;
                    ObjectValidator.addError(systemStatus, object, field, REQUIRED_FIELD);
                }
            } else if (errorType == INVALID_DATE) {
                try {
                    String date = ObjectUtils.getParam(object, field);
                    if (date == null || "".equals(date.trim())) {
                        returnValue = false;
                        ObjectValidator.addError(systemStatus, object, field, REQUIRED_FIELD);
                        break block30;
                    }
                    try {
                        date = new java.sql.Date(Timestamp.valueOf(date).getTime()).toString();
                        Locale locale = new Locale(System.getProperty("LANGUAGE"), System.getProperty("COUNTRY"));
                        SimpleDateFormat localeFormatter = new SimpleDateFormat("yyyy-MM-dd", locale);
                        localeFormatter.applyPattern("yyyy-MM-dd");
                        localeFormatter.setLenient(false);
                        localeFormatter.parse(date);
                    }
                    catch (ParseException e1) {
                        returnValue = false;
                        ObjectValidator.addError(systemStatus, object, field, INVALID_DATE);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (errorType == INVALID_NOT_REQUIRED_DATE) {
                try {
                    String date = ObjectUtils.getParam(object, field);
                    if (date == null || "".equals(date.trim())) break block30;
                    try {
                        date = new java.sql.Date(Timestamp.valueOf(date).getTime()).toString();
                        Locale locale = new Locale(System.getProperty("LANGUAGE"), System.getProperty("COUNTRY"));
                        SimpleDateFormat localeFormatter = new SimpleDateFormat("yyyy-MM-dd", locale);
                        localeFormatter.applyPattern("yyyy-MM-dd");
                        localeFormatter.setLenient(false);
                        localeFormatter.parse(date);
                    }
                    catch (ParseException e1) {
                        returnValue = false;
                        ObjectValidator.addError(systemStatus, object, field, INVALID_DATE);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (errorType == INVALID_EMAIL) {
                try {
                    String email = ObjectUtils.getParam(object, field);
                    if (email != null && !"".equals(email.trim())) {
                        try {
                            StringTokenizer str = new StringTokenizer(email, ",");
                            if (str.hasMoreTokens()) {
                                String temp = str.nextToken();
                                InternetAddress inetAddress = new InternetAddress(temp.trim(), true);
                                break block30;
                            }
                            InternetAddress inetAddress = new InternetAddress(email.trim(), true);
                        }
                        catch (AddressException e1) {
                            returnValue = false;
                            ObjectValidator.addError(systemStatus, object, field, INVALID_EMAIL);
                        }
                        break block30;
                    }
                    returnValue = false;
                    ObjectValidator.addError(systemStatus, object, field, INVALID_EMAIL);
                }
                catch (Exception e) {
                    returnValue = false;
                    e.printStackTrace();
                }
            } else if (errorType == INVALID_EMAIL_NOT_REQUIRED) {
                try {
                    String email = ObjectUtils.getParam(object, field);
                    if (email == null || "".equals(email.trim())) break block30;
                    try {
                        StringTokenizer str = new StringTokenizer(email, ",");
                        if (str.hasMoreTokens()) {
                            String temp = str.nextToken();
                            InternetAddress inetAddress = new InternetAddress(temp.trim(), true);
                            break block30;
                        }
                        InternetAddress inetAddress = new InternetAddress(email.trim(), true);
                    }
                    catch (AddressException e1) {
                        returnValue = false;
                        ObjectValidator.addError(systemStatus, object, field, INVALID_EMAIL);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return returnValue;
    }

    public static void checkError(SystemStatus systemStatus, Object object, String field, String errorName, int errorType) {
        block30: {
            if (errorType == REQUIRED_FIELD) {
                String result = ObjectUtils.getParam(object, field);
                if (result == null || "".equals(result.trim())) {
                    ObjectValidator.addError(systemStatus, object, errorName, REQUIRED_FIELD);
                }
            } else if (errorType == INVALID_DATE) {
                try {
                    String date = ObjectUtils.getParam(object, field);
                    if (date == null || "".equals(date.trim())) {
                        ObjectValidator.addError(systemStatus, object, errorName, REQUIRED_FIELD);
                        break block30;
                    }
                    try {
                        date = new java.sql.Date(Timestamp.valueOf(date).getTime()).toString();
                        Locale locale = new Locale(System.getProperty("LANGUAGE"), System.getProperty("COUNTRY"));
                        SimpleDateFormat localeFormatter = new SimpleDateFormat("yyyy-MM-dd", locale);
                        localeFormatter.applyPattern("yyyy-MM-dd");
                        localeFormatter.setLenient(false);
                        localeFormatter.parse(date);
                    }
                    catch (ParseException e1) {
                        ObjectValidator.addError(systemStatus, object, errorName, INVALID_DATE);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (errorType == INVALID_NOT_REQUIRED_DATE) {
                try {
                    String date = ObjectUtils.getParam(object, field);
                    if (date == null || "".equals(date.trim())) break block30;
                    try {
                        date = new java.sql.Date(Timestamp.valueOf(date).getTime()).toString();
                        Locale locale = new Locale(System.getProperty("LANGUAGE"), System.getProperty("COUNTRY"));
                        SimpleDateFormat localeFormatter = new SimpleDateFormat("yyyy-MM-dd", locale);
                        localeFormatter.setLenient(false);
                        localeFormatter.parse(date);
                    }
                    catch (ParseException e1) {
                        ObjectValidator.addError(systemStatus, object, errorName, INVALID_DATE);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (errorType == INVALID_EMAIL) {
                try {
                    String email = ObjectUtils.getParam(object, field);
                    if (email != null && !"".equals(email.trim())) {
                        try {
                            StringTokenizer str = new StringTokenizer(email, ",");
                            if (str.hasMoreTokens()) {
                                String temp = str.nextToken();
                                InternetAddress inetAddress = new InternetAddress(temp.trim(), true);
                                break block30;
                            }
                            InternetAddress inetAddress = new InternetAddress(email.trim(), true);
                        }
                        catch (AddressException e1) {
                            ObjectValidator.addError(systemStatus, object, field, INVALID_EMAIL);
                        }
                        break block30;
                    }
                    ObjectValidator.addError(systemStatus, object, field, INVALID_EMAIL);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (errorType == INVALID_EMAIL_NOT_REQUIRED) {
                try {
                    String email = ObjectUtils.getParam(object, field);
                    if (email == null || "".equals(email.trim())) break block30;
                    try {
                        StringTokenizer str = new StringTokenizer(email, ",");
                        if (str.hasMoreTokens()) {
                            String temp = str.nextToken();
                            InternetAddress inetAddress = new InternetAddress(temp.trim(), true);
                            break block30;
                        }
                        InternetAddress inetAddress = new InternetAddress(email.trim(), true);
                    }
                    catch (AddressException e1) {
                        ObjectValidator.addError(systemStatus, object, field, INVALID_EMAIL);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void addError(SystemStatus systemStatus, Object object, String field, int errorType) {
        if (errorType == REQUIRED_FIELD) {
            ObjectValidator.addError(systemStatus, object, field, "object.validation.required");
        } else if (errorType == PAST_DATE) {
            ObjectValidator.addError(systemStatus, object, field, "object.validation.dateInThePast");
        } else if (errorType == INVALID_DATE || errorType == INVALID_NOT_REQUIRED_DATE) {
            ObjectValidator.addError(systemStatus, object, field, "object.validation.incorrectDateFormat");
        } else if (errorType == INVALID_NUMBER) {
            ObjectValidator.addError(systemStatus, object, field, "object.validation.incorrectNumberFormat");
        } else if (errorType == INVALID_EMAIL || errorType == INVALID_EMAIL_NOT_REQUIRED) {
            ObjectValidator.addError(systemStatus, object, field, "object.validation.invalidEmailAddress");
        }
    }

    private static void addError(SystemStatus systemStatus, Object object, String field, String errorKey) {
        HashMap errors = (HashMap)ObjectUtils.getObject(object, "errors");
        if (systemStatus != null) {
            errors.put(field + "Error", systemStatus.getLabel(errorKey));
        } else {
            errors.put(field + "Error", "field error");
        }
    }

    public static void checkWarning(SystemStatus systemStatus, Object object, String field, int warningType) {
        Timestamp result;
        if (warningType == IS_BEFORE_TODAY && (result = (Timestamp)ObjectUtils.getObject(object, field)) != null && result.before(new Date())) {
            ObjectValidator.addWarning(systemStatus, object, field, "object.validation.beforeToday");
        }
    }

    public static void addWarning(SystemStatus systemStatus, Object object, String field, String warningKey) {
        HashMap warnings = (HashMap)ObjectUtils.getObject(object, "warnings");
        if (systemStatus != null) {
            warnings.put(field + "Warning", systemStatus.getLabel(warningKey));
        } else {
            warnings.put(field + "Warning", "field warning");
        }
    }

    public static void checkLength(SystemStatus systemStatus, Object object, String errorName, String fieldName, int length) {
        String value = (String)ObjectUtils.getObject(object, fieldName);
        if (value != null && value.length() > length) {
            ObjectValidator.addError(systemStatus, object, fieldName, errorName);
        }
    }
}

