/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.hooks.CustomHook;
import com.darkhorseventures.framework.servlets.ControllerHook;
import com.zeroio.iteam.base.ProjectList;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SessionManager;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.controller.UserSession;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.login.beans.LoginBean;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.modules.website.base.SiteLog;
import org.aspcfs.utils.SiteUtils;

public class SecurityHook
implements ControllerHook {
    public static final String fs = System.getProperty("file.separator");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String securityCheck(Servlet servlet, HttpServletRequest request) {
        LoginBean failedSession;
        UserBean userSession = (UserBean)((Object)request.getSession().getAttribute("User"));
        ConnectionElement ceSession = (ConnectionElement)request.getSession().getAttribute("ConnectionElement");
        String action = request.getServletPath();
        int slash = action.lastIndexOf("/");
        action = action.substring(slash + 1);
        ApplicationPrefs applicationPrefs = (ApplicationPrefs)servlet.getServletConfig().getServletContext().getAttribute("applicationPrefs");
        if (action.toUpperCase().startsWith("LOGIN") || action.toUpperCase().startsWith("SETUP") || action.toUpperCase().startsWith("UPGRADE") || action.toUpperCase().startsWith("LICENSESERVER") || action.toUpperCase().startsWith("PROCESS")) {
            return null;
        }
        if (action.toUpperCase().startsWith("PORTAL")) {
            Connection db = null;
            try {
                Site thisSite = SecurityHook.retrieveSite(servlet.getServletConfig().getServletContext(), request);
                boolean isNewUser = false;
                if (userSession == null || ceSession == null) {
                    isNewUser = true;
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("SecurityHook-> Creating a web site user session");
                    }
                    ceSession = thisSite.getConnectionElement();
                    request.getSession().setAttribute("ConnectionElement", (Object)ceSession);
                    userSession = new UserBean();
                    userSession.setUserId(-2);
                    userSession.setActualUserId(-2);
                    userSession.setIdRange("-2");
                    userSession.setConnectionElement(ceSession);
                    userSession.setClientType(request);
                    request.getSession().setAttribute("User", (Object)userSession);
                }
                db = ((ConnectionPool)servlet.getServletConfig().getServletContext().getAttribute("ConnectionPool")).getConnection(ceSession);
                if (isNewUser) {
                    SiteLog siteLog = new SiteLog();
                    org.aspcfs.modules.website.base.SiteList websiteList = new org.aspcfs.modules.website.base.SiteList();
                    websiteList.setEnabled(1);
                    websiteList.buildList(db);
                    if (websiteList.size() > 0) {
                        org.aspcfs.modules.website.base.Site webSite = (org.aspcfs.modules.website.base.Site)((Object)websiteList.get(0));
                        siteLog.setSiteId(webSite.getId());
                        siteLog.setIp(request.getRemoteAddr());
                        siteLog.setBrowser(request.getHeader("USER-AGENT"));
                        siteLog.setReferrer(request.getHeader("REFERER"));
                        siteLog.insert(db);
                        userSession.setSessionId(String.valueOf(siteLog.getId()));
                    }
                }
                SecurityHook.retrieveSystemStatus(servlet.getServletConfig().getServletContext(), db, ceSession, thisSite.getLanguage());
                ((ConnectionPool)servlet.getServletConfig().getServletContext().getAttribute("ConnectionPool")).free(db);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ((ConnectionPool)servlet.getServletConfig().getServletContext().getAttribute("ConnectionPool")).free(db);
            }
            return null;
        }
        String value = CustomHook.populateSecurityHook((ApplicationPrefs)applicationPrefs);
        if (value != null) {
            return value;
        }
        String requestedURL = (String)request.getAttribute("requestedURL");
        if (requestedURL == null && "GET".equals(request.getMethod()) && request.getParameter("redirectTo") == null) {
            String uri = request.getRequestURI();
            String queryString = request.getQueryString();
            requestedURL = uri.substring(uri.lastIndexOf("/") + 1) + (queryString == null ? "" : "?" + queryString);
            request.setAttribute("requestedURL", (Object)requestedURL);
        }
        if (userSession == null || userSession.getUserId() < 0) {
            failedSession = new LoginBean();
            failedSession.setMessage("* Please login, your session has expired");
            request.setAttribute("LoginBean", (Object)failedSession);
            return "SecurityCheck";
        }
        if ("true".equals((String)servlet.getServletConfig().getServletContext().getAttribute("ForceSSL")) && "http".equals(request.getScheme())) {
            failedSession = new LoginBean();
            failedSession.setMessage("* A secure connection is required");
            request.setAttribute("LoginBean", (Object)failedSession);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("A secure connection is required");
            }
            return "SecurityCheck";
        }
        if (userSession != null && userSession.getUserId() > -1) {
            SessionManager thisManager;
            UserSession sessionInfo;
            String actionQuery;
            SystemStatus systemStatus;
            ConnectionElement ce = userSession.getConnectionElement();
            if (ce == null) {
                System.out.println("SecurityHook-> Fatal: CE is null");
                return "SystemError";
            }
            Hashtable globalStatus = (Hashtable)servlet.getServletConfig().getServletContext().getAttribute("SystemStatus");
            if (globalStatus == null) {
                System.out.println("SecurityHook-> Fatal: SystemStatus Hashtable is null!");
            }
            if ((systemStatus = (SystemStatus)globalStatus.get(ce.getUrl())) == null) {
                Connection db = null;
                try {
                    Site thisSite = SecurityHook.retrieveSite(servlet.getServletConfig().getServletContext(), request);
                    db = ((ConnectionPool)servlet.getServletConfig().getServletContext().getAttribute("ConnectionPool")).getConnection(ce);
                    systemStatus = SecurityHook.retrieveSystemStatus(servlet.getServletConfig().getServletContext(), db, ce, thisSite.getLanguage());
                }
                catch (Exception e) {
                    ((ConnectionPool)servlet.getServletConfig().getServletContext().getAttribute("ConnectionPool")).free(db);
                    catch (Throwable throwable) {
                        ((ConnectionPool)servlet.getServletConfig().getServletContext().getAttribute("ConnectionPool")).free(db);
                        throw throwable;
                    }
                }
                ((ConnectionPool)servlet.getServletConfig().getServletContext().getAttribute("ConnectionPool")).free(db);
            }
            if ((actionQuery = request.getQueryString()) == null || actionQuery.indexOf("actionSource") == -1) {
                request.setAttribute("moduleAction", (Object)action);
                request.setAttribute("moduleCommand", (Object)request.getParameter("command"));
                request.setAttribute("moduleSection", (Object)request.getParameter("section"));
            }
            if ((sessionInfo = (thisManager = systemStatus.getSessionManager()).getUserSession(userSession.getActualUserId())) == null) {
                request.getSession().setMaxInactiveInterval(systemStatus.getSessionTimeout());
                thisManager.addUser(request, userSession.getActualUserId());
            }
            if (sessionInfo != null && !sessionInfo.getId().equals(request.getSession().getId())) {
                if (request.getSession(false) != null) {
                    request.getSession(false).invalidate();
                }
                LoginBean failedSession2 = new LoginBean();
                failedSession2.setMessage("* Please login, your session expired because you logged in from " + sessionInfo.getIpAddress());
                request.setAttribute("LoginBean", (Object)failedSession2);
                return "SecurityCheck";
            }
            if (sessionInfo == null) {
                request.getSession().setMaxInactiveInterval(systemStatus.getSessionTimeout());
                thisManager.addUser(request, userSession.getActualUserId());
                sessionInfo = thisManager.getUserSession(userSession.getActualUserId());
            }
            sessionInfo.setLastAccessed(System.currentTimeMillis());
            if (userSession.getHierarchyCheck().before(systemStatus.getHierarchyCheck()) || userSession.getPermissionCheck().before(systemStatus.getPermissionCheck())) {
                Connection db = null;
                try {
                    User updatedUser;
                    db = ((ConnectionPool)servlet.getServletConfig().getServletContext().getAttribute("ConnectionPool")).getConnection(ce);
                    if (userSession.getHierarchyCheck().before(systemStatus.getHierarchyCheck())) {
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("SecurityHook-> ** Getting you a new user record");
                        }
                        updatedUser = systemStatus.getUser(userSession.getUserId());
                        userSession.setUserRecord(updatedUser);
                        userSession.setHierarchyCheck(new Date());
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("SecurityHook-> Updating user session with new user record");
                        }
                    }
                    updatedUser = userSession.getUserRecord();
                    if (userSession.getHierarchyCheck().before(systemStatus.getHierarchyCheck())) {
                        updatedUser.setBuildContact(true);
                    } else {
                        updatedUser.setBuildContact(false);
                    }
                    updatedUser.setBuildHierarchy(false);
                    updatedUser.buildResources(db);
                    userSession.setPermissionCheck(new Date());
                }
                catch (SQLException e) {
                }
                finally {
                    ((ConnectionPool)servlet.getServletConfig().getServletContext().getAttribute("ConnectionPool")).free(db);
                }
            }
            userSession.getUserRecord().setCurrency(applicationPrefs.get("SYSTEM.CURRENCY"));
            userSession.getUserRecord().setLanguage(systemStatus.getLanguage());
        }
        return null;
    }

    public static Site retrieveSite(ServletContext context, HttpServletRequest request) {
        String serverName = request.getServerName();
        ConnectionPool sqlDriver = (ConnectionPool)context.getAttribute("ConnectionPool");
        ApplicationPrefs prefs = (ApplicationPrefs)context.getAttribute("applicationPrefs");
        SiteList sites = SiteUtils.getSiteList(prefs, sqlDriver, serverName);
        if (sites.size() == 1) {
            return (Site)((Object)sites.get(0));
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SecurityHook-> retrieveSite size: " + sites.size());
        }
        return null;
    }

    public static Site retrieveSite(ServletContext context, ConnectionElement ce) {
        ConnectionPool sqlDriver = (ConnectionPool)context.getAttribute("ConnectionPool");
        ApplicationPrefs prefs = (ApplicationPrefs)context.getAttribute("applicationPrefs");
        SiteList sites = SiteUtils.getSiteList(prefs, sqlDriver, ce);
        if (sites.size() == 1) {
            return (Site)((Object)sites.get(0));
        }
        return null;
    }

    public static synchronized SystemStatus retrieveSystemStatus(ServletContext context, Connection db, ConnectionElement ce, String language) throws SQLException {
        Hashtable statusList = (Hashtable)context.getAttribute("SystemStatus");
        if (!statusList.containsKey(ce.getUrl())) {
            SystemStatus newSystemStatus = new SystemStatus();
            newSystemStatus.setConnectionElement((ConnectionElement)ce.clone());
            ApplicationPrefs prefs = (ApplicationPrefs)context.getAttribute("applicationPrefs");
            newSystemStatus.setFileLibraryPath(prefs.get("FILELIBRARY") + ce.getDbName() + fs);
            newSystemStatus.queryRecord(db);
            ConnectionPool cp = (ConnectionPool)context.getAttribute("ConnectionPool");
            String link = "";
            String url = "";
            if (prefs.has("WEBSERVER.URL")) {
                url = prefs.get("WEBSERVER.URL");
            } else {
                SiteList sites = SiteUtils.getSiteList(prefs, cp, ce);
                if (sites.size() > 0) {
                    String contextName;
                    Site thisSite = (Site)((Object)sites.get(0));
                    url = thisSite.getVirtualHost();
                    String port = prefs.get("WEBSERVER.PORT");
                    if (port != null && !port.equals("80") && !port.equals("443")) {
                        url = url + ":" + port;
                    }
                    if ((contextName = prefs.get("WEBSERVER.CONTEXT")) != null) {
                        url = url + contextName;
                    }
                }
            }
            link = "true".equals(prefs.get("FORCESSL")) ? "https://" + url : "http://" + url;
            if (link.endsWith("/")) {
                link = link.substring(0, link.length() - 1);
            }
            newSystemStatus.setUrl(link);
            newSystemStatus.getLookupList(db, "lookup_project_role");
            statusList.put(ce.getUrl(), newSystemStatus);
            if (System.getProperty("DEBUG") != null) {
                System.out.println("SecurityHook-> Added new System Status object: " + ce.getUrl());
            }
            HashMap projectNameCache = ProjectList.buildNameList((Connection)db);
            newSystemStatus.getObjects().put("200401202226", projectNameCache);
            newSystemStatus.setApplicationPrefs(prefs);
            if (language != null) {
                newSystemStatus.setLanguage(language);
            } else {
                newSystemStatus.setLanguage(prefs.get("SYSTEM.LANGUAGE"));
            }
            prefs.addDictionary(context, language);
            prefs.addIcelets(context, language);
            newSystemStatus.startServers(context);
        }
        return (SystemStatus)statusList.get(ce.getUrl());
    }
}

