/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller;

import com.darkhorseventures.framework.actions.ActionContext;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.aspcfs.controller.UserSession;

public class SessionManager {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    HashMap sessions = new HashMap();

    public void setSessions(HashMap sessions) {
        this.sessions = sessions;
    }

    public HashMap getSessions() {
        return this.sessions;
    }

    public void addUser(ActionContext context, int userId) {
        this.addUser(context.getRequest(), userId);
    }

    public void addUser(HttpServletRequest request, int userId) {
        HttpSession session = request.getSession();
        UserSession thisSession = new UserSession();
        thisSession.setId(session.getId());
        thisSession.setIpAddress(request.getRemoteAddr());
        thisSession.setCreationTime(session.getCreationTime());
        thisSession.setUserId(userId);
        if (this.sessions.get(new Integer(userId)) == null) {
            this.synchUpdate(thisSession, userId, 1);
        } else if (System.getProperty("DEBUG") != null) {
            System.out.println("SessionManager-> User " + userId + " already has a session");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchUpdate(UserSession thisSession, int userId, int action) {
        SessionManager sessionManager = this;
        synchronized (sessionManager) {
            if (action == 1) {
                this.sessions.put(new Integer(userId), thisSession);
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("SessionManager-> User " + userId + " Added");
                }
            } else if (action == 2) {
                this.sessions.remove(new Integer(userId));
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("SessionManager-> User " + userId + " Removed");
                }
            }
        }
    }

    public void removeUser(int userId) {
        UserSession thisSession = (UserSession)this.sessions.get(new Integer(userId));
        if (thisSession != null) {
            this.synchUpdate(thisSession, userId, 2);
        }
    }

    public boolean isUserLoggedIn(int userId) {
        return this.sessions.containsKey(new Integer(userId));
    }

    public UserSession getUserSession(int userId) {
        if (this.sessions.get(new Integer(userId)) != null) {
            return (UserSession)this.sessions.get(new Integer(userId));
        }
        return null;
    }

    public UserSession replaceUserSession(ActionContext context, int userId) {
        this.removeUser(userId);
        this.addUser(context, userId);
        return this.getUserSession(userId);
    }

    public int size() {
        return this.sessions.size();
    }
}

