/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.controller.Tracker;
import com.zeroio.webdav.WebdavManager;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import net.sf.asterisk.manager.ManagerConnection;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.ImportManager;
import org.aspcfs.controller.SessionManager;
import org.aspcfs.controller.objectHookManager.ObjectHookManager;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.CategoryEditor;
import org.aspcfs.modules.admin.base.CustomListViewEditor;
import org.aspcfs.modules.admin.base.Permission;
import org.aspcfs.modules.admin.base.Role;
import org.aspcfs.modules.admin.base.RoleList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.admin.base.UserPermissionList;
import org.aspcfs.utils.AsteriskListener;
import org.aspcfs.utils.AsteriskManager;
import org.aspcfs.utils.XMLUtils;
import org.aspcfs.utils.XMPPManager;
import org.aspcfs.utils.web.LookupList;
import org.jivesoftware.smack.XMPPConnection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SystemStatus {
    private ConnectionElement connectionElement = null;
    private String fileLibraryPath = null;
    private String url = null;
    private Date permissionCheck = new Date();
    private Hashtable rolePermissions = new Hashtable();
    private boolean permissionUpdating = false;
    private Date hierarchyCheck = new Date();
    private UserList hierarchyList = new UserList();
    private Hashtable userList = new Hashtable();
    private Hashtable siteUserList = new Hashtable();
    private boolean hierarchyUpdating = false;
    private HashMap lookups = new HashMap();
    private HashMap objects = new HashMap();
    private Map preferences = new LinkedHashMap();
    private int sessionTimeout = 5400;
    private ObjectHookManager hookManager = new ObjectHookManager();
    private SessionManager sessionManager = new SessionManager();
    private WebdavManager webdavManager = new WebdavManager();
    private Map categoryEditorList = new HashMap();
    private Map customListViewEditors = new HashMap();
    private HashMap accessTypes = new HashMap();
    private Tracker tracker = new Tracker();
    private ApplicationPrefs applicationPrefs = null;
    private ManagerConnection asteriskConnection = null;
    private AsteriskListener asteriskListener = null;
    private XMPPConnection xmppConnection = null;
    private String language = null;

    public SystemStatus() {
    }

    public SystemStatus(Connection db) throws SQLException {
        this.queryRecord(db);
    }

    public void queryRecord(Connection db) throws SQLException {
        this.buildHierarchyList(db);
        this.buildPreferences(db);
        this.buildRolePermissions(db);
        this.buildWebdavResources(db);
    }

    public void setPermissionCheck(Date tmp) {
        this.permissionCheck = tmp;
    }

    public void setHierarchyCheck(Date tmp) {
        this.hierarchyCheck = tmp;
    }

    public void setConnectionElement(ConnectionElement tmp) {
        this.connectionElement = tmp;
    }

    public void setFileLibraryPath(String tmp) {
        this.fileLibraryPath = tmp;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setWebdavManager(WebdavManager webdavManager) {
        this.webdavManager = webdavManager;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Map getCategoryEditorList() {
        return this.categoryEditorList;
    }

    public Map getCustomListViewEditors() {
        return this.customListViewEditors;
    }

    public ImportManager getImportManager(ActionContext context) {
        return (ImportManager)context.getServletContext().getAttribute("ImportManager");
    }

    public void setPreferences(Map preferences) {
        this.preferences = preferences;
    }

    public Map getPreferences() {
        return this.preferences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CategoryEditor getCategoryEditor(Connection db, int constantId) throws SQLException {
        SystemStatus systemStatus = this;
        synchronized (systemStatus) {
            CategoryEditor categoryEditor = (CategoryEditor)this.categoryEditorList.get(new Integer(constantId));
            if (categoryEditor == null) {
                categoryEditor = new CategoryEditor(db, constantId);
                categoryEditor.build(db);
                this.categoryEditorList.put(new Integer(constantId), categoryEditor);
            }
            return categoryEditor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomListViewEditor getCustomListViewEditor(ActionContext context, Connection db, int constantId) throws SQLException {
        String webinfPath = context.getServletContext().getRealPath("/WEB-INF/");
        SystemStatus systemStatus = this;
        synchronized (systemStatus) {
            CustomListViewEditor listViewEditor = (CustomListViewEditor)this.customListViewEditors.get(new Integer(constantId));
            if (listViewEditor == null) {
                listViewEditor = new CustomListViewEditor(db, constantId);
                listViewEditor.build(db, webinfPath);
                this.customListViewEditors.put(new Integer(constantId), listViewEditor);
            }
            return listViewEditor;
        }
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public WebdavManager getWebdavManager() {
        return this.webdavManager;
    }

    public Date getPermissionCheck() {
        while (this.permissionUpdating) {
        }
        return this.permissionCheck;
    }

    public Date getHierarchyCheck() {
        while (this.hierarchyUpdating) {
        }
        return this.hierarchyCheck;
    }

    public UserList getHierarchyList() {
        while (this.hierarchyUpdating) {
        }
        return this.hierarchyList;
    }

    public Hashtable getUserList() {
        while (this.hierarchyUpdating) {
        }
        return this.userList;
    }

    public Hashtable getSiteUserList() {
        while (this.hierarchyUpdating) {
        }
        return this.siteUserList;
    }

    public String getLabel(String thisLabel) {
        String text = this.getValue("system.fields.label", thisLabel);
        if (text == null) {
            text = this.applicationPrefs.getLabel("system.fields.label", thisLabel, this.language);
        }
        return text;
    }

    public String getLabel(String thisLabel, String defaultText) {
        String result = this.getLabel(thisLabel);
        if (result == null) {
            return defaultText;
        }
        return result;
    }

    public String[] getLettersArray(String thisLabel) {
        String letters = this.getLabel(thisLabel);
        return letters.split(",");
    }

    public String getMenuProperty(String item, String thisProperty) {
        String text = this.getValue("system.modules.label", item, thisProperty);
        if (text == null) {
            text = this.applicationPrefs.getValue("system.modules.label", item, thisProperty, this.language);
        }
        return text;
    }

    public String getSubMenuProperty(String thisLabel) {
        String text = this.getValue("system.submenu.label", thisLabel);
        if (text == null) {
            text = this.applicationPrefs.getLabel("system.submenu.label", thisLabel, this.language);
        }
        return text;
    }

    public String getContainerMenuProperty(String collection, String thisProperty) {
        String text = this.getValue(collection, thisProperty, "value");
        if (text == null) {
            text = this.applicationPrefs.getValue(collection, thisProperty, "value", this.language);
        }
        return text;
    }

    public ConnectionElement getConnectionElement() {
        return this.connectionElement;
    }

    public String getFileLibraryPath() {
        return this.fileLibraryPath;
    }

    public ObjectHookManager getHookManager() {
        return this.hookManager;
    }

    public ApplicationPrefs getApplicationPrefs() {
        return this.applicationPrefs;
    }

    public Map getLocalizationPrefs() {
        return this.applicationPrefs.getLocalizationPrefs(this.language);
    }

    public void setApplicationPrefs(ApplicationPrefs tmp) {
        this.applicationPrefs = tmp;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void buildHierarchyList(Connection db) throws SQLException {
        this.hierarchyList.clear();
        this.userList.clear();
        this.siteUserList.clear();
        UserList tmpListA = new UserList();
        tmpListA.setBuildContact(false);
        tmpListA.setBuildContactDetails(false);
        tmpListA.setBuildHierarchy(false);
        tmpListA.setTopLevel(true);
        tmpListA.setIncludeUsersWithRolesOnly(false);
        tmpListA.buildList(db);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SystemStatus-> buildHierarchyList: A " + tmpListA.size());
        }
        UserList tmpListB = new UserList();
        tmpListB.setBuildContact(false);
        tmpListB.setBuildContactDetails(false);
        tmpListB.setBuildHierarchy(false);
        tmpListB.setTopLevel(false);
        tmpListB.setIncludeUsersWithRolesOnly(false);
        tmpListB.buildList(db);
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SystemStatus-> buildHierarchyList: B " + tmpListB.size());
        }
        for (User thisUser : tmpListA) {
            User userToAdd = tmpListB.getTopUser(thisUser.getId());
            if (userToAdd != null) {
                this.hierarchyList.add(userToAdd);
                this.userList.put(new Integer(userToAdd.getId()), userToAdd);
                this.addUserToSite(userToAdd);
                this.addChildUsers(userToAdd, tmpListB);
                continue;
            }
            this.hierarchyList.add(thisUser);
            this.userList.put(new Integer(thisUser.getId()), thisUser);
            this.addUserToSite(thisUser);
        }
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SystemStatus-> Top Level Users added : " + this.hierarchyList.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateHierarchy(Connection db) throws SQLException {
        Date checkDate = new Date();
        if (checkDate.after(this.getHierarchyCheck())) {
            SystemStatus systemStatus = this;
            synchronized (systemStatus) {
                try {
                    this.hierarchyUpdating = true;
                    if (checkDate.after(this.hierarchyCheck)) {
                        this.buildHierarchyList(db);
                        this.setHierarchyCheck(new Date());
                    }
                }
                catch (SQLException e) {
                    throw e;
                }
                finally {
                    this.hierarchyUpdating = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRolePermissions(Connection db) throws SQLException {
        Date checkDate = new Date();
        if (checkDate.after(this.getPermissionCheck())) {
            SystemStatus systemStatus = this;
            synchronized (systemStatus) {
                try {
                    this.permissionUpdating = true;
                    if (checkDate.after(this.permissionCheck)) {
                        this.buildRolePermissions(db);
                        this.setPermissionCheck(new Date());
                    }
                }
                catch (SQLException e) {
                    throw e;
                }
                finally {
                    this.permissionUpdating = false;
                }
            }
        }
    }

    public void buildPreferences(Connection db) {
        XMLUtils xml;
        File prefsFile;
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SystemStatus-> Loading system preferences: " + this.fileLibraryPath + "system.xml ");
        }
        this.preferences.clear();
        try {
            if (this.fileLibraryPath != null && (prefsFile = new File(this.fileLibraryPath + "system.xml")).exists()) {
                xml = new XMLUtils(prefsFile);
                NodeList configNodes = xml.getDocumentElement().getElementsByTagName("config");
                for (int i = 0; i < configNodes.getLength(); ++i) {
                    Node configNode = configNodes.item(i);
                    if (configNode == null || configNode.getNodeType() != 1 || !"config".equals(((Element)configNode).getTagName()) || ((Element)configNode).getAttribute("enabled") != null && !"".equals(((Element)configNode).getAttribute("enabled")) && !"true".equals(((Element)configNode).getAttribute("enabled"))) continue;
                    String configName = ((Element)configNode).getAttribute("name");
                    LinkedHashMap preferenceGroup = null;
                    if (configName == null) continue;
                    if (this.preferences.containsKey(configName)) {
                        preferenceGroup = (LinkedHashMap)this.preferences.get(configName);
                    } else {
                        preferenceGroup = new LinkedHashMap();
                        this.preferences.put(configName, preferenceGroup);
                    }
                    NodeList paramNodes = ((Element)configNode).getElementsByTagName("param");
                    for (int j = 0; j < paramNodes.getLength(); ++j) {
                        Node paramNode = paramNodes.item(j);
                        if (paramNode == null || paramNode.getNodeType() != 1 || !"param".equals(((Element)paramNode).getTagName())) continue;
                        String paramName = ((Element)paramNode).getAttribute("name");
                        if (System.getProperty("DEBUG") != null) {
                            System.out.println("SystemStatus-> Added pref " + configName + ":" + paramName);
                        }
                        if (paramName == null) continue;
                        preferenceGroup.put(paramName, paramNode);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println("SystemStatus-> Preferences Error: " + e.getMessage());
        }
        try {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("SystemStatus-> Loading workflow processes from database");
            }
            this.hookManager.setFileLibraryPath(this.fileLibraryPath);
            this.hookManager.initializeBusinessProcessList(db, true);
            this.hookManager.initializeObjectHookList(db, true);
            if (this.hookManager.getProcessList().size() == 0 || this.hookManager.getHookList().size() == 0) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("SystemStatus-> Loading workflow processes: " + this.fileLibraryPath + "workflow.xml");
                }
                if (this.fileLibraryPath != null && (prefsFile = new File(this.fileLibraryPath + "workflow.xml")).exists()) {
                    xml = new XMLUtils(prefsFile);
                    this.hookManager.setFileLibraryPath(this.fileLibraryPath);
                    if (this.hookManager.getProcessList().size() == 0) {
                        this.hookManager.initializeBusinessProcessList(xml.getDocumentElement(), true, false);
                    }
                    if (this.hookManager.getHookList().size() == 0) {
                        this.hookManager.initializeObjectHookList(xml.getDocumentElement(), true, false);
                    }
                }
            }
            this.addApplicationWorkflow();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println("SystemStatus-> Workflow Error: " + e.getMessage());
        }
    }

    public void addApplicationWorkflow() {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SystemStatus-> Loading application workflow processes: " + this.fileLibraryPath + "application.xml");
        }
        try {
            File prefsFile;
            if (this.fileLibraryPath != null && (prefsFile = new File(this.fileLibraryPath + "application.xml")).exists()) {
                XMLUtils xml = new XMLUtils(prefsFile);
                this.hookManager.setFileLibraryPath(this.fileLibraryPath);
                this.hookManager.initializeBusinessProcessList(xml.getDocumentElement(), false, true);
                this.hookManager.initializeObjectHookList(xml.getDocumentElement(), false, true);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println("SystemStatus-> application Workflow Error: " + e.getMessage());
        }
    }

    public void loadWorkflows(Connection db) {
        try {
            if (System.getProperty("DEBUG") != null) {
                System.out.println("SystemStatus-> Loading workflow processes from database");
            }
            this.hookManager.setFileLibraryPath(this.fileLibraryPath);
            this.hookManager.initializeBusinessProcessList(db, true);
            this.hookManager.initializeObjectHookList(db, true);
            this.addApplicationWorkflow();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            System.out.println("SystemStatus-> Workflow Error: " + e.getMessage());
        }
    }

    public void buildWebdavResources(Connection db) throws SQLException {
        this.webdavManager.buildModules(db, this.fileLibraryPath);
    }

    public void buildRolePermissions(Connection db) throws SQLException {
        this.rolePermissions.clear();
        RoleList roles = new RoleList();
        roles.buildList(db);
        for (Role thisRole : roles) {
            ArrayList<String> permissions = new ArrayList<String>();
            UserPermissionList permissionList = new UserPermissionList(db, thisRole.getId());
            for (Permission thisPermission : permissionList) {
                if (thisPermission.getAdd()) {
                    permissions.add(thisPermission.getName() + "-add");
                }
                if (thisPermission.getView()) {
                    permissions.add(thisPermission.getName() + "-view");
                }
                if (thisPermission.getEdit()) {
                    permissions.add(thisPermission.getName() + "-edit");
                }
                if (!thisPermission.getDelete()) continue;
                permissions.add(thisPermission.getName() + "-delete");
            }
            this.rolePermissions.put(new Integer(thisRole.getId()), permissions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LookupList getLookupList(Connection db, String tableName) throws SQLException {
        if (!this.lookups.containsKey(tableName) && db != null) {
            SystemStatus systemStatus = this;
            synchronized (systemStatus) {
                if (!this.lookups.containsKey(tableName)) {
                    this.lookups.put(tableName, new LookupList(db, tableName));
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("SystemStatus-> Added LookupList object: " + tableName);
                    }
                }
            }
        }
        return (LookupList)this.lookups.get(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeLookup(String tableName) {
        if (this.lookups.containsKey(tableName)) {
            SystemStatus systemStatus = this;
            synchronized (systemStatus) {
                if (this.lookups.containsKey(tableName)) {
                    this.lookups.remove(tableName);
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("SystemStatus-> Removed LookupList object: " + tableName);
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessTypeList getAccessTypeList(Connection db, int accessId) throws SQLException {
        if (!this.accessTypes.containsKey(new Integer(accessId))) {
            SystemStatus systemStatus = this;
            synchronized (systemStatus) {
                if (!this.accessTypes.containsKey(new Integer(accessId))) {
                    this.accessTypes.put(new Integer(accessId), new AccessTypeList(db, accessId));
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("SystemStatus --> Added new AccessTypeList object: " + accessId);
                    }
                }
            }
        }
        return (AccessTypeList)this.accessTypes.get(new Integer(accessId));
    }

    public Tracker getTracker() {
        return this.tracker;
    }

    public boolean hasField(String thisField) {
        Map ignoredFieldsGroup = (Map)this.preferences.get("system.fields.ignore");
        if (ignoredFieldsGroup != null) {
            return ignoredFieldsGroup.containsKey(thisField);
        }
        return false;
    }

    public Map getCustomValidators() {
        Map customValidators = (Map)this.preferences.get("system.fields.customValidator");
        return customValidators;
    }

    private void addChildUsers(User thisUser, UserList addFrom) {
        if (thisUser.getShortChildList() == null) {
            thisUser.setChildUsers(new UserList());
        }
        for (User tmpUser : addFrom) {
            if (tmpUser.getManagerId() != thisUser.getId()) continue;
            this.userList.put(new Integer(tmpUser.getId()), tmpUser);
            this.addUserToSite(tmpUser);
            thisUser.getShortChildList().add(tmpUser);
            tmpUser.setManagerUser(thisUser);
            this.addChildUsers(tmpUser, addFrom);
        }
    }

    private void addUserToSite(User thisUser) {
        if (thisUser.getSiteId() > -1) {
            String siteUsers = null;
            siteUsers = this.siteUserList.containsKey(new Integer(thisUser.getSiteId())) ? (String)this.siteUserList.get(new Integer(thisUser.getSiteId())) : "";
            if (siteUsers.length() > 0) {
                siteUsers = siteUsers + ",";
            }
            siteUsers = siteUsers + String.valueOf(thisUser.getId());
            this.siteUserList.put(new Integer(thisUser.getSiteId()), siteUsers);
        }
    }

    public void processHook(ActionContext context, int action, Object previousObject, Object object, ConnectionPool sqlDriver, ConnectionElement ce) {
        this.hookManager.process(context, action, previousObject, object, sqlDriver, ce);
    }

    public void processEvent(ServletContext context, String processName, ConnectionPool sqlDriver, ConnectionElement ce) {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("SystemStatus-> processEvent: " + processName + " " + ce.getUrl());
        }
        this.hookManager.process(context, processName, sqlDriver, ce);
    }

    public User getUser(int id) {
        while (this.hierarchyUpdating) {
        }
        return (User)((Object)this.userList.get(new Integer(id)));
    }

    public boolean hasPermission(int userId, String thisPermission) {
        while (this.permissionUpdating) {
        }
        int roleId = this.getUser(userId).getRoleId();
        ArrayList permissions = (ArrayList)this.rolePermissions.get(new Integer(roleId));
        if (permissions == null) {
            return false;
        }
        return permissions.contains(thisPermission);
    }

    public boolean hasPermissions() {
        return this.rolePermissions.size() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUserContact(Connection db, int id) throws SQLException {
        SystemStatus systemStatus = this;
        synchronized (systemStatus) {
            User thisUser = this.getUser(id);
            if (thisUser != null) {
                thisUser.getContact().build(db);
            }
        }
    }

    public String getValue(String section, String parameter) {
        return this.getValue(section, parameter, "value");
    }

    public String getValue(String section, String parameter, String tagName) {
        Node param;
        Map prefGroup = (Map)this.preferences.get(section);
        if (prefGroup != null && (param = (Node)prefGroup.get(parameter)) != null) {
            return XMLUtils.getNodeText(XMLUtils.getFirstChild((Element)param, tagName));
        }
        return null;
    }

    public int getValueAsInt(String section, String parameter) {
        String intValue = this.getValue(section, parameter);
        if (intValue == null) {
            return -1;
        }
        return Integer.parseInt(intValue);
    }

    public HashMap getObjects() {
        return this.objects;
    }

    public void setObjects(HashMap tmp) {
        this.objects = tmp;
    }

    public Object getObject(String label) {
        return this.objects.get(label);
    }

    public ManagerConnection getAsteriskConnection() {
        return this.asteriskConnection;
    }

    public AsteriskListener getAsteriskListener() {
        return this.asteriskListener;
    }

    public void setAsteriskListener(AsteriskListener asteriskListener) {
        this.asteriskListener = asteriskListener;
    }

    public XMPPConnection getXmppConnection() {
        return this.xmppConnection;
    }

    public String getSiteIdRange(int siteId) {
        return (String)this.getSiteUserList().get(new Integer(siteId));
    }

    public void startServers(ServletContext context) {
        if ("true".equals(this.applicationPrefs.get("XMPP.ENABLED"))) {
            this.xmppConnection = XMPPManager.verifyConnection(this, this.applicationPrefs);
        } else {
            XMPPManager.removeConnection(this);
        }
        if ("true".equals(this.applicationPrefs.get("ASTERISK.OUTBOUND.ENABLED")) || "true".equals(this.applicationPrefs.get("ASTERISK.INBOUND.ENABLED"))) {
            this.asteriskConnection = AsteriskManager.verifyConnection(this, this.applicationPrefs, context);
        } else {
            AsteriskManager.removeConnection(this);
        }
    }

    public void stopServers() {
        AsteriskManager.removeConnection(this);
        XMPPManager.removeConnection(this);
    }
}

