/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpSession;
import org.aspcfs.modules.admin.base.Permission;
import org.aspcfs.modules.admin.base.Viewpoint;
import org.aspcfs.modules.admin.base.ViewpointList;
import org.aspcfs.modules.admin.base.ViewpointPermissionList;

public class UserSession {
    String id = null;
    int maxInactiveInterval = -1;
    long lastAccessed = -1L;
    long creationTime = -1L;
    String ipAddress = null;
    HashMap viewpoints = null;
    int userId = -1;

    public UserSession() {
    }

    public UserSession(ActionContext context) {
        this.build(context);
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMaxInactiveInterval(int maxInactiveInterval) {
        this.maxInactiveInterval = maxInactiveInterval;
    }

    public void setLastAccessed(long lastAccessed) {
        this.lastAccessed = lastAccessed;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public void setCreationTime(long creationTime) {
        this.creationTime = creationTime;
    }

    public void setViewpoints(HashMap viewpoints) {
        this.viewpoints = viewpoints;
    }

    public HashMap getViewpoints() {
        return this.viewpoints;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public long getLastAccessed() {
        return this.lastAccessed;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    private void build(ActionContext context) {
        HttpSession session = context.getSession();
        this.id = session.getId();
        this.ipAddress = context.getIpAddress();
        this.creationTime = session.getCreationTime();
    }

    private void update(HttpSession session) {
        this.lastAccessed = session.getLastAccessedTime();
    }

    public void invalidateViewpoints() {
        this.viewpoints = null;
    }

    public int getUserId() {
        return this.userId;
    }

    public void setUserId(int userId) {
        this.userId = userId;
    }

    public void buildViewpoints(Connection db, String permName, int userId) throws SQLException {
        if (this.viewpoints == null) {
            this.viewpoints = new HashMap();
        }
        ViewpointList vpList = new ViewpointList();
        vpList.setUserId(userId);
        vpList.setBuildResources(true);
        vpList.setIncludeEnabledOnly(true);
        vpList.buildList(db);
        for (Viewpoint thisVp : vpList) {
            ViewpointPermissionList vpPermList = thisVp.getPermissionList();
            Iterator j = vpPermList.keySet().iterator();
            while (j.hasNext()) {
                ArrayList vpUsers;
                Permission thisPermission = (Permission)((Object)vpPermList.get((String)j.next()));
                String pName = thisPermission.getName();
                if (!permName.equals(pName)) continue;
                if (this.viewpoints.containsKey(pName)) {
                    vpUsers = (ArrayList)this.viewpoints.get(pName);
                    this.viewpoints.remove(pName);
                    vpUsers.add(new Integer(thisVp.getVpUserId()));
                    this.viewpoints.put(pName, vpUsers);
                    continue;
                }
                vpUsers = new ArrayList();
                if (thisVp.getVpUser().getAlias() != -1) {
                    vpUsers.add(new Integer(thisVp.getVpUser().getAlias()));
                } else {
                    vpUsers.add(new Integer(thisVp.getVpUserId()));
                }
                this.viewpoints.put(pName, vpUsers);
            }
        }
    }

    public HashMap getViewpoints(Connection db, String permName, int userId) throws SQLException {
        if (this.viewpoints == null || this.viewpoints != null && !this.viewpoints.containsKey(permName)) {
            this.buildViewpoints(db, permName, userId);
        }
        return this.viewpoints;
    }

    public boolean isViewpointsValid() {
        return this.viewpoints != null;
    }
}

