/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller.objectHookManager;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.aspcfs.apps.workFlowManager.BusinessProcess;
import org.aspcfs.apps.workFlowManager.BusinessProcessList;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.WorkflowManager;
import org.aspcfs.controller.objectHookManager.ObjectHookAction;
import org.aspcfs.controller.objectHookManager.ObjectHookActionList;
import org.aspcfs.controller.objectHookManager.ObjectHookList;

public class ObjectHook
extends Thread {
    private ComponentContext context = null;
    private ObjectHookList objectHookList = null;
    private BusinessProcessList businessProcessList = null;
    private int actionId = -1;
    private WorkflowManager manager = null;
    private String businessProcess = null;

    public void setObjectHookList(ObjectHookList tmp) {
        this.objectHookList = tmp;
    }

    public void setBusinessProcessList(BusinessProcessList tmp) {
        this.businessProcessList = tmp;
    }

    public void setActionId(int tmp) {
        this.actionId = tmp;
    }

    public void setManager(WorkflowManager tmp) {
        this.manager = tmp;
    }

    public void setBusinessProcess(String tmp) {
        this.businessProcess = tmp;
    }

    public BusinessProcessList getBusinessProcessList() {
        return this.businessProcessList;
    }

    public ObjectHookList getObjectHookList() {
        return this.objectHookList;
    }

    public int getActionId() {
        return this.actionId;
    }

    public WorkflowManager getManager() {
        return this.manager;
    }

    public String getBusinessProcess() {
        return this.businessProcess;
    }

    public ObjectHook(ComponentContext context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (System.getProperty("DEBUG") != null) {
                Thread.sleep(2000L);
            }
            if (this.businessProcess == null) {
                ObjectHookActionList actionList = (ObjectHookActionList)this.objectHookList.get(this.context.getClassName());
                if (actionList != null) {
                    BusinessProcess thisProcess;
                    ObjectHookAction thisAction;
                    int i;
                    boolean applicationActions = true;
                    HashMap<Integer, String> orderedAppActionKeys = new HashMap<Integer, String>();
                    HashMap<Integer, String> orderedUserActionKeys = new HashMap<Integer, String>();
                    for (ObjectHookAction thisAction2 : actionList.values()) {
                        if (thisAction2 != null && thisAction2.getApplication() && thisAction2.getTypeId() == this.actionId && thisAction2.getEnabled()) {
                            orderedAppActionKeys.put(new Integer(thisAction2.getPriority()), "" + thisAction2.getApplication() + "|" + thisAction2.getPriority() + "|" + thisAction2.getTypeId());
                        }
                        if (thisAction2 == null || thisAction2.getApplication() || thisAction2.getTypeId() != this.actionId || !thisAction2.getEnabled()) continue;
                        orderedUserActionKeys.put(new Integer(thisAction2.getPriority()), "" + thisAction2.getApplication() + "|" + thisAction2.getPriority() + "|" + thisAction2.getTypeId());
                    }
                    ArrayList applKeySet = new ArrayList(orderedAppActionKeys.keySet());
                    Object[] array = applKeySet.toArray();
                    Arrays.sort(array);
                    for (i = 0; i < array.length; ++i) {
                        thisAction = (ObjectHookAction)actionList.get((String)orderedAppActionKeys.get(array[i]));
                        this.businessProcess = null;
                        if (thisAction != null && thisAction.getEnabled() && thisAction.getTypeId() == this.actionId && thisAction.getApplication()) {
                            this.businessProcess = thisAction.getProcessName();
                        }
                        if (this.businessProcess == null) continue;
                        this.context.setProcessName(this.businessProcess);
                        if (this.businessProcessList == null || (thisProcess = (BusinessProcess)this.businessProcessList.get(this.businessProcess)) == null) continue;
                        this.context.setProcess(thisProcess);
                        this.manager.execute(this.context);
                    }
                    applicationActions = false;
                    applKeySet = new ArrayList(orderedUserActionKeys.keySet());
                    array = applKeySet.toArray();
                    Arrays.sort(array);
                    for (i = 0; i < array.length; ++i) {
                        thisAction = (ObjectHookAction)actionList.get((String)orderedUserActionKeys.get(array[i]));
                        this.businessProcess = null;
                        if (thisAction != null && thisAction.getEnabled() && thisAction.getTypeId() == this.actionId && !thisAction.getApplication()) {
                            this.businessProcess = thisAction.getProcessName();
                        }
                        if (this.businessProcess == null) continue;
                        this.context.setProcessName(this.businessProcess);
                        if (this.businessProcessList == null || (thisProcess = (BusinessProcess)this.businessProcessList.get(this.businessProcess)) == null) continue;
                        this.context.setProcess(thisProcess);
                        this.manager.execute(this.context);
                    }
                }
            } else {
                BusinessProcess thisProcess;
                this.context.setProcessName(this.businessProcess);
                if (this.businessProcessList != null && (thisProcess = (BusinessProcess)this.businessProcessList.get(this.businessProcess)) != null) {
                    this.context.setProcess(thisProcess);
                    this.manager.execute(this.context);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }
}

