/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller.objectHookManager;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.utils.DatabaseUtils;
import org.w3c.dom.Element;

public class ObjectHookAction {
    public static final int UNDEFINED = -1;
    public static final int INSERT = 1;
    public static final int UPDATE = 2;
    public static final int DELETE = 3;
    private int id = -1;
    private int hookId = -1;
    private int triggerId = -1;
    private int processId = -1;
    private int linkModuleId = -1;
    private int typeId = -1;
    private boolean enabled = true;
    private int priority = -1;
    private boolean application = false;
    private String className = null;
    private String processName = null;
    private String linkModule = null;

    public ObjectHookAction() {
    }

    public ObjectHookAction(Element actionElement) {
        this.setType(actionElement.getAttribute("type"));
        this.setProcessName(actionElement.getAttribute("process"));
        this.setEnabled(actionElement.getAttribute("enabled"));
    }

    public ObjectHookAction(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setHookId(int tmp) {
        this.hookId = tmp;
    }

    public void setHookId(String tmp) {
        this.hookId = Integer.parseInt(tmp);
    }

    public void setTriggerId(int tmp) {
        this.triggerId = tmp;
    }

    public void setTriggerId(String tmp) {
        this.triggerId = Integer.parseInt(tmp);
    }

    public void setProcessId(int tmp) {
        this.processId = tmp;
    }

    public void setProcessId(String tmp) {
        this.processId = Integer.parseInt(tmp);
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public void setClassName(String tmp) {
        this.className = tmp;
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = DatabaseUtils.parseInt(tmp, -1);
    }

    public void setType(String tmp) {
        this.typeId = ObjectHookAction.parseAction(tmp);
    }

    public void setProcessName(String tmp) {
        this.processName = tmp;
    }

    public void setLinkModule(String tmp) {
        this.linkModule = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = tmp == null || "".equals(tmp) ? true : DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getHookId() {
        return this.hookId;
    }

    public int getTriggerId() {
        return this.triggerId;
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public String getClassName() {
        return this.className;
    }

    public String getBaseClassName() {
        return this.className.substring(this.className.lastIndexOf(".") + 1);
    }

    public int getTypeId() {
        return this.typeId;
    }

    public String getProcessName() {
        return this.processName;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int tmp) {
        this.priority = tmp;
    }

    public void setPriority(String tmp) {
        this.priority = Integer.parseInt(tmp);
    }

    public boolean getApplication() {
        return this.application;
    }

    public void setApplication(boolean tmp) {
        this.application = tmp;
    }

    public void setApplication(String tmp) {
        this.application = DatabaseUtils.parseBoolean(tmp);
    }

    public static int parseAction(String actionText) {
        if ("insert".equals(actionText)) {
            return 1;
        }
        if ("update".equals(actionText)) {
            return 2;
        }
        if ("delete".equals(actionText)) {
            return 3;
        }
        return -1;
    }

    public String getTypeText() {
        switch (this.typeId) {
            case 1: {
                return "Insert";
            }
            case 2: {
                return "Update";
            }
            case 3: {
                return "Delete";
            }
        }
        return "Undefined";
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("id");
        this.hookId = rs.getInt("hook_id");
        this.processId = rs.getInt("process_id");
        this.enabled = rs.getBoolean("enabled");
        this.priority = rs.getInt("priority");
        this.className = rs.getString("hook_class");
        this.typeId = rs.getInt("action_type_id");
        this.processName = rs.getString("process_name");
    }

    public void insert(Connection db) throws SQLException {
        boolean autoCommit = db.getAutoCommit();
        try {
            if (autoCommit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            ResultSet rs = null;
            if (this.linkModuleId == -1 && this.linkModule != null && !this.linkModule.equals("")) {
                this.linkModuleId = PermissionCategory.lookupId(db, Integer.parseInt(this.linkModule));
            }
            int i = 0;
            if (this.hookId == -1) {
                pst = db.prepareStatement("SELECT hook_id FROM business_process_hook_library WHERE link_module_id = ? AND hook_class = ? ");
                pst.setInt(1, this.linkModuleId);
                pst.setString(2, this.className);
                rs = pst.executeQuery();
                if (rs.next()) {
                    this.hookId = rs.getInt("hook_id");
                }
                rs.close();
                pst.close();
                if (this.hookId == -1) {
                    i = 0;
                    this.id = DatabaseUtils.getNextSeq(db, "business_process_hl_hook_id_seq");
                    pst = db.prepareStatement("INSERT INTO business_process_hook_library (" + (this.id > -1 ? "hook_id, " : "") + "link_module_id, hook_class, enabled) VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?,?)");
                    if (this.id > -1) {
                        pst.setInt(++i, this.id);
                    }
                    pst.setInt(++i, this.linkModuleId);
                    pst.setString(++i, this.className);
                    pst.setBoolean(++i, true);
                    pst.execute();
                    pst.close();
                    this.hookId = DatabaseUtils.getCurrVal(db, "business_process_hl_hook_id_seq", this.id);
                }
            }
            if (this.triggerId == -1) {
                pst = db.prepareStatement("SELECT trigger_id FROM business_process_hook_triggers WHERE action_type_id = ? AND hook_id = ? ");
                pst.setInt(1, this.typeId);
                pst.setInt(2, this.hookId);
                rs = pst.executeQuery();
                if (rs.next()) {
                    this.triggerId = rs.getInt("trigger_id");
                }
                rs.close();
                pst.close();
                if (this.triggerId == -1) {
                    i = 0;
                    this.id = DatabaseUtils.getNextSeq(db, "business_process_ho_trig_id_seq");
                    pst = db.prepareStatement("INSERT INTO business_process_hook_triggers (" + (this.id > -1 ? "trigger_id, " : "") + "action_type_id, hook_id, enabled) VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?)");
                    if (this.id > -1) {
                        pst.setInt(++i, this.id);
                    }
                    pst.setInt(++i, this.typeId);
                    pst.setInt(++i, this.hookId);
                    pst.setBoolean(++i, true);
                    pst.execute();
                    pst.close();
                    this.triggerId = DatabaseUtils.getCurrVal(db, "business_process_ho_trig_id_seq", this.id);
                }
            }
            if (this.processId == -1 && this.processName != null) {
                i = 0;
                pst = db.prepareStatement("SELECT process_id FROM business_process WHERE process_name = ?");
                pst.setString(1, this.processName);
                rs = pst.executeQuery();
                if (rs.next()) {
                    this.processId = rs.getInt("process_id");
                }
                rs.close();
                pst.close();
            }
            int currentId = -1;
            if (this.processId != -1) {
                i = 0;
                pst = db.prepareStatement("SELECT id FROM business_process_hook WHERE trigger_id = ? AND process_id = ? AND enabled = ? ");
                pst.setInt(++i, this.triggerId);
                pst.setInt(++i, this.processId);
                pst.setBoolean(++i, this.enabled);
                rs = pst.executeQuery();
                if (rs.next()) {
                    currentId = DatabaseUtils.getInt(rs, "id");
                }
                rs.close();
                pst.close();
            }
            if (currentId != -1) {
                pst = db.prepareStatement("UPDATE business_process_hook SET priority = ? WHERE id = ? ");
                pst.setInt(1, this.priority);
                pst.setInt(2, this.id);
                pst.execute();
                pst.close();
            } else {
                this.id = DatabaseUtils.getNextSeq(db, "business_process_ho_hook_id_seq");
                i = 0;
                pst = db.prepareStatement("INSERT INTO business_process_hook (" + (this.id > -1 ? "id, " : "") + "trigger_id, process_id, enabled, priority) VALUES " + "(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?)");
                if (this.id > -1) {
                    pst.setInt(++i, this.id);
                }
                pst.setInt(++i, this.triggerId);
                pst.setInt(++i, this.processId);
                pst.setBoolean(++i, this.enabled);
                pst.setInt(++i, this.priority);
                pst.execute();
                this.id = DatabaseUtils.getCurrVal(db, "business_process_ho_hook_id_seq", this.id);
                pst.close();
            }
            if (autoCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            if (autoCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (autoCommit) {
                db.setAutoCommit(true);
            }
        }
    }
}

