/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller.objectHookManager;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.controller.objectHookManager.ObjectHookAction;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class ObjectHookActionList
extends HashMap {
    private String className = null;
    private int linkModuleId = -1;
    private String linkModule = null;
    private boolean isApplication = false;

    public ObjectHookActionList() {
    }

    public void setClassName(String tmp) {
        this.className = tmp;
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public String getClassName() {
        return this.className;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public boolean getIsApplication() {
        return this.isApplication;
    }

    public void setIsApplication(boolean tmp) {
        this.isApplication = tmp;
    }

    public void setIsApplication(String tmp) {
        this.isApplication = DatabaseUtils.parseBoolean(tmp);
    }

    public ObjectHookActionList(Element hookElement, boolean isApp) {
        this.processHookElement(hookElement, isApp);
    }

    public void processHookElement(Element hookElement, boolean isApp) {
        this.setIsApplication(isApp);
        this.className = hookElement.getAttribute("class");
        this.linkModule = hookElement.getAttribute("module");
        Element actions = XMLUtils.getFirstElement(hookElement, "actions");
        if (actions != null) {
            ArrayList actionNodes = XMLUtils.getElements(actions, "action");
            for (Element actionElement : actionNodes) {
                ObjectHookAction thisAction = new ObjectHookAction(actionElement);
                thisAction.setClassName(this.className);
                thisAction.setLinkModule(this.linkModule);
                thisAction.setPriority(this.getNextPriority(this.className, this.getIsApplication(), thisAction.getTypeId()));
                thisAction.setApplication(this.getIsApplication());
                this.put(new String("" + thisAction.getApplication() + "|" + thisAction.getPriority() + "|" + thisAction.getTypeId()), thisAction);
            }
        }
    }

    public int getNextPriority(String className, boolean isApplication, int typeId) {
        int result = 0;
        for (ObjectHookAction thisAction : this.values()) {
            if (!thisAction.getClassName().equals(className) || result >= thisAction.getPriority() || isApplication != thisAction.getApplication() || typeId != thisAction.getTypeId()) continue;
            result = thisAction.getPriority();
        }
        return ++result;
    }

    public void insert(Connection db) throws SQLException {
        for (ObjectHookAction thisAction : this.values()) {
            if (thisAction.getApplication()) continue;
            thisAction.insert(db);
        }
    }

    public boolean removeProcessesFromMemory(boolean userProc, boolean applProc) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String key : this.keySet()) {
            if (userProc && key.indexOf("false") != -1) {
                keys.add(key);
            }
            if (!applProc || key.indexOf("true") == -1) continue;
            keys.add(key);
        }
        for (String key : keys) {
            ObjectHookAction hookAction = (ObjectHookAction)this.remove(key);
            hookAction = null;
        }
        return true;
    }
}

