/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller.objectHookManager;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.controller.objectHookManager.ObjectHookAction;
import org.aspcfs.controller.objectHookManager.ObjectHookActionList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.XMLUtils;
import org.w3c.dom.Element;

public class ObjectHookList
extends HashMap {
    private int enabled = -1;
    private int linkModuleId = -1;
    private boolean isApplication = false;

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setLinkModuleId(int tmp) {
        this.linkModuleId = tmp;
    }

    public void setLinkModuleId(String tmp) {
        this.linkModuleId = Integer.parseInt(tmp);
    }

    public int getEnabled() {
        return this.enabled;
    }

    public int getLinkModuleId() {
        return this.linkModuleId;
    }

    public boolean getIsApplication() {
        return this.isApplication;
    }

    public void setIsApplication(boolean tmp) {
        this.isApplication = tmp;
    }

    public void setIsApplication(String tmp) {
        this.isApplication = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean buildList(File xmlFile) {
        try {
            XMLUtils xml = new XMLUtils(xmlFile);
            return this.parse(xml.getDocumentElement(), false);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public boolean buildList(File xmlFile, boolean isApplication) {
        try {
            XMLUtils xml = new XMLUtils(xmlFile);
            return this.parse(xml.getDocumentElement(), isApplication);
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
    }

    public boolean parse(Element element, boolean isApplication) {
        if (element == null) {
            return false;
        }
        ObjectHookActionList actionList = null;
        try {
            Element hooks = XMLUtils.getFirstElement(element, "hooks");
            if (hooks != null) {
                ArrayList hookNodes = XMLUtils.getElements(hooks, "hook");
                for (Element hookElement : hookNodes) {
                    ObjectHookActionList oldActionList;
                    String hookClass = hookElement.getAttribute("class");
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ObjectHookList-> Added a hook: " + hookClass);
                    }
                    if ((oldActionList = (ObjectHookActionList)this.get(hookClass)) != null && oldActionList.size() > 0) {
                        oldActionList.processHookElement(hookElement, isApplication);
                        this.put(hookClass, oldActionList);
                        continue;
                    }
                    actionList = new ObjectHookActionList(hookElement, isApplication);
                    this.put(hookClass, actionList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean has(Object object) throws ClassNotFoundException {
        return this.get(object.getClass().getName()) != null;
    }

    public ArrayList getActionsByProcess(String processName) {
        ArrayList<ObjectHookAction> actions = new ArrayList<ObjectHookAction>();
        for (ObjectHookActionList thisList : this.values()) {
            for (ObjectHookAction thisAction : thisList.values()) {
                if (!processName.equals(thisAction.getProcessName())) continue;
                actions.add(thisAction);
            }
        }
        return actions;
    }

    public void buildList(Connection db) throws SQLException {
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlSelect.append("SELECT h.id, hl.hook_id, h.process_id, h.enabled, h.priority, hl.hook_class, t.action_type_id, bp.process_name FROM business_process_hook h, business_process_hook_library hl, business_process_hook_triggers t, business_process bp WHERE h.id > 0 AND hl.hook_id = t.hook_id AND h.trigger_id = t.trigger_id AND h.process_id = bp.process_id ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY id ");
        PreparedStatement pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        this.prepareFilter(pst);
        ResultSet rs = pst.executeQuery();
        while (rs.next()) {
            ObjectHookAction thisAction = new ObjectHookAction(rs);
            this.addAction(thisAction);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.linkModuleId > -1) {
            sqlFilter.append("AND hl.link_module_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND h.enabled = ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.linkModuleId > -1) {
            pst.setInt(++i, this.linkModuleId);
        }
        if (this.enabled != -1) {
            pst.setBoolean(++i, this.enabled == 1);
        }
        return i;
    }

    public void addAction(ObjectHookAction action) {
        ObjectHookActionList actionList = (ObjectHookActionList)this.get(action.getClassName());
        if (actionList == null) {
            actionList = new ObjectHookActionList();
            this.put(action.getClassName(), actionList);
        }
        if (action.getPriority() == -1) {
            action.setPriority(actionList.getNextPriority(action.getClassName(), action.getApplication(), action.getTypeId()));
        }
        actionList.put(new String("" + action.getApplication() + "|" + action.getPriority() + "|" + action.getTypeId()), action);
    }

    public void addAction(ObjectHookAction action, boolean isApp) {
        ObjectHookActionList actionList = (ObjectHookActionList)this.get(action.getClassName());
        if (actionList == null) {
            actionList = new ObjectHookActionList();
            this.put(action.getClassName(), actionList);
        }
        action.setApplication(isApp);
        if (action.getPriority() == -1) {
            action.setPriority(actionList.getNextPriority(action.getClassName(), isApp, action.getTypeId()));
        }
        actionList.put(new String("" + action.getApplication() + "|" + action.getPriority() + "|" + action.getTypeId()), action);
    }

    public void insert(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            for (ObjectHookActionList actionList : this.values()) {
                actionList.insert(db);
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }

    public int getSizeOfActions() {
        int resultCount = 0;
        for (ObjectHookActionList actionList : this.values()) {
            resultCount += actionList.values().size();
        }
        return resultCount;
    }
}

