/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.controller.objectHookManager;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.ServletContext;
import org.aspcfs.apps.workFlowManager.BusinessProcessList;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ScheduledEventList;
import org.aspcfs.apps.workFlowManager.WorkflowManager;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.objectHookManager.ObjectHook;
import org.aspcfs.controller.objectHookManager.ObjectHookList;
import org.aspcfs.modules.service.base.PacketContext;
import org.aspcfs.utils.web.RequestUtils;
import org.w3c.dom.Element;

public class ObjectHookManager {
    private ObjectHookList hookList = null;
    private BusinessProcessList processList = null;
    private ScheduledEventList eventList = null;
    private String fileLibraryPath = null;

    public void setFileLibraryPath(String tmp) {
        this.fileLibraryPath = tmp;
    }

    public ObjectHookList getHookList() {
        return this.hookList;
    }

    public void setHookList(ObjectHookList tmp) {
        this.hookList = tmp;
    }

    public BusinessProcessList getProcessList() {
        return this.processList;
    }

    public void setProcessList(BusinessProcessList tmp) {
        this.processList = tmp;
    }

    public ScheduledEventList getEventList() {
        return this.eventList;
    }

    public void setEventList(ScheduledEventList tmp) {
        this.eventList = tmp;
    }

    public void initializeObjectHookList(Element documentElement, boolean overwrite, boolean isApplicationType) {
        if (overwrite) {
            this.hookList = new ObjectHookList();
        }
        this.hookList.parse(documentElement, isApplicationType);
    }

    public void initializeObjectHookList(boolean overwrite) {
        if (overwrite) {
            this.hookList = new ObjectHookList();
        }
    }

    public void initializeObjectHookList(Connection db, boolean overwrite) throws SQLException {
        if (overwrite) {
            this.hookList = new ObjectHookList();
        }
        this.hookList.buildList(db);
    }

    public void initializeBusinessProcessList(Element documentElement, boolean overwrite, boolean isApplicationType) {
        if (overwrite) {
            this.processList = new BusinessProcessList();
        }
        this.processList.parse(documentElement, isApplicationType);
    }

    public void initializeBusinessProcessList(Connection db, boolean overwrite) throws SQLException {
        if (overwrite) {
            this.processList = new BusinessProcessList();
        }
        this.processList.buildList(db);
    }

    public void initializeBusinessProcessList(boolean overwrite) {
        if (overwrite) {
            this.processList = new BusinessProcessList();
        }
    }

    public void process(PacketContext packetContext, int action, Object previousObject, Object object) {
        this.process(packetContext.getActionContext(), action, previousObject, object, packetContext.getConnectionPool(), packetContext.getConnectionElement());
    }

    public void process(ActionContext actionContext, int action, Object previousObject, Object object, ConnectionPool sqlDriver, ConnectionElement ce) {
        try {
            WorkflowManager wfManager = (WorkflowManager)actionContext.getServletContext().getAttribute("WorkflowManager");
            if (wfManager != null && this.hookList != null && this.processList != null) {
                if (object != null && this.hookList.has(object) || previousObject != null && this.hookList.has(previousObject)) {
                    ApplicationPrefs prefs = (ApplicationPrefs)actionContext.getServletContext().getAttribute("applicationPrefs");
                    ComponentContext context = new ComponentContext();
                    context.setPreviousObject(previousObject);
                    context.setThisObject(object);
                    context.setParameter("FileLibraryPath", this.fileLibraryPath);
                    context.setAttribute("SERVERURL", RequestUtils.getLink(actionContext, ""));
                    context.setAttribute("ConnectionPool", sqlDriver);
                    context.setAttribute("ConnectionElement", ce);
                    context.setAttribute("ClientSSLKeystore", actionContext.getServletContext().getAttribute("ClientSSLKeystore"));
                    context.setAttribute("ClientSSLKeystorePassword", actionContext.getServletContext().getAttribute("ClientSSLKeystorePassword"));
                    context.setAttribute("MAILSERVER", prefs.get("MAILSERVER"));
                    context.setAttribute("EMAILADDRESS", prefs.get("EMAILADDRESS"));
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("ObjectHookList-> Hook thread start");
                    }
                    ObjectHook thisHook = new ObjectHook(context);
                    thisHook.setActionId(action);
                    thisHook.setObjectHookList(this.hookList);
                    thisHook.setBusinessProcessList(this.processList);
                    thisHook.setManager(wfManager);
                    thisHook.start();
                }
            } else {
                if (wfManager == null) {
                    System.out.println("ObjectHookManager-> WorkflowManager not found");
                }
                if (this.processList == null) {
                    System.out.println("ObjectHookManager-> ProcessList not found");
                }
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(System.out);
        }
    }

    public void process(ServletContext servletContext, String processName, ConnectionPool sqlDriver, ConnectionElement ce) {
        WorkflowManager wfManager = (WorkflowManager)servletContext.getAttribute("WorkflowManager");
        if (wfManager != null && this.processList != null) {
            ComponentContext context = new ComponentContext();
            context.setParameter("FileLibraryPath", this.fileLibraryPath);
            context.setAttribute("ConnectionPool", sqlDriver);
            context.setAttribute("ConnectionElement", ce);
            context.setAttribute("ClientSSLKeystore", servletContext.getAttribute("ClientSSLKeystore"));
            context.setAttribute("ClientSSLKeystorePassword", servletContext.getAttribute("ClientSSLKeystorePassword"));
            ApplicationPrefs prefs = (ApplicationPrefs)servletContext.getAttribute("applicationPrefs");
            if (prefs != null) {
                context.setAttribute("MAILSERVER", prefs.get("MAILSERVER"));
                context.setAttribute("EMAILADDRESS", prefs.get("EMAILADDRESS"));
            }
            if (System.getProperty("DEBUG") != null) {
                System.out.println("ObjectHookList-> Hook thread start for process: " + processName);
            }
            ObjectHook thisHook = new ObjectHook(context);
            thisHook.setBusinessProcess(processName);
            thisHook.setBusinessProcessList(this.processList);
            thisHook.setManager(wfManager);
            thisHook.start();
        } else if (System.getProperty("DEBUG") != null) {
            if (wfManager == null) {
                System.out.println("ObjectHookManager-> WorkflowManager not found");
            }
            if (this.processList == null) {
                System.out.println("ObjectHookManager-> ProcessList not found");
            }
        }
    }
}

