/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.jcrontab.datasource;

import com.darkhorseventures.database.ConnectionElement;
import com.darkhorseventures.database.ConnectionPool;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.aspcfs.modules.system.base.Site;
import org.aspcfs.modules.system.base.SiteList;
import org.aspcfs.utils.DatabaseUtils;
import org.jcrontab.Crontab;
import org.jcrontab.data.CrontabEntryBean;
import org.jcrontab.data.CrontabEntryException;
import org.jcrontab.data.CrontabParser;
import org.jcrontab.data.DataNotFoundException;
import org.jcrontab.data.DataSource;
import org.jcrontab.log.Log;

public class CFSDatasource
implements DataSource {
    private CrontabParser cp = new CrontabParser();
    private static Object dbDriver = null;
    private static CFSDatasource instance;
    public static String querySearching;
    public static String queryStoring;
    public static String queryRemoving;
    private static String DEFAULT_TABLE;

    public DataSource getInstance() {
        if (instance == null) {
            instance = new CFSDatasource();
        }
        return instance;
    }

    public CrontabEntryBean find(CrontabEntryBean ceb) throws CrontabEntryException, ClassNotFoundException, SQLException, DataNotFoundException {
        CrontabEntryBean[] cebra = this.findAll();
        for (int i = 0; i < cebra.length; ++i) {
            if (!cebra[i].equals((Object)ceb)) continue;
            return cebra[i];
        }
        throw new DataNotFoundException("Unable to find :" + ceb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrontabEntryBean[] findAll(Object connectionPool) throws CrontabEntryException, ClassNotFoundException, SQLException, DataNotFoundException {
        if (connectionPool == null) {
            return this.findAll();
        }
        ConnectionPool cp = (ConnectionPool)connectionPool;
        ArrayList events = new ArrayList();
        Crontab crontab = Crontab.getInstance();
        String dbUrl = crontab.getProperty("org.jcrontab.data.GenericSQLSource.url");
        String dbUser = crontab.getProperty("org.jcrontab.data.GenericSQLSource.username");
        String dbPwd = crontab.getProperty("org.jcrontab.data.GenericSQLSource.password");
        ConnectionElement gk = new ConnectionElement(dbUrl, dbUser, dbPwd);
        gk.setDriver(crontab.getProperty("org.jcrontab.data.GenericSQLSource.driver"));
        gk.setDbName(crontab.getProperty("org.jcrontab.data.GenericSQLSource.database"));
        Connection db = null;
        SiteList siteList = new SiteList();
        siteList.setEnabled(1);
        try {
            db = cp.getConnection(gk);
            this.findAll(events, db, DEFAULT_TABLE, null);
            siteList.buildList(db);
        }
        catch (Exception e) {
        }
        finally {
            cp.free(db);
        }
        if (siteList.size() > 0) {
            for (Site thisSite : siteList) {
                ConnectionElement ce = new ConnectionElement(thisSite.getDatabaseUrl(), thisSite.getDatabaseUsername(), thisSite.getDatabasePassword());
                ce.setDriver(thisSite.getDatabaseDriver());
                ce.setDbName(thisSite.getDatabaseName());
                try {
                    db = cp.getConnection(ce);
                    this.findAll(events, db, "business_process_events", ce);
                }
                catch (Exception e) {}
                continue;
                finally {
                    cp.free(db);
                }
            }
        } else {
            try {
                db = cp.getConnection(gk);
                this.findAll(events, db, "business_process_events", gk);
            }
            catch (Exception e) {
            }
            finally {
                cp.free(db);
            }
        }
        return this.buildCrontabArray(events);
    }

    public CrontabEntryBean[] findAll() throws CrontabEntryException, ClassNotFoundException, SQLException, DataNotFoundException {
        ArrayList events = new ArrayList();
        return this.buildCrontabArray(events);
    }

    public void findAll(ArrayList list, Connection conn, String table, ConnectionElement connectionElement) throws CrontabEntryException, ClassNotFoundException, SQLException, DataNotFoundException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = conn.prepareStatement("SELECT " + DatabaseUtils.addQuotes(conn, "second") + ", " + DatabaseUtils.addQuotes(conn, "minute") + ", " + DatabaseUtils.addQuotes(conn, "hour") + ", dayofmonth, " + "" + DatabaseUtils.addQuotes(conn, "month") + ", " + DatabaseUtils.addQuotes(conn, "dayofweek") + ", " + DatabaseUtils.addQuotes(conn, "year") + ", task, extrainfo, businessDays " + "FROM " + table + " " + "WHERE enabled = ?");
            pst.setBoolean(1, true);
            rs = pst.executeQuery();
            while (rs.next()) {
                boolean[] bSeconds = new boolean[60];
                boolean[] bYears = new boolean[10];
                String second = rs.getString("second");
                String minute = rs.getString("minute");
                String hour = rs.getString("hour");
                String dayofmonth = rs.getString("dayofmonth");
                String month = rs.getString("month");
                String dayofweek = rs.getString("dayofweek");
                String year = rs.getString("year");
                String task = rs.getString("task");
                String extrainfo = rs.getString("extrainfo");
                String line = minute + " " + hour + " " + dayofmonth + " " + month + " " + dayofweek + " " + task + " " + extrainfo;
                boolean businessDays = rs.getBoolean("businessDays");
                CrontabEntryBean ceb = this.cp.marshall(line);
                this.cp.parseToken(year, bYears, false);
                ceb.setBYears(bYears);
                ceb.setYears(year);
                this.cp.parseToken(second, bSeconds, false);
                ceb.setBSeconds(bSeconds);
                ceb.setSeconds(second);
                ceb.setBusinessDays(businessDays);
                ceb.setConnectionContext((Object)connectionElement);
                list.add(ceb);
            }
            rs.close();
            pst.close();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private CrontabEntryBean[] buildCrontabArray(ArrayList list) {
        CrontabEntryBean[] result = new CrontabEntryBean[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            result[i] = (CrontabEntryBean)list.get(i);
            result[i].setId(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CrontabEntryBean[] beans) throws CrontabEntryException, ClassNotFoundException, SQLException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(queryRemoving);
            for (int i = 0; i < beans.length; ++i) {
                ps.setString(1, beans[i].getSeconds());
                ps.setString(2, beans[i].getMinutes());
                ps.setString(3, beans[i].getHours());
                ps.setString(4, beans[i].getDaysOfMonth());
                ps.setString(5, beans[i].getMonths());
                ps.setString(6, beans[i].getDaysOfWeek());
                ps.setString(7, beans[i].getYear());
                if ("".equals(beans[i].getMethodName())) {
                    ps.setString(8, beans[i].getClassName());
                } else {
                    String classAndMethod = beans[i].getClassName() + "#" + beans[i].getMethodName();
                    ps.setString(8, classAndMethod);
                }
                String[] extraInfo = beans[i].getExtraInfo();
                String extraInfob = new String();
                if (extraInfo.length > 0) {
                    for (int z = 0; z < extraInfo.length; ++z) {
                        extraInfob = extraInfob + " " + extraInfo[z];
                    }
                }
                ps.setString(9, extraInfob);
                ps.setBoolean(10, beans[i].getBusinessDays());
                ps.executeUpdate();
            }
            ps.close();
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e2) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void store(CrontabEntryBean[] beans) throws CrontabEntryException, ClassNotFoundException, SQLException {
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = this.getConnection();
            ps = conn.prepareStatement(queryStoring);
            for (int i = 0; i < beans.length; ++i) {
                ps.setString(1, beans[i].getSeconds());
                ps.setString(2, beans[i].getMinutes());
                ps.setString(3, beans[i].getHours());
                ps.setString(4, beans[i].getDaysOfMonth());
                ps.setString(5, beans[i].getMonths());
                ps.setString(6, beans[i].getDaysOfWeek());
                ps.setString(7, beans[i].getYear());
                if ("".equals(beans[i].getMethodName())) {
                    ps.setString(8, beans[i].getClassName());
                } else {
                    String classAndMethod = beans[i].getClassName() + "#" + beans[i].getMethodName();
                    ps.setString(8, classAndMethod);
                }
                String[] extraInfo = beans[i].getExtraInfo();
                String extraInfob = new String();
                if (extraInfo.length > 0) {
                    for (int z = 0; z < extraInfo.length; ++z) {
                        extraInfob = extraInfob + " " + extraInfo[z];
                    }
                }
                ps.setString(9, extraInfob);
                ps.setBoolean(10, beans[i].getBusinessDays());
                ps.executeUpdate();
            }
            ps.close();
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception e2) {}
        }
    }

    public void store(CrontabEntryBean bean) throws CrontabEntryException, ClassNotFoundException, SQLException {
        CrontabEntryBean[] list = new CrontabEntryBean[]{bean};
        this.store(list);
    }

    private Connection getConnection() throws SQLException {
        Crontab crontab = Crontab.getInstance();
        String dbUser = crontab.getProperty("org.jcrontab.data.GenericSQLSource.username");
        String dbPwd = crontab.getProperty("org.jcrontab.data.GenericSQLSource.password");
        String dbUrl = crontab.getProperty("org.jcrontab.data.GenericSQLSource.url");
        if (dbDriver == null) {
            dbDriver = this.loadDatabaseDriver(crontab.getProperty("org.jcrontab.data.GenericSQLSource.dbDataSource"));
        }
        if (dbDriver instanceof javax.sql.DataSource) {
            if (dbUser != null && dbPwd != null) {
                return ((javax.sql.DataSource)dbDriver).getConnection(dbUser, dbPwd);
            }
            return ((javax.sql.DataSource)dbDriver).getConnection();
        }
        return DatabaseUtils.getConnection(dbUrl, dbUser, dbPwd);
    }

    private Object loadDatabaseDriver(String srcName) throws SQLException {
        String dbDataSource = srcName;
        Crontab crontab = Crontab.getInstance();
        if (dbDataSource == null) {
            String dbDriver = crontab.getProperty("org.jcrontab.data.GenericSQLSource.driver");
            Log.info((String)("CFSDatasource-> Loading dbDriver: " + dbDriver));
            try {
                return Class.forName(dbDriver).newInstance();
            }
            catch (Exception ie) {
                Log.error((String)("CFSDatasource-> Error loading " + dbDriver), (Throwable)ie);
                return DriverManager.getDriver(crontab.getProperty("org.jcrontab.data.GenericSQLSource.url"));
            }
        }
        try {
            javax.sql.DataSource dataSource = null;
            Log.info((String)("Loading dataSource: " + dbDataSource));
            InitialContext ctx = null;
            ctx = new InitialContext();
            try {
                dataSource = (javax.sql.DataSource)ctx.lookup(dbDataSource);
            }
            catch (NameNotFoundException nnfe) {
                Log.info((String)nnfe.getExplanation());
                Log.info((String)"Checking Tomcat Context");
                Context tomcatCtx = (Context)ctx.lookup("java:comp/env");
                dataSource = (javax.sql.DataSource)tomcatCtx.lookup(dbDataSource);
            }
            Log.debug((String)"DataSource loaded. ");
            return dataSource;
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (e instanceof NamingException) {
                msg = ((NamingException)e).getExplanation();
            }
            Log.debug((String)msg);
            Log.info((String)(msg + " will try to use dbDriver..."));
            return this.loadDatabaseDriver(null);
        }
    }

    static {
        querySearching = "SELECT \"second\", \"minute\", \"hour\", dayofmonth, \"month\", \"dayofweek\", \"year\", task, extrainfo, businessDays FROM events WHERE task = ? ";
        queryStoring = "INSERT INTO events(\"second\", \"minute\", \"hour\", dayofmonth, \"month\", \"dayofweek\", \"year\", task, extrainfo, businessDays) VALUES(?, ?, ?, ?, ?, ?, ?, ?, ?, ?) ";
        queryRemoving = "DELETE FROM events WHERE \"second\" = ? AND \"minute\" = ? AND \"hour\" = ? AND dayofmonth = ? AND \"month\" = ? AND \"dayofweek\" = ? AND \"year\" = ? AND task = ? AND extrainfo = ? AND businessDays = ?";
        DEFAULT_TABLE = "events";
    }
}

