/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actionplans.base.ActionItemWork;
import org.aspcfs.modules.actionplans.base.ActionPhaseWork;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanList;
import org.aspcfs.modules.actionplans.base.ActionPlanWork;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.utils.FileUtils;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class AccountActionPlans
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            User user = this.getUser(context, this.getUserId(context));
            String orgId = context.getRequest().getParameter("orgId");
            if (orgId == null) {
                orgId = context.getRequest().getParameter("accountId");
            }
            boolean popup = context.getRequest().getParameter("popup") != null && "true".equals(context.getRequest().getParameter("popup"));
            Organization orgDetails = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("orgDetails", (Object)orgDetails);
            PagedListInfo planWorkListInfo = this.getPagedListInfo(context, "accountActionPlanWorkListInfo");
            planWorkListInfo.setLink("AccountActionPlans.do?command=View&orgId=" + orgId + (popup ? "&popup=true" : ""));
            if (!planWorkListInfo.hasListFilters()) {
                planWorkListInfo.addFilter(1, "myhierarchy");
                planWorkListInfo.addFilter(2, "true");
            }
            ActionPlanWorkList planWorkList = new ActionPlanWorkList();
            planWorkList.setPagedListInfo(planWorkListInfo);
            planWorkList.setSiteId(orgDetails.getSiteId());
            if (user.getSiteId() == -1) {
                planWorkList.setIncludeAllSites(true);
            }
            planWorkList.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 42420034));
            planWorkList.setLinkItemId(orgId);
            if ("my".equals(planWorkListInfo.getFilterValue("listFilter1"))) {
                planWorkList.setOwner(this.getUserId(context));
            } else if ("mymanaged".equals(planWorkListInfo.getFilterValue("listFilter1"))) {
                planWorkList.setManager(this.getUserId(context));
            } else if ("mywaiting".equals(planWorkListInfo.getFilterValue("listFilter1"))) {
                planWorkList.setOwner(this.getUserId(context));
                planWorkList.setManager(this.getUserId(context));
                planWorkList.setCurrentStepOwner(this.getUserId(context));
                planWorkList.setAllMyPlans(true);
            } else if ("myhierarchy".equals(planWorkListInfo.getFilterValue("listFilter1"))) {
                planWorkList.setOwnerRange(this.getUserRange(context));
            }
            if ("all".equals(planWorkListInfo.getFilterValue("listFilter2"))) {
                planWorkList.setEnabled(-1);
            } else if ("true".equals(planWorkListInfo.getFilterValue("listFilter2"))) {
                planWorkList.setEnabled(1);
            } else if ("false".equals(planWorkListInfo.getFilterValue("listFilter2"))) {
                planWorkList.setEnabled(0);
            }
            planWorkList.setBuildPhaseWork(true);
            planWorkList.setBuildStepWork(true);
            planWorkList.setBuildLinkedObject(true);
            planWorkList.buildList(db);
            context.getRequest().setAttribute("actionPlanWorkList", (Object)planWorkList);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return AccountActionPlans.getReturn(context, "View");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String planWorkId = context.getRequest().getParameter("actionPlanId");
            ActionPlanWork planWork = new ActionPlanWork(db, Integer.parseInt(planWorkId));
            planWork.setBuildLinkedObject(true);
            planWork.buildPhaseWork(db);
            planWork.buildLinkedObject(db);
            planWork.delete(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-add")) {
            return "PermissionError";
        }
        ActionPlanWork planWork = (ActionPlanWork)((Object)context.getFormBean());
        Connection db = null;
        try {
            db = this.getConnection(context);
            String orgId = context.getRequest().getParameter("orgId");
            if (orgId == null) {
                orgId = context.getRequest().getParameter("accountId");
            }
            Organization orgDetails = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("orgDetails", (Object)orgDetails);
            ActionPlanList actionPlanList = new ActionPlanList();
            actionPlanList.setIncludeOnlyApproved(1);
            actionPlanList.setLinkObjectId(ActionPlan.getMapIdGivenConstantId(db, 42420034));
            actionPlanList.setEnabled(1);
            actionPlanList.setSiteId(orgDetails.getSiteId());
            actionPlanList.buildList(db);
            context.getRequest().setAttribute("actionPlanList", (Object)actionPlanList);
            context.getRequest().setAttribute("actionPlanWork", (Object)planWork);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountActionPlans.getReturn(context, "Add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-add")) {
            return "PermissionError";
        }
        Connection db = null;
        Organization orgDetails = null;
        User assigned = null;
        User manager = null;
        Contact assignedContact = null;
        Contact managerContact = null;
        ActionPlanWork planWork = (ActionPlanWork)((Object)context.getFormBean());
        String actionPlanIdString = context.getRequest().getParameter("actionPlan");
        if (actionPlanIdString != null && !"".equals(actionPlanIdString.trim()) && !"null".equals(actionPlanIdString.trim())) {
            planWork.setActionPlanId(actionPlanIdString);
        }
        try {
            db = this.getConnection(context);
            String orgId = context.getRequest().getParameter("orgId");
            if (orgId == null) {
                orgId = context.getRequest().getParameter("accountId");
            }
            orgDetails = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("orgDetails", (Object)orgDetails);
            boolean isValid = this.validateObject(context, db, (Object)planWork);
            boolean recordStatus = false;
            if (isValid) {
                ActionPlan actionPlan = new ActionPlan();
                actionPlan.setBuildPhases(true);
                actionPlan.setBuildSteps(true);
                actionPlan.queryRecord(db, planWork.getActionPlanId());
                planWork.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 42420034));
                planWork.setLinkItemId(orgDetails.getOrgId());
                planWork.setEnteredBy(this.getUserId(context));
                planWork.setModifiedBy(this.getUserId(context));
                planWork.insert(db, actionPlan);
                this.processInsertHook(context, (Object)planWork);
                context.getRequest().setAttribute("actionPlanId", (Object)String.valueOf(planWork.getId()));
                assigned = this.getUser(context, planWork.getAssignedTo());
                assignedContact = new Contact(db, assigned.getContactId());
                manager = this.getUser(context, planWork.getManagerId());
                managerContact = new Contact(db, manager.getContactId());
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace(System.out);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (planWork.getId() > -1) {
            try {
                String templateFile = AccountActionPlans.getDbNamePath(context) + "templates_" + this.getUserLanguage(context) + ".xml";
                if (!FileUtils.fileExists(templateFile)) {
                    templateFile = AccountActionPlans.getDbNamePath(context) + "templates_en_US.xml";
                }
                planWork.sendEmail(context, assignedContact, managerContact, orgDetails.getName(), templateFile);
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                return "SystemError";
            }
        } else {
            return this.executeCommandAdd(context);
        }
        return this.executeCommandDetails(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String orgId = context.getRequest().getParameter("orgId");
            if (orgId == null) {
                orgId = context.getRequest().getParameter("accountId");
            }
            Organization orgDetails = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("orgDetails", (Object)orgDetails);
            String actionPlanId = context.getRequest().getParameter("actionPlanId");
            if (actionPlanId == null || "".equals(actionPlanId)) {
                actionPlanId = (String)context.getRequest().getAttribute("actionPlanId");
            }
            ActionPlanWork planWork = new ActionPlanWork();
            planWork.setBuildPhaseWork(true);
            planWork.setBuildGlobalPhases(0);
            planWork.setBuildStepWork(true);
            planWork.setBuildLinkedObject(true);
            planWork.setOrganization(orgDetails);
            planWork.queryRecord(db, Integer.parseInt(actionPlanId));
            planWork.buildStepLinks();
            context.getRequest().setAttribute("actionPlanWork", (Object)planWork);
            ActionPlanWork globalPlanWork = new ActionPlanWork();
            globalPlanWork.setBuildPhaseWork(true);
            globalPlanWork.setBuildGlobalPhases(1);
            globalPlanWork.setBuildStepWork(true);
            globalPlanWork.setOrganization(orgDetails);
            globalPlanWork.setBuildLinkedObject(true);
            globalPlanWork.queryRecord(db, Integer.parseInt(actionPlanId));
            context.getRequest().setAttribute("globalActionPlanWork", (Object)globalPlanWork);
            SystemStatus thisSystem = this.getSystemStatus(context);
            LookupList ratingLookup = thisSystem.getLookupList(db, "lookup_contact_rating");
            ratingLookup.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
            ratingLookup.setJsEvent("onChange=\"javascript:updateRating(this);\"");
            context.getRequest().setAttribute("ratingLookup", (Object)ratingLookup);
            context.getRequest().setAttribute("systemStatus", (Object)thisSystem);
            context.getRequest().setAttribute("objectName", (Object)ActionPlan.getDescriptionGivenConstantId(db, 42420034));
            context.getRequest().setAttribute("constants", (Object)ActionPlan.buildConstants(db));
            String notAttached = context.getRequest().getParameter("notAttached");
            if (notAttached != null && "true".equals(notAttached.trim())) {
                context.getRequest().setAttribute("actionWarning", (Object)thisSystem.getLabel("", "The recipient was not added to the active campaign"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountActionPlans.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyStatus(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus thisSystem = this.getSystemStatus(context);
            String itemId = context.getRequest().getParameter("itemId");
            ActionItemWork itemWork = new ActionItemWork(db, Integer.parseInt(itemId));
            itemWork.buildStep(db);
            context.getRequest().setAttribute("actionItemWork", (Object)itemWork);
            ActionItemWork nextItemWork = itemWork.getNextItem(db);
            if (nextItemWork == null) {
                nextItemWork = new ActionItemWork();
            } else {
                nextItemWork.buildStep(db);
                nextItemWork.buildLinkedObject(db);
            }
            context.getRequest().setAttribute("nextItemWork", (Object)nextItemWork);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ModifyStatusOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateStatus(ActionContext context) {
        boolean isAccountPopup;
        if (!this.hasPermission(context, "accounts-action-plans-edit")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        Connection db = null;
        boolean status = false;
        ActionItemWork itemWork = null;
        ActionPhaseWork phaseWork = null;
        ActionPhaseWork nextPhaseWork = null;
        ActionItemWork nextItem2 = null;
        ActionPlanWork planWork = null;
        ActionItemWork oldItem = null;
        Organization orgDetails = null;
        boolean sendEmailForAllNewSteps = false;
        boolean sendEmailForNextStep = false;
        try {
            db = this.getConnection(context);
            String itemId = context.getRequest().getParameter("stepId");
            String nextStepId = context.getRequest().getParameter("nextStepId");
            String statusId = context.getRequest().getParameter("statusId");
            String orgId = context.getRequest().getParameter("orgId");
            orgDetails = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("orgDetails", (Object)orgDetails);
            if (itemId != null && Integer.parseInt(itemId) > 0) {
                itemWork = new ActionItemWork();
                itemWork.setBuildStep(true);
                itemWork.queryRecord(db, Integer.parseInt(itemId));
                phaseWork = new ActionPhaseWork(db, itemWork.getPhaseWorkId());
                planWork = new ActionPlanWork(db, phaseWork.getPlanWorkId());
                planWork.setBuildLinkedObject(true);
                itemWork.setPlanWork(planWork);
                oldItem = new ActionItemWork();
                oldItem.setPlanWork(planWork);
                oldItem.queryRecord(db, itemWork.getId());
                if (statusId != null && Integer.parseInt(statusId) > 0) {
                    itemWork.setStatusId(statusId);
                    itemWork.setModifiedBy(this.getUserId(context));
                }
                if (nextStepId != null && Integer.parseInt(nextStepId) > 0) {
                    nextItem2 = new ActionItemWork();
                    nextItem2.setBuildStep(true);
                    nextItem2.queryRecord(db, Integer.parseInt(nextStepId));
                    nextItem2.setPlanWork(planWork);
                    if (nextItem2.getPhaseWorkId() != itemWork.getPhaseWorkId()) {
                        nextPhaseWork = new ActionPhaseWork(db, nextItem2.getPhaseWorkId());
                        nextPhaseWork.setPlanWork(planWork);
                        nextPhaseWork.setBuildLinkedObject(true);
                        nextPhaseWork.buildPhaseObject(db);
                        nextPhaseWork.buildStepWork(db);
                        if (nextPhaseWork != null && nextPhaseWork.getPhase().getRandom() && nextPhaseWork.noStepComplete()) {
                            sendEmailForAllNewSteps = true;
                        }
                    }
                    status = itemWork.updateStatus(db, nextItem2);
                    this.processUpdateHook(context, (Object)oldItem, (Object)itemWork);
                    if (!sendEmailForAllNewSteps && nextItem2 != null) {
                        this.processUpdateHook(context, (Object)itemWork, (Object)nextItem2);
                    }
                } else {
                    status = itemWork.updateStatus(db, null);
                    phaseWork.setBuildStepWork(true);
                    phaseWork.setBuildPhase(true);
                    phaseWork.queryRecord(db, itemWork.getPhaseWorkId());
                    this.processUpdateHook(context, (Object)oldItem, (Object)itemWork);
                    nextPhaseWork = phaseWork.getNextPhase(db);
                    if (phaseWork.getPhase().getRandom() && phaseWork.allStepsComplete() && nextPhaseWork != null) {
                        nextPhaseWork.setPlanWork(planWork);
                        nextPhaseWork.setBuildLinkedObject(true);
                        nextPhaseWork.buildStepWork(db);
                        nextPhaseWork.buildPhaseObject(db);
                        if (nextPhaseWork.getPhase().getRandom() && nextPhaseWork.noStepComplete()) {
                            sendEmailForAllNewSteps = true;
                        } else if (!nextPhaseWork.getPhase().getRandom() && nextPhaseWork.noStepComplete() && nextPhaseWork.getItemWorkList().size() > 0) {
                            nextItem2 = (ActionItemWork)((Object)nextPhaseWork.getItemWorkList().get(0));
                            nextItem2.setPlanWork(planWork);
                            nextItem2.buildStep(db);
                            nextItem2.buildLinkedObject(db);
                            this.processUpdateHook(context, (Object)itemWork, (Object)nextItem2);
                        }
                    }
                }
            }
            if (sendEmailForAllNewSteps && nextPhaseWork != null && nextPhaseWork.getItemWorkList() != null) {
                for (ActionItemWork nextItem2 : nextPhaseWork.getItemWorkList()) {
                    nextItem2.setPlanWork(planWork);
                    nextItem2 = new ActionItemWork(db, nextItem2.getId());
                    nextItem2.buildStep(db);
                    nextItem2.buildLinkedObject(db);
                    this.processUpdateHook(context, (Object)itemWork, (Object)nextItem2);
                }
            }
            String returnUrl = context.getRequest().getParameter("returnUrl");
            context.getRequest().setAttribute("refreshUrl", (Object)returnUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean bl = isAccountPopup = context.getRequest().getParameter("popupType") != null && "inline".equals(context.getRequest().getParameter("popupType"));
        if ("true".equals(context.getRequest().getParameter("popup")) && !isAccountPopup) {
            return "UpdateStatusOK";
        }
        return this.executeCommandDetails(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateRating(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-edit")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String planId = context.getRequest().getParameter("planId");
            String rating = context.getRequest().getParameter("rating");
            ActionPlanWork planWork = new ActionPlanWork();
            planWork.setBuildLinkedObject(true);
            planWork.queryRecord(db, Integer.parseInt(planId));
            planWork.updateRating(db, Integer.parseInt(rating));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    public String executeCommandAttach(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-edit")) {
            return "PermissionError";
        }
        return "AttachOK";
    }

    public String executeCommandResetFolderAttachment(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-delete")) {
            return "PermissionError";
        }
        return "ResetFolderAttachmentOK";
    }

    public String executeCommandViewNotes(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-edit")) {
            return "PermissionError";
        }
        return "ViewNotesOK";
    }

    public String executeCommandReassign(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-edit")) {
            return "PermissionError";
        }
        return "ReassignOK";
    }

    public String executeCommandRestart(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-edit")) {
            return "PermissionError";
        }
        return "RestartOK";
    }

    public String executeCommandEnable(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-edit")) {
            return "PermissionError";
        }
        return "EnableOK";
    }

    public String executeCommandRevertStatus(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-edit")) {
            return "PermissionError";
        }
        return "RevertStatusOK";
    }

    public String executeCommandUpdateGlobalStatus(ActionContext context) {
        if (!this.hasPermission(context, "accounts-action-plans-edit")) {
            return "PermissionError";
        }
        return "UpdateGlobalStatusOK";
    }

    public String executeCommandConfirmRevert(ActionContext context) {
        return "GoConfirmRevertOK";
    }

    public String executeCommandRevertToLead(ActionContext context) {
        return "GoRevertToLeadOK";
    }
}

