/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.modules.contacts.base.ContactHistoryList;
import org.aspcfs.utils.web.PagedListInfo;

public final class AccountContactsHistory
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-history-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ContactsHistory", "View History");
        String source = context.getRequest().getParameter("source");
        Contact newContact = null;
        String contactId = context.getRequest().getParameter("contactId");
        if (contactId == null) {
            contactId = (String)context.getRequest().getAttribute("contactId");
        }
        String isPopup = context.getRequest().getParameter("popup");
        PagedListInfo accountContactHistoryListInfo = this.getPagedListInfo(context, "accountContactHistoryListInfo");
        accountContactHistoryListInfo.setLink("AccountContactsHistory.do?command=View&contactId=" + contactId + (isPopup != null && "true".equals(isPopup) ? "&popup=true" : ""));
        ContactHistoryList historyList = new ContactHistoryList();
        historyList.setPagedListInfo(accountContactHistoryListInfo);
        accountContactHistoryListInfo.setSearchCriteria(historyList, context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            newContact = new Contact(db, Integer.parseInt(contactId));
            if (!AccountContactsHistory.isRecordAccessPermitted(context, db, newContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)newContact);
            historyList.setContactId(newContact.getId());
            if (accountContactHistoryListInfo.getSavedCriteria().size() == 0) {
                this.setDefaultFilters(context, historyList);
            }
            historyList.buildList(db);
            context.getRequest().setAttribute("historyList", (Object)historyList);
            Organization orgDetails = new Organization(db, newContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountContactsHistory.getReturn(context, "List");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddNote(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-history-add")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ContactsHistory", "View History");
        String source = context.getRequest().getParameter("source");
        Contact newContact = null;
        ContactHistory history = null;
        String contactId = context.getRequest().getParameter("contactId");
        if (contactId == null) {
            contactId = (String)context.getRequest().getAttribute("contactId");
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            newContact = new Contact(db, Integer.parseInt(contactId));
            if (!AccountContactsHistory.isRecordAccessPermitted(context, db, newContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)newContact);
            history = new ContactHistory();
            context.getRequest().setAttribute("contactHistory", (Object)history);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddNoteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveNote(ActionContext context) {
        this.addModuleBean(context, "ContactsHistory", "View History");
        String source = context.getRequest().getParameter("source");
        Contact newContact = null;
        String contactId = context.getRequest().getParameter("contactId");
        ContactHistory contactHistory = (ContactHistory)((Object)context.getFormBean());
        if (contactHistory.getId() != -1 ? !this.hasPermission(context, "accounts-accounts-contacts-history-edit") : !this.hasPermission(context, "accounts-accounts-contacts-history-add")) {
            return "PermissionError";
        }
        if (contactId == null) {
            contactId = (String)context.getRequest().getAttribute("contactId");
        }
        boolean isValid = false;
        boolean recordInserted = false;
        int resultCount = -1;
        Connection db = null;
        try {
            db = this.getConnection(context);
            newContact = new Contact(db, Integer.parseInt(contactId));
            if (!AccountContactsHistory.isRecordAccessPermitted(context, db, newContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            contactHistory.setEnteredBy(this.getUserId(context));
            contactHistory.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)contactHistory);
            if (isValid) {
                if (contactHistory.getId() != -1) {
                    resultCount = contactHistory.update(db);
                } else {
                    recordInserted = contactHistory.insert(db);
                }
            }
            if (!recordInserted && resultCount == -1) {
                context.getRequest().setAttribute("ContactDetails", (Object)newContact);
                context.getRequest().setAttribute("contactHistory", (Object)contactHistory);
                String string = "AddNoteOK";
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SaveNoteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyNote(ActionContext context) {
        String id;
        if (!this.hasPermission(context, "accounts-accounts-contacts-history-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ContactsHistory", "View History");
        String source = context.getRequest().getParameter("source");
        Contact newContact = null;
        ContactHistory contactHistory = null;
        String contactId = context.getRequest().getParameter("contactId");
        if (contactId == null) {
            contactId = (String)context.getRequest().getAttribute("contactId");
        }
        if ((id = context.getRequest().getParameter("id")) == null) {
            id = (String)context.getRequest().getAttribute("id");
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            newContact = new Contact(db, Integer.parseInt(contactId));
            if (!AccountContactsHistory.isRecordAccessPermitted(context, db, newContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)newContact);
            contactHistory = new ContactHistory(db, Integer.parseInt(id));
            context.getRequest().setAttribute("contactHistory", (Object)contactHistory);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddNoteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteNote(ActionContext context) {
        String id;
        if (!this.hasPermission(context, "accounts-accounts-contacts-history-delete")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "ContactsHistory", "View History");
        String source = context.getRequest().getParameter("source");
        Contact newContact = null;
        ContactHistory contactHistory = null;
        String contactId = context.getRequest().getParameter("contactId");
        if (contactId == null) {
            contactId = (String)context.getRequest().getAttribute("contactId");
        }
        if ((id = context.getRequest().getParameter("id")) == null) {
            id = (String)context.getRequest().getAttribute("id");
        }
        Connection db = null;
        boolean result = false;
        try {
            db = this.getConnection(context);
            newContact = new Contact(db, Integer.parseInt(contactId));
            if (!AccountContactsHistory.isRecordAccessPermitted(context, db, newContact.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("ContactDetails", (Object)newContact);
            contactHistory = new ContactHistory(db, Integer.parseInt(id));
            result = contactHistory.delete(db);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandView(context);
    }

    private void setDefaultFilters(ActionContext context, ContactHistoryList list) {
        if (this.hasPermission(context, "accounts-accounts-contacts-view")) {
            list.setNotes(true);
        }
        if (this.hasPermission(context, "accounts-accounts-contacts-calls-edit") || this.hasPermission(context, "accounts-accounts-contacts-calls-view")) {
            list.setActivities(true);
        }
        if (this.hasPermission(context, "myhomepage-inbox-view") || this.hasPermission(context, "accounts-accounts-contacts-messages-view")) {
            list.setEmail(true);
        }
        if (this.hasPermission(context, "accounts-quotes-view") || this.hasPermission(context, "accounts-quotes-edit")) {
            list.setQuotes(true);
        }
        if (this.hasPermission(context, "accounts-accounts-contacts-opportunities-view") || this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit")) {
            list.setOpportunities(true);
        }
        if (this.hasPermission(context, "accounts-service-contracts-view") || this.hasPermission(context, "accounts-service-contracts-edit")) {
            list.setServiceContracts(true);
        }
        if (this.hasPermission(context, "accounts-accounts-tickets-edit") || this.hasPermission(context, "accounts-accounts-tickets-view")) {
            list.setTickets(true);
        }
        if (this.hasPermission(context, "myhomepage-tasks-view") || this.hasPermission(context, "myhomepage-tasks-edit")) {
            list.setTasks(true);
        }
        if (this.hasPermission(context, "accounts-assets-edit") || this.hasPermission(context, "accounts-assets-view")) {
            list.setAssets(true);
        }
    }
}

