/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldCategoryList;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponentList;
import org.aspcfs.modules.pipeline.base.OpportunityComponentLog;
import org.aspcfs.modules.pipeline.base.OpportunityComponentLogList;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.pipeline.base.OpportunityHeaderList;
import org.aspcfs.modules.pipeline.beans.OpportunityBean;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class AccountContactsOpps
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewOpps(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-view")) {
            return "PermissionError";
        }
        String contactId = context.getRequest().getParameter("contactId");
        this.addModuleBean(context, "View Accounts", "View Opportunities");
        PagedListInfo oppPagedListInfo = this.getPagedListInfo(context, "AccountContactOppsPagedListInfo");
        oppPagedListInfo.setLink("AccountContactsOpps.do?command=ViewOpps&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId"));
        Connection db = null;
        OpportunityHeaderList oppList = new OpportunityHeaderList();
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            thisContact = this.addFormElements(context, db);
            AccessTypeList accessTypeList = null;
            accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            oppList.setPagedListInfo(oppPagedListInfo);
            oppList.setAllowMultipleComponents(this.allowMultiple(context));
            oppList.setContactId(contactId);
            oppList.setBuildTotalValues(true);
            if (oppPagedListInfo.getListView() == null || "".equals(oppPagedListInfo.getListView())) {
                oppPagedListInfo.setListView("all");
            }
            if ("my".equals(oppPagedListInfo.getListView())) {
                oppList.setControlledHierarchyOnly(-1);
                oppList.setOwner(this.getUserId(context));
                oppList.setQueryOpenOnly(true);
            } else if ("closed".equals(oppPagedListInfo.getListView())) {
                oppList.setControlledHierarchy(0, this.getUserRange(context));
                oppList.setAccessType(accessTypeList.getCode(626030334));
                oppList.setQueryClosedOnly(true);
            } else {
                oppList.setControlledHierarchy(0, this.getUserRange(context));
                oppList.setAccessType(accessTypeList.getCode(626030334));
                oppList.setQueryOpenOnly(true);
            }
            if (thisContact.isTrashed()) {
                oppList.setIncludeOnlyTrashed(true);
            }
            oppList.buildList(db);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("OpportunityHeaderList", (Object)oppList);
        return AccountContactsOpps.getReturn(context, "ListOpps");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrepare(ActionContext context) {
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        String id = context.getRequest().getParameter("headerId");
        if (id == null || "".equals(id)) {
            id = (String)context.getRequest().getAttribute("headerId");
        }
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        User thisRec = thisUser.getUserRecord();
        UserList shortChildList = thisRec.getShortChildList();
        UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
        userList.setMyId(this.getUserId(context));
        userList.setMyValue(thisUser.getContact().getNameLastFirst());
        userList.setIncludeMe(true);
        userList.setExcludeDisabledIfUnselected(true);
        userList.setExcludeExpiredIfUnselected(true);
        context.getRequest().setAttribute("UserList", (Object)userList);
        SystemStatus systemStatus = this.getSystemStatus(context);
        if (id != null && !"-1".equals(id) && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-add")) {
            return "PermissionError";
        }
        try {
            db = this.getConnection(context);
            if (id != null && !"-1".equals(id)) {
                OpportunityHeader oppHeader = new OpportunityHeader(db, Integer.parseInt(id));
                context.getRequest().setAttribute("opportunityHeader", (Object)oppHeader);
            }
            this.addFormElements(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "PrepareOppOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-add")) {
            return "PermissionError";
        }
        boolean recordInserted = false;
        boolean isValid = false;
        OpportunityBean newOpp = (OpportunityBean)((Object)context.getRequest().getAttribute("OppDetails"));
        String contactId = context.getRequest().getParameter("contactId");
        SystemStatus systemStatus = this.getSystemStatus(context);
        if (!systemStatus.hasField("opportunity.componentTypes")) {
            newOpp.getComponent().setTypeList(context.getRequest().getParameterValues("selectedList"));
        }
        newOpp.getComponent().setEnteredBy(this.getUserId(context));
        newOpp.getComponent().setModifiedBy(this.getUserId(context));
        newOpp.getHeader().setEnteredBy(this.getUserId(context));
        newOpp.getHeader().setModifiedBy(this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            isValid = this.validateObject(context, db, (Object)newOpp);
            isValid = this.validateObject(context, db, (Object)newOpp.getHeader()) && isValid;
            boolean bl = isValid = this.validateObject(context, db, (Object)newOpp.getComponent()) && isValid;
            if (isValid) {
                recordInserted = newOpp.insert(db, context);
            }
            if (recordInserted) {
                OpportunityHeader header = newOpp.getHeader();
                OpportunityComponent component = newOpp.getComponent();
                component.setContactId(header.getContactLink());
                component.setOrgId(header.getAccountLink());
                this.processInsertHook(context, (Object)component);
            } else {
                LookupList typeSelect = new LookupList(db, "lookup_opportunity_types");
                context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
                context.getRequest().setAttribute("TypeList", (Object)newOpp.getComponent().getTypeList());
                if (context.getRequest().getParameter("addQuote") != null && "true".equals(context.getRequest().getParameter("addQuote"))) {
                    context.getRequest().setAttribute("addQuote", (Object)"true");
                }
            }
            context.getRequest().setAttribute("ComponentDetails", (Object)newOpp.getComponent());
            context.getRequest().setAttribute("OpportunityHeader", (Object)newOpp.getHeader());
            this.addFormElements(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            this.addRecentItem(context, (Object)newOpp.getHeader());
            context.getRequest().setAttribute("headerId", (Object)String.valueOf(newOpp.getHeader().getId()));
            context.getRequest().setAttribute("OpportunityDetails", (Object)newOpp);
            if ("true".equals(context.getRequest().getParameter("addQuote"))) {
                context.getRequest().setAttribute("contactId", (Object)contactId);
                return "AddQuoteOK";
            }
            return this.executeCommandDetailsOpp(context);
        }
        return this.executeCommandPrepare(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateOpp(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = 0;
        boolean isValid = false;
        String headerId = context.getRequest().getParameter("headerId");
        try {
            db = this.getConnection(context);
            OpportunityHeader oldHeader = new OpportunityHeader(db, Integer.parseInt(headerId));
            OpportunityHeader oppHeader = new OpportunityHeader(db, Integer.parseInt(headerId));
            if (!this.hasAuthority(context, oppHeader.getManager())) {
                String string = "PermissionError";
                return string;
            }
            oppHeader.setModifiedBy(this.getUserId(context));
            oppHeader.setDescription(context.getRequest().getParameter("description"));
            isValid = this.validateObject(context, db, (Object)oppHeader);
            if (isValid) {
                resultCount = oppHeader.update(db);
            }
            if (resultCount == 1) {
                this.processUpdateHook(context, (Object)oldHeader, (Object)oppHeader);
            }
            this.addFormElements(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandViewOpps(context);
            }
            return this.executeCommandDetailsOpp(context);
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandModifyOpp(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveComponent(ActionContext context) {
        boolean recordInserted = false;
        int resultCount = 0;
        boolean isValid = false;
        String permission = "accounts-accounts-contacts-opportunities-add";
        OpportunityBean bean = new OpportunityBean();
        OpportunityHeader header = null;
        OpportunityComponent oldComponent = null;
        OpportunityComponent newComponent = (OpportunityComponent)((Object)context.getFormBean());
        SystemStatus systemStatus = this.getSystemStatus(context);
        if (!systemStatus.hasField("opportunity.componentTypes")) {
            newComponent.setTypeList(context.getRequest().getParameterValues("selectedList"));
        }
        newComponent.setEnteredBy(this.getUserId(context));
        newComponent.setModifiedBy(this.getUserId(context));
        String action = newComponent.getId() > 0 ? "modify" : "insert";
        String contactId = context.getRequest().getParameter("contactId");
        if ("modify".equals(action)) {
            permission = "accounts-accounts-contacts-opportunities-edit";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            header = new OpportunityHeader(db, newComponent.getHeaderId());
            newComponent.setContactId(header.getContactLink());
            newComponent.setOrgId(header.getAccountLink());
            bean.setHeader(header);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            Contact thisContact = this.addFormElements(context, db);
            if (newComponent.getId() > 0) {
                newComponent.setModifiedBy(this.getUserId(context));
                if (!this.hasAuthority(db, context, (Object)thisContact)) {
                    String string = "PermissionError";
                    return string;
                }
                if (!this.hasAuthority(context, newComponent.getOwner()) && !this.hasAuthority(context, header.getManager())) {
                    String string = "PermissionError";
                    return string;
                }
                bean.setComponent(newComponent);
                isValid = this.validateObject(context, db, (Object)bean);
                boolean bl = isValid = this.validateObject(context, db, (Object)newComponent) && isValid;
                if (isValid) {
                    oldComponent = new OpportunityComponent(db, newComponent.getId());
                    resultCount = newComponent.update(db, context);
                }
                if (resultCount == 1) {
                    this.processUpdateHook(context, (Object)oldComponent, (Object)newComponent);
                }
            } else {
                if (!this.hasAuthority(db, context, (Object)thisContact)) {
                    String string = "PermissionError";
                    return string;
                }
                if (!this.hasAuthority(context, header.getManager())) {
                    String string = "PermissionError";
                    return string;
                }
                bean.setComponent(newComponent);
                isValid = this.validateObject(context, db, (Object)bean);
                boolean bl = isValid = this.validateObject(context, db, (Object)newComponent) && isValid;
                if (isValid) {
                    recordInserted = newComponent.insert(db, context);
                }
            }
            if (recordInserted) {
                this.processInsertHook(context, (Object)newComponent);
                this.addRecentItem(context, (Object)newComponent);
            } else if (resultCount == 1) {
                newComponent.queryRecord(db, newComponent.getId());
            } else {
                LookupList typeSelect = new LookupList(db, "lookup_opportunity_types");
                context.getRequest().setAttribute("TypeSelect", (Object)typeSelect);
                context.getRequest().setAttribute("TypeList", (Object)newComponent.getTypeList());
                if ("modify".equals(action) && resultCount == -1) {
                    UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
                    User thisRec = thisUser.getUserRecord();
                    UserList shortChildList = thisRec.getShortChildList();
                    UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
                    userList.setMyId(this.getUserId(context));
                    userList.setMyValue(thisUser.getContact().getNameLastFirst());
                    userList.setIncludeMe(true);
                    userList.setExcludeDisabledIfUnselected(true);
                    userList.setExcludeExpiredIfUnselected(true);
                    context.getRequest().setAttribute("UserList", (Object)userList);
                }
            }
            context.getRequest().setAttribute("ComponentDetails", (Object)newComponent);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if ("insert".equals(action)) {
            if (recordInserted) {
                return this.executeCommandDetailsOpp(context);
            }
            return this.executeCommandPrepare(context);
        }
        if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandDetailsOpp(context);
            }
            return this.executeCommandDetailsComponent(context);
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandPrepare(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetailsOpp(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-view")) {
            return "PermissionError";
        }
        int headerId = -1;
        this.addModuleBean(context, "View Accounts", "Opportunities");
        headerId = context.getRequest().getParameter("headerId") != null ? Integer.parseInt(context.getRequest().getParameter("headerId")) : Integer.parseInt((String)context.getRequest().getAttribute("headerId"));
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        OpportunityHeader thisHeader = null;
        OpportunityComponentList componentList = null;
        boolean popup = context.getRequest().getParameter("popup") != null && "true".equals(context.getRequest().getParameter("popup"));
        PagedListInfo oppPagedListInfo = this.getPagedListInfo(context, "AccountContactOppsPagedListInfo", false);
        PagedListInfo componentListInfo = this.getPagedListInfo(context, "AccountContactComponentListInfo");
        componentListInfo.setLink("AccountContactsOpps.do?command=DetailsOpp&headerId=" + headerId + "&contactId=" + contactId + (popup ? "&popup=true" : ""));
        try {
            db = this.getConnection(context);
            Contact thisContact = this.addFormElements(context, db);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, headerId);
            context.getRequest().setAttribute("OpportunityHeader", (Object)thisHeader);
            componentList = new OpportunityComponentList();
            componentList.setPagedListInfo(componentListInfo);
            if ("my".equals(oppPagedListInfo.getListView())) {
                componentList.setControlledHierarchyOnly(-1);
                componentList.setOwner(this.getUserId(context));
                componentList.setQueryOpenOnly(true);
            } else {
                componentList.setControlledHierarchy(0, this.getUserRange(context));
            }
            componentList.setAccessType(thisHeader.getAccessType());
            if (!(this.excludeHierarchy(context) || this.hasAuthority(context, thisHeader.getManager()) || OpportunityHeader.isComponentOwner(db, headerId, this.getUserId(context)))) {
                String string = "PermissionError";
                return string;
            }
            componentList.setHeaderId(thisHeader.getId());
            if (thisHeader.isTrashed()) {
                componentList.setIncludeOnlyTrashed(true);
            }
            componentList.buildList(db);
            context.getRequest().setAttribute("ComponentList", (Object)componentList);
            thisHeader.setAccountLink(thisContact.getOrgId());
            if (!this.allowMultiple(context) && componentList.size() > 0) {
                OpportunityComponent thisComponent = (OpportunityComponent)((Object)componentList.get(0));
                context.getRequest().setAttribute("OppComponentDetails", (Object)thisComponent);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addRecentItem(context, (Object)thisHeader);
        if (!this.allowMultiple(context) && componentList.size() > 0) {
            return AccountContactsOpps.getReturn(context, "DetailsComponent");
        }
        return AccountContactsOpps.getReturn(context, "DetailsOpp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyOpp(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Opportunities");
        int headerId = Integer.parseInt(context.getRequest().getParameter("headerId"));
        Connection db = null;
        OpportunityHeader thisHeader = null;
        try {
            db = this.getConnection(context);
            Contact thisContact = this.addFormElements(context, db);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, headerId);
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(context, thisHeader.getManager())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("OpportunityHeader", (Object)thisHeader);
            this.addRecentItem(context, (Object)thisHeader);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountContactsOpps.getReturn(context, "ModifyOpp");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetailsComponent(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-view")) {
            return "PermissionError";
        }
        OpportunityComponent thisComponent = null;
        OpportunityHeader header = null;
        Contact thisContact = null;
        Connection db = null;
        this.addModuleBean(context, "View Accounts", "Opportunities");
        String componentId = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisContact = this.addFormElements(context, db);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            thisComponent = new OpportunityComponent(db, Integer.parseInt(componentId));
            header = new OpportunityHeader(db, thisComponent.getHeaderId());
            if (!this.excludeHierarchy(context) && !this.hasAuthority(context, thisComponent.getOwner()) && accessTypeList.getCode(626030334) != header.getAccessType()) {
                String string = "PermissionError";
                return string;
            }
            thisComponent.checkEnabledOwnerAccount(db);
            context.getRequest().setAttribute("OppComponentDetails", (Object)thisComponent);
            context.getRequest().setAttribute("OpportunityHeader", (Object)header);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (this.allowMultiple(context)) {
            this.addRecentItem(context, (Object)thisComponent);
        } else {
            this.addRecentItem(context, (Object)header);
        }
        return AccountContactsOpps.getReturn(context, "DetailsComponent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-delete")) {
            return "PermissionError";
        }
        HtmlDialog htmlDialog = new HtmlDialog();
        String headerId = context.getRequest().getParameter("headerId");
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            Contact thisContact = this.addFormElements(context, db);
            OpportunityHeader thisOpp = new OpportunityHeader(db, headerId);
            if (!this.hasAuthority(context, thisOpp.getManager())) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = thisOpp.processDependencies(db, this.allowMultiple(context));
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='AccountContactsOpps.do?command=TrashOpp&contactId=" + contactId + "&id=" + headerId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmComponentDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-delete")) {
            return "PermissionError";
        }
        OpportunityComponent thisComponent = null;
        OpportunityHeader header = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            Contact thisContact = this.addFormElements(context, db);
            thisComponent = new OpportunityComponent(db, id);
            header = new OpportunityHeader(db, thisComponent.getHeaderId());
            if (!this.hasAuthority(context, thisComponent.getOwner()) && !this.hasAuthority(context, header.getManager())) {
                String string = "PermissionError";
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.contact.opps.delete"));
            htmlDialog.setShowAndConfirm(false);
            htmlDialog.setDeleteUrl("javascript:window.location.href='AccountContactsOppComponents.do?command=DeleteComponent&contactId=" + contactId + "&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteOpp(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        String contactId = context.getRequest().getParameter("contactId");
        OpportunityHeader newOpp = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            Contact thisContact = this.addFormElements(context, db);
            newOpp = new OpportunityHeader(db, context.getRequest().getParameter("id"));
            if (!this.hasAuthority(context, newOpp.getManager())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = newOpp.delete(db, context, AccountContactsOpps.getDbNamePath(context));
            if (recordDeleted) {
                this.invalidateUserData(context, this.getUserId(context));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean inLinePopup = "inline".equals(context.getRequest().getParameter("popupType"));
        if (recordDeleted) {
            context.getRequest().setAttribute("contactId", (Object)contactId);
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountContactsOpps.do?command=ViewOpps&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popupType|actionId" + (inLinePopup ? "|popup" : ""))));
            this.deleteRecentItem(context, (Object)newOpp);
            return "OppDeleteOK";
        }
        this.processErrors(context, newOpp.getErrors());
        return this.executeCommandViewOpps(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteComponent(ActionContext context) {
        Object thisContact;
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        OpportunityComponent component = null;
        OpportunityHeader header = null;
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisContact = this.addFormElements(context, db);
            component = new OpportunityComponent(db, context.getRequest().getParameter("id"));
            header = new OpportunityHeader(db, component.getHeaderId());
            if (!this.hasAuthority(context, component.getOwner()) && !this.hasAuthority(context, header.getManager())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = component.delete(db, context);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            thisContact = "SystemError";
            return thisContact;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean isPopup = context.getRequest().getParameter("sourcepopup") != null && "true".equals(context.getRequest().getParameter("sourcepopup"));
        boolean inLinePopup = "inline".equals(context.getRequest().getParameter("popupType"));
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountContactsOpps.do?command=DetailsOpp&headerId=" + component.getHeaderId() + "&contactId=" + contactId + (isPopup ? "&popup=true" : "") + RequestUtils.addLinkParams(context.getRequest(), "popupType|actionId" + (inLinePopup ? "|popup" : ""))));
            this.deleteRecentItem(context, (Object)component);
            return "ComponentDeleteOK";
        }
        this.processErrors(context, component.getErrors());
        return this.executeCommandViewOpps(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrashOpp(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-delete")) {
            return "PermissionError";
        }
        boolean recordUpdated = false;
        String contactId = context.getRequest().getParameter("contactId");
        OpportunityHeader newOpp = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            Contact thisContact = this.addFormElements(context, db);
            newOpp = new OpportunityHeader(db, context.getRequest().getParameter("id"));
            recordUpdated = newOpp.updateStatus(db, context, true, this.getUserId(context));
            if (!this.hasAuthority(db, context, (Object)thisContact)) {
                String string = "PermissionError";
                return string;
            }
            if (!this.hasAuthority(context, newOpp.getManager())) {
                String string = "PermissionError";
                return string;
            }
            newOpp.invalidateUserData(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean inLinePopup = "inline".equals(context.getRequest().getParameter("popupType"));
        if (recordUpdated) {
            context.getRequest().setAttribute("contactId", (Object)contactId);
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountContactsOpps.do?command=ViewOpps&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popupType|actionId" + (inLinePopup ? "|popup" : ""))));
            this.deleteRecentItem(context, (Object)newOpp);
            return "OppDeleteOK";
        }
        this.processErrors(context, newOpp.getErrors());
        return this.executeCommandViewOpps(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyComponent(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        OpportunityComponent component = null;
        OpportunityHeader header = null;
        this.addModuleBean(context, "View Accounts", "Opportunities");
        String componentId = context.getRequest().getParameter("id");
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        User thisRec = thisUser.getUserRecord();
        UserList shortChildList = thisRec.getShortChildList();
        UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
        userList.setMyId(this.getUserId(context));
        userList.setMyValue(thisUser.getContact().getNameLastFirst());
        userList.setIncludeMe(true);
        userList.setExcludeDisabledIfUnselected(true);
        userList.setExcludeExpiredIfUnselected(true);
        context.getRequest().setAttribute("UserList", (Object)userList);
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
            context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
            LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
            context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
            LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
            context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
            LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
            context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
            AccessTypeList accessTypeList = systemStatus.getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            component = new OpportunityComponent(db, componentId);
            context.getRequest().setAttribute("headerId", (Object)String.valueOf(component.getHeaderId()));
            header = new OpportunityHeader(db, component.getHeaderId());
            Contact thisContact = this.addFormElements(context, db);
            if (!this.hasAuthority(context, component.getOwner()) && !this.hasAuthority(context, header.getManager())) {
                String string = "PermissionError";
                return string;
            }
            header.setAccountLink(thisContact.getOrgId());
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("ComponentDetails", (Object)component);
        if (this.allowMultiple(context)) {
            this.addRecentItem(context, (Object)component);
        } else {
            this.addRecentItem(context, (Object)header);
        }
        return this.executeCommandPrepare(context);
    }

    public Contact addFormElements(ActionContext context, Connection db) throws SQLException {
        String contactId = context.getRequest().getParameter("contactId");
        Contact thisContact = (Contact)((Object)context.getRequest().getAttribute("ContactDetails"));
        Organization thisOrganization = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList environmentSelect = systemStatus.getLookupList(db, "lookup_opportunity_environment");
        context.getRequest().setAttribute("environmentSelect", (Object)environmentSelect);
        LookupList competitorsSelect = systemStatus.getLookupList(db, "lookup_opportunity_competitors");
        context.getRequest().setAttribute("competitorsSelect", (Object)competitorsSelect);
        LookupList compellingEventSelect = systemStatus.getLookupList(db, "lookup_opportunity_event_compelling");
        context.getRequest().setAttribute("compellingEventSelect", (Object)compellingEventSelect);
        LookupList budgetSelect = systemStatus.getLookupList(db, "lookup_opportunity_budget");
        context.getRequest().setAttribute("budgetSelect", (Object)budgetSelect);
        LookupList siteList = new LookupList(db, "lookup_site_id");
        siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SiteIdList", (Object)siteList);
        AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
        context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
        if (thisContact == null) {
            thisContact = new Contact(db, contactId);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
        }
        if (thisContact.getOrgId() > -1) {
            thisOrganization = new Organization(db, thisContact.getOrgId());
        }
        context.getRequest().setAttribute("OrgDetails", thisOrganization);
        context.getRequest().setAttribute("orgId", (Object)String.valueOf(thisOrganization.getId()));
        return thisContact;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddFolderRecord(ActionContext context) {
        OpportunityHeader thisHeader;
        Organization thisOrganization;
        Contact thisContact;
        Connection db;
        block7: {
            block6: {
                db = null;
                thisContact = null;
                thisOrganization = null;
                SystemStatus systemStatus = this.getSystemStatus(context);
                context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
                String headerId = context.getRequest().getParameter("headerId");
                db = this.getConnection(context);
                thisHeader = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("OpportunityHeader", (Object)thisHeader);
                thisContact = new Contact(db, thisHeader.getContactLink());
                if (this.hasPermission(context, "accounts-accounts-contacts-opps-folders-add") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit"))) break block6;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (this.hasAuthority(context, thisHeader.getEnteredBy())) break block7;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            String selectedCatId = context.getRequest().getParameter("catId");
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(120200514);
            thisCategory.setLinkItemId(thisHeader.getId());
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            context.getRequest().setAttribute("Category", (Object)thisCategory);
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "Opportunities", "Add Folder Record");
        return AccountContactsOpps.getReturn(context, "AddFolderRecord");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandFolderList(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opps-folders-view")) {
            return "PermissionError";
        }
        Connection db = null;
        Contact thisContact = null;
        Organization thisOrganization = null;
        OpportunityHeader thisHeader = null;
        try {
            db = this.getConnection(context);
            String contactId = context.getRequest().getParameter("contactId");
            thisContact = new Contact(db, Integer.parseInt(contactId));
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            String headerId = context.getRequest().getParameter("headerId");
            thisHeader = new OpportunityHeader(db, Integer.parseInt(headerId));
            context.getRequest().setAttribute("OpportunityHeader", (Object)thisHeader);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(120200514);
            thisList.setLinkItemId(thisHeader.getId());
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.setBuildTotalNumOfRecords(true);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Contacts", "Custom Fields Details");
        return AccountContactsOpps.getReturn(context, "FolderList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandFields(ActionContext context) {
        OpportunityHeader thisHeader;
        String headerId;
        Organization thisOrganization;
        String selectedCatId;
        boolean showRecords;
        String recordId;
        Contact thisContact;
        Connection db;
        block18: {
            block17: {
                db = null;
                thisContact = null;
                recordId = null;
                showRecords = true;
                selectedCatId = null;
                thisOrganization = null;
                headerId = context.getRequest().getParameter("headerId");
                db = this.getConnection(context);
                thisHeader = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("OpportunityHeader", (Object)thisHeader);
                thisContact = new Contact(db, thisHeader.getContactLink());
                if (this.hasPermission(context, "accounts-accounts-contacts-opps-folders-view") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-opportunities-view"))) break block17;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (this.hasAuthority(context, thisHeader.getEnteredBy())) break block18;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(120200514);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            selectedCatId = context.getRequest().getParameter("catId");
            if (selectedCatId == null) {
                selectedCatId = (String)context.getRequest().getAttribute("catId");
            }
            if (selectedCatId == null) {
                selectedCatId = String.valueOf(thisList.getDefaultCategoryId());
            }
            context.getRequest().setAttribute("catId", (Object)selectedCatId);
            if (Integer.parseInt(selectedCatId) > 0) {
                recordId = context.getRequest().getParameter("recId");
                String recordDeleted = (String)context.getRequest().getAttribute("recordDeleted");
                if (recordDeleted != null) {
                    recordId = null;
                }
                CustomFieldCategory thisCategory = thisList.getCategory(Integer.parseInt(selectedCatId));
                if (recordId == null && thisCategory.getAllowMultipleRecords()) {
                    PagedListInfo folderListInfo = this.getPagedListInfo(context, "ContactFolderInfo");
                    folderListInfo.setLink("AccountContactsOpps.do?command=Fields&headerId=" + headerId + "&catId=" + selectedCatId);
                    CustomFieldRecordList recordList = new CustomFieldRecordList();
                    recordList.setLinkModuleId(120200514);
                    recordList.setLinkItemId(thisHeader.getId());
                    recordList.setCategoryId(thisCategory.getId());
                    recordList.buildList(db);
                    recordList.buildRecordColumns(db, thisCategory);
                    context.getRequest().setAttribute("Records", (Object)recordList);
                } else {
                    thisCategory.setLinkModuleId(120200514);
                    thisCategory.setLinkItemId(thisHeader.getId());
                    if (recordId != null) {
                        thisCategory.setRecordId(Integer.parseInt(recordId));
                    } else {
                        thisCategory.buildRecordId(db);
                        recordId = String.valueOf(thisCategory.getRecordId());
                    }
                    thisCategory.setIncludeEnabled(1);
                    thisCategory.setIncludeScheduled(1);
                    thisCategory.setBuildResources(true);
                    thisCategory.buildResources(db);
                    showRecords = false;
                    if (thisCategory.getRecordId() > -1) {
                        CustomFieldRecord thisRecord = new CustomFieldRecord(db, thisCategory.getRecordId());
                        context.getRequest().setAttribute("Record", (Object)thisRecord);
                    }
                }
                context.getRequest().setAttribute("Category", (Object)thisCategory);
            }
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "Opportunities", "Custom Fields Details");
        if (Integer.parseInt(selectedCatId) <= 0) {
            return AccountContactsOpps.getReturn(context, "FieldsEmpty");
        }
        if (recordId == null && showRecords) {
            return AccountContactsOpps.getReturn(context, "FieldRecordList");
        }
        return AccountContactsOpps.getReturn(context, "Fields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyFields(ActionContext context) {
        OpportunityHeader thisHeader;
        String recordId;
        String selectedCatId;
        Organization thisOrganization;
        Contact thisContact;
        Connection db;
        block8: {
            block7: {
                db = null;
                thisContact = null;
                thisOrganization = null;
                selectedCatId = context.getRequest().getParameter("catId");
                recordId = context.getRequest().getParameter("recId");
                SystemStatus systemStatus = this.getSystemStatus(context);
                context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
                String headerId = context.getRequest().getParameter("headerId");
                db = this.getConnection(context);
                thisHeader = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("OpportunityHeader", (Object)thisHeader);
                thisContact = new Contact(db, thisHeader.getContactLink());
                if (this.hasPermission(context, "accounts-accounts-contacts-opps-folders-edit") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit"))) break block7;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (this.hasAuthority(context, thisHeader.getEnteredBy())) break block8;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(120200514);
            thisCategory.setLinkItemId(thisHeader.getId());
            thisCategory.setRecordId(Integer.parseInt(recordId));
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            context.getRequest().setAttribute("Category", (Object)thisCategory);
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "Opportunities", "Modify Custom Fields");
        if (recordId.equals("-1")) {
            return AccountContactsOpps.getReturn(context, "AddFolderRecord");
        }
        return AccountContactsOpps.getReturn(context, "ModifyFields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateFields(ActionContext context) {
        OpportunityHeader thisHeader;
        int resultCount;
        Organization thisOrganization;
        Contact thisContact;
        Connection db;
        block13: {
            block12: {
                db = null;
                thisContact = null;
                thisOrganization = null;
                resultCount = 0;
                SystemStatus systemStatus = this.getSystemStatus(context);
                context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
                String headerId = context.getRequest().getParameter("headerId");
                db = this.getConnection(context);
                thisHeader = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("OpportunityHeader", (Object)thisHeader);
                thisContact = new Contact(db, thisHeader.getContactLink());
                if (this.hasPermission(context, "accounts-accounts-contacts-opps-folders-edit") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit"))) break block12;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            if (this.hasAuthority(context, thisHeader.getEnteredBy())) break block13;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(120200514);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            String selectedCatId = context.getRequest().getParameter("catId");
            String recordId = context.getRequest().getParameter("recId");
            context.getRequest().setAttribute("catId", (Object)selectedCatId);
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(120200514);
            thisCategory.setLinkItemId(thisHeader.getId());
            thisCategory.setRecordId(Integer.parseInt(recordId));
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            thisCategory.setParameters(context);
            thisCategory.setModifiedBy(this.getUserId(context));
            if (!thisCategory.getReadOnly()) {
                resultCount = thisCategory.update(db);
            }
            if (resultCount == -1) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Contacts-> ModifyField validation error");
                }
            } else {
                thisCategory.buildResources(db);
                CustomFieldRecord thisRecord = new CustomFieldRecord(db, thisCategory.getRecordId());
                context.getRequest().setAttribute("Record", (Object)thisRecord);
            }
            context.getRequest().setAttribute("Category", (Object)thisCategory);
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (resultCount == -1) {
            return AccountContactsOpps.getReturn(context, "ModifyFields");
        }
        if (resultCount == 1) {
            return AccountContactsOpps.getReturn(context, "UpdateFields");
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertFields(ActionContext context) {
        OpportunityHeader thisHeader;
        Organization thisOrganization;
        Contact thisContact;
        int resultCode;
        Connection db;
        block8: {
            db = null;
            resultCode = -1;
            thisContact = null;
            thisOrganization = null;
            SystemStatus systemStatus = this.getSystemStatus(context);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
            String headerId = context.getRequest().getParameter("headerId");
            db = this.getConnection(context);
            thisHeader = new OpportunityHeader(db, headerId);
            context.getRequest().setAttribute("OpportunityHeader", (Object)thisHeader);
            thisContact = new Contact(db, thisHeader.getContactLink());
            if (this.hasPermission(context, "accounts-accounts-contacts-opps-folders-add") && (thisContact.getOrgId() <= 0 || this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit"))) break block8;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(120200514);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            String selectedCatId = context.getRequest().getParameter("catId");
            context.getRequest().setAttribute("catId", (Object)selectedCatId);
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(120200514);
            thisCategory.setLinkItemId(thisHeader.getId());
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            thisCategory.setParameters(context);
            thisCategory.setEnteredBy(this.getUserId(context));
            thisCategory.setModifiedBy(this.getUserId(context));
            if (!thisCategory.getReadOnly()) {
                resultCode = thisCategory.insert(db);
            }
            if (resultCode == -1 && System.getProperty("DEBUG") != null) {
                System.out.println("Contacts-> InsertField validation error");
            }
            context.getRequest().setAttribute("Category", (Object)thisCategory);
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (resultCode == -1) {
            return AccountContactsOpps.getReturn(context, "AddFolderRecord");
        }
        return this.executeCommandFields(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteFields(ActionContext context) {
        Connection db = null;
        boolean recordDeleted = false;
        Organization thisOrganization = null;
        Contact thisContact = null;
        try {
            db = this.getConnection(context);
            String selectedCatId = context.getRequest().getParameter("catId");
            String recordId = context.getRequest().getParameter("recId");
            String headerId = context.getRequest().getParameter("headerId");
            OpportunityHeader thisHeader = new OpportunityHeader(db, headerId);
            context.getRequest().setAttribute("OpportunityHeader", (Object)thisHeader);
            thisContact = new Contact(db, thisHeader.getContactLink());
            if (!this.hasPermission(context, "accounts-accounts-contacts-opps-folders-delete") || thisContact.getOrgId() > 0 && !this.hasPermission(context, "accounts-accounts-contacts-opportunities-edit")) {
                String string = "PermissionError";
                return string;
            }
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            CustomFieldRecord thisRecord = new CustomFieldRecord(db, Integer.parseInt(recordId));
            thisRecord.setLinkModuleId(120200514);
            thisRecord.setLinkItemId(Integer.parseInt(headerId));
            thisRecord.setCategoryId(Integer.parseInt(selectedCatId));
            if (!thisCategory.getReadOnly()) {
                recordDeleted = thisRecord.delete(db);
            }
            context.getRequest().setAttribute("recordDeleted", (Object)"true");
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DeleteFieldsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandComponentHistory(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-view")) {
            return "PermissionError";
        }
        Object errorMessage = null;
        int headerId = -1;
        int componentId = -1;
        this.addModuleBean(context, "View Contacts", "View Opportunity History List");
        componentId = context.getRequest().getParameter("id") != null ? Integer.parseInt(context.getRequest().getParameter("id")) : Integer.parseInt((String)context.getRequest().getAttribute("id"));
        String contactId = context.getRequest().getParameter("contactId");
        Connection db = null;
        Organization thisOrganization = null;
        Contact thisContact = null;
        OpportunityComponent thisComponent = null;
        OpportunityHeader thisHeader = null;
        OpportunityComponentLogList componentLogList = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        if ("true".equals(context.getRequest().getParameter("reset"))) {
            context.getSession().removeAttribute("contactComponentHistoryListInfo");
        }
        PagedListInfo componentHistoryListInfo = this.getPagedListInfo(context, "accountContactsComponentHistoryListInfo");
        componentHistoryListInfo.setLink("AccountContactsOppComponents.do?command=ComponentHistory&contactId=" + contactId + "&id=" + componentId + RequestUtils.addLinkParams(context.getRequest(), "viewSource"));
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            context.getRequest().setAttribute("contactDetails", (Object)thisContact);
            AccessTypeList accessTypeList = this.getSystemStatus(context).getAccessTypeList(db, 804051057);
            context.getRequest().setAttribute("accessTypeList", (Object)accessTypeList);
            thisComponent = new OpportunityComponent();
            thisComponent.queryRecord(db, componentId);
            context.getRequest().setAttribute("opportunityComponent", (Object)thisComponent);
            thisHeader = new OpportunityHeader();
            thisHeader.setBuildComponentCount(true);
            thisHeader.queryRecord(db, thisComponent.getHeaderId());
            context.getRequest().setAttribute("opportunityHeader", (Object)thisHeader);
            componentLogList = new OpportunityComponentLogList();
            componentLogList.setPagedListInfo(componentHistoryListInfo);
            componentLogList.setHeaderId(thisHeader.getId());
            componentLogList.setComponentId(componentId);
            componentLogList.buildList(db);
            context.getRequest().setAttribute("componentHistoryList", (Object)componentLogList);
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("orgDetails", (Object)thisOrganization);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountContactsOpps.getReturn(context, "ComponentHistory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandComponentHistoryDetails(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-opportunities-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Contacts", "View Opportunity History Details");
        String historyId = context.getRequest().getParameter("id");
        String contactId = context.getRequest().getParameter("contactId");
        Contact thisContact = null;
        Organization thisOrganization = null;
        OpportunityComponentLog thisComponentLog = null;
        OpportunityComponent component = null;
        OpportunityHeader header = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisContact = new Contact(db, contactId);
            context.getRequest().setAttribute("contactDetails", (Object)thisContact);
            thisComponentLog = new OpportunityComponentLog(db, Integer.parseInt(historyId));
            context.getRequest().setAttribute("componentLogDetails", (Object)thisComponentLog);
            component = new OpportunityComponent(db, thisComponentLog.getComponentId());
            context.getRequest().setAttribute("opportunityComponent", (Object)component);
            header = new OpportunityHeader(db, component.getHeaderId());
            context.getRequest().setAttribute("opportunityHeader", (Object)header);
            thisOrganization = new Organization(db, thisContact.getOrgId());
            context.getRequest().setAttribute("orgDetails", (Object)thisOrganization);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountContactsOpps.getReturn(context, "ComponentHistoryDetails");
    }

    private boolean allowMultiple(ActionContext context) {
        String multiple = this.getSystemPref(context, OpportunityComponent.MULTPLE_CONFIG_NAME, "multiple");
        return OpportunityComponent.allowMultiple(multiple);
    }

    private boolean excludeHierarchy(ActionContext context) {
        String exclude = this.getSystemPref(context, OpportunityComponent.MULTPLE_CONFIG_NAME, "excludeHierarchy");
        return DatabaseUtils.parseBoolean(exclude);
    }
}

