/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.orders.base.Order;
import org.aspcfs.modules.orders.base.OrderList;
import org.aspcfs.modules.orders.base.OrderPaymentList;
import org.aspcfs.modules.orders.beans.StatusBean;
import org.aspcfs.modules.products.base.ProductOptionList;
import org.aspcfs.modules.products.base.ProductOptionValuesList;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class AccountOrders
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        this.addModuleBean(context, "View Orders", "View Order Details");
        String orgid = context.getRequest().getParameter("orgId");
        if (orgid == null) {
            orgid = (String)context.getRequest().getAttribute("orgId");
        }
        PagedListInfo orderListInfo = this.getPagedListInfo(context, "OrderListInfo");
        orderListInfo.setLink("AccountOrders.do?command=View&orgId=" + orgid);
        Connection db = null;
        OrderList orderList = new OrderList();
        Organization thisOrganization = null;
        this.resetPagedListInfo(context);
        try {
            db = this.getConnection(context);
            orderList.setPagedListInfo(orderListInfo);
            orderList.setOrgId(Integer.parseInt(orgid));
            orderList.setClosedOnly(0);
            orderList.buildList(db);
            thisOrganization = new Organization(db, Integer.parseInt(orgid));
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_order_type");
            context.getRequest().setAttribute("typeSelect", (Object)typeSelect);
            LookupList statusSelect = systemStatus.getLookupList(db, "lookup_order_status");
            context.getRequest().setAttribute("statusSelect", (Object)statusSelect);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("OrderList", (Object)orderList);
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        this.addModuleBean(context, "View Orders", "View Order Details");
        String orderId = context.getRequest().getParameter("id");
        Connection db = null;
        Order newOrder = null;
        ProductOptionList optionList = null;
        ProductOptionValuesList optionValuesList = null;
        Organization thisOrganization = null;
        try {
            db = this.getConnection(context);
            newOrder = new Order();
            newOrder.setBuildProducts(true);
            newOrder.queryRecord(db, Integer.parseInt(orderId));
            optionList = new ProductOptionList();
            optionList.buildList(db);
            context.getRequest().setAttribute("productOptionList", (Object)optionList);
            optionValuesList = new ProductOptionValuesList();
            optionValuesList.buildList(db);
            context.getRequest().setAttribute("productOptionValuesList", (Object)optionValuesList);
            thisOrganization = new Organization(db, newOrder.getOrgId());
            OrderPaymentList paymentList = new OrderPaymentList();
            paymentList.setOrderId(newOrder.getId());
            paymentList.buildList(db);
            context.getRequest().setAttribute("paymentList", (Object)paymentList);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_order_type");
            context.getRequest().setAttribute("typeSelect", (Object)typeSelect);
            LookupList statusSelect = systemStatus.getLookupList(db, "lookup_order_status");
            context.getRequest().setAttribute("statusSelect", (Object)statusSelect);
            LookupList paymentSelect = systemStatus.getLookupList(db, "lookup_payment_status");
            context.getRequest().setAttribute("paymentSelect", (Object)paymentSelect);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("OrderDetails", (Object)newOrder);
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return "DetailsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyStatus(ActionContext context) {
        Object errorMessage = null;
        Connection db = null;
        Order newOrder = null;
        ProductOptionList optionList = null;
        ProductOptionValuesList optionValuesList = null;
        Organization thisOrganization = null;
        try {
            String tempOrderId = context.getRequest().getParameter("id");
            int tempid = Integer.parseInt(tempOrderId);
            db = this.getConnection(context);
            newOrder = new Order();
            newOrder.setBuildProducts(true);
            newOrder.queryRecord(db, tempid);
            optionList = new ProductOptionList();
            optionList.buildList(db);
            context.getRequest().setAttribute("productOptionList", (Object)optionList);
            optionValuesList = new ProductOptionValuesList();
            optionValuesList.buildList(db);
            context.getRequest().setAttribute("productOptionValuesList", (Object)optionValuesList);
            OrderPaymentList paymentList = new OrderPaymentList();
            paymentList.setOrderId(newOrder.getId());
            paymentList.buildList(db);
            context.getRequest().setAttribute("paymentList", (Object)paymentList);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList typeSelect = systemStatus.getLookupList(db, "lookup_order_type");
            context.getRequest().setAttribute("typeSelect", (Object)typeSelect);
            LookupList statusSelect = systemStatus.getLookupList(db, "lookup_order_status");
            context.getRequest().setAttribute("statusSelect", (Object)statusSelect);
            StatusBean statusBean = new StatusBean();
            statusBean.setStatusId(newOrder.getStatusId());
            context.getRequest().setAttribute("statusBean", (Object)statusBean);
            thisOrganization = new Organization(db, newOrder.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        context.getRequest().setAttribute("OrderDetails", (Object)newOrder);
        return "ModifyStatusOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        Connection db = null;
        try {
            String tempOrderId = context.getRequest().getParameter("id");
            int tempid = Integer.parseInt(tempOrderId);
            db = this.getConnection(context);
            Order newOrder = new Order();
            newOrder.setBuildProducts(true);
            newOrder.queryRecord(db, tempid);
            newOrder.delete(db);
        }
        catch (Exception e) {
            String string;
            try {
                e.printStackTrace();
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveStatus(ActionContext context) {
        Object errorMessage = null;
        Connection db = null;
        Order newOrder = null;
        ProductOptionList optionList = null;
        Organization thisOrganization = null;
        Object optionValuesList = null;
        try {
            String tempOrderId = context.getRequest().getParameter("id");
            int tempid = Integer.parseInt(tempOrderId);
            db = this.getConnection(context);
            newOrder = new Order();
            newOrder.setBuildProducts(true);
            newOrder.queryRecord(db, tempid);
            optionList = new ProductOptionList();
            optionList.buildList(db);
            context.getRequest().setAttribute("productOptionList", (Object)optionList);
            Calendar now = Calendar.getInstance();
            Timestamp rightNow = new Timestamp(now.getTimeInMillis());
            StatusBean statusBean = (StatusBean)((Object)context.getFormBean());
            if (statusBean.getStatusId() != -1 && statusBean.getStatusId() != 0) {
                newOrder.setStatusId(statusBean.getStatusId());
            }
            newOrder.setModified(rightNow);
            newOrder.update(db);
            thisOrganization = new Organization(db, newOrder.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        context.getRequest().setAttribute("OrderDetails", (Object)newOrder);
        return "SaveStatusOK";
    }

    private void resetPagedListInfo(ActionContext context) {
        this.deletePagedListInfo(context, "ContactListInfo");
        this.deletePagedListInfo(context, "AccountFolderInfo");
        this.deletePagedListInfo(context, "AccountTicketInfo");
        this.deletePagedListInfo(context, "AccountDocumentInfo");
        this.deletePagedListInfo(context, "QuoteListInfo");
    }
}

