/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.orders.base.Order;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.products.base.CustomerProduct;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.products.base.ProductOptionList;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.quotes.base.QuoteNote;
import org.aspcfs.modules.quotes.base.QuoteNoteList;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteProductList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class AccountQuotes
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        String headerId;
        String orgid;
        if (!this.hasPermission(context, "accounts-quotes-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Quotes", "View Quote Details");
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        if ((orgid = context.getRequest().getParameter("orgId")) == null) {
            orgid = (String)context.getRequest().getAttribute("orgId");
        }
        if ((headerId = context.getRequest().getParameter("headerId")) == null) {
            headerId = (String)context.getRequest().getAttribute("headerId");
        }
        PagedListInfo quoteListInfo = this.getPagedListInfo(context, "accountQuoteListInfo", "qe.group_id", "desc");
        quoteListInfo.setLink("AccountQuotes.do?command=View&orgId=" + orgid + RequestUtils.addLinkParams(context.getRequest(), "version|popup|popupType"));
        Connection db = null;
        QuoteList quoteList = new QuoteList();
        Organization thisOrganization = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            thisOrganization = new Organization(db, Integer.parseInt(orgid));
            if (!AccountQuotes.isRecordAccessPermitted(context, db, Integer.parseInt(orgid))) {
                String string = "PermissionError";
                return string;
            }
            if (thisOrganization.isTrashed()) {
                quoteList.setIncludeOnlyTrashed(true);
            }
            if (version != null && !"".equals(version)) {
                Quote quote = new Quote(db, Integer.parseInt(version));
                quoteList.setBuildCompleteVersionList(true);
                quoteList.setId(quote.getRootQuote(db, quote.getParentId()));
                quoteList.setPagedListInfo(quoteListInfo);
                quoteListInfo.setSearchCriteria(quoteList, context);
                if (thisOrganization.isTrashed()) {
                    quoteList.setIncludeOnlyTrashed(true);
                }
                quoteList.buildList(db);
                context.getRequest().setAttribute("quoteList", (Object)quoteList);
                context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
                String string = "ListOK";
                return string;
            }
            quoteList.setPagedListInfo(quoteListInfo);
            quoteList.setOrgId(Integer.parseInt(orgid));
            if (headerId != null && !"".equals(headerId)) {
                quoteList.setHeaderId(Integer.parseInt(headerId));
            }
            quoteList.buildList(db);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            errorMessage.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("quoteList", (Object)quoteList);
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return AccountQuotes.getReturn(context, "List");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        String quoteId;
        String printQuote;
        if (!this.hasPermission(context, "accounts-quotes-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Quotes", "View Quote Details");
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        if ((printQuote = context.getRequest().getParameter("canPrint")) != null && !"".equals(printQuote)) {
            context.getRequest().setAttribute("canPrint", (Object)printQuote);
        }
        if ((quoteId = (String)context.getRequest().getAttribute("quoteId")) == null || "".equals(quoteId)) {
            quoteId = context.getRequest().getParameter("quoteId");
        }
        Quote quote = null;
        QuoteProductList quoteProducts = null;
        ProductCatalogList productList = null;
        ProductOptionList optionList = null;
        Object valuesList = null;
        Organization thisOrganization = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        if (quoteId == null || "".equals(quoteId)) {
            try {
                int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
                int ticketId = Integer.parseInt(context.getRequest().getParameter("ticketId"));
            }
            catch (Exception e) {
                context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.invalidCriteria"));
                return "SearchCriteriaError";
            }
            return this.executeCommandAddQuote(context);
        }
        Connection db = null;
        try {
            int headerId;
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            quote.retrieveTicket(db);
            if (!AccountQuotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String ticketId = "PermissionError";
                return ticketId;
            }
            thisOrganization = new Organization(db, quote.getOrgId());
            optionList = new ProductOptionList();
            optionList.setBuildConfigDetails(true);
            optionList.buildList(db);
            context.getRequest().setAttribute("optionList", (Object)optionList);
            productList = new ProductCatalogList();
            quoteProducts = quote.getProductList();
            for (QuoteProduct quoteProduct : quoteProducts) {
                quoteProduct.buildProductOptions(db);
                quoteProduct.queryRecord(db, quoteProduct.getId());
                ProductCatalog product = new ProductCatalog();
                product.setBuildOptions(true);
                product.queryRecord(db, quoteProduct.getProductId());
                productList.add(product);
            }
            context.getRequest().setAttribute("quoteProductList", (Object)quoteProducts);
            context.getRequest().setAttribute("productList", (Object)productList);
            int orderId = quote.getOrderId(db);
            if (orderId != -1) {
                Order order = new Order(db, orderId);
                context.getRequest().setAttribute("order", (Object)order);
            }
            if ((headerId = quote.getHeaderId()) != -1) {
                OpportunityHeader opportunity = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("opportunity", (Object)opportunity);
            }
            Quote quoteBean = new Quote();
            context.getRequest().setAttribute("quoteBean", (Object)quoteBean);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            if (quote.getLogoFileId() > 0) {
                FileItem thisItem = new FileItem(db, quote.getLogoFileId(), 126200514, 126200511);
                context.getRequest().setAttribute("fileItem", (Object)thisItem);
            }
        }
        catch (Exception errorMessage) {
            errorMessage.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("quote", (Object)quote);
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        return AccountQuotes.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemoveProduct(ActionContext context) {
        if (!this.hasPermission(context, "accounts-quotes-edit")) {
            return "PermissionError";
        }
        String quoteName = context.getRequest().getParameter("quoteId");
        String productName = context.getRequest().getParameter("productId");
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int quoteId = Integer.parseInt(quoteName);
        int productId = Integer.parseInt(productName);
        QuoteProduct quoteProduct = null;
        ProductCatalog product = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quoteProduct = new QuoteProduct(db, productId);
            Quote previousQuote = new Quote();
            previousQuote.setBuildProducts(true);
            previousQuote.queryRecord(db, quoteProduct.getQuoteId());
            if (!AccountQuotes.isRecordAccessPermitted(context, db, previousQuote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            product = new ProductCatalog(db, quoteProduct.getProductId());
            quoteProduct.delete(db);
            Quote quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteProduct.getQuoteId());
            this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandDetails(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveNotes(ActionContext context) {
        if (!this.hasPermission(context, "accounts-quotes-view")) {
            return "PermissionError";
        }
        int quoteId = -1;
        boolean isValid = false;
        int recordCount = -1;
        String quoteIdString = context.getRequest().getParameter("quoteId");
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        QuoteNote quoteNote = null;
        Quote quote = null;
        Quote previousQuote = null;
        Quote notes = (Quote)((Object)context.getFormBean());
        if (notes == null) {
            notes = new Quote();
        }
        Organization thisOrganization = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quoteId = Integer.parseInt(quoteIdString);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            if (!AccountQuotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("quote", (Object)quote);
            previousQuote = new Quote(db, quoteId);
            thisOrganization = new Organization(db, quote.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            if (notes.getNotes() != null) {
                quoteNote = new QuoteNote();
                quoteNote.setQuoteId(quote.getId());
                quoteNote.setEnteredBy(this.getUserId(context));
                quoteNote.setModifiedBy(this.getUserId(context));
                quoteNote.setNotes(notes.getNotes());
                isValid = this.validateObject(context, db, (Object)quoteNote);
                if (isValid) {
                    quoteNote.insert(db);
                }
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            if (quote.getStatusId() == list.getIdFromValue("Rejected by customer")) {
                quote.setStatusId(list.getIdFromValue("Pending customer acceptance"));
                Timestamp currentTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
                quote.setIssuedDate(currentTimestamp);
                quote.setStatusDate(currentTimestamp);
                boolean bl = isValid = isValid && this.validateObject(context, db, (Object)quote);
                if (isValid) {
                    recordCount = quote.update(db);
                }
                if (recordCount == 1) {
                    this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
                }
            }
            QuoteNoteList noteList = new QuoteNoteList();
            noteList.setQuoteId(quote.getId());
            noteList.buildList(db);
            context.getRequest().setAttribute("quoteNoteList", (Object)noteList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountQuotes.getReturn(context, "SaveNotes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSubmit(ActionContext context) {
        if (!this.hasPermission(context, "accounts-quotes-edit")) {
            return "PermissionError";
        }
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int quoteId = -1;
        String quoteIdString = context.getRequest().getParameter("quoteId");
        Quote quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quoteId = Integer.parseInt(quoteIdString);
            quote = new Quote();
            quote.queryRecord(db, quoteId);
            if (!AccountQuotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("quote", (Object)quote);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SubmitOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-quotes-delete")) {
            return "PermissionError";
        }
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int quoteId = Integer.parseInt(context.getRequest().getParameter("quoteId"));
        int orgId = Integer.parseInt(context.getRequest().getParameter("orgId"));
        Quote quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            if (!AccountQuotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            quote.delete(db);
            this.processDeleteHook(context, (Object)quote);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean inline = context.getRequest().getParameter("popupType") != null && "inline".equals(context.getRequest().getParameter("popupType"));
        context.getRequest().setAttribute("refreshUrl", (Object)("AccountQuotes.do?command=View&orgId=" + orgId + (inline ? "&popup=true" : "")));
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-quotes-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        Quote quote = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String quoteId = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        if (context.getRequest().getParameter("quoteId") != null) {
            quoteId = context.getRequest().getParameter("quoteId");
        }
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.setBuildTicket(true);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            if (!AccountQuotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            htmlDialog.setTitle("Centric CRM: Quote Management");
            DependencyList dependencies = quote.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (quote.getOrderId(db) != -1) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("quotes.deleteRelatedOrdersFirst"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("quotes.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='AccountQuotes.do?command=Delete&quoteId=" + quote.getId() + "&orgId=" + quote.getOrgId() + RequestUtils.addLinkParams(context.getRequest(), "version|popup|popupType") + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "accounts-quotes-edit")) {
            return "PermissionError";
        }
        boolean isValid = false;
        Quote previousQuote = null;
        int recordCount = -1;
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int quoteId = Integer.parseInt(context.getRequest().getParameter("quoteId"));
        Quote quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            Quote quoteBean = (Quote)((Object)context.getFormBean());
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            if (!AccountQuotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            previousQuote = new Quote(db, quoteId);
            if (quoteBean.getNotes() != null) {
                quote.setNotes(quoteBean.getNotes());
            }
            if (quoteBean.getExpirationDate() != null) {
                quote.setExpirationDate(quoteBean.getExpirationDate());
            }
            if (isValid = this.validateObject(context, db, (Object)quote)) {
                recordCount = quote.update(db);
            }
            if (recordCount == 1) {
                this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SetSearchOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyForm(ActionContext context) {
        String quoteIdString;
        if (!this.hasPermission(context, "accounts-quotes-edit")) {
            return "PermissionError";
        }
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        if ((quoteIdString = (String)context.getRequest().getAttribute("quoteId")) == null || "".equals(quoteIdString)) {
            quoteIdString = context.getRequest().getParameter("quoteId");
        }
        Quote quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            list2.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            quote = new Quote(db, Integer.parseInt(quoteIdString));
            if (!AccountQuotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("quoteBean", (Object)quote);
            int headerId = quote.getHeaderId();
            if (headerId != -1) {
                OpportunityHeader opportunity = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("opportunity", (Object)opportunity);
            }
            Organization orgDetails = new Organization(db, quote.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            ContactList contactList = new ContactList();
            contactList.setOrgId(quote.getOrgId());
            contactList.setLeadsOnly(0);
            contactList.setEmployeesOnly(0);
            contactList.setDefaultContactId(quote.getContactId());
            contactList.buildList(db);
            context.getRequest().setAttribute("contactList", (Object)contactList);
            FileItemList itemList = new FileItemList();
            itemList.setLinkModuleId(126200511);
            itemList.setLinkItemId(126200514);
            itemList.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)itemList);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountQuotes.getReturn(context, "ModifyForm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        boolean isAddVersion;
        if (!this.hasPermission(context, "accounts-quotes-edit")) {
            return "PermissionError";
        }
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        String version = context.getRequest().getParameter("versionId");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String orgIdString = context.getRequest().getParameter("orgId");
        int orgId = -1;
        if (orgIdString != null && !"".equals(orgIdString)) {
            orgId = Integer.parseInt(orgIdString);
        }
        String quoteIdString = context.getRequest().getParameter("quoteId");
        int quoteId = -1;
        if (quoteIdString != null && !"".equals(quoteIdString)) {
            quoteId = Integer.parseInt(quoteIdString);
        }
        boolean isValid = false;
        int recordCount = -1;
        Quote quote = null;
        Quote previousQuote = null;
        Quote quoteBean = (Quote)((Object)context.getFormBean());
        User user = this.getUser(context, this.getUserId(context));
        String printQuote = (String)context.getRequest().getAttribute("canPrint");
        if (printQuote != null && !"".equals(printQuote)) {
            context.getRequest().setAttribute("canPrint", (Object)printQuote);
        } else {
            printQuote = quoteBean.getCanPrint();
            context.getRequest().setAttribute("canPrint", (Object)printQuote);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            quote = new Quote(db, quoteId);
            if (!AccountQuotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            previousQuote = new Quote(db, quoteId);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            int contactId = quoteBean.getContactId();
            if (quoteBean.getContactId() != -1) {
                quote.setContactId(quoteBean.getContactId());
            }
            quote.setShortDescription(quoteBean.getShortDescription());
            quote.setExpirationDate(quoteBean.getExpirationDate());
            quote.setIssuedDate(quoteBean.getIssuedDate());
            quote.setNotes(quoteBean.getNotes());
            quote.setStatusId(quoteBean.getStatusId());
            quote.setHeaderId(quoteBean.getHeaderId());
            quote.setDeliveryId(quoteBean.getDeliveryId());
            quote.setEmailAddress(quoteBean.getEmailAddress());
            quote.setFaxNumber(quoteBean.getFaxNumber());
            quote.setPhoneNumber(quoteBean.getPhoneNumber());
            quote.setAddress(quoteBean.getAddress());
            quote.setCloseIt(quoteBean.getCloseIt());
            quote.setClosed(quoteBean.getClosed());
            quote.setSubmitAction(quoteBean.getSubmitAction());
            quote.setLogoFileId(quoteBean.getLogoFileId());
            quote.setModifiedBy(user.getId());
            isValid = this.validateObject(context, db, (Object)quote);
            if (isValid) {
                recordCount = quote.update(db);
            }
            if (recordCount == 1) {
                this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
            }
            Organization orgDetails = new Organization(db, orgId);
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordCount == -1 || !isValid) {
            return this.executeCommandModifyForm(context);
        }
        boolean bl = isAddVersion = context.getRequest().getParameter("newVersion") != null && "true".equals(context.getRequest().getParameter("newVersion"));
        if (isAddVersion) {
            return "ModifyAddVersionOK";
        }
        return AccountQuotes.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddQuote(ActionContext context) {
        if (!this.hasPermission(context, "accounts-quotes-add")) {
            return "PermissionError";
        }
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        boolean isValid = false;
        boolean recordInserted = false;
        String ticketIdString = context.getRequest().getParameter("ticketId");
        int ticketId = -1;
        String productIdString = context.getRequest().getParameter("productId");
        int productId = -1;
        String orgIdString = context.getRequest().getParameter("orgId");
        int orgId = -1;
        if (ticketIdString != null && !"".equals(ticketIdString)) {
            ticketId = Integer.parseInt(ticketIdString);
        }
        if (productIdString != null && !"".equals(productIdString)) {
            productId = Integer.parseInt(productIdString);
        }
        if (orgIdString != null && !"".equals(orgIdString)) {
            orgId = Integer.parseInt(orgIdString);
        }
        Quote quote = null;
        Ticket ticket = null;
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            int contactId;
            db = this.getConnection(context);
            quote = (Quote)((Object)context.getFormBean());
            if (!AccountQuotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            if (ticketId != -1) {
                ticket = new Ticket(db, ticketId);
                ProductCatalog product = new ProductCatalog(db, productId);
                quote.setProductId(product.getId());
                product.determineCategory(db);
                quote.setShortDescription(product.getCategoryName() + ", " + product.getName() + ": ");
                if (!ticket.getProblem().equals("New Ad Design Request") && ticket.getCustomerProductId() != -1) {
                    CustomerProduct customerProduct = new CustomerProduct(db, ticket.getCustomerProductId());
                    quote.setCustomerProductId(customerProduct.getId());
                }
                quote.setOrgId(ticket.getOrgId());
                quote.setContactId(ticket.getContactId());
                quote.setTicketId(ticket.getId());
            }
            if ((contactId = quote.getContactId()) != -1) {
                Organization orgDetails = new Organization(db, quote.getOrgId());
                context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            } else {
                quote.setStatusId(list.getIdFromValue("Incomplete"));
            }
            quote.setEnteredBy(user.getId());
            quote.setModifiedBy(user.getId());
            quote.createNewGroup(db);
            isValid = this.validateObject(context, db, (Object)quote);
            if (isValid) {
                quote.setVersion(quote.getNewVersion());
                recordInserted = quote.insert(db);
                String quoteId = "" + quote.getId();
                context.getRequest().setAttribute("quoteId", (Object)quoteId);
            }
            if (recordInserted) {
                this.processInsertHook(context, (Object)quote);
            }
            if (ticketId != -1) {
                QuoteNote quoteNote = new QuoteNote();
                quoteNote.setQuoteId(quote.getId());
                quoteNote.setNotes(ticket.getProblem().trim());
                quoteNote.setModifiedBy(user.getId());
                quoteNote.setEnteredBy(user.getId());
                boolean bl = isValid = isValid && this.validateObject(context, db, (Object)quoteNote);
                if (isValid) {
                    quoteNote.insert(db);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!isValid) {
            return this.executeCommandAddQuoteForm(context);
        }
        return "SaveOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddQuoteForm(ActionContext context) {
        if (!this.hasPermission(context, "accounts-quotes-add")) {
            return "PermissionError";
        }
        int orgId = -1;
        String orgIdString = context.getRequest().getParameter("orgId");
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        if (orgIdString != null && !"".equals(orgIdString)) {
            orgId = Integer.parseInt(orgIdString);
        }
        Quote quote = (Quote)((Object)context.getFormBean());
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            list2.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            if (!AccountQuotes.isRecordAccessPermitted(context, db, orgId)) {
                String string = "PermissionError";
                return string;
            }
            Organization orgDetails = new Organization(db, orgId);
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            int headerId = quote.getHeaderId();
            if (headerId != -1) {
                OpportunityHeader opportunity = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("opportunity", (Object)opportunity);
            }
            ContactList contactList = new ContactList();
            contactList.setOrgId(orgId);
            contactList.setLeadsOnly(0);
            contactList.setEmployeesOnly(0);
            contactList.buildList(db);
            context.getRequest().setAttribute("contactList", (Object)contactList);
            if (quote == null) {
                quote = new Quote();
            }
            quote.setOrgId(orgId);
            quote.setName(orgDetails.getName());
            quote.setEnteredBy(user.getId());
            quote.setModifiedBy(user.getId());
            context.getRequest().setAttribute("quoteBean", (Object)quote);
            FileItemList itemList = new FileItemList();
            itemList.setLinkModuleId(126200511);
            itemList.setLinkItemId(126200514);
            itemList.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)itemList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        return AccountQuotes.getReturn(context, "AddQuoteForm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddVersion(ActionContext context) {
        if (!this.hasPermission(context, "accounts-quotes-add")) {
            return "PermissionError";
        }
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String quoteId = context.getRequest().getParameter("quoteId");
        Quote quote = null;
        Quote oldQuote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (quoteId != null && !"".equals(quoteId)) {
                oldQuote = new Quote();
                oldQuote.setBuildProducts(true);
                oldQuote.queryRecord(db, Integer.parseInt(quoteId));
            }
            if (!AccountQuotes.isRecordAccessPermitted(context, db, oldQuote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            quote = new Quote();
            quote.setStatusId(list.getIdFromValue("Incomplete"));
            quote = oldQuote.addVersion(db, quote);
            quote.queryRecord(db, quote.getId());
            this.processUpdateHook(context, (Object)oldQuote, (Object)quote);
            String quoteIdString = String.valueOf(quote.getId());
            context.getRequest().setAttribute("quoteId", (Object)quoteIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandModifyForm(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewHistory(ActionContext context) {
        SystemStatus systemStatus;
        Quote quote;
        Connection db;
        block7: {
            if (!this.hasPermission(context, "accounts-quotes-view")) {
                return "PermissionError";
            }
            String version = context.getRequest().getParameter("version");
            if (version != null && !"".equals(version)) {
                context.getRequest().setAttribute("version", (Object)version);
            }
            db = null;
            quote = null;
            String quoteId = null;
            systemStatus = this.getSystemStatus(context);
            quoteId = context.getRequest().getParameter("quoteId");
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildHistory(true);
            quote.setSystemStatus(systemStatus);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            if (AccountQuotes.isRecordAccessPermitted(context, db, quote.getOrgId())) break block7;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("quote", (Object)quote);
            Organization orgDetails = new Organization(db, quote.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "View Quotes", "View Quote Details");
        return AccountQuotes.getReturn(context, "ViewHistory");
    }
}

