/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.relationships.base.Relationship;
import org.aspcfs.modules.relationships.base.RelationshipList;
import org.aspcfs.modules.relationships.base.RelationshipTypeList;

public final class AccountRelationships
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-relationships-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            Organization thisOrg = this.addFormElements(context, db);
            if (!AccountRelationships.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            RelationshipList thisList = new RelationshipList();
            thisList.setCategoryIdMapsFrom(42420034);
            thisList.setObjectIdMapsFrom(thisOrg.getOrgId());
            thisList.setBuildDualMappings(true);
            thisList.buildList(db);
            context.getRequest().setAttribute("relationshipList", (Object)thisList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountRelationships.getReturn(context, "View");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-relationships-add")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            Organization thisOrg = this.addFormElements(context, db);
            if (!AccountRelationships.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            RelationshipTypeList typeList = new RelationshipTypeList();
            typeList.setCategoryIdMapsFrom(42420034);
            typeList.buildList(db);
            context.getRequest().setAttribute("TypeList", (Object)typeList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountRelationships.getReturn(context, "Add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-relationships-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            Organization thisOrg = this.addFormElements(context, db);
            if (!AccountRelationships.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountRelationships.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        String permission = "accounts-accounts-relationships-add";
        HashMap<String, String> errors = new HashMap<String, String>();
        boolean recordInserted = false;
        int resultCount = -1;
        String relTypeId = context.getRequest().getParameter("relTypeId");
        int typeId = -1;
        boolean isValid = false;
        Relationship oldRelationship = null;
        Relationship thisRelationship = (Relationship)((Object)context.getFormBean());
        thisRelationship.setModifiedBy(this.getUserId(context));
        if (thisRelationship.getId() > 0) {
            permission = "accounts-accounts-relationships-edit";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            Organization thisOrg;
            db = this.getConnection(context);
            if (thisRelationship.getId() > 0) {
                oldRelationship = new Relationship(db, thisRelationship.getId());
            }
            if (!AccountRelationships.isRecordAccessPermitted(context, db, (thisOrg = this.addFormElements(context, db)).getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            thisRelationship.setModifiedBy(this.getUserId(context));
            if (relTypeId.endsWith("_reciprocal")) {
                thisRelationship.setObjectIdMapsFrom(thisRelationship.getObjectIdMapsTo());
                thisRelationship.setObjectIdMapsTo(thisOrg.getOrgId());
                typeId = Integer.parseInt(relTypeId.substring(0, relTypeId.indexOf("_")));
            } else {
                typeId = Integer.parseInt(relTypeId);
            }
            thisRelationship.setTypeId(typeId);
            thisRelationship.setCategoryIdMapsFrom(42420034);
            thisRelationship.setCategoryIdMapsTo(42420034);
            RelationshipList thisList = new RelationshipList();
            thisList.setCategoryIdMapsFrom(42420034);
            thisList.setObjectIdMapsFrom(thisRelationship.getObjectIdMapsFrom());
            thisList.setTypeId(typeId);
            thisList.buildList(db);
            isValid = this.validateObject(context, db, (Object)thisRelationship);
            if (isValid) {
                SystemStatus systemStatus;
                if (thisRelationship.getId() > 0) {
                    if (thisList.checkDuplicateRelationship(db, thisRelationship.getObjectIdMapsTo(), typeId, 42420034) == 1) {
                        resultCount = thisRelationship.update(db);
                        if (resultCount > 0) {
                            this.processUpdateHook(context, (Object)oldRelationship, (Object)thisRelationship);
                        }
                    } else {
                        systemStatus = this.getSystemStatus(context);
                        errors.put("actionError", systemStatus.getLabel("object.validation.actionError.relationshipDuplicate"));
                    }
                } else {
                    thisRelationship.setEnteredBy(this.getUserId(context));
                    if (thisList.checkDuplicateRelationship(db, thisRelationship.getObjectIdMapsTo(), typeId, 42420034) == 0) {
                        recordInserted = thisRelationship.insert(db);
                        if (recordInserted) {
                            thisRelationship = new Relationship(db, thisRelationship.getId());
                            this.processInsertHook(context, (Object)thisRelationship);
                        }
                    } else {
                        systemStatus = this.getSystemStatus(context);
                        errors.put("actionError", systemStatus.getLabel("object.validation.actionError.relationshipDuplicate"));
                    }
                }
            }
            if (!recordInserted && resultCount != 1) {
                Organization secondOrganization;
                if (relTypeId.endsWith("_reciprocal")) {
                    if (thisRelationship.getObjectIdMapsFrom() != -1) {
                        secondOrganization = new Organization(db, thisRelationship.getObjectIdMapsFrom());
                        context.getRequest().setAttribute("secondOrganization", (Object)secondOrganization);
                    }
                } else if (thisRelationship.getObjectIdMapsTo() != -1) {
                    secondOrganization = new Organization(db, thisRelationship.getObjectIdMapsTo());
                    context.getRequest().setAttribute("secondOrganization", (Object)secondOrganization);
                }
                RelationshipTypeList typeList = new RelationshipTypeList();
                typeList.setCategoryIdMapsFrom(42420034);
                typeList.buildList(db);
                context.getRequest().setAttribute("TypeList", (Object)typeList);
                context.getRequest().setAttribute("relationship", (Object)thisRelationship);
                if (errors.size() > 0) {
                    this.processErrors(context, errors);
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (isValid && (recordInserted || resultCount == 1)) {
            return "SaveOK";
        }
        if (thisRelationship.getId() > 0) {
            return AccountRelationships.getReturn(context, "Modify");
        }
        return AccountRelationships.getReturn(context, "Add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-relationships-delete")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        String relId = context.getRequest().getParameter("id");
        boolean recordDeleted = false;
        Connection db = null;
        try {
            db = this.getConnection(context);
            Organization thisOrg = this.addFormElements(context, db);
            if (!AccountRelationships.isRecordAccessPermitted(context, db, thisOrg.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            Relationship thisRelation = new Relationship(db, Integer.parseInt(relId));
            recordDeleted = thisRelation.delete(db);
            if (!recordDeleted) {
                thisRelation.getErrors().put("actionError", systemStatus.getLabel("object.validation.actionError.relationshipDeletion"));
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DeleteOK";
    }

    public Organization addFormElements(ActionContext context, Connection db) throws SQLException {
        String orgId = context.getRequest().getParameter("orgId");
        Organization thisOrg = new Organization(db, Integer.parseInt(orgId));
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrg);
        return thisOrg;
    }
}

