/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketActivityLog;
import org.aspcfs.modules.troubletickets.base.TicketActivityLogList;
import org.aspcfs.modules.troubletickets.base.TicketPerDayDescription;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class AccountTicketActivityLog
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        Ticket thisTicket;
        Connection db;
        block6: {
            if (!this.hasPermission(context, "accounts-accounts-tickets-activity-log-view")) {
                return "PermissionError";
            }
            db = null;
            String ticketId = context.getRequest().getParameter("id");
            db = this.getConnection(context);
            thisTicket = new Ticket(db, Integer.parseInt(ticketId));
            if (AccountTicketActivityLog.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block6;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
            this.loadOrganizaton(context, db, thisTicket);
            TicketActivityLogList thisList = new TicketActivityLogList();
            PagedListInfo tmListInfo = this.getPagedListInfo(context, "TMListInfo");
            tmListInfo.setLink("AccountTicketActivityLog.do?command=List&id=" + thisTicket.getId() + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType"));
            thisList.setPagedListInfo(tmListInfo);
            thisList.setTicketId(thisTicket.getId());
            thisList.buildList(db);
            context.getRequest().setAttribute("activityList", (Object)thisList);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AccountTicketActivityLog.getReturn(context, "List");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        Ticket thisTicket;
        Connection db;
        block7: {
            if (!this.hasPermission(context, "accounts-accounts-tickets-activity-log-add")) {
                return "PermissionError";
            }
            db = null;
            thisTicket = null;
            String ticketId = context.getRequest().getParameter("id");
            db = this.getConnection(context);
            thisTicket = new Ticket(db, Integer.parseInt(ticketId));
            if (AccountTicketActivityLog.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block7;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
            this.loadOrganizaton(context, db, thisTicket);
            LookupList onsiteModelList = new LookupList(db, "lookup_onsite_model");
            onsiteModelList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("onsiteModelList", (Object)onsiteModelList);
            context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
            TicketActivityLog thisMaintenance = (TicketActivityLog)((Object)context.getRequest().getAttribute("activityDetails"));
            if (thisMaintenance != null && thisMaintenance.getEnteredBy() == -1) {
                thisMaintenance = new TicketActivityLog();
                context.getRequest().setAttribute("activityDetails", (Object)thisMaintenance);
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AccountTicketActivityLog.getReturn(context, "Add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-activity-log-edit")) {
            return "PermissionError";
        }
        Ticket thisTicket = null;
        Connection db = null;
        try {
            thisTicket = (Ticket)((Object)context.getFormBean());
            if (thisTicket.getId() != -1) return AccountTicketActivityLog.getReturn(context, "Modify");
            String ticketId = context.getRequest().getParameter("id");
            String formId = context.getRequest().getParameter("formId");
            db = this.getConnection(context);
            thisTicket = new Ticket(db, Integer.parseInt(ticketId));
            context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
            this.loadOrganizaton(context, db, thisTicket);
            LookupList onsiteModelList = new LookupList(db, "lookup_onsite_model");
            onsiteModelList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("onsiteModelList", (Object)onsiteModelList);
            context.getRequest().setAttribute("return", (Object)context.getRequest().getParameter("return"));
            TicketActivityLog thisMaintenance = new TicketActivityLog();
            thisMaintenance.queryRecord(db, Integer.parseInt(formId));
            if (thisMaintenance.getLinkTicketId() == thisTicket.getId()) {
                if (!AccountTicketActivityLog.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                    String string = "PermissionError";
                    this.freeConnection(context, db);
                    return string;
                }
                context.getRequest().setAttribute("activityDetails", (Object)thisMaintenance);
                return AccountTicketActivityLog.getReturn(context, "Modify");
            }
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        Ticket thisTicket;
        boolean isValid;
        boolean inserted;
        Connection db;
        block11: {
            if (!this.hasPermission(context, "accounts-accounts-tickets-activity-log-add")) {
                return "PermissionError";
            }
            db = null;
            inserted = false;
            isValid = false;
            String ticketId = context.getRequest().getParameter("id");
            db = this.getConnection(context);
            thisTicket = new Ticket(db, Integer.parseInt(ticketId));
            if (AccountTicketActivityLog.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block11;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            this.loadOrganizaton(context, db, thisTicket);
            TicketActivityLog thisMaintenance = new TicketActivityLog();
            thisMaintenance.setModifiedBy(this.getUserId(context));
            thisMaintenance.setEnteredBy(this.getUserId(context));
            thisMaintenance.setLinkTicketId(thisTicket.getId());
            thisMaintenance.setTravelTowardsServiceContract(context.getRequest().getParameter("travelTowardsServiceContract"));
            thisMaintenance.setLaborTowardsServiceContract(context.getRequest().getParameter("laborTowardsServiceContract"));
            thisMaintenance.setPhoneResponseTime(context.getRequest().getParameter("phoneResponseTime"));
            thisMaintenance.setEngineerResponseTime(context.getRequest().getParameter("engineerResponseTime"));
            thisMaintenance.setAlertDateTimeZone(context.getRequest().getParameter("alertDateTimeZone"));
            thisMaintenance.setTimeZoneForDateFields(context.getRequest(), context.getRequest().getParameter("alertDate"), "alertDate");
            thisMaintenance.setFollowUpRequired(context.getRequest().getParameter("followUpRequired"));
            thisMaintenance.setFollowUpDescription(context.getRequest().getParameter("followUpDescription"));
            thisMaintenance.setOnlyWarnings(context.getRequest().getParameter("onlyWarnings"));
            thisMaintenance.setRequestItems(context.getRequest());
            thisMaintenance.setRequest(context.getRequest());
            thisMaintenance.setRelatedContractId(thisTicket.getContractId());
            isValid = this.validateObject(context, db, (Object)thisMaintenance);
            int i = 1;
            while (context.getRequest().getParameter("activityDate" + i) != null || context.getRequest().getParameter("descriptionOfService" + i) != null) {
                if (!context.getRequest().getParameter("activityDate" + i).trim().equals("") || !context.getRequest().getParameter("descriptionOfService" + i).trim().equals("")) {
                    TicketPerDayDescription thisPerDayDescription = new TicketPerDayDescription();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("descriptionOfService", context.getRequest().getParameter("descriptionOfService" + i));
                    map.put("activityDateTimeZone", context.getRequest().getParameter("activityDate" + i + "TimeZone"));
                    map.put("activityDate", context.getRequest().getParameter("activityDate" + i));
                    map.put("request", (String)context.getRequest());
                    map.put("parseItem", "" + i);
                    isValid = this.validateObject(context, db, (Object)thisPerDayDescription, map) && isValid;
                }
                ++i;
            }
            if (isValid) {
                inserted = thisMaintenance.insert(db);
            }
            if (!inserted) {
                context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
                context.getRequest().setAttribute("activityDetails", (Object)thisMaintenance);
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (inserted) {
            return this.executeCommandList(context);
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        TicketActivityLog thisMaintenance;
        Ticket thisTicket;
        int resultCount;
        Connection db;
        boolean isValid;
        block14: {
            block13: {
                if (!this.hasPermission(context, "accounts-accounts-tickets-activity-log-edit")) {
                    return "PermissionError";
                }
                isValid = false;
                db = null;
                resultCount = -1;
                String ticketId = context.getRequest().getParameter("id");
                String formId = context.getRequest().getParameter("formId");
                db = this.getConnection(context);
                thisTicket = new Ticket(db, Integer.parseInt(ticketId));
                this.loadOrganizaton(context, db, thisTicket);
                thisMaintenance = new TicketActivityLog();
                thisMaintenance.queryRecord(db, Integer.parseInt(formId));
                if (thisMaintenance.getLinkTicketId() != thisTicket.getId()) break block13;
                if (AccountTicketActivityLog.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block14;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            thisMaintenance.setModifiedBy(this.getUserId(context));
            thisMaintenance.setTravelTowardsServiceContract(context.getRequest().getParameter("travelTowardsServiceContract"));
            thisMaintenance.setLaborTowardsServiceContract(context.getRequest().getParameter("laborTowardsServiceContract"));
            thisMaintenance.setPhoneResponseTime(context.getRequest().getParameter("phoneResponseTime"));
            thisMaintenance.setEngineerResponseTime(context.getRequest().getParameter("engineerResponseTime"));
            thisMaintenance.setAlertDateTimeZone(context.getRequest().getParameter("alertDateTimeZone"));
            thisMaintenance.setTimeZoneForDateFields(context.getRequest(), context.getRequest().getParameter("alertDate"), "alertDate");
            thisMaintenance.setFollowUpRequired(context.getRequest().getParameter("followUpRequired"));
            thisMaintenance.setFollowUpDescription(context.getRequest().getParameter("followUpDescription"));
            thisMaintenance.setOnlyWarnings(context.getRequest().getParameter("onlyWarnings"));
            thisMaintenance.setRequestItems(context.getRequest());
            String modified = context.getRequest().getParameter("modified");
            thisMaintenance.setModified(modified);
            thisMaintenance.setRequest(context.getRequest());
            thisMaintenance.setRelatedContractId(thisTicket.getContractId());
            isValid = this.validateObject(context, db, (Object)thisMaintenance);
            int i = 1;
            while (context.getRequest().getParameter("activityDate" + i) != null) {
                if (!context.getRequest().getParameter("activityDate" + i).trim().equals("")) {
                    TicketPerDayDescription thisPerDayDescription = new TicketPerDayDescription();
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("descriptionOfService", context.getRequest().getParameter("descriptionOfService" + i));
                    map.put("activityDateTimeZone", context.getRequest().getParameter("activityDate" + i + "TimeZone"));
                    map.put("activityDate", context.getRequest().getParameter("activityDate" + i));
                    map.put("request", (String)context.getRequest());
                    map.put("parseItem", "" + i);
                    isValid = this.validateObject(context, db, (Object)thisPerDayDescription, map) && isValid;
                }
                ++i;
            }
            if (isValid) {
                resultCount = thisMaintenance.update(db);
            }
            if (resultCount == -1) {
                context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
                context.getRequest().setAttribute("activityDetails", (Object)thisMaintenance);
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandList(context);
            }
            return this.executeCommandView(context);
        }
        return this.executeCommandModify(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        Connection db;
        block7: {
            String string;
            block6: {
                if (!this.hasPermission(context, "accounts-accounts-tickets-activity-log-view")) {
                    return "PermissionError";
                }
                db = null;
                String ticketId = context.getRequest().getParameter("id");
                String formId = context.getRequest().getParameter("formId");
                db = this.getConnection(context);
                Ticket thisTicket = new Ticket(db, Integer.parseInt(ticketId));
                context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
                this.loadOrganizaton(context, db, thisTicket);
                LookupList onsiteModelList = new LookupList(db, "lookup_onsite_model");
                onsiteModelList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
                context.getRequest().setAttribute("onsiteModelList", (Object)onsiteModelList);
                TicketActivityLog thisMaintenance = new TicketActivityLog();
                thisMaintenance.queryRecord(db, Integer.parseInt(formId));
                context.getRequest().setAttribute("activityDetails", (Object)thisMaintenance);
                thisMaintenance.queryRecord(db, Integer.parseInt(formId));
                if (thisMaintenance.getLinkTicketId() != thisTicket.getId()) break block6;
                if (AccountTicketActivityLog.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block7;
                String string2 = "PermissionError";
                this.freeConnection(context, db);
                return string2;
            }
            try {
                string = "PermissionError";
            }
            catch (Exception e) {
                String string3;
                try {
                    context.getRequest().setAttribute("Error", (Object)e);
                    string3 = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string3;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AccountTicketActivityLog.getReturn(context, "View");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        TicketActivityLog thisMaintenance;
        SystemStatus systemStatus;
        String formId;
        String ticketId;
        HtmlDialog htmlDialog;
        Connection db;
        block8: {
            block7: {
                if (!this.hasPermission(context, "accounts-accounts-tickets-activity-log-delete")) {
                    return "PermissionError";
                }
                db = null;
                htmlDialog = new HtmlDialog();
                ticketId = context.getRequest().getParameter("id");
                formId = context.getRequest().getParameter("formId");
                db = this.getConnection(context);
                systemStatus = this.getSystemStatus(context);
                Ticket thisTicket = new Ticket();
                thisTicket.queryRecord(db, Integer.parseInt(ticketId));
                context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
                thisMaintenance = new TicketActivityLog();
                thisMaintenance.queryRecord(db, Integer.parseInt(formId));
                if (thisMaintenance.getLinkTicketId() != thisTicket.getId()) break block7;
                if (AccountTicketActivityLog.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block8;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            DependencyList dependencies = new DependencyList();
            dependencies = thisMaintenance.processDependencies();
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.formHeader"));
            htmlDialog.addButton(systemStatus.getLabel("button.delete"), "javascript:window.location.href='AccountTicketActivityLog.do?command=Delete&id=" + ticketId + "&formId=" + formId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-activity-log-delete")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean recordDeleted = false;
        Ticket thisTicket = null;
        Connection db = null;
        String ticketId = context.getRequest().getParameter("id");
        int formId = Integer.parseInt(context.getRequest().getParameter("formId"));
        try {
            db = this.getConnection(context);
            thisTicket = new Ticket(db, Integer.parseInt(ticketId));
            context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
            this.loadOrganizaton(context, db, thisTicket);
            TicketActivityLog thisMaintenance = new TicketActivityLog();
            thisMaintenance.queryRecord(db, formId);
            if (thisMaintenance.getLinkTicketId() == thisTicket.getId()) {
                if (!AccountTicketActivityLog.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                    String string = "PermissionError";
                    return string;
                }
            } else {
                String string = "PermissionError";
                return string;
            }
            thisMaintenance.setRequest(context.getRequest());
            thisMaintenance.setRelatedContractId(thisTicket.getContractId());
            recordDeleted = thisMaintenance.delete(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.noteDeletion"));
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountTicketActivityLog.do?command=View&id=" + ticketId));
            String string = "DeleteError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        String inline = context.getRequest().getParameter("popupType");
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountTicketActivityLog.do?command=List&id=" + ticketId + (inline != null && "inline".equals(inline) ? "&popup=true" : "")));
            return "DeleteOK";
        }
        this.processErrors(context, thisTicket.getErrors());
        context.getRequest().setAttribute("refreshUrl", (Object)("AccountTicketActivityLog.do?command=View&id=" + ticketId + "&formId=" + formId + (inline != null && "inline".equals(inline) ? "&popup=true" : "")));
        return "DeleteOK";
    }

    private void loadOrganizaton(ActionContext context, Connection db, Ticket ticket) throws SQLException {
        Organization thisOrganization = new Organization(db, ticket.getOrgId());
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
    }
}

