/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketMaintenanceNote;
import org.aspcfs.modules.troubletickets.base.TicketMaintenanceNoteList;
import org.aspcfs.modules.troubletickets.base.TicketReplacementPart;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class AccountTicketMaintenanceNotes
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        Ticket thisTicket;
        Connection db;
        block8: {
            block7: {
                if (!this.hasPermission(context, "accounts-accounts-tickets-maintenance-report-view")) {
                    return "PermissionError";
                }
                db = null;
                String ticketId = context.getRequest().getParameter("id");
                db = this.getConnection(context);
                thisTicket = new Ticket(db, Integer.parseInt(ticketId));
                if (AccountTicketMaintenanceNotes.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block7;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
            this.loadOrganizaton(context, db, thisTicket);
            if (thisTicket.getAssetId() != -1) break block8;
            String string = AccountTicketMaintenanceNotes.getReturn(context, "FormERROR");
            this.freeConnection(context, db);
            return string;
        }
        try {
            this.buildFormElements(context, db);
            TicketMaintenanceNoteList thisList = new TicketMaintenanceNoteList();
            PagedListInfo sunListInfo = this.getPagedListInfo(context, "SunListInfo");
            sunListInfo.setLink("AccountTicketMaintenanceNotes.do?command=List&id=" + thisTicket.getId() + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType"));
            thisList.setPagedListInfo(sunListInfo);
            thisList.setTicketId(thisTicket.getId());
            thisList.buildList(db);
            context.getRequest().setAttribute("maintenanceList", (Object)thisList);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AccountTicketMaintenanceNotes.getReturn(context, "List");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        Ticket thisTicket;
        Connection db;
        block6: {
            if (!this.hasPermission(context, "accounts-accounts-tickets-maintenance-report-add")) {
                return "PermissionError";
            }
            db = null;
            thisTicket = null;
            String ticketId = context.getRequest().getParameter("id");
            db = this.getConnection(context);
            thisTicket = new Ticket(db, Integer.parseInt(ticketId));
            if (AccountTicketMaintenanceNotes.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block6;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
            this.loadOrganizaton(context, db, thisTicket);
            this.buildFormElements(context, db);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AccountTicketMaintenanceNotes.getReturn(context, "Add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        TicketMaintenanceNote thisSun;
        Connection db;
        block8: {
            block7: {
                if (!this.hasPermission(context, "accounts-accounts-tickets-maintenance-report-edit")) {
                    return "PermissionError";
                }
                Ticket thisTicket = null;
                db = null;
                String ticketId = context.getRequest().getParameter("id");
                String formId = context.getRequest().getParameter("formId");
                db = this.getConnection(context);
                thisTicket = new Ticket(db, Integer.parseInt(ticketId));
                context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
                this.loadOrganizaton(context, db, thisTicket);
                this.buildFormElements(context, db);
                context.getRequest().setAttribute("return", (Object)context.getRequest().getParameter("return"));
                thisSun = new TicketMaintenanceNote();
                thisSun.queryRecord(db, Integer.parseInt(formId));
                if (thisSun.getLinkTicketId() != thisTicket.getId()) break block7;
                if (AccountTicketMaintenanceNotes.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block8;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("maintenanceDetails", (Object)thisSun);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AccountTicketMaintenanceNotes.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        boolean isValid;
        Connection db;
        block10: {
            Ticket thisTicket;
            block9: {
                if (!this.hasPermission(context, "accounts-accounts-tickets-maintenance-report-add")) {
                    return "PermissionError";
                }
                db = null;
                isValid = false;
                String ticketId = context.getRequest().getParameter("id");
                db = this.getConnection(context);
                thisTicket = new Ticket(db, Integer.parseInt(ticketId));
                if (AccountTicketMaintenanceNotes.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block9;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            try {
                this.loadOrganizaton(context, db, thisTicket);
                TicketMaintenanceNote thisMaintenance = new TicketMaintenanceNote();
                thisMaintenance.setModifiedBy(this.getUserId(context));
                thisMaintenance.setEnteredBy(this.getUserId(context));
                thisMaintenance.setLinkTicketId(thisTicket.getId());
                String descriptionOfService = context.getRequest().getParameter("descriptionOfService");
                thisMaintenance.setDescriptionOfService(descriptionOfService);
                thisMaintenance.setRequestItems(context.getRequest());
                isValid = this.validateObject(context, db, (Object)thisMaintenance);
                int i = 1;
                for (TicketReplacementPart replacementPart : thisMaintenance.getTicketReplacementPartList()) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    String parseItem = map.put("parseItem", "" + i);
                    String partNumber = map.put("partNumber", replacementPart.getPartNumber());
                    String partDescription = map.put("partDescription", replacementPart.getPartDescription());
                    isValid = this.validateObject(context, db, (Object)replacementPart, map) && isValid;
                    ++i;
                }
                if (isValid) {
                    thisMaintenance.insert(db);
                    break block10;
                }
                context.getRequest().setAttribute("maintenanceDetails", (Object)thisMaintenance);
            }
            catch (Exception e) {
                String string;
                try {
                    context.getRequest().setAttribute("Error", (Object)e);
                    string = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string;
            }
        }
        this.freeConnection(context, db);
        if (isValid) {
            return this.executeCommandList(context);
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        TicketMaintenanceNote thisMaintenance;
        boolean isValid;
        int resultCount;
        Connection db;
        block13: {
            block12: {
                if (!this.hasPermission(context, "accounts-accounts-tickets-maintenance-report-edit")) {
                    return "PermissionError";
                }
                db = null;
                resultCount = -1;
                isValid = false;
                String ticketId = context.getRequest().getParameter("id");
                String formId = context.getRequest().getParameter("formId");
                db = this.getConnection(context);
                Ticket thisTicket = new Ticket(db, Integer.parseInt(ticketId));
                this.loadOrganizaton(context, db, thisTicket);
                thisMaintenance = new TicketMaintenanceNote();
                thisMaintenance.queryRecord(db, Integer.parseInt(formId));
                if (thisMaintenance.getLinkTicketId() != thisTicket.getId()) break block12;
                if (AccountTicketMaintenanceNotes.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block13;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            thisMaintenance.setModifiedBy(this.getUserId(context));
            String descriptionOfService = context.getRequest().getParameter("descriptionOfService");
            thisMaintenance.setDescriptionOfService(descriptionOfService);
            thisMaintenance.setRequestItems(context.getRequest());
            String modified = context.getRequest().getParameter("modified");
            thisMaintenance.setModified(modified);
            isValid = this.validateObject(context, db, (Object)thisMaintenance);
            int i = 1;
            for (TicketReplacementPart replacementPart : thisMaintenance.getTicketReplacementPartList()) {
                HashMap<String, String> map = new HashMap<String, String>();
                String parseItem = map.put("parseItem", "" + i);
                String partNumber = map.put("partNumber", replacementPart.getPartNumber());
                String partDescription = map.put("partDescription", replacementPart.getPartDescription());
                isValid = this.validateObject(context, db, (Object)replacementPart, map) && isValid;
                ++i;
            }
            if (isValid) {
                resultCount = thisMaintenance.update(db);
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandList(context);
            }
            return this.executeCommandView(context);
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandModify(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        Connection db;
        block7: {
            String string;
            block6: {
                if (!this.hasPermission(context, "accounts-accounts-tickets-maintenance-report-view")) {
                    return "PermissionError";
                }
                db = null;
                String ticketId = context.getRequest().getParameter("id");
                String formId = context.getRequest().getParameter("formId");
                db = this.getConnection(context);
                Ticket thisTicket = new Ticket(db, Integer.parseInt(ticketId));
                context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
                this.loadOrganizaton(context, db, thisTicket);
                this.buildFormElements(context, db);
                TicketMaintenanceNote thisSun = new TicketMaintenanceNote();
                thisSun.queryRecord(db, Integer.parseInt(formId));
                context.getRequest().setAttribute("maintenanceDetails", (Object)thisSun);
                if (thisSun.getLinkTicketId() != thisTicket.getId()) break block6;
                if (AccountTicketMaintenanceNotes.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block7;
                String string2 = "PermissionError";
                this.freeConnection(context, db);
                return string2;
            }
            try {
                string = "PermissionError";
            }
            catch (Exception e) {
                String string3;
                try {
                    context.getRequest().setAttribute("Error", (Object)e);
                    string3 = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string3;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        return AccountTicketMaintenanceNotes.getReturn(context, "View");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        SystemStatus systemStatus;
        String formId;
        String ticketId;
        HtmlDialog htmlDialog;
        Connection db;
        block8: {
            block7: {
                if (!this.hasPermission(context, "accounts-accounts-tickets-maintenance-report-delete")) {
                    return "PermissionError";
                }
                db = null;
                htmlDialog = new HtmlDialog();
                ticketId = context.getRequest().getParameter("id");
                formId = context.getRequest().getParameter("formId");
                db = this.getConnection(context);
                systemStatus = this.getSystemStatus(context);
                Ticket thisTicket = new Ticket();
                thisTicket.queryRecord(db, Integer.parseInt(ticketId));
                context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
                TicketMaintenanceNote thisMaintenance = new TicketMaintenanceNote();
                thisMaintenance.queryRecord(db, Integer.parseInt(formId));
                if (thisMaintenance.getLinkTicketId() != thisTicket.getId()) break block7;
                if (AccountTicketMaintenanceNotes.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) break block8;
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n");
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.formHeader"));
            htmlDialog.addButton(systemStatus.getLabel("button.delete"), "javascript:window.location.href='AccountTicketMaintenanceNotes.do?command=Delete&id=" + ticketId + "&formId=" + formId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-maintenance-report-delete")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean recordDeleted = false;
        Ticket thisTicket = null;
        Connection db = null;
        String ticketId = context.getRequest().getParameter("id");
        int formId = Integer.parseInt(context.getRequest().getParameter("formId"));
        try {
            db = this.getConnection(context);
            thisTicket = new Ticket(db, Integer.parseInt(ticketId));
            context.getRequest().setAttribute("ticketDetails", (Object)thisTicket);
            this.loadOrganizaton(context, db, thisTicket);
            TicketMaintenanceNote thisMaintenance = new TicketMaintenanceNote();
            thisMaintenance.queryRecord(db, formId);
            if (thisMaintenance.getLinkTicketId() == thisTicket.getId()) {
                if (!AccountTicketMaintenanceNotes.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                    String string = "PermissionError";
                    return string;
                }
            } else {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisMaintenance.delete(db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.noteDeletion"));
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountTicketMaintenanceNotes.do?command=View&id=" + ticketId));
            String string = "DeleteError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        String inline = context.getRequest().getParameter("popupType");
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountTicketMaintenanceNotes.do?command=List&id=" + ticketId + (inline != null && "inline".equals(inline) ? "&popup=true" : "")));
            return "DeleteOK";
        }
        this.processErrors(context, thisTicket.getErrors());
        context.getRequest().setAttribute("refreshUrl", (Object)("AccountTicketMaintenanceNotes.do?command=View&id=" + ticketId + "&formId=" + formId + (inline != null && "inline".equals(inline) ? "&popup=true" : "")));
        return "DeleteOK";
    }

    private void loadOrganizaton(ActionContext context, Connection db, Ticket ticket) throws SQLException {
        Organization thisOrganization = new Organization(db, ticket.getOrgId());
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
    }

    private void buildFormElements(ActionContext context, Connection db) throws SQLException {
        LookupList onsiteModelList = new LookupList(db, "lookup_onsite_model");
        onsiteModelList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("onsiteModelList", (Object)onsiteModelList);
        LookupList assetVendorList = new LookupList(db, "lookup_asset_vendor");
        assetVendorList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("assetVendorList", (Object)assetVendorList);
        LookupList assetManufacturerList = new LookupList(db, "lookup_asset_manufacturer");
        assetManufacturerList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("assetManufacturerList", (Object)assetManufacturerList);
    }
}

