/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actionplans.base.ActionPlanList;
import org.aspcfs.modules.actionplans.base.ActionPlanWorkList;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.CategoryEditor;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.products.base.CustomerProduct;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.modules.troubletickets.base.TicketCategory;
import org.aspcfs.modules.troubletickets.base.TicketCategoryAssignment;
import org.aspcfs.modules.troubletickets.base.TicketCategoryList;
import org.aspcfs.modules.troubletickets.base.TicketDefect;
import org.aspcfs.modules.troubletickets.base.TicketDefectList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.RequestUtils;

public final class AccountTickets
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        return AccountTickets.getReturn(context, "Include");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReopenTicket(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-edit")) {
            return "PermissionError";
        }
        int resultCount = -1;
        Connection db = null;
        Ticket thisTicket = null;
        Ticket oldTicket = null;
        try {
            db = this.getConnection(context);
            thisTicket = new Ticket(db, Integer.parseInt(context.getRequest().getParameter("id")));
            oldTicket = new Ticket(db, thisTicket.getId());
            if (!AccountTickets.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            thisTicket.setModifiedBy(this.getUserId(context));
            resultCount = thisTicket.reopen(db);
            thisTicket.queryRecord(db, thisTicket.getId());
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == -1) {
            return this.executeCommandTicketDetails(context);
        }
        if (resultCount == 1) {
            this.processUpdateHook(context, (Object)oldTicket, (Object)thisTicket);
            return this.executeCommandTicketDetails(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddTicket(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-add")) {
            return "PermissionError";
        }
        Connection db = null;
        Ticket newTic = null;
        Organization newOrg = null;
        String temporgId = context.getRequest().getParameter("orgId");
        int tempid = Integer.parseInt(temporgId);
        try {
            db = this.getConnection(context);
            if (!AccountTickets.isRecordAccessPermitted(context, db, tempid)) {
                String string = "PermissionError";
                return string;
            }
            newOrg = new Organization(db, tempid);
            newTic = (Ticket)((Object)context.getFormBean());
            if (!(context.getRequest().getParameter("refresh") != null || context.getRequest().getParameter("contact") != null && context.getRequest().getParameter("contact").equals("on"))) {
                newTic.setOrgId(tempid);
            }
            this.buildFormElements(context, db, newTic, newOrg);
            this.addModuleBean(context, "View Accounts", "Add a Ticket");
            context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
            String currentDate = AccountTickets.getCurrentDateAsString(context);
            context.getRequest().setAttribute("currentDate", (Object)currentDate);
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountTickets.getReturn(context, "AddTicket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertTicket(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean contactRecordInserted = false;
        boolean isValid = true;
        Contact nc = null;
        Ticket newTicket = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        String newContact = context.getRequest().getParameter("contact");
        Ticket newTic = (Ticket)((Object)context.getFormBean());
        if (newTic.getAssignedTo() > -1 && newTic.getAssignedDate() == null) {
            newTic.setAssignedDate(new Timestamp(System.currentTimeMillis()));
        }
        newTic.setEnteredBy(this.getUserId(context));
        newTic.setModifiedBy(this.getUserId(context));
        if (newContact != null && newContact.equals("on")) {
            nc = new Contact();
            nc.setNameFirst(context.getRequest().getParameter("thisContact_nameFirst"));
            nc.setNameLast(context.getRequest().getParameter("thisContact_nameLast"));
            nc.setTitle(context.getRequest().getParameter("thisContact_title"));
            nc.setRequestItems(context);
            nc.setOrgId(newTic.getOrgId());
            nc.setEnteredBy(this.getUserId(context));
            nc.setModifiedBy(this.getUserId(context));
            nc.setOwner(this.getUserId(context));
        }
        try {
            Object sourceList;
            db = this.getConnection(context);
            String temporgId = context.getRequest().getParameter("orgId");
            int tempid = Integer.parseInt(temporgId);
            if (AccountTickets.isPortalUser(context)) {
                sourceList = new LookupList(db, "lookup_ticketsource");
                newTic.setSourceCode(((LookupList)sourceList).getIdFromValue("Web"));
            }
            if (!AccountTickets.isRecordAccessPermitted(context, db, newTic.getOrgId())) {
                sourceList = "PermissionError";
                return sourceList;
            }
            Organization newOrg = new Organization(db, tempid);
            context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
            if (nc != null) {
                boolean bl = isValid = this.validateObject(context, db, (Object)nc) && isValid;
                if (isValid) {
                    contactRecordInserted = nc.insert(db);
                }
                if (contactRecordInserted) {
                    newTic.setContactId(nc.getId());
                }
                if (contactRecordInserted) {
                    if (newTic.getOrgId() > 0) {
                        newTic.setSiteId(Organization.getOrganizationSiteId(db, newTic.getOrgId()));
                    }
                    if (isValid = this.validateObject(context, db, (Object)newTic)) {
                        recordInserted = newTic.insert(db);
                    }
                }
            } else {
                if (newTic.getOrgId() > 0) {
                    newTic.setSiteId(Organization.getOrganizationSiteId(db, newTic.getOrgId()));
                }
                boolean bl = isValid = this.validateObject(context, db, (Object)newTic) && isValid;
                if (isValid) {
                    recordInserted = newTic.insert(db);
                }
            }
            if (recordInserted) {
                newTicket = new Ticket(db, newTic.getId());
                context.getRequest().setAttribute("TicketDetails", (Object)newTicket);
                if (newTicket.getProductId() != -1) {
                    ProductCatalog product = new ProductCatalog(db, newTicket.getProductId());
                    context.getRequest().setAttribute("product", (Object)product);
                }
                if (newTicket.getCustomerProductId() != -1) {
                    CustomerProduct customerProduct = new CustomerProduct(db, newTicket.getCustomerProductId());
                    customerProduct.buildFileList(db);
                    context.getRequest().setAttribute("customerProduct", (Object)customerProduct);
                }
                if (newTicket.getDefectId() != -1) {
                    TicketDefect defect = new TicketDefect(db, newTicket.getDefectId());
                    context.getRequest().setAttribute("defect", (Object)defect);
                }
                LookupList ticketStateList = new LookupList(db, "lookup_ticket_state");
                ticketStateList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
                context.getRequest().setAttribute("ticketStateList", (Object)ticketStateList);
                TicketCategoryList ticketCategoryList = new TicketCategoryList();
                ticketCategoryList.setSiteId(newOrg.getSiteId());
                ticketCategoryList.setExclusiveToSite(true);
                ticketCategoryList.setEnabledState(1);
                ticketCategoryList.buildList(db);
                context.getRequest().setAttribute("ticketCategoryList", (Object)ticketCategoryList);
                this.addRecentItem(context, (Object)newTicket);
                this.processInsertHook(context, (Object)newTic);
            }
            this.addModuleBean(context, "View Accounts", "Ticket Insert ok");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return AccountTickets.getReturn(context, "InsertTicket");
        }
        return this.executeCommandAddTicket(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTicketDetails(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String ticketId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            Ticket newTic = new Ticket();
            newTic.setBuildHistory(true);
            SystemStatus systemStatus = this.getSystemStatus(context);
            newTic.setSystemStatus(systemStatus);
            newTic.setBuildOrgHierarchy(true);
            newTic.queryRecord(db, Integer.parseInt(ticketId));
            if (!AccountTickets.isRecordAccessPermitted(context, db, newTic.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            if (newTic.getProductId() != -1) {
                ProductCatalog product = new ProductCatalog(db, newTic.getProductId());
                context.getRequest().setAttribute("product", (Object)product);
                QuoteList quoteList = new QuoteList();
                quoteList.setTicketId(newTic.getId());
                quoteList.buildList(db);
                context.getRequest().setAttribute("quoteList", (Object)quoteList);
            }
            LookupList causeList = new LookupList(db, "lookup_ticket_cause");
            causeList.addItem(-1, "");
            context.getRequest().setAttribute("causeList", (Object)causeList);
            LookupList ticketStateList = new LookupList(db, "lookup_ticket_state");
            ticketStateList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ticketStateList", (Object)ticketStateList);
            LookupList resolutionList = new LookupList(db, "lookup_ticket_resolution");
            resolutionList.addItem(-1, "");
            context.getRequest().setAttribute("resolutionList", (Object)resolutionList);
            if (newTic.getCustomerProductId() != -1) {
                CustomerProduct customerProduct = new CustomerProduct(db, newTic.getCustomerProductId());
                customerProduct.buildFileList(db);
                context.getRequest().setAttribute("customerProduct", (Object)customerProduct);
            }
            if (newTic.getDefectId() != -1) {
                TicketDefect defect = new TicketDefect(db, newTic.getDefectId());
                context.getRequest().setAttribute("defect", (Object)defect);
            }
            if (newTic.getAssignedTo() > 0) {
                newTic.checkEnabledOwnerAccount(db);
            }
            context.getRequest().setAttribute("TicketDetails", (Object)newTic);
            this.addRecentItem(context, (Object)newTic);
            Organization thisOrganization = new Organization(db, newTic.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            this.addModuleBean(context, "View Accounts", "View Tickets");
            this.deletePagedListInfo(context, "AccountTicketsFolderInfo");
            this.deletePagedListInfo(context, "AccountTicketDocumentListInfo");
            this.deletePagedListInfo(context, "AccountTicketTaskListInfo");
            this.deletePagedListInfo(context, "accountTicketPlanWorkListInfo");
            TicketCategoryList ticketCategoryList = new TicketCategoryList();
            ticketCategoryList.setEnabledState(1);
            ticketCategoryList.setSiteId(thisOrganization.getSiteId());
            ticketCategoryList.setExclusiveToSite(true);
            ticketCategoryList.buildList(db);
            context.getRequest().setAttribute("ticketCategoryList", (Object)ticketCategoryList);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountTickets.getReturn(context, "TicketDetails");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        String id = context.getRequest().getParameter("id");
        int orgId = Integer.parseInt(context.getRequest().getParameter("orgId"));
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            Ticket ticket = new Ticket(db, Integer.parseInt(id));
            if (!AccountTickets.isRecordAccessPermitted(context, db, ticket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = ticket.processDependencies(db);
            HtmlDialog htmlDialog = new HtmlDialog();
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='AccountTickets.do?command=DeleteTicket&id=" + id + "&orgId=" + orgId + "&forceDelete=true" + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId") + "'");
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            String string = "ConfirmDeleteOK";
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteTicket(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        Connection db = null;
        int orgId = Integer.parseInt(context.getRequest().getParameter("orgId"));
        String passedId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            Organization newOrg = new Organization(db, orgId);
            Ticket thisTic = new Ticket(db, Integer.parseInt(passedId));
            if (!AccountTickets.isRecordAccessPermitted(context, db, thisTic.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisTic.delete(db, AccountTickets.getDbNamePath(context));
            if (recordDeleted) {
                this.processDeleteHook(context, (Object)thisTic);
                this.deleteRecentItem(context, (Object)thisTic);
                String inline = context.getRequest().getParameter("popupType");
                context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
                context.getRequest().setAttribute("refreshUrl", (Object)("Accounts.do?command=ViewTickets&orgId=" + orgId + (inline != null && "inline".equals(inline.trim()) ? "&popup=true" : "")));
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordDeleted) {
            return "DeleteTicketOK";
        }
        return this.executeCommandTicketDetails(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrashTicket(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-delete")) {
            return "PermissionError";
        }
        boolean recordUpdated = false;
        Connection db = null;
        int orgId = Integer.parseInt(context.getRequest().getParameter("orgId"));
        String passedId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            Organization newOrg = new Organization(db, orgId);
            Ticket thisTic = new Ticket(db, Integer.parseInt(passedId));
            if (!AccountTickets.isRecordAccessPermitted(context, db, thisTic.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            recordUpdated = thisTic.updateStatus(db, true, this.getUserId(context));
            if (recordUpdated) {
                this.processDeleteHook(context, (Object)thisTic);
                this.deleteRecentItem(context, (Object)thisTic);
                context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
                String inline = context.getRequest().getParameter("popupType");
                context.getRequest().setAttribute("refreshUrl", (Object)("Accounts.do?command=ViewTickets&orgId=" + orgId + (inline != null && "inline".equals(inline) ? "&popup=true" : "")));
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordUpdated) {
            return "DeleteTicketOK";
        }
        return this.executeCommandTicketDetails(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRestoreTicket(ActionContext context) {
        if (!this.hasPermission(context, "tickets-tickets-edit")) {
            return "PermissionError";
        }
        boolean recordUpdated = false;
        Connection db = null;
        Ticket thisTicket = null;
        try {
            db = this.getConnection(context);
            thisTicket = new Ticket(db, Integer.parseInt(context.getRequest().getParameter("id")));
            if (!AccountTickets.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            thisTicket.setModifiedBy(this.getUserId(context));
            recordUpdated = thisTicket.updateStatus(db, false, this.getUserId(context));
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordUpdated) {
            return this.executeCommandTicketDetails(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyTicket(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        Ticket newTic = null;
        String ticketId = context.getRequest().getParameter("id");
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            User user = this.getUser(context, this.getUserId(context));
            if (context.getRequest().getParameter("companyName") == null) {
                newTic = new Ticket(db, Integer.parseInt(ticketId));
            } else {
                newTic = (Ticket)((Object)context.getFormBean());
                newTic.buildRelatedInformation(db);
            }
            if (!AccountTickets.isRecordAccessPermitted(context, db, newTic.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            Organization thisOrganization = new Organization(db, newTic.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            LookupList departmentList = new LookupList(db, "lookup_department");
            departmentList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            departmentList.setJsEvent("onChange=\"javascript:updateUserList();javascript:resetAssignedDate();\"");
            context.getRequest().setAttribute("DepartmentList", (Object)departmentList);
            LookupList ticketStateList = new LookupList(db, "lookup_ticket_state");
            ticketStateList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ticketStateList", (Object)ticketStateList);
            LookupList resolvedByDeptList = new LookupList(db, "lookup_department");
            resolvedByDeptList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            resolvedByDeptList.setJsEvent("onChange=\"javascript:updateResolvedByUserList();\"");
            context.getRequest().setAttribute("resolvedByDeptList", (Object)resolvedByDeptList);
            LookupList severityList = new LookupList(db, "ticket_severity");
            context.getRequest().setAttribute("SeverityList", (Object)severityList);
            LookupList priorityList = new LookupList(db, "ticket_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList sourceList = new LookupList(db, "lookup_ticketsource");
            sourceList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SourceList", (Object)sourceList);
            LookupList causeList = new LookupList(db, "lookup_ticket_cause");
            causeList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("causeList", (Object)causeList);
            LookupList resolutionList = new LookupList(db, "lookup_ticket_resolution");
            resolutionList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("resolutionList", (Object)resolutionList);
            TicketDefectList list = new TicketDefectList();
            list.setSiteId(newTic.getOrgSiteId());
            list.buildList(db);
            HtmlSelect defectSelect = list.getHtmlSelectObj(newTic.getDefectId());
            defectSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes", "None"), 0);
            context.getRequest().setAttribute("defectSelect", (Object)defectSelect);
            LookupList escalationList = new LookupList(db, "lookup_ticket_escalation");
            escalationList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("EscalationList", (Object)escalationList);
            TicketCategoryList categoryList = new TicketCategoryList();
            categoryList.setCatLevel(0);
            categoryList.setSiteId(thisOrganization.getSiteId());
            categoryList.setExclusiveToSite(true);
            categoryList.setParentCode(0);
            categoryList.setHtmlJsEvent("onChange=\"javascript:updateSubList1();\"");
            categoryList.buildList(db);
            categoryList.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("CategoryList", (Object)categoryList);
            UserList userList = new UserList();
            userList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            userList.setHidden(0);
            userList.setBuildContact(true);
            userList.setBuildContactDetails(false);
            userList.setDepartment(newTic.getDepartmentCode() != -1 ? newTic.getDepartmentCode() : 0);
            userList.setExcludeDisabledIfUnselected(true);
            userList.setExcludeExpiredIfUnselected(true);
            userList.setRoleType(0);
            userList.setSiteId(newTic.getOrgSiteId());
            userList.setIncludeUsersWithAccessToAllSites(true);
            userList.buildList(db);
            context.getRequest().setAttribute("UserList", (Object)userList);
            UserList resolvedUserList = new UserList();
            resolvedUserList.setHidden(0);
            resolvedUserList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            resolvedUserList.setBuildContact(true);
            resolvedUserList.setBuildContactDetails(false);
            resolvedUserList.setExcludeDisabledIfUnselected(true);
            resolvedUserList.setExcludeExpiredIfUnselected(true);
            resolvedUserList.setRoleType(0);
            resolvedUserList.setDepartment(newTic.getResolvedByDeptCode() != -1 ? newTic.getResolvedByDeptCode() : 0);
            resolvedUserList.setSiteId(newTic.getOrgSiteId());
            resolvedUserList.setIncludeUsersWithAccessToAllSites(true);
            resolvedUserList.buildList(db);
            context.getRequest().setAttribute("resolvedUserList", (Object)resolvedUserList);
            TicketCategoryList subList1 = new TicketCategoryList();
            subList1.setCatLevel(1);
            subList1.setSiteId(thisOrganization.getSiteId());
            subList1.setExclusiveToSite(true);
            subList1.setParentCode(newTic.getCatCode());
            subList1.setHtmlJsEvent("onChange=\"javascript:updateSubList2();\"");
            subList1.buildList(db);
            subList1.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList1", (Object)subList1);
            ContactList contactList = new ContactList();
            if (newTic != null && newTic.getOrgId() != -1) {
                contactList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
                contactList.setBuildDetails(false);
                contactList.setBuildTypes(false);
                contactList.setOrgId(newTic.getOrgId());
                contactList.setDefaultContactId(newTic.getContactId());
                contactList.buildList(db);
            }
            context.getRequest().setAttribute("ContactList", (Object)contactList);
            TicketCategoryList subList2 = new TicketCategoryList();
            subList2.setCatLevel(2);
            subList2.setSiteId(thisOrganization.getSiteId());
            subList2.setExclusiveToSite(true);
            if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == 1) {
                subList2.setParentCode(0);
                newTic.setSubCat1(0);
                newTic.setSubCat2(0);
                newTic.setSubCat3(0);
            } else if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == -1) {
                subList2.setParentCode(newTic.getSubCat1());
                subList2.getCatListSelect().setDefaultKey(newTic.getSubCat2());
            } else {
                subList2.setParentCode(newTic.getSubCat1());
            }
            subList2.setHtmlJsEvent("onChange=\"javascript:updateSubList3();\"");
            subList2.buildList(db);
            subList2.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList2", (Object)subList2);
            TicketCategoryList subList3 = new TicketCategoryList();
            subList3.setCatLevel(3);
            subList3.setSiteId(thisOrganization.getSiteId());
            subList3.setExclusiveToSite(true);
            if (context.getRequest().getParameter("refresh") != null && (Integer.parseInt(context.getRequest().getParameter("refresh")) == 1 || Integer.parseInt(context.getRequest().getParameter("refresh")) == 2)) {
                subList3.setParentCode(0);
                newTic.setSubCat2(0);
                newTic.setSubCat3(0);
            } else if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == -1) {
                subList3.setParentCode(newTic.getSubCat2());
                subList3.getCatListSelect().setDefaultKey(newTic.getSubCat3());
            } else {
                subList3.setParentCode(newTic.getSubCat2());
            }
            subList3.setHtmlJsEvent("onChange=\"javascript:updateSubList4();\"");
            subList3.buildList(db);
            subList3.getCatListSelect().addItem(0, "Undetermined");
            context.getRequest().setAttribute("SubList3", (Object)subList3);
            if (context.getRequest().getParameter("refresh") != null && (Integer.parseInt(context.getRequest().getParameter("refresh")) == 1 || Integer.parseInt(context.getRequest().getParameter("refresh")) == 3)) {
                newTic.setSubCat3(0);
            }
            ActionPlanList actionPlans = new ActionPlanList();
            actionPlans.setLinkObjectId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
            if (newTic.getCatCode() > 0) {
                actionPlans.setLinkCatCode(newTic.getCatCode());
            }
            if (newTic.getSubCat1() > 0) {
                actionPlans.setLinkSubCat1(newTic.getSubCat1());
            }
            if (newTic.getSubCat2() > 0) {
                actionPlans.setLinkSubCat2(newTic.getSubCat2());
            }
            if (newTic.getSubCat3() > 0) {
                actionPlans.setLinkSubCat3(newTic.getSubCat3());
            }
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, 202041401);
            actionPlans.setNameTable(thisEditor.getTableName());
            actionPlans.setSiteId(thisOrganization.getSiteId());
            actionPlans.setJsEvent("id=\"actionPlanId\"");
            actionPlans.setEnabled(1);
            actionPlans.setIncludeOnlyApproved(1);
            if (actionPlans.getLinkCatCode() <= 0 && actionPlans.getLinkSubCat1() <= 0 && actionPlans.getLinkSubCat2() <= 0 && actionPlans.getLinkSubCat3() <= 0) {
                actionPlans.setDisplayNone(true);
            }
            actionPlans.buildList(db);
            ActionPlanWorkList workList = new ActionPlanWorkList();
            workList.setLinkModuleId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
            workList.setLinkItemId(newTic.getId());
            workList.setSiteId(newTic.getSiteId());
            if (user.getSiteId() == -1) {
                workList.setIncludeAllSites(true);
            }
            workList.buildList(db);
            if (workList.size() > 0) {
                context.getRequest().setAttribute("insertActionPlan", (Object)String.valueOf(true));
            }
            actionPlans.addAtleastOne(db, workList);
            context.getRequest().setAttribute("actionPlans", (Object)actionPlans);
            this.addRecentItem(context, (Object)newTic);
            context.getRequest().setAttribute("TicketDetails", (Object)newTic);
            this.addModuleBean(context, "View Accounts", "View Tickets");
            String currentDate = AccountTickets.getCurrentDateAsString(context);
            context.getRequest().setAttribute("currentDate", (Object)currentDate);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountTickets.getReturn(context, "ModifyTicket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateTicket(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = 0;
        int catCount = 0;
        TicketCategory thisCat = null;
        boolean catInserted = false;
        boolean isValid = true;
        Ticket newTic = (Ticket)((Object)context.getFormBean());
        if (newTic.getAssignedTo() > -1 && newTic.getAssignedDate() == null) {
            newTic.setAssignedDate(new Timestamp(System.currentTimeMillis()));
        }
        if (context.getRequest().getParameter("close").equals("1")) {
            newTic.setCloseIt(true);
        }
        try {
            db = this.getConnection(context);
            Organization orgDetails = new Organization(db, newTic.getOrgId());
            if (!AccountTickets.isRecordAccessPermitted(context, db, newTic.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            for (catCount = 0; catCount < 4; ++catCount) {
                if (context.getRequest().getParameter("newCat" + catCount + "chk") == null || !context.getRequest().getParameter("newCat" + catCount + "chk").equals("on") || context.getRequest().getParameter("newCat" + catCount) == null || context.getRequest().getParameter("newCat" + catCount).equals("")) continue;
                thisCat = new TicketCategory();
                thisCat.setSiteId(orgDetails.getSiteId());
                if (catCount == 0) {
                    thisCat.setParentCode(0);
                } else if (catCount == 1) {
                    thisCat.setParentCode(newTic.getCatCode());
                } else if (catCount == 2) {
                    thisCat.setParentCode(newTic.getSubCat1());
                } else {
                    thisCat.setParentCode(newTic.getSubCat2());
                }
                thisCat.setDescription(context.getRequest().getParameter("newCat" + catCount));
                thisCat.setCategoryLevel(catCount);
                thisCat.setLevel(catCount);
                boolean bl = isValid = this.validateObject(context, db, (Object)thisCat) && isValid;
                if (!isValid || !(catInserted = thisCat.insert(db))) continue;
                if (catCount == 0) {
                    newTic.setCatCode(thisCat.getId());
                    continue;
                }
                if (catCount == 1) {
                    newTic.setSubCat1(thisCat.getId());
                    continue;
                }
                if (catCount == 2) {
                    newTic.setSubCat2(thisCat.getId());
                    continue;
                }
                newTic.setSubCat3(thisCat.getId());
            }
            Ticket previousTicket = new Ticket(db, newTic.getId());
            newTic.setModifiedBy(this.getUserId(context));
            newTic.setSiteId(Organization.getOrganizationSiteId(db, newTic.getOrgId()));
            boolean bl = isValid = this.validateObject(context, db, (Object)newTic) && isValid;
            if (isValid) {
                resultCount = newTic.update(db);
            }
            if (resultCount == 1) {
                newTic.queryRecord(db, newTic.getId());
                this.processUpdateHook(context, (Object)previousTicket, (Object)newTic);
                TicketCategoryList ticketCategoryList = new TicketCategoryList();
                ticketCategoryList.setEnabledState(1);
                ticketCategoryList.setSiteId(newTic.getSiteId());
                ticketCategoryList.setExclusiveToSite(true);
                ticketCategoryList.buildList(db);
                context.getRequest().setAttribute("ticketCategoryList", (Object)ticketCategoryList);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1 && isValid) {
            return "UpdateTicketOK";
        }
        return this.executeCommandModifyTicket(context);
    }

    protected void buildFormElements(ActionContext context, Connection db, Ticket newTic, Organization newOrg) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList departmentList = new LookupList(db, "lookup_department");
        departmentList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        departmentList.setJsEvent("onChange=\"javascript:updateUserList();javascript:resetAssignedDate();\"");
        context.getRequest().setAttribute("DepartmentList", (Object)departmentList);
        LookupList ticketStateList = new LookupList(db, "lookup_ticket_state");
        ticketStateList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("ticketStateList", (Object)ticketStateList);
        LookupList resolvedByDeptList = new LookupList(db, "lookup_department");
        resolvedByDeptList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        resolvedByDeptList.setJsEvent("onChange=\"javascript:updateResolvedByUserList();\"");
        context.getRequest().setAttribute("resolvedByDeptList", (Object)resolvedByDeptList);
        LookupList severityList = new LookupList(db, "ticket_severity");
        context.getRequest().setAttribute("SeverityList", (Object)severityList);
        LookupList priorityList = new LookupList(db, "ticket_priority");
        context.getRequest().setAttribute("PriorityList", (Object)priorityList);
        LookupList sourceList = new LookupList(db, "lookup_ticketsource");
        sourceList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SourceList", (Object)sourceList);
        LookupList causeList = new LookupList(db, "lookup_ticket_cause");
        causeList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("causeList", (Object)causeList);
        LookupList resolutionList = new LookupList(db, "lookup_ticket_resolution");
        resolutionList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("resolutionList", (Object)resolutionList);
        LookupList escalationList = new LookupList(db, "lookup_ticket_escalation");
        escalationList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("EscalationList", (Object)escalationList);
        TicketCategoryList categoryList = new TicketCategoryList();
        categoryList.setCatLevel(0);
        categoryList.setParentCode(0);
        categoryList.setSiteId(newOrg.getSiteId());
        categoryList.setExclusiveToSite(true);
        categoryList.setHtmlJsEvent("onChange=\"javascript:updateSubList1();\"");
        categoryList.buildList(db);
        categoryList.getCatListSelect().addItem(0, "Undetermined");
        context.getRequest().setAttribute("CategoryList", (Object)categoryList);
        UserList userList = new UserList();
        userList.setHidden(0);
        userList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
        userList.setBuildContact(true);
        userList.setBuildContactDetails(false);
        userList.setExcludeDisabledIfUnselected(true);
        userList.setExcludeExpiredIfUnselected(true);
        userList.setRoleType(0);
        userList.setDepartment(newTic.getDepartmentCode() != -1 ? newTic.getDepartmentCode() : 0);
        userList.setSiteId(newOrg.getSiteId());
        userList.setIncludeUsersWithAccessToAllSites(true);
        userList.buildList(db);
        context.getRequest().setAttribute("UserList", (Object)userList);
        UserList resolvedUserList = new UserList();
        resolvedUserList.setHidden(0);
        resolvedUserList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
        resolvedUserList.setBuildContact(true);
        resolvedUserList.setBuildContactDetails(false);
        resolvedUserList.setExcludeDisabledIfUnselected(true);
        resolvedUserList.setExcludeExpiredIfUnselected(true);
        resolvedUserList.setRoleType(0);
        resolvedUserList.setDepartment(newTic.getResolvedByDeptCode() != -1 ? newTic.getResolvedByDeptCode() : 0);
        resolvedUserList.setSiteId(newOrg.getSiteId());
        resolvedUserList.setIncludeUsersWithAccessToAllSites(true);
        resolvedUserList.buildList(db);
        context.getRequest().setAttribute("resolvedUserList", (Object)resolvedUserList);
        ContactList contactList = new ContactList();
        contactList.setBuildDetails(false);
        contactList.setBuildTypes(false);
        contactList.setOrgId(Integer.parseInt(context.getRequest().getParameter("orgId")));
        contactList.setDefaultContactId(newTic.getContactId());
        contactList.buildList(db);
        context.getRequest().setAttribute("ContactList", (Object)contactList);
        TicketDefectList list = new TicketDefectList();
        list.setSiteId(newOrg.getSiteId());
        list.buildList(db);
        HtmlSelect defectSelect = list.getHtmlSelectObj(newTic.getDefectId());
        defectSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes", "None"), 0);
        context.getRequest().setAttribute("defectSelect", (Object)defectSelect);
        TicketCategoryList subList1 = new TicketCategoryList();
        subList1.setCatLevel(1);
        subList1.setSiteId(newOrg.getSiteId());
        subList1.setExclusiveToSite(true);
        subList1.setParentCode(newTic.getCatCode());
        subList1.setHtmlJsEvent("onChange=\"javascript:updateSubList2();\"");
        subList1.buildList(db);
        subList1.getCatListSelect().addItem(0, "Undetermined");
        context.getRequest().setAttribute("SubList1", (Object)subList1);
        TicketCategoryList subList2 = new TicketCategoryList();
        subList2.setCatLevel(2);
        subList2.setSiteId(newOrg.getSiteId());
        subList2.setExclusiveToSite(true);
        if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == 1) {
            subList2.setParentCode(0);
            newTic.setSubCat1(0);
            newTic.setSubCat2(0);
            newTic.setSubCat3(0);
        } else if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == -1) {
            subList2.setParentCode(newTic.getSubCat1());
            subList2.getCatListSelect().setDefaultKey(newTic.getSubCat2());
        } else {
            subList2.setParentCode(newTic.getSubCat1());
        }
        subList2.setHtmlJsEvent("onChange=\"javascript:updateSubList3();\"");
        subList2.buildList(db);
        subList2.getCatListSelect().addItem(0, "Undetermined");
        context.getRequest().setAttribute("SubList2", (Object)subList2);
        TicketCategoryList subList3 = new TicketCategoryList();
        subList3.setCatLevel(3);
        subList3.setSiteId(newOrg.getSiteId());
        subList3.setExclusiveToSite(true);
        if (context.getRequest().getParameter("refresh") != null && (Integer.parseInt(context.getRequest().getParameter("refresh")) == 1 || Integer.parseInt(context.getRequest().getParameter("refresh")) == 2)) {
            subList3.setParentCode(0);
            newTic.setSubCat2(0);
            newTic.setSubCat3(0);
        } else if (context.getRequest().getParameter("refresh") != null && Integer.parseInt(context.getRequest().getParameter("refresh")) == -1) {
            subList3.setParentCode(newTic.getSubCat2());
            subList3.getCatListSelect().setDefaultKey(newTic.getSubCat3());
        } else {
            subList3.setParentCode(newTic.getSubCat2());
        }
        subList3.setHtmlJsEvent("onChange=\"javascript:updateSubList4();\"");
        subList3.buildList(db);
        subList3.getCatListSelect().addItem(0, "Undetermined");
        context.getRequest().setAttribute("SubList3", (Object)subList3);
        ActionPlanList actionPlans = new ActionPlanList();
        actionPlans.setLinkObjectId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
        if (newTic.getCatCode() > 0) {
            actionPlans.setLinkCatCode(newTic.getCatCode());
        }
        if (newTic.getSubCat1() > 0) {
            actionPlans.setLinkSubCat1(newTic.getSubCat1());
        }
        if (newTic.getSubCat2() > 0) {
            actionPlans.setLinkSubCat2(newTic.getSubCat2());
        }
        if (newTic.getSubCat3() > 0) {
            actionPlans.setLinkSubCat3(newTic.getSubCat3());
        }
        if (actionPlans.getLinkCatCode() <= 0 && actionPlans.getLinkSubCat1() <= 0 && actionPlans.getLinkSubCat2() <= 0 && actionPlans.getLinkSubCat3() <= 0) {
            actionPlans.setDisplayNone(true);
        }
        CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, 202041401);
        actionPlans.setNameTable(thisEditor.getTableName());
        actionPlans.setJsEvent("id=\"actionPlanId\"");
        actionPlans.setEnabled(1);
        actionPlans.setSiteId(newOrg.getSiteId());
        actionPlans.setIncludeOnlyApproved(1);
        actionPlans.buildList(db);
        context.getRequest().setAttribute("actionPlans", (Object)actionPlans);
        if (context.getRequest().getParameter("insertActionPlan") != null && !"".equals(context.getRequest().getParameter("insertActionPlan"))) {
            context.getRequest().setAttribute("insertActionPlan", (Object)String.valueOf(true));
        }
        if (context.getRequest().getParameter("refresh") != null && (Integer.parseInt(context.getRequest().getParameter("refresh")) == 1 || Integer.parseInt(context.getRequest().getParameter("refresh")) == 3)) {
            newTic.setSubCat3(0);
        }
        context.getRequest().setAttribute("TicketDetails", (Object)newTic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeCommandCategoryJSList(ActionContext context) {
        Connection db = null;
        try {
            ActionPlanList plans = null;
            TicketCategoryAssignment assignment = null;
            String orgId = context.getRequest().getParameter("orgId");
            String catCode = context.getRequest().getParameter("catCode");
            String subCat1 = context.getRequest().getParameter("subCat1");
            String subCat2 = context.getRequest().getParameter("subCat2");
            String subCat3 = context.getRequest().getParameter("subCat3");
            db = this.getConnection(context);
            Organization orgDetails = new Organization(db, Integer.parseInt(orgId));
            plans = new ActionPlanList();
            plans.setSiteId(orgDetails.getSiteId());
            plans.setLinkObjectId(ActionPlan.getMapIdGivenConstantId(db, 912051329));
            if (catCode != null) {
                plans.setLinkCatCode(catCode);
                TicketCategoryList subList1 = new TicketCategoryList();
                subList1.setCatLevel(1);
                subList1.setSiteId(orgDetails.getSiteId());
                subList1.setExclusiveToSite(true);
                subList1.setParentCode(Integer.parseInt(catCode));
                subList1.buildList(db);
                assignment = new TicketCategoryAssignment(db, Integer.parseInt(catCode), null);
                context.getRequest().setAttribute("SubList1", (Object)subList1);
            } else if (subCat1 != null) {
                plans.setLinkSubCat1(subCat1);
                TicketCategoryList subList2 = new TicketCategoryList();
                subList2.setCatLevel(2);
                subList2.setSiteId(orgDetails.getSiteId());
                subList2.setExclusiveToSite(true);
                subList2.setParentCode(Integer.parseInt(subCat1));
                subList2.buildList(db);
                assignment = new TicketCategoryAssignment(db, Integer.parseInt(subCat1), null);
                context.getRequest().setAttribute("SubList2", (Object)subList2);
            } else if (subCat2 != null) {
                plans.setLinkSubCat2(subCat2);
                TicketCategoryList subList3 = new TicketCategoryList();
                subList3.setCatLevel(3);
                subList3.setSiteId(orgDetails.getSiteId());
                subList3.setExclusiveToSite(true);
                subList3.setParentCode(Integer.parseInt(subCat2));
                subList3.buildList(db);
                assignment = new TicketCategoryAssignment(db, Integer.parseInt(subCat2), null);
                context.getRequest().setAttribute("SubList3", (Object)subList3);
            } else if (subCat3 != null) {
                plans.setLinkSubCat3(subCat3);
                assignment = new TicketCategoryAssignment(db, Integer.parseInt(subCat3), null);
            }
            if (plans.getLinkCatCode() <= 0 && plans.getLinkSubCat1() <= 0 && plans.getLinkSubCat2() <= 0 && plans.getLinkSubCat3() <= 0) {
                plans.setDisplayNone(true);
            }
            if (assignment != null && assignment.getId() > -1) {
                assignment.setSiteId(orgDetails.getSiteId());
                assignment.buildDepartmentUsers(db);
                context.getRequest().setAttribute("assignment", (Object)assignment);
            } else if (assignment != null) {
                assignment.setSiteId(orgDetails.getSiteId());
                assignment.setDepartmentId(0);
                assignment.buildDepartmentUsers(db);
                context.getRequest().setAttribute("assignment", (Object)assignment);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            CategoryEditor thisEditor = systemStatus.getCategoryEditor(db, 202041401);
            plans.setNameTable(thisEditor.getTableName());
            plans.setJsEvent("id=\"actionPlanId\"");
            plans.setEnabled(1);
            plans.setSiteId(orgDetails.getSiteId());
            plans.setIncludeOnlyApproved(1);
            plans.buildList(db);
            context.getRequest().setAttribute("actionPlans", (Object)plans);
        }
        catch (Exception exception) {
            this.freeConnection(context, db);
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
        }
        this.freeConnection(context, db);
        return "CategoryJSListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeCommandDepartmentJSList(ActionContext context) {
        Connection db = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            String departmentCode = context.getRequest().getParameter("departmentCode");
            db = this.getConnection(context);
            UserList userList = new UserList();
            userList.setEnabled(1);
            userList.setHidden(0);
            userList.setExpired(0);
            userList.setEmptyHtmlSelectRecord(systemStatus.getLabel("calendar.none.4dashes"));
            if (departmentCode != null && !"".equals(departmentCode) && !"-1".equals(departmentCode)) {
                userList.setBuildContact(true);
                userList.setBuildContactDetails(false);
                userList.setDepartment(Integer.parseInt(departmentCode));
                userList.setRoleType(0);
                userList.buildList(db);
            }
            context.getRequest().setAttribute("UserList", (Object)userList);
        }
        catch (Exception errorMessage) {
            this.freeConnection(context, db);
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
        }
        this.freeConnection(context, db);
        return "DepartmentJSListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewHistory(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String ticketId = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            Ticket thisTic = new Ticket();
            thisTic.setBuildHistory(true);
            SystemStatus systemStatus = this.getSystemStatus(context);
            thisTic.setSystemStatus(systemStatus);
            thisTic.queryRecord(db, Integer.parseInt(ticketId));
            if (!AccountTickets.isRecordAccessPermitted(context, db, thisTic.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            Organization thisOrganization = new Organization(db, thisTic.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            if (thisTic.getAssignedTo() > -1) {
                thisTic.checkEnabledOwnerAccount(db);
            }
            context.getRequest().setAttribute("TicketDetails", (Object)thisTic);
            this.addRecentItem(context, (Object)thisTic);
            this.addModuleBean(context, "View Tickets", "Ticket Details");
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountTickets.getReturn(context, "ViewHistory");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeCommandOrganizationJSList(ActionContext context) {
        Connection db = null;
        try {
            String orgId = context.getRequest().getParameter("orgId");
            db = this.getConnection(context);
            ContactList contactList = new ContactList();
            if (orgId != null && !"-1".equals(orgId)) {
                contactList.setBuildDetails(false);
                contactList.setBuildTypes(false);
                contactList.setOrgId(Integer.parseInt(orgId));
                contactList.buildList(db);
            }
            context.getRequest().setAttribute("ContactList", (Object)contactList);
        }
        catch (Exception exception) {
            this.freeConnection(context, db);
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
        }
        this.freeConnection(context, db);
        return "OrganizationJSListOK";
    }
}

