/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.actions.ProjectManagementFileFolders;
import com.zeroio.iteam.base.FileFolder;
import com.zeroio.iteam.base.FileFolderHierarchy;
import java.sql.Connection;
import java.sql.SQLException;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.troubletickets.base.Ticket;

public final class AccountTicketsDocumentsFolders
extends CFSModule {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        Exception errorMessage = null;
        Connection db = null;
        try {
            FileFolder thisFolder = (FileFolder)context.getFormBean();
            thisFolder.setParentId(context.getRequest().getParameter("parentId"));
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!AccountTicketsDocumentsFolders.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                this.freeConnection(context, db);
                return string;
            }
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
            context.getRequest().setAttribute("fileFolder", (Object)thisFolder);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return AccountTicketsDocumentsFolders.getReturn(context, "Add");
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        Object errorMessage = null;
        Connection db = null;
        int resultCount = 0;
        boolean recordInserted = false;
        boolean isValid = false;
        try {
            boolean newFolder;
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!AccountTicketsDocumentsFolders.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileFolder thisFolder = (FileFolder)context.getFormBean();
            boolean bl = newFolder = thisFolder.getId() == -1;
            if (newFolder) {
                thisFolder.setEnteredBy(this.getUserId(context));
            }
            thisFolder.setModifiedBy(this.getUserId(context));
            thisFolder.setLinkModuleId(6);
            thisFolder.setLinkItemId(ticketId);
            isValid = this.validateObject(context, db, thisFolder);
            if (newFolder) {
                if (isValid) {
                    recordInserted = thisFolder.insert(db);
                }
            } else if (isValid) {
                resultCount = thisFolder.update(db);
            }
            ProjectManagementFileFolders.buildHierarchy((Connection)db, (ActionContext)context);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            return "InsertOK";
        }
        if (resultCount == 1) {
            return "UpdateOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("id");
        String folderId = context.getRequest().getParameter("folderId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!AccountTicketsDocumentsFolders.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileFolder thisFolder = new FileFolder(db, Integer.parseInt(itemId));
            recordDeleted = thisFolder.delete(db);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            if (recordDeleted) {
                return "DeleteOK";
            }
            return "DeleteERROR";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        Exception errorMessage = null;
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("id");
        String folderId = context.getRequest().getParameter("folderId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!AccountTicketsDocumentsFolders.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileFolder thisFolder = (FileFolder)context.getFormBean();
            thisFolder.setId(Integer.parseInt(itemId));
            thisFolder.queryRecord(db, Integer.parseInt(itemId));
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return this.executeCommandAdd(context);
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandMove(ActionContext context) {
        String itemId = context.getRequest().getParameter("id");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!AccountTicketsDocumentsFolders.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileFolder thisFolder = new FileFolder(db, Integer.parseInt(itemId));
            context.getRequest().setAttribute("FileFolder", (Object)thisFolder);
            FileFolderHierarchy hierarchy = new FileFolderHierarchy();
            hierarchy.setLinkModuleId(6);
            hierarchy.setLinkItemId(ticketId);
            hierarchy.build(db);
            context.getRequest().setAttribute("folderHierarchy", (Object)hierarchy);
            String string = "MoveOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveMove(ActionContext context) {
        String newFolderId = context.getRequest().getParameter("folderId");
        String itemId = context.getRequest().getParameter("id");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Ticket thisTicket = this.addTicket(context, db);
            int ticketId = thisTicket.getId();
            if (!AccountTicketsDocumentsFolders.isRecordAccessPermitted(context, db, thisTicket.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            FileFolder thisFolder = new FileFolder(db, Integer.parseInt(itemId));
            int folderId = Integer.parseInt(newFolderId);
            if (folderId != 0 && folderId != -1) {
                FileFolder newParent = new FileFolder(db, folderId);
                FileFolderHierarchy thisHierarchy = new FileFolderHierarchy();
                thisHierarchy.setLinkModuleId(6);
                thisHierarchy.setLinkItemId(ticketId);
                thisHierarchy.build(db, thisFolder.getId());
                if (thisHierarchy.getHierarchy().hasFolder(Integer.parseInt(newFolderId))) {
                    thisFolder.buildSubFolders(db);
                    for (FileFolder childFolder : thisFolder.getSubFolders()) {
                        childFolder.updateParentId(db, thisFolder.getParentId());
                    }
                }
            }
            thisFolder.updateParentId(db, folderId);
            String string = "PopupCloseOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    private Ticket addTicket(ActionContext context, Connection db) throws SQLException {
        String ticketId = context.getRequest().getParameter("tId");
        if (ticketId == null) {
            ticketId = (String)context.getRequest().getAttribute("tId");
        }
        return this.addTicket(context, db, ticketId);
    }

    private Ticket addTicket(ActionContext context, Connection db, String ticketId) throws SQLException {
        context.getRequest().setAttribute("tId", (Object)ticketId);
        Ticket thisTicket = new Ticket(db, Integer.parseInt(ticketId));
        context.getRequest().setAttribute("TicketDetails", (Object)thisTicket);
        context.getRequest().setAttribute("OrgDetails", (Object)new Organization(db, thisTicket.getOrgId()));
        return thisTicket;
    }
}

