/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.webutils.FileDownload;
import java.io.File;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.controller.ApplicationPrefs;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationList;
import org.aspcfs.modules.accounts.base.OrganizationReport;
import org.aspcfs.modules.actionplans.base.ActionItemWork;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.AccessTypeList;
import org.aspcfs.modules.admin.base.SICCodeList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.assets.base.Asset;
import org.aspcfs.modules.assets.base.AssetList;
import org.aspcfs.modules.base.CustomField;
import org.aspcfs.modules.base.CustomFieldCategory;
import org.aspcfs.modules.base.CustomFieldCategoryList;
import org.aspcfs.modules.base.CustomFieldGroup;
import org.aspcfs.modules.base.CustomFieldRecord;
import org.aspcfs.modules.base.CustomFieldRecordList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.contacts.base.ContactReport;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.mycfs.beans.CalendarBean;
import org.aspcfs.modules.pipeline.base.OpportunityHeaderList;
import org.aspcfs.modules.pipeline.base.OpportunityReport;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.modules.troubletickets.base.TicketReport;
import org.aspcfs.utils.web.CountrySelect;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.StateSelect;

public final class Accounts
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandDashboard(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandReports(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-reports-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "Reports", "ViewReports");
        PagedListInfo rptListInfo = this.getPagedListInfo(context, "RptListInfo");
        rptListInfo.setLink("Accounts.do?command=Reports");
        FileItemList files = new FileItemList();
        files.setLinkModuleId(10);
        files.setPagedListInfo(rptListInfo);
        if ("all".equals(rptListInfo.getListView())) {
            files.setOwnerIdRange(this.getUserRange(context));
        } else {
            files.setOwner(this.getUserId(context));
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            files.buildList(db);
            context.getRequest().setAttribute("FileList", (Object)files);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ReportsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadCSVReport(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-reports-view")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        String itemId = context.getRequest().getParameter("fid");
        FileItem thisItem = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisItem = new FileItem(db, Integer.parseInt(itemId), -1, 10);
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        try {
            FileItem itemToDownload = null;
            itemToDownload = thisItem;
            String filePath = this.getPath(context, "account-reports") + Accounts.getDatePath(itemToDownload.getEntered()) + itemToDownload.getFilename() + ".csv";
            FileDownload fileDownload = new FileDownload();
            fileDownload.setFullPath(filePath);
            fileDownload.setDisplayName(itemToDownload.getClientFilename());
            if (fileDownload.fileExists()) {
                fileDownload.sendFile(context);
                db = this.getConnection(context);
                itemToDownload.updateCounter(db);
            } else {
                System.err.println("Accounts-> Trying to send a file that does not exist");
            }
        }
        catch (SocketException se) {
        }
        catch (Exception e) {
            errorMessage = e;
            System.out.println(e.toString());
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            return "-none-";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandShowReportHtml(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-reports-view")) {
            return "PermissionError";
        }
        FileItem thisItem = null;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisItem = new FileItem(db, Integer.parseInt(itemId), -1, 10);
            String filePath = this.getPath(context, "account-reports") + Accounts.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".html";
            String textToShow = Accounts.includeFile(filePath);
            context.getRequest().setAttribute("ReportText", (Object)textToShow);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ReportHtmlOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandGenerateForm(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-reports-add")) {
            return "PermissionError";
        }
        Connection db = null;
        CustomFieldCategoryList thisList = new CustomFieldCategoryList();
        thisList.setLinkModuleId(1);
        thisList.setIncludeEnabled(1);
        thisList.setIncludeScheduled(1);
        thisList.setAllSelectOption(true);
        thisList.setBuildResources(false);
        try {
            db = this.getConnection(context);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "Generate new");
        return "GenerateFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandExportReport(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-reports-add")) {
            return "PermissionError";
        }
        String subject = context.getRequest().getParameter("subject");
        String type = context.getRequest().getParameter("type");
        String ownerCriteria = context.getRequest().getParameter("criteria1");
        SystemStatus systemStatus = this.getSystemStatus(context);
        HashMap<String, String> errors = new HashMap<String, String>();
        if (subject == null || "".equals(subject.trim())) {
            errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
        }
        if (!errors.isEmpty()) {
            this.processErrors(context, errors);
            return this.executeCommandGenerateForm(context);
        }
        String filePath = this.getPath(context, "account-reports");
        SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy");
        String datePathToUse1 = formatter1.format(new Date());
        SimpleDateFormat formatter2 = new SimpleDateFormat("MMdd");
        String datePathToUse2 = formatter2.format(new Date());
        filePath = filePath + datePathToUse1 + fs + datePathToUse2 + fs;
        OrganizationReport orgReport = new OrganizationReport();
        orgReport.setCriteria(context.getRequest().getParameterValues("selectedList"));
        orgReport.setFilePath(filePath);
        orgReport.setSubject(subject);
        orgReport.setMinerOnly(false);
        orgReport.setIncludeEnabled(-1);
        orgReport.setOrgSiteId(this.getUserSiteId(context));
        if (ownerCriteria.equals("my")) {
            orgReport.setOwnerId(this.getUserId(context));
        } else if (ownerCriteria.equals("levels")) {
            orgReport.setOwnerIdRange(this.getUserRange(context));
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (type.equals("5")) {
                OpportunityReport oppReport = new OpportunityReport();
                oppReport.setHeader(systemStatus.getLabel("Centric CRM Accounts", "centriccrm.accounts"));
                oppReport.setFilePath(filePath);
                oppReport.setEnteredBy(this.getUserId(context));
                oppReport.setModifiedBy(this.getUserId(context));
                oppReport.setSiteId(this.getUserSiteId(context));
                oppReport.setExclusiveToSite(true);
                if (oppReport.getSiteId() == -1) {
                    oppReport.setIncludeAllSites(true);
                }
                oppReport.setSubject(subject);
                if (ownerCriteria.equals("my")) {
                    oppReport.setLimitId(this.getUserId(context));
                } else if (ownerCriteria.equals("levels")) {
                    oppReport.setAccountOwnerIdRange(this.getUserRange(context));
                }
                oppReport.setCriteria(null);
                oppReport.getOrgReportJoin().setCriteria(context.getRequest().getParameterValues("selectedList"));
                oppReport.setJoinOrgs(true);
                oppReport.buildReportFull(db, context);
                orgReport.setEnteredBy(this.getUserId(context));
                orgReport.setModifiedBy(this.getUserId(context));
                oppReport.saveAndInsert(db);
            } else if (type.equals("2")) {
                ContactReport contactReport = new ContactReport();
                contactReport.setFilePath(filePath);
                contactReport.setEnteredBy(this.getUserId(context));
                contactReport.setModifiedBy(this.getUserId(context));
                contactReport.setSubject(subject);
                contactReport.setHeader(systemStatus.getLabel("Centric CRM Accounts", "centriccrm.accounts"));
                contactReport.addIgnoreTypeId(1);
                contactReport.addIgnoreTypeId(2);
                contactReport.setSiteId(this.getUserSiteId(context));
                contactReport.setExclusiveToSite(true);
                if (contactReport.getSiteId() == -1) {
                    contactReport.setIncludeAllSites(true);
                }
                contactReport.setCriteria(null);
                contactReport.getOrgReportJoin().setCriteria(context.getRequest().getParameterValues("selectedList"));
                if (ownerCriteria.equals("my")) {
                    contactReport.setLimitId(this.getUserId(context));
                    contactReport.setOwner(this.getUserId(context));
                } else if (ownerCriteria.equals("levels")) {
                    contactReport.setAccountOwnerIdRange(this.getUserRange(context));
                }
                contactReport.setJoinOrgs(true);
                contactReport.buildReportFull(db);
                contactReport.saveAndInsert(db);
            } else if (type.equals("3")) {
                TicketReport ticReport = new TicketReport();
                ticReport.setFilePath(filePath);
                ticReport.setEnteredBy(this.getUserId(context));
                ticReport.setModifiedBy(this.getUserId(context));
                ticReport.setSubject(subject);
                ticReport.setSiteId(this.getUserSiteId(context));
                ticReport.setExclusiveToSite(true);
                if (ticReport.getSiteId() == -1) {
                    ticReport.setIncludeAllSites(true);
                }
                ticReport.setHeader(systemStatus.getLabel("Centric CRM Accounts", "centriccrm.accounts"));
                ticReport.setJoinOrgs(true);
                if (ownerCriteria.equals("my")) {
                    ticReport.setLimitId(this.getUserId(context));
                } else if (ownerCriteria.equals("levels")) {
                    ticReport.setAccountOwnerIdRange(this.getUserRange(context));
                }
                ticReport.setCriteria(null);
                ticReport.getOrgReportJoin().setCriteria(context.getRequest().getParameterValues("selectedList"));
                ticReport.buildReportFull(db, context);
                ticReport.saveAndInsert(db);
            } else {
                int folderId = Integer.parseInt(context.getRequest().getParameter("catId"));
                if (type.equals("4") && folderId == 0) {
                    orgReport.setIncludeFolders(true);
                } else if (type.equals("4") && folderId > 0) {
                    orgReport.setFolderId(folderId);
                }
                orgReport.setEnteredBy(this.getUserId(context));
                orgReport.setModifiedBy(this.getUserId(context));
                orgReport.buildReportFull(db);
                orgReport.saveAndInsert(db);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandReports(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteReport(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-reports-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        String itemId = context.getRequest().getParameter("fid");
        Connection db = null;
        try {
            String filePath2;
            File fileToDelete2;
            db = this.getConnection(context);
            FileItem thisItem = new FileItem(db, Integer.parseInt(itemId), -1, 10);
            recordDeleted = thisItem.delete(db, this.getPath(context, "account-reports"));
            String filePath1 = this.getPath(context, "account-reports") + Accounts.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".csv";
            File fileToDelete1 = new File(filePath1);
            if (!fileToDelete1.delete()) {
                System.err.println("FileItem-> Tried to delete file: " + filePath1);
            }
            if (!(fileToDelete2 = new File(filePath2 = this.getPath(context, "account-reports") + Accounts.getDatePath(thisItem.getEntered()) + thisItem.getFilename() + ".html")).delete()) {
                System.err.println("FileItem-> Tried to delete file: " + filePath2);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Reports", "Reports del");
        if (recordDeleted) {
            return "DeleteReportOK";
        }
        return "DeleteReportERROR";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchForm(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-view")) {
            return "PermissionError";
        }
        if (Accounts.isPortalUser(context)) {
            return this.executeCommandSearch(context);
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            HashMap<String, String> map;
            StateSelect stateSelect;
            db = this.getConnection(context);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            siteList.addItem(-2, systemStatus.getLabel("accounts.allSites"));
            context.getRequest().setAttribute("SiteList", (Object)siteList);
            LookupList stageList = new LookupList(db, "lookup_account_stage");
            stageList.addItem(-1, systemStatus.getLabel("accounts.any"));
            context.getRequest().setAttribute("StageList", (Object)stageList);
            PagedListInfo orgListInfo = this.getPagedListInfo(context, "SearchOrgListInfo");
            orgListInfo.setCurrentLetter("");
            orgListInfo.setCurrentOffset(0);
            if (orgListInfo.getSearchOptionValue("searchcodeContactCountry") != null && !"-1".equals(orgListInfo.getSearchOptionValue("searchcodeContactCountry"))) {
                stateSelect = new StateSelect(systemStatus, orgListInfo.getSearchOptionValue("searchcodeContactCountry"));
                if (orgListInfo.getSearchOptionValue("searchContactOtherState") != null) {
                    map = new HashMap<String, String>();
                    map.put(orgListInfo.getSearchOptionValue("searchcodeContactCountry"), orgListInfo.getSearchOptionValue("searchContactOtherState"));
                    stateSelect.setPreviousStates(map);
                }
                context.getRequest().setAttribute("ContactStateSelect", (Object)stateSelect);
            }
            if (orgListInfo.getSearchOptionValue("searchcodeAccountCountry") != null && !"-1".equals(orgListInfo.getSearchOptionValue("searchcodeAccountCountry"))) {
                stateSelect = new StateSelect(systemStatus, orgListInfo.getSearchOptionValue("searchcodeAccountCountry"));
                if (orgListInfo.getSearchOptionValue("searchAccountOtherState") != null) {
                    map = new HashMap();
                    map.put(orgListInfo.getSearchOptionValue("searchcodeAccountCountry"), orgListInfo.getSearchOptionValue("searchAccountOtherState"));
                    stateSelect.setPreviousStates(map);
                }
                context.getRequest().setAttribute("AccountStateSelect", (Object)stateSelect);
            }
            this.buildFormElements(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Search Accounts", "Accounts Search");
        return "SearchOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-add")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteList", (Object)siteList);
            LookupList stageList = new LookupList(db, "lookup_account_stage");
            stageList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("StageList", (Object)stageList);
            Organization newOrg = (Organization)((Object)context.getFormBean());
            ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
            StateSelect stateSelect = new StateSelect(systemStatus, (newOrg.getAddressList() != null ? newOrg.getAddressList().getCountries() : "") + prefs.get("SYSTEM.COUNTRY"));
            stateSelect.setPreviousStates(newOrg.getAddressList() != null ? newOrg.getAddressList().getSelectedStatesHashMap() : new HashMap());
            context.getRequest().setAttribute("StateSelect", (Object)stateSelect);
            this.buildFormElements(context, db);
            if (newOrg.getEnteredBy() != -1) {
                newOrg.setTypeListToTypes(db);
                context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Add Account", "Accounts Add");
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        if (context.getRequest().getParameter("actionSource") != null) {
            return Accounts.getReturn(context, "AddAccount");
        }
        return Accounts.getReturn(context, "Add");
    }

    public void buildFormElements(ActionContext context, Connection db) throws SQLException {
        LookupList addrTypeList;
        LookupList phoneTypeList;
        String index = null;
        if (context.getRequest().getParameter("index") != null) {
            index = context.getRequest().getParameter("index");
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList salutationList = new LookupList(db, "lookup_title");
        salutationList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SalutationList", (Object)salutationList);
        LookupList segmentList = new LookupList(db, "lookup_segments");
        segmentList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SegmentList", (Object)segmentList);
        LookupList industrySelect = new LookupList(db, "lookup_industry");
        industrySelect.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("IndustryList", (Object)industrySelect);
        SICCodeList sicCodeList = new SICCodeList(db);
        sicCodeList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SICCodeList", (Object)sicCodeList);
        LookupList sourceList = new LookupList(db, "lookup_contact_source");
        sourceList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("SourceList", (Object)sourceList);
        LookupList ratingList = new LookupList(db, "lookup_contact_rating");
        ratingList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("RatingList", (Object)ratingList);
        LookupList accountTypeList1 = new LookupList(db, "lookup_account_types");
        accountTypeList1.setSelectSize(4);
        accountTypeList1.setMultiple(true);
        context.getRequest().setAttribute("AccountTypeList", (Object)accountTypeList1);
        LookupList accountTypeList2 = new LookupList(db, "lookup_account_types");
        accountTypeList2.addItem(-1, systemStatus.getLabel("accounts.allTypes"));
        context.getRequest().setAttribute("TypeSelect", (Object)accountTypeList2);
        LookupList accountSizeList = new LookupList(db, "lookup_account_size");
        accountSizeList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("AccountSizeList", (Object)accountSizeList);
        if (index == null || index != null && Integer.parseInt(index) == 0) {
            phoneTypeList = new LookupList(db, "lookup_orgphone_types");
            context.getRequest().setAttribute("OrgPhoneTypeList", (Object)phoneTypeList);
            addrTypeList = new LookupList(db, "lookup_orgaddress_types");
            context.getRequest().setAttribute("OrgAddressTypeList", (Object)addrTypeList);
            LookupList emailTypeList = new LookupList(db, "lookup_orgemail_types");
            context.getRequest().setAttribute("OrgEmailTypeList", (Object)emailTypeList);
        } else {
            phoneTypeList = new LookupList(db, "lookup_contactphone_types");
            context.getRequest().setAttribute("OrgPhoneTypeList", (Object)phoneTypeList);
            addrTypeList = new LookupList(db, "lookup_contactaddress_types");
            context.getRequest().setAttribute("OrgAddressTypeList", (Object)addrTypeList);
            LookupList emailTypeList = new LookupList(db, "lookup_contactemail_types");
            context.getRequest().setAttribute("OrgEmailTypeList", (Object)emailTypeList);
        }
        StateSelect stateSelect = (StateSelect)context.getRequest().getAttribute("StateSelect");
        if (stateSelect == null) {
            ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
            stateSelect = new StateSelect(systemStatus, prefs.get("SYSTEM.COUNTRY"));
        }
        CountrySelect countrySelect = new CountrySelect(systemStatus);
        context.getRequest().setAttribute("StateSelect", (Object)stateSelect);
        context.getRequest().setAttribute("CountrySelect", (Object)countrySelect);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        int tempid;
        Organization newOrg;
        SystemStatus systemStatus;
        Connection db;
        block8: {
            if (!this.hasPermission(context, "accounts-accounts-view")) {
                return "PermissionError";
            }
            db = null;
            systemStatus = this.getSystemStatus(context);
            newOrg = null;
            String temporgId = context.getRequest().getParameter("orgId");
            if (temporgId == null) {
                temporgId = (String)context.getRequest().getAttribute("orgId");
            }
            tempid = Integer.parseInt(temporgId);
            db = this.getConnection(context);
            if (Accounts.isRecordAccessPermitted(context, db, Integer.parseInt(temporgId))) break block8;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            newOrg = new Organization(db, tempid);
            newOrg.checkEnabledOwnerAccount(db);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteList", (Object)siteList);
            LookupList stageList = new LookupList(db, "lookup_account_stage");
            stageList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("StageList", (Object)stageList);
            this.buildFormElements(context, db);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addRecentItem(context, (Object)newOrg);
        String action = context.getRequest().getParameter("action");
        if (action != null && action.equals("modify")) {
            this.addModuleBean(context, "Accounts", "Modify Account Details");
            return "DetailsOK";
        }
        this.addModuleBean(context, "View Accounts", "View Account Details");
        context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
        return Accounts.getReturn(context, "Details");
    }

    public String executeCommandDashboard(ActionContext context) {
        if (!this.hasPermission(context, "accounts-dashboard-view")) {
            if (!this.hasPermission(context, "accounts-accounts-view")) {
                return "PermissionError";
            }
            if (Accounts.isPortalUser(context)) {
                return this.executeCommandSearch(context);
            }
            return this.executeCommandSearchForm(context);
        }
        this.addModuleBean(context, "Dashboard", "Dashboard");
        CalendarBean calendarInfo = (CalendarBean)context.getSession().getAttribute("AccountsCalendarInfo");
        if (calendarInfo == null) {
            calendarInfo = new CalendarBean(this.getUser(context, this.getUserId(context)).getLocale());
            calendarInfo.addAlertType("Accounts", "org.aspcfs.modules.accounts.base.AccountsListScheduledActions", "Accounts");
            calendarInfo.setCalendarDetailsView("Accounts");
            context.getSession().setAttribute("AccountsCalendarInfo", (Object)calendarInfo);
        }
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        User thisRec = thisUser.getUserRecord();
        UserList shortChildList = thisRec.getShortChildList();
        UserList newUserList = thisRec.getFullChildList(shortChildList, new UserList());
        newUserList.setMyId(this.getUserId(context));
        newUserList.setMyValue(thisUser.getUserRecord().getContact().getNameLastFirst());
        newUserList.setIncludeMe(true);
        newUserList.setJsEvent("onChange = \"javascript:fillFrame('calendar','MyCFS.do?command=MonthView&source=Calendar&userId='+document.getElementById('userId').value + '&return=Accounts'); javascript:fillFrame('calendardetails','MyCFS.do?command=Alerts&source=CalendarDetails&userId='+document.getElementById('userId').value + '&return=Accounts');javascript:changeDivContent('userName','Scheduled Actions for ' + document.getElementById('userId').options[document.getElementById('userId').selectedIndex].firstChild.nodeValue);\"");
        HtmlSelect userListSelect = newUserList.getHtmlSelectObj("userId", this.getUserId(context));
        userListSelect.addAttribute("id", "userId");
        context.getRequest().setAttribute("Return", (Object)"Accounts");
        context.getRequest().setAttribute("NewUserList", (Object)userListSelect);
        return "DashboardOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearch(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-view")) {
            return "PermissionError";
        }
        String source = context.getRequest().getParameter("source");
        OrganizationList organizationList = new OrganizationList();
        this.addModuleBean(context, "View Accounts", "Search Results");
        PagedListInfo searchListInfo = this.getPagedListInfo(context, "SearchOrgListInfo");
        searchListInfo.setLink("Accounts.do?command=Search");
        SystemStatus systemStatus = this.getSystemStatus(context);
        this.resetPagedListInfo(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (Accounts.isPortalUser(context)) {
                organizationList.setOrgSiteId(this.getUserSiteId(context));
                source = "searchForm";
            }
            if ((searchListInfo.getListView() == null || "".equals(searchListInfo.getListView())) && !"searchForm".equals(source)) {
                String string = "ListOK";
                return string;
            }
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            siteList.addItem(-2, systemStatus.getLabel("accounts.allSites"));
            context.getRequest().setAttribute("SiteIdList", (Object)siteList);
            LookupList stageList = new LookupList(db, "lookup_account_stage");
            stageList.addItem(-1, systemStatus.getLabel("accounts.any"));
            context.getRequest().setAttribute("StageList", (Object)stageList);
            if (!"true".equals(searchListInfo.getCriteriaValue("searchContacts"))) {
                Object assets;
                if ("contacts".equals(context.getSession().getAttribute("previousSearchType"))) {
                    this.deletePagedListInfo(context, "SearchOrgListInfo");
                    searchListInfo = this.getPagedListInfo(context, "SearchOrgListInfo");
                    searchListInfo.setLink("Accounts.do?command=Search");
                }
                organizationList.setPagedListInfo(searchListInfo);
                organizationList.setMinerOnly(false);
                organizationList.setTypeId(searchListInfo.getFilterKey("listFilter1"));
                organizationList.setStageId(searchListInfo.getCriteriaValue("searchcodeStageId"));
                searchListInfo.setSearchCriteria(organizationList, context);
                if ("my".equals(searchListInfo.getListView())) {
                    organizationList.setOwnerId(this.getUserId(context));
                }
                if (organizationList.getOrgSiteId() == -2) {
                    organizationList.setOrgSiteId(this.getUserSiteId(context));
                    organizationList.setIncludeOrganizationWithoutSite(false);
                } else if (organizationList.getOrgSiteId() == -1) {
                    organizationList.setIncludeOrganizationWithoutSite(true);
                }
                int enabled = searchListInfo.getFilterKey("listFilter2");
                organizationList.setIncludeEnabled(enabled);
                if (Accounts.isPortalUser(context)) {
                    organizationList.setOrgSiteId(this.getUserSiteId(context));
                    organizationList.setIncludeOrganizationWithoutSite(false);
                    organizationList.setOrgId(Accounts.getPortalUserPermittedOrgId(context));
                }
                organizationList.buildList(db);
                context.getRequest().setAttribute("OrgList", (Object)organizationList);
                context.getSession().setAttribute("previousSearchType", (Object)"accounts");
                if (organizationList.size() == 1 && organizationList.getAssetSerialNumber() != null) {
                    assets = new AssetList();
                    ((AssetList)assets).setOrgId(((Organization)((Object)organizationList.get(0))).getId());
                    ((AssetList)assets).setSerialNumber(organizationList.getAssetSerialNumber());
                    ((AssetList)assets).setSkipParentIdRequirement(true);
                    ((AssetList)assets).buildList(db);
                    if (((ArrayList)assets).size() == 1) {
                        Asset asset = (Asset)((Object)((ArrayList)assets).get(0));
                        context.getRequest().setAttribute("id", (Object)String.valueOf(asset.getId()));
                        String string = "AssetDetailsOK";
                        return string;
                    }
                }
                assets = "ListOK";
                return assets;
            }
            if ("accounts".equals(context.getSession().getAttribute("previousSearchType"))) {
                this.deletePagedListInfo(context, "SearchOrgListInfo");
                searchListInfo = this.getPagedListInfo(context, "SearchOrgListInfo");
                searchListInfo.setLink("Accounts.do?command=Search");
            }
            ContactList contactList = new ContactList();
            contactList.setIncludeAllSites(true);
            contactList.setPagedListInfo(searchListInfo);
            if ("my".equals(searchListInfo.getListView())) {
                contactList.setAccountOwnerId(this.getUserId(context));
            }
            contactList.setAccountTypeId(searchListInfo.getFilterKey("listFilter1"));
            int enabled = searchListInfo.getFilterKey("listFilter2");
            contactList.setIncludeEnabledAccount(enabled);
            contactList.setBuildDetails(true);
            contactList.setBuildTypes(false);
            contactList.setWithAccountsOnly(true);
            contactList.addIgnoreTypeId(1);
            searchListInfo.setSearchCriteria(contactList, context);
            if (contactList.getOrgSiteId() == -2) {
                contactList.setOrgSiteId(this.getUserSiteId(context));
                contactList.setIncludeContactsFromOrganizationsWithoutSite(false);
            } else if (contactList.getOrgSiteId() == -1) {
                contactList.setIncludeContactsFromOrganizationsWithoutSite(true);
            }
            if (searchListInfo.getColumnToSortBy() == null || "searchForm".equals(source)) {
                searchListInfo.setColumnToSortBy("c.org_name,c.namelast");
            }
            if (Accounts.isPortalUser(context)) {
                contactList.setOrgId(Accounts.getPortalUserPermittedOrgId(context));
            }
            contactList.buildList(db);
            context.getRequest().setAttribute("ContactList", (Object)contactList);
            context.getSession().setAttribute("previousSearchType", (Object)"contacts");
            String string = "ContactListOK";
            return string;
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewTickets(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-tickets-view")) {
            return "PermissionError";
        }
        Connection db = null;
        TicketList ticList = new TicketList();
        Organization newOrg = null;
        int passedId = Integer.parseInt(context.getRequest().getParameter("orgId"));
        PagedListInfo ticketListInfo = this.getPagedListInfo(context, "AccountTicketInfo", "t.entered", "desc");
        ticketListInfo.setLink("Accounts.do?command=ViewTickets&orgId=" + passedId);
        ticList.setPagedListInfo(ticketListInfo);
        try {
            db = this.getConnection(context);
            if (!Accounts.isRecordAccessPermitted(context, db, passedId)) {
                String string = "PermissionError";
                return string;
            }
            newOrg = new Organization(db, passedId);
            ticList.setOrgId(passedId);
            if (newOrg.isTrashed()) {
                ticList.setIncludeOnlyTrashed(true);
            }
            ticList.buildList(db);
            context.getRequest().setAttribute("TicList", (Object)ticList);
            context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
            this.addModuleBean(context, "View Accounts", "Accounts View");
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return Accounts.getReturn(context, "ViewTickets");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsert(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean recordInserted = false;
        boolean isValid = false;
        Organization insertedOrg = null;
        Organization newOrg = (Organization)((Object)context.getFormBean());
        newOrg.setTypeList(context.getRequest().getParameterValues("selectedList"));
        newOrg.setEnteredBy(this.getUserId(context));
        newOrg.setModifiedBy(this.getUserId(context));
        newOrg.setOwner(this.getUserId(context));
        try {
            db = this.getConnection(context);
            LookupList segmentList = new LookupList(db, "lookup_segments");
            segmentList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SegmentList", (Object)segmentList);
            LookupList stageList = new LookupList(db, "lookup_account_stage");
            stageList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("StageList", (Object)stageList);
            if (context.getRequest().getParameter("form_type").equalsIgnoreCase("individual")) {
                newOrg.setIsIndividual(true);
                newOrg.setName(newOrg.getNameLastFirstMiddle());
                newOrg.populatePrimaryContact();
                newOrg.getPrimaryContact().setRequestItems(context);
                AccessTypeList accessTypes = this.getSystemStatus(context).getAccessTypeList(db, 626030331);
                newOrg.getPrimaryContact().setAccessType(accessTypes.getDefaultItem());
            } else {
                newOrg.setIsIndividual(false);
                newOrg.setRequestItems(context);
            }
            if (this.getUserSiteId(context) != -1) {
                if (newOrg.getId() == -1) {
                    newOrg.setSiteId(this.getUserSiteId(context));
                } else if (!Accounts.isRecordAccessPermitted(context, db, newOrg.getId())) {
                    String string = "PermissionError";
                    return string;
                }
            }
            if (isValid = this.validateObject(context, db, (Object)newOrg)) {
                recordInserted = newOrg.insert(db);
            }
            if (recordInserted) {
                insertedOrg = new Organization(db, newOrg.getOrgId());
                context.getRequest().setAttribute("OrgDetails", (Object)insertedOrg);
                this.addRecentItem(context, (Object)newOrg);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Accounts Insert ok");
        if (recordInserted) {
            String target = context.getRequest().getParameter("target");
            if (context.getRequest().getParameter("popup") != null) {
                return "ClosePopupOK";
            }
            if (target != null && "add_contact".equals(target)) {
                return "InsertAndAddContactOK";
            }
            return "InsertOK";
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        int resultCount = -1;
        boolean isValid = false;
        Organization newOrg = (Organization)((Object)context.getFormBean());
        Organization oldOrg = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        newOrg.setTypeList(context.getRequest().getParameterValues("selectedList"));
        newOrg.setModifiedBy(this.getUserId(context));
        newOrg.setEnteredBy(this.getUserId(context));
        try {
            db = this.getConnection(context);
            if (context.getRequest().getParameter("form_type").equalsIgnoreCase("individual")) {
                newOrg.setIsIndividual(true);
                newOrg.populatePrimaryContact(db);
                if (newOrg.getPrimaryContact() == null) {
                    if (newOrg.getPrimaryContactId() == -1) {
                        newOrg.getErrors().put("primaryContactIdError", systemStatus.getLabel("", "Select valid primary contact"));
                    } else {
                        newOrg.updatePrimaryContact(db, true);
                    }
                } else {
                    newOrg.updatePrimaryContact();
                    newOrg.getPrimaryContact().setRequestItems(context);
                    newOrg.setName(newOrg.getNameLastFirstMiddle());
                }
            } else {
                newOrg.setIsIndividual(false);
                newOrg.setRequestItems(context);
                newOrg.populatePrimaryContact(db);
                if (newOrg.getPrimaryContact() != null) {
                    newOrg.updatePrimaryContact(db, false);
                }
            }
            oldOrg = new Organization(db, newOrg.getOrgId());
            isValid = this.validateObject(context, db, (Object)newOrg);
            if (isValid) {
                resultCount = newOrg.update(db);
            }
            if (resultCount == 1) {
                this.processUpdateHook(context, (Object)oldOrg, (Object)newOrg);
                if (context.getRequest().getParameter("form_type").equalsIgnoreCase("individual") && newOrg.getPrimaryContactId() == -1) {
                    newOrg.getPrimaryContact().update(db);
                }
                ContactList.updateOrgName(db, newOrg);
                LookupList segmentList = new LookupList(db, "lookup_segments");
                segmentList.addItem(-1, this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
                context.getRequest().setAttribute("SegmentList", (Object)segmentList);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Modify Account");
        if (resultCount == -1 || !isValid) {
            return this.executeCommandModify(context);
        }
        if (resultCount == 1) {
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("list")) {
                return this.executeCommandSearch(context);
            }
            if (context.getRequest().getParameter("return") != null && context.getRequest().getParameter("return").equals("dashboard")) {
                return this.executeCommandDashboard(context);
            }
            if (context.getRequest().getParameter("return") == null || !context.getRequest().getParameter("return").equals("Calendar")) return "UpdateOK";
            if (context.getRequest().getParameter("popup") == null) return "UpdateOK";
            return "PopupCloseOK";
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-delete")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Exception errorMessage = null;
        boolean recordDeleted = false;
        Organization thisOrganization = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisOrganization = new Organization(db, Integer.parseInt(context.getRequest().getParameter("orgId")));
            if (!Accounts.isRecordAccessPermitted(context, db, thisOrganization.getId())) {
                String string = "PermissionError";
                return string;
            }
            if (context.getRequest().getParameter("action") != null) {
                if (context.getRequest().getParameter("action").equals("delete")) {
                    thisOrganization.setContactDelete(true);
                    thisOrganization.setRevenueDelete(true);
                    thisOrganization.setDocumentDelete(true);
                    OpportunityHeaderList opportunityList = new OpportunityHeaderList();
                    opportunityList.setOrgId(thisOrganization.getOrgId());
                    opportunityList.buildList(db);
                    opportunityList.invalidateUserData(context, db);
                    thisOrganization.setForceDelete(context.getRequest().getParameter("forceDelete"));
                    recordDeleted = thisOrganization.delete(db, context, Accounts.getDbNamePath(context));
                } else if (context.getRequest().getParameter("action").equals("disable")) {
                    recordDeleted = thisOrganization.disable(db);
                }
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Accounts", "Delete Account");
        if (errorMessage == null) {
            if (recordDeleted) {
                this.deleteRecentItem(context, (Object)thisOrganization);
                context.getRequest().setAttribute("refreshUrl", (Object)"Accounts.do?command=Search");
                if ("disable".equals(context.getRequest().getParameter("action")) && "list".equals(context.getRequest().getParameter("return"))) {
                    return this.executeCommandSearch(context);
                }
                return "DeleteOK";
            }
            this.processErrors(context, thisOrganization.getErrors());
            return this.executeCommandSearch(context);
        }
        System.out.println(errorMessage);
        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.accountDeletion"));
        context.getRequest().setAttribute("refreshUrl", (Object)"Accounts.do?command=Search");
        return "DeleteError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-delete")) {
            return "PermissionError";
        }
        boolean recordUpdated = false;
        Organization thisOrganization = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String orgId = context.getRequest().getParameter("orgId");
            if (!Accounts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            recordUpdated = thisOrganization.updateStatus(db, context, true, this.getUserId(context));
            this.invalidateUserData(context, this.getUserId(context));
            this.invalidateUserData(context, thisOrganization.getOwner());
            if (recordUpdated) {
                this.deleteRecentItem(context, (Object)thisOrganization);
                this.deleteRecentItems(context, db, thisOrganization);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("refreshUrl", (Object)"Accounts.do?command=Search");
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Accounts", "Delete Account");
        if (recordUpdated) {
            context.getRequest().setAttribute("refreshUrl", (Object)"Accounts.do?command=Search");
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandSearch(context);
            }
            return "DeleteOK";
        }
        return this.executeCommandSearch(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRestore(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-delete")) {
            return "PermissionError";
        }
        boolean recordUpdated = false;
        Organization thisOrganization = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            String orgId = context.getRequest().getParameter("orgId");
            if (!Accounts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            recordUpdated = thisOrganization.updateStatus(db, context, false, this.getUserId(context));
            this.invalidateUserData(context, this.getUserId(context));
            this.invalidateUserData(context, thisOrganization.getOwner());
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Accounts", "Delete Account");
        if (recordUpdated) {
            context.getRequest().setAttribute("refreshUrl", (Object)"Accounts.do?command=Search");
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandSearch(context);
            }
            return this.executeCommandDetails(context);
        }
        return this.executeCommandSearch(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandEnable(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-edit")) {
            return "PermissionError";
        }
        boolean recordEnabled = false;
        Organization thisOrganization = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            thisOrganization = new Organization(db, Integer.parseInt(context.getRequest().getParameter("orgId")));
            recordEnabled = thisOrganization.enable(db);
            if (!recordEnabled) {
                this.validateObject(context, db, (Object)thisOrganization);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Accounts", "Delete Account");
        return this.executeCommandSearch(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-delete")) {
            return "PermissionError";
        }
        Connection db = null;
        Organization thisOrg = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        if (context.getRequest().getParameter("id") != null) {
            id = context.getRequest().getParameter("id");
        }
        try {
            db = this.getConnection(context);
            thisOrg = new Organization(db, Integer.parseInt(id));
            if (!Accounts.isRecordAccessPermitted(context, db, thisOrg.getId())) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = thisOrg.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
            htmlDialog.addButton(systemStatus.getLabel("button.delete"), "javascript:window.location.href='Accounts.do?command=Trash&action=delete&orgId=" + thisOrg.getOrgId() + "&forceDelete=true" + "'");
            if (thisOrg.getEnabled()) {
                htmlDialog.addButton(systemStatus.getLabel("button.disableOnly"), "javascript:window.location.href='Accounts.do?command=Delete&orgId=" + thisOrg.getOrgId() + "&action=disable'");
            }
            htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-edit")) {
            return "PermissionError";
        }
        String orgid = context.getRequest().getParameter("orgId");
        context.getRequest().setAttribute("orgId", (Object)orgid);
        int tempid = Integer.parseInt(orgid);
        Connection db = null;
        Organization newOrg = null;
        try {
            db = this.getConnection(context);
            newOrg = (Organization)((Object)context.getFormBean());
            if (newOrg.getId() == -1) {
                newOrg = new Organization(db, tempid);
                if (newOrg.getPrimaryContact() == null) {
                    newOrg.setIsIndividual(false);
                } else {
                    newOrg.setIsIndividual(true);
                }
            } else {
                newOrg.setTypeListToTypes(db);
            }
            if (!Accounts.isRecordAccessPermitted(context, db, newOrg.getId())) {
                String string = "PermissionError";
                return string;
            }
            if (newOrg.getPrimaryContact() == null) {
                ContactList contacts = new ContactList();
                contacts.setOrgId(newOrg.getOrgId());
                contacts.buildList(db);
                context.getRequest().setAttribute("contactList", (Object)contacts);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
            LookupList industrySelect = systemStatus.getLookupList(db, "lookup_industry");
            industrySelect.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("IndustryList", (Object)industrySelect);
            SICCodeList sicCodeList = new SICCodeList(db);
            sicCodeList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SICCodeList", (Object)sicCodeList);
            LookupList sourceList = new LookupList(db, "lookup_contact_source");
            sourceList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SourceList", (Object)sourceList);
            LookupList ratingList = new LookupList(db, "lookup_contact_rating");
            ratingList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("RatingList", (Object)ratingList);
            LookupList phoneTypeList = systemStatus.getLookupList(db, "lookup_orgphone_types");
            context.getRequest().setAttribute("OrgPhoneTypeList", (Object)phoneTypeList);
            LookupList addrTypeList = systemStatus.getLookupList(db, "lookup_orgaddress_types");
            context.getRequest().setAttribute("OrgAddressTypeList", (Object)addrTypeList);
            LookupList emailTypeList = systemStatus.getLookupList(db, "lookup_orgemail_types");
            context.getRequest().setAttribute("OrgEmailTypeList", (Object)emailTypeList);
            LookupList accountSizeList = new LookupList(db, "lookup_account_size");
            accountSizeList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("AccountSizeList", (Object)accountSizeList);
            LookupList salutationList = new LookupList(db, "lookup_title");
            salutationList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SalutationList", (Object)salutationList);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SiteList", (Object)siteList);
            LookupList stageList = new LookupList(db, "lookup_account_stage");
            stageList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("StageList", (Object)stageList);
            LookupList segmentList = new LookupList(db, "lookup_segments");
            segmentList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("SegmentList", (Object)segmentList);
            if (newOrg.getPrimaryContact() != null) {
                LookupList contactEmailTypeList = systemStatus.getLookupList(db, "lookup_contactemail_types");
                context.getRequest().setAttribute("ContactEmailTypeList", (Object)contactEmailTypeList);
                LookupList contactAddrTypeList = systemStatus.getLookupList(db, "lookup_contactaddress_types");
                context.getRequest().setAttribute("ContactAddressTypeList", (Object)contactAddrTypeList);
                LookupList contactPhoneTypeList = systemStatus.getLookupList(db, "lookup_contactphone_types");
                context.getRequest().setAttribute("ContactPhoneTypeList", (Object)contactPhoneTypeList);
            }
            ApplicationPrefs prefs = (ApplicationPrefs)context.getServletContext().getAttribute("applicationPrefs");
            StateSelect stateSelect = new StateSelect(systemStatus, (newOrg.getPrimaryContact() == null ? newOrg.getAddressList().getCountries() + "," : newOrg.getPrimaryContact().getAddressList().getCountries() + ",") + prefs.get("SYSTEM.COUNTRY"));
            stateSelect.setPreviousStates(newOrg.getPrimaryContact() == null ? newOrg.getAddressList().getSelectedStatesHashMap() : newOrg.getPrimaryContact().getAddressList().getSelectedStatesHashMap());
            context.getRequest().setAttribute("StateSelect", (Object)stateSelect);
            CountrySelect countrySelect = new CountrySelect(systemStatus);
            context.getRequest().setAttribute("CountrySelect", (Object)countrySelect);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
            UserList userList = this.filterOwnerListForSite(context, newOrg.getSiteId());
            context.getRequest().setAttribute("UserList", (Object)userList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Accounts", "Account Modify");
        context.getRequest().setAttribute("OrgDetails", (Object)newOrg);
        if (context.getRequest().getParameter("popup") != null) {
            return "PopupModifyOK";
        }
        return "ModifyOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandFolderList(ActionContext context) {
        String orgId;
        Organization thisOrganization;
        Connection db;
        block6: {
            if (!this.hasPermission(context, "accounts-accounts-folders-view")) {
                return "PermissionError";
            }
            db = null;
            thisOrganization = null;
            orgId = context.getRequest().getParameter("orgId");
            db = this.getConnection(context);
            if (Accounts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) break block6;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(1);
            thisList.setLinkItemId(thisOrganization.getId());
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.setBuildTotalNumOfRecords(true);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "Accounts", "Custom Fields Details");
        return Accounts.getReturn(context, "FolderList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandFields(ActionContext context) {
        String orgId;
        String selectedCatId;
        boolean showRecords;
        String recordId;
        Organization thisOrganization;
        Connection db;
        block19: {
            if (!this.hasPermission(context, "accounts-accounts-folders-view")) {
                return "PermissionError";
            }
            db = null;
            thisOrganization = null;
            String source = context.getRequest().getParameter("source");
            String actionStepId = context.getRequest().getParameter("actionStepId");
            if (source != null && !"".equals(source.trim())) {
                context.getRequest().setAttribute("source", (Object)source);
            }
            if (actionStepId != null && !"".equals(actionStepId.trim())) {
                context.getRequest().setAttribute("actionStepId", (Object)actionStepId);
            }
            recordId = null;
            showRecords = true;
            selectedCatId = null;
            orgId = context.getRequest().getParameter("orgId");
            db = this.getConnection(context);
            if (Accounts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) break block19;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            CustomFieldCategoryList thisList = new CustomFieldCategoryList();
            thisList.setLinkModuleId(1);
            thisList.setIncludeEnabled(1);
            thisList.setIncludeScheduled(1);
            thisList.setBuildResources(false);
            thisList.buildList(db);
            context.getRequest().setAttribute("CategoryList", (Object)thisList);
            selectedCatId = context.getRequest().getParameter("catId");
            if (selectedCatId == null) {
                selectedCatId = (String)context.getRequest().getAttribute("catId");
            }
            if (selectedCatId == null) {
                selectedCatId = "" + thisList.getDefaultCategoryId();
            }
            context.getRequest().setAttribute("catId", (Object)selectedCatId);
            if (Integer.parseInt(selectedCatId) > 0) {
                recordId = context.getRequest().getParameter("recId");
                String recordDeleted = (String)context.getRequest().getAttribute("recordDeleted");
                if (recordDeleted != null) {
                    recordId = null;
                }
                CustomFieldCategory thisCategory = thisList.getCategory(Integer.parseInt(selectedCatId));
                if (recordId == null && thisCategory.getAllowMultipleRecords()) {
                    PagedListInfo folderListInfo = this.getPagedListInfo(context, "AccountFolderInfo");
                    folderListInfo.setLink("Accounts.do?command=Fields&orgId=" + orgId + "&catId=" + selectedCatId);
                    CustomFieldRecordList recordList = new CustomFieldRecordList();
                    recordList.setLinkModuleId(1);
                    recordList.setLinkItemId(thisOrganization.getOrgId());
                    recordList.setCategoryId(thisCategory.getId());
                    recordList.buildList(db);
                    recordList.buildRecordColumns(db, thisCategory);
                    context.getRequest().setAttribute("Records", (Object)recordList);
                } else {
                    thisCategory.setLinkModuleId(1);
                    thisCategory.setLinkItemId(thisOrganization.getOrgId());
                    if (recordId != null) {
                        thisCategory.setRecordId(Integer.parseInt(recordId));
                    } else {
                        thisCategory.buildRecordId(db);
                        recordId = String.valueOf(thisCategory.getRecordId());
                    }
                    thisCategory.setIncludeEnabled(1);
                    thisCategory.setIncludeScheduled(1);
                    thisCategory.setBuildResources(true);
                    thisCategory.buildResources(db);
                    showRecords = false;
                    if (thisCategory.getRecordId() > -1) {
                        CustomFieldRecord thisRecord = new CustomFieldRecord(db, thisCategory.getRecordId());
                        context.getRequest().setAttribute("Record", (Object)thisRecord);
                    }
                }
                context.getRequest().setAttribute("Category", (Object)thisCategory);
            }
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "View Accounts", "Custom Fields Details");
        if (Integer.parseInt(selectedCatId) <= 0) {
            return Accounts.getReturn(context, "FieldsEmpty");
        }
        if (recordId == null && showRecords) {
            return Accounts.getReturn(context, "FieldRecordList");
        }
        return Accounts.getReturn(context, "Fields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCheckFields(ActionContext context) {
        String selectedCatId;
        boolean hasMultipleRecords;
        Connection db;
        block19: {
            CustomFieldCategory thisCategory;
            block20: {
                String string;
                block22: {
                    String recordId;
                    block21: {
                        String orgId;
                        Organization thisOrganization;
                        block18: {
                            if (!this.hasPermission(context, "accounts-accounts-folders-view")) {
                                return "PermissionError";
                            }
                            db = null;
                            thisOrganization = null;
                            recordId = context.getRequest().getParameter("recId");
                            String source = context.getRequest().getParameter("source");
                            String actionStepId = context.getRequest().getParameter("actionStepId");
                            if (source != null && !"".equals(source.trim())) {
                                context.getRequest().setAttribute("source", (Object)source);
                            }
                            if (actionStepId != null && !"".equals(actionStepId.trim())) {
                                context.getRequest().setAttribute("actionStepId", (Object)actionStepId);
                            }
                            hasMultipleRecords = false;
                            selectedCatId = null;
                            orgId = context.getRequest().getParameter("orgId");
                            db = this.getConnection(context);
                            if (Accounts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) break block18;
                            String string2 = "PermissionError";
                            this.freeConnection(context, db);
                            return string2;
                        }
                        thisOrganization = new Organization(db, Integer.parseInt(orgId));
                        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
                        CustomFieldCategoryList thisList = new CustomFieldCategoryList();
                        thisList.setLinkModuleId(1);
                        thisList.setIncludeEnabled(1);
                        thisList.setIncludeScheduled(1);
                        thisList.setBuildResources(false);
                        thisList.buildList(db);
                        context.getRequest().setAttribute("CategoryList", (Object)thisList);
                        selectedCatId = context.getRequest().getParameter("catId");
                        if (selectedCatId == null) {
                            selectedCatId = (String)context.getRequest().getAttribute("catId");
                        }
                        if (selectedCatId == null) {
                            selectedCatId = "" + thisList.getDefaultCategoryId();
                        }
                        context.getRequest().setAttribute("catId", (Object)selectedCatId);
                        if (Integer.parseInt(selectedCatId) <= 0) break block19;
                        thisCategory = thisList.getCategory(Integer.parseInt(selectedCatId));
                        thisCategory.setLinkModuleId(1);
                        thisCategory.setIncludeEnabled(1);
                        thisCategory.setIncludeScheduled(1);
                        thisCategory.setLinkItemId(thisOrganization.getOrgId());
                        thisCategory.setBuildResources(true);
                        thisCategory.buildRecordId(db);
                        thisCategory.buildResources(db);
                        if ((recordId == null || "".equals(recordId.trim()) || "-1".equals(recordId)) && thisCategory.getRecordId() != -1) {
                            recordId = String.valueOf(thisCategory.getRecordId());
                        }
                        if (recordId != null && !"".equals(recordId.trim()) && !"-1".equals(recordId)) {
                            CustomFieldRecord thisRecord = new CustomFieldRecord(db, Integer.parseInt(recordId));
                            context.getRequest().setAttribute("Record", (Object)thisRecord);
                        }
                        if (thisCategory.getRecordId() == -1 && thisCategory.getAllowMultipleRecords()) {
                            PagedListInfo folderListInfo = this.getPagedListInfo(context, "AccountFolderInfo");
                            folderListInfo.setLink("Accounts.do?command=Fields&orgId=" + orgId + "&catId=" + selectedCatId);
                            CustomFieldRecordList recordList = new CustomFieldRecordList();
                            recordList.setLinkModuleId(1);
                            recordList.setLinkItemId(thisOrganization.getOrgId());
                            recordList.setCategoryId(thisCategory.getId());
                            recordList.buildList(db);
                            recordList.buildRecordColumns(db, thisCategory);
                            hasMultipleRecords = recordList.size() > 0 && (recordId == null || "".equals(recordId.trim())) || recordList.size() > 1 && recordId != null && !"".equals(recordId.trim());
                            context.getRequest().setAttribute("Records", (Object)recordList);
                            break block20;
                        }
                        if (thisCategory.getRecordId() == -1 || !thisCategory.getAllowMultipleRecords()) break block21;
                        context.getRequest().setAttribute("recordDeleted", (Object)"true");
                        string = this.executeCommandFields(context);
                        this.freeConnection(context, db);
                        return string;
                    }
                    if (thisCategory.getRecordId() == -1 || thisCategory.getAllowMultipleRecords()) break block22;
                    context.getRequest().setAttribute("recId", (Object)recordId);
                    string = this.executeCommandModifyFields(context);
                    this.freeConnection(context, db);
                    return string;
                }
                if (thisCategory.getRecordId() != -1 || thisCategory.getAllowMultipleRecords()) break block20;
                string = this.executeCommandAddFolderRecord(context);
                this.freeConnection(context, db);
                return string;
            }
            try {
                context.getRequest().setAttribute("Category", (Object)thisCategory);
            }
            catch (Exception e) {
                String string;
                try {
                    context.getRequest().setAttribute("Error", (Object)e);
                    string = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string;
            }
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "View Accounts", "Custom Fields Details");
        if (Integer.parseInt(selectedCatId) <= 0) {
            return Accounts.getReturn(context, "FieldsEmpty");
        }
        if (hasMultipleRecords) {
            return this.executeCommandModifyFields(context);
        }
        return Accounts.getReturn(context, "FieldRecordList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddFolderRecord(ActionContext context) {
        String orgId;
        Organization thisOrganization;
        Connection db;
        block8: {
            if (!this.hasPermission(context, "accounts-accounts-folders-add")) {
                return "PermissionError";
            }
            db = null;
            String source = context.getRequest().getParameter("source");
            String actionStepId = context.getRequest().getParameter("actionStepId");
            if (source != null && !"".equals(source.trim())) {
                context.getRequest().setAttribute("source", (Object)source);
            }
            if (actionStepId != null && !"".equals(actionStepId.trim())) {
                context.getRequest().setAttribute("actionStepId", (Object)actionStepId);
            }
            thisOrganization = null;
            orgId = context.getRequest().getParameter("orgId");
            db = this.getConnection(context);
            if (Accounts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) break block8;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            String selectedCatId = context.getRequest().getParameter("catId");
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(1);
            thisCategory.setLinkItemId(thisOrganization.getOrgId());
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            context.getRequest().setAttribute("Category", (Object)thisCategory);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "View Accounts", "Add Folder Record");
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        return Accounts.getReturn(context, "AddFolderRecord");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyFields(ActionContext context) {
        String orgId;
        String recordId;
        String selectedCatId;
        Organization thisOrganization;
        Connection db;
        block10: {
            if (!this.hasPermission(context, "accounts-accounts-folders-edit")) {
                return "PermissionError";
            }
            db = null;
            thisOrganization = null;
            String source = context.getRequest().getParameter("source");
            String actionStepId = context.getRequest().getParameter("actionStepId");
            if (source != null && !"".equals(source.trim())) {
                context.getRequest().setAttribute("source", (Object)source);
            }
            if (actionStepId != null && !"".equals(actionStepId.trim())) {
                context.getRequest().setAttribute("actionStepId", (Object)actionStepId);
            }
            selectedCatId = context.getRequest().getParameter("catId");
            recordId = context.getRequest().getParameter("recId");
            if ((recordId == null || "".equals(recordId.trim()) || "-1".equals(recordId.trim())) && ((recordId = (String)context.getRequest().getAttribute("recId")) == null || "".equals(recordId.trim()))) {
                recordId = String.valueOf(-1);
            }
            orgId = context.getRequest().getParameter("orgId");
            db = this.getConnection(context);
            if (Accounts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) break block10;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            thisCategory.setLinkModuleId(1);
            thisCategory.setLinkItemId(thisOrganization.getOrgId());
            thisCategory.setRecordId(Integer.parseInt(recordId));
            thisCategory.setIncludeEnabled(1);
            thisCategory.setIncludeScheduled(1);
            thisCategory.setBuildResources(true);
            thisCategory.buildResources(db);
            context.getRequest().setAttribute("Category", (Object)thisCategory);
        }
        catch (Exception e) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)e);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "View Accounts", "Modify Custom Fields");
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        if (recordId.equals("-1")) {
            return Accounts.getReturn(context, "AddFolderRecord");
        }
        return Accounts.getReturn(context, "ModifyFields");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdateFields(ActionContext context) {
        boolean isValid;
        int resultCount;
        Connection db;
        block19: {
            String string;
            String orgId;
            Organization thisOrganization;
            String actionStepId;
            block18: {
                String popupString;
                if (!this.hasPermission(context, "accounts-accounts-folders-edit")) {
                    return "PermissionError";
                }
                db = null;
                boolean popup = false;
                String source = context.getRequest().getParameter("source");
                actionStepId = context.getRequest().getParameter("actionStepId");
                if (source != null && !"".equals(source.trim())) {
                    context.getRequest().setAttribute("source", (Object)source);
                }
                if (actionStepId != null && !"".equals(actionStepId.trim())) {
                    context.getRequest().setAttribute("actionStepId", (Object)actionStepId);
                }
                popup = (popupString = context.getRequest().getParameter("popup")) != null && !"".equals(popupString.trim()) && "true".equals(popupString);
                thisOrganization = null;
                resultCount = 0;
                isValid = false;
                context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
                orgId = context.getRequest().getParameter("orgId");
                db = this.getConnection(context);
                if (Accounts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) break block18;
                String string2 = "PermissionError";
                this.freeConnection(context, db);
                return string2;
            }
            try {
                thisOrganization = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
                CustomFieldCategoryList thisList = new CustomFieldCategoryList();
                thisList.setLinkModuleId(1);
                thisList.setIncludeEnabled(1);
                thisList.setIncludeScheduled(1);
                thisList.setBuildResources(false);
                thisList.buildList(db);
                context.getRequest().setAttribute("CategoryList", (Object)thisList);
                String selectedCatId = context.getRequest().getParameter("catId");
                String recordId = context.getRequest().getParameter("recId");
                context.getRequest().setAttribute("catId", (Object)selectedCatId);
                CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
                thisCategory.setLinkModuleId(1);
                thisCategory.setLinkItemId(thisOrganization.getOrgId());
                thisCategory.setRecordId(Integer.parseInt(recordId));
                thisCategory.setIncludeEnabled(1);
                thisCategory.setIncludeScheduled(1);
                thisCategory.setBuildResources(true);
                thisCategory.buildResources(db);
                thisCategory.setParameters(context);
                thisCategory.setModifiedBy(this.getUserId(context));
                if (!thisCategory.getReadOnly()) {
                    thisCategory.setCanNotContinue(true);
                    isValid = this.validateObject(context, db, thisCategory);
                    if (isValid) {
                        for (CustomFieldGroup group : thisCategory) {
                            for (CustomField field : group) {
                                field.setValidateData(true);
                                field.setRecordId(thisCategory.getRecordId());
                                isValid = this.validateObject(context, db, field) && isValid;
                            }
                        }
                    }
                    if (isValid && resultCount != -1) {
                        thisCategory.setCanNotContinue(true);
                        resultCount = thisCategory.update(db);
                        thisCategory.setCanNotContinue(false);
                        resultCount = thisCategory.insertGroup(db, thisCategory.getRecordId());
                    }
                }
                context.getRequest().setAttribute("Category", (Object)thisCategory);
                if (resultCount != -1 && isValid) {
                    thisCategory.buildResources(db);
                    CustomFieldRecord thisRecord = new CustomFieldRecord(db, thisCategory.getRecordId());
                    context.getRequest().setAttribute("Record", (Object)thisRecord);
                    break block19;
                }
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Accounts-> ModifyField validation error");
                }
                if (actionStepId != null && !"".equals(actionStepId.trim())) {
                    context.getRequest().setAttribute("recId", (Object)recordId);
                }
                context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
                string = Accounts.getReturn(context, "ModifyFields");
            }
            catch (Exception e) {
                String string3;
                try {
                    context.getRequest().setAttribute("Error", (Object)e);
                    string3 = "SystemError";
                }
                catch (Throwable throwable) {
                    this.freeConnection(context, db);
                    throw throwable;
                }
                this.freeConnection(context, db);
                return string3;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        if (resultCount == 1 && isValid) {
            if (context.getRequest().getParameter("source") != null && "attachplan".equals(context.getRequest().getParameter("source"))) {
                return "UpdateFieldsAttachPlanOK";
            }
            return Accounts.getReturn(context, "UpdateFields");
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandInsertFields(ActionContext context) {
        boolean popup;
        block19: {
            String popupString;
            if (!this.hasPermission(context, "accounts-accounts-folders-add")) {
                return "PermissionError";
            }
            popup = false;
            String source = context.getRequest().getParameter("source");
            String actionStepId = context.getRequest().getParameter("actionStepId");
            if (source != null && !"".equals(source.trim())) {
                context.getRequest().setAttribute("source", (Object)source);
            }
            if (actionStepId != null && !"".equals(actionStepId.trim())) {
                context.getRequest().setAttribute("actionStepId", (Object)actionStepId);
            }
            popup = (popupString = context.getRequest().getParameter("popup")) != null && !"".equals(popupString.trim()) && "true".equals(popupString);
            Connection db = null;
            int resultCode = -1;
            boolean isValid = false;
            Organization thisOrganization = null;
            try {
                db = this.getConnection(context);
                String orgId = context.getRequest().getParameter("orgId");
                if (!Accounts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                    String string = "PermissionError";
                    return string;
                }
                thisOrganization = new Organization(db, Integer.parseInt(orgId));
                context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
                CustomFieldCategoryList thisList = new CustomFieldCategoryList();
                thisList.setLinkModuleId(1);
                thisList.setIncludeEnabled(1);
                thisList.setIncludeScheduled(1);
                thisList.setBuildResources(false);
                thisList.buildList(db);
                context.getRequest().setAttribute("CategoryList", (Object)thisList);
                String selectedCatId = context.getRequest().getParameter("catId");
                context.getRequest().setAttribute("catId", (Object)selectedCatId);
                CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
                thisCategory.setLinkModuleId(1);
                thisCategory.setLinkItemId(thisOrganization.getOrgId());
                thisCategory.setIncludeEnabled(1);
                thisCategory.setIncludeScheduled(1);
                thisCategory.setBuildResources(true);
                thisCategory.buildResources(db);
                thisCategory.setParameters(context);
                thisCategory.setEnteredBy(this.getUserId(context));
                thisCategory.setModifiedBy(this.getUserId(context));
                if (!thisCategory.getReadOnly()) {
                    thisCategory.setCanNotContinue(true);
                    isValid = this.validateObject(context, db, thisCategory);
                    if (isValid) {
                        resultCode = thisCategory.insert(db);
                        for (CustomFieldGroup group : thisCategory) {
                            for (CustomField field : group) {
                                field.setValidateData(true);
                                field.setRecordId(thisCategory.getRecordId());
                                isValid = this.validateObject(context, db, field) && isValid;
                            }
                        }
                    }
                    thisCategory.setCanNotContinue(false);
                    if (isValid && resultCode != -1) {
                        resultCode = thisCategory.insertGroup(db, thisCategory.getRecordId());
                    }
                }
                context.getRequest().setAttribute("Category", (Object)thisCategory);
                if (resultCode != -1 && isValid) {
                    this.processInsertHook(context, thisCategory);
                    break block19;
                }
                if (thisCategory.getRecordId() != -1) {
                    CustomFieldRecord record = new CustomFieldRecord(db, thisCategory.getRecordId());
                    record.delete(db);
                }
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("Accounts-> InsertField validation error");
                }
                context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
                String string = Accounts.getReturn(context, "AddFolderRecord");
                return string;
            }
            catch (Exception e) {
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        if (popup && context.getRequest().getParameter("source") != null && "attachplan".equals(context.getRequest().getParameter("source"))) {
            return "InsertFieldsAttachPlanOK";
        }
        return this.executeCommandFields(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteFields(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-folders-delete")) {
            return "PermissionError";
        }
        String source = context.getRequest().getParameter("source");
        String popupString = context.getRequest().getParameter("popup");
        boolean popup = popupString != null && "true".equals(popupString.trim());
        boolean returnToList = true;
        String actionStepId = context.getRequest().getParameter("actionStepId");
        ActionItemWork item = null;
        if (source != null && !"".equals(source.trim())) {
            context.getRequest().setAttribute("source", (Object)source);
        }
        if (actionStepId != null && !"".equals(actionStepId.trim())) {
            context.getRequest().setAttribute("actionStepId", (Object)actionStepId);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String selectedCatId = context.getRequest().getParameter("catId");
            String recordId = context.getRequest().getParameter("recId");
            String orgId = context.getRequest().getParameter("orgId");
            if (!Accounts.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            CustomFieldCategory thisCategory = new CustomFieldCategory(db, Integer.parseInt(selectedCatId));
            CustomFieldRecord thisRecord = new CustomFieldRecord(db, Integer.parseInt(recordId));
            thisRecord.setLinkModuleId(1);
            thisRecord.setLinkItemId(Integer.parseInt(orgId));
            thisRecord.setCategoryId(Integer.parseInt(selectedCatId));
            if (!(actionStepId == null || "".equals(actionStepId.trim()) || "-1".equals(actionStepId) || "null".equals(actionStepId))) {
                item = new ActionItemWork(db, Integer.parseInt(actionStepId));
            }
            if (!thisCategory.getReadOnly()) {
                thisRecord.delete(db);
            }
            context.getRequest().setAttribute("recordDeleted", (Object)"true");
            if (item != null && item.getId() > 0 && thisRecord.getId() == item.getLinkItemId() && item.getLinkModuleId() == ActionPlan.getMapIdGivenConstantId(db, 42420034)) {
                returnToList = false;
                thisCategory.setRecordId(thisRecord.getId());
                context.getRequest().setAttribute("Category", (Object)thisCategory);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (returnToList) {
            return Accounts.getReturn(context, "DeleteFields");
        }
        return "DeletedFieldPopupOK";
    }

    private void resetPagedListInfo(ActionContext context) {
        this.deletePagedListInfo(context, "ContactListInfo");
        this.deletePagedListInfo(context, "AccountFolderInfo");
        this.deletePagedListInfo(context, "RptListInfo");
        this.deletePagedListInfo(context, "OpportunityPagedInfo");
        this.deletePagedListInfo(context, "AccountTicketInfo");
        this.deletePagedListInfo(context, "AutoGuideAccountInfo");
        this.deletePagedListInfo(context, "RevenueListInfo");
        this.deletePagedListInfo(context, "AccountDocumentInfo");
        this.deletePagedListInfo(context, "ServiceContractListInfo");
        this.deletePagedListInfo(context, "AssetListInfo");
        this.deletePagedListInfo(context, "AccountProjectInfo");
        this.deletePagedListInfo(context, "orgHistoryListInfo");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRebuildFormElements(ActionContext context) {
        Connection db = null;
        String index = null;
        if (context.getRequest().getParameter("index") != null) {
            index = context.getRequest().getParameter("index");
        }
        try {
            db = this.getConnection(context);
            if (Integer.parseInt(index) == 0) {
                LookupList phoneTypeList = new LookupList(db, "lookup_orgphone_types");
                context.getRequest().setAttribute("OrgPhoneTypeList", (Object)phoneTypeList);
                LookupList addrTypeList = new LookupList(db, "lookup_orgaddress_types");
                context.getRequest().setAttribute("OrgAddressTypeList", (Object)addrTypeList);
                LookupList emailTypeList = new LookupList(db, "lookup_orgemail_types");
                context.getRequest().setAttribute("OrgEmailTypeList", (Object)emailTypeList);
            } else {
                LookupList phoneTypeList = new LookupList(db, "lookup_contactphone_types");
                context.getRequest().setAttribute("OrgPhoneTypeList", (Object)phoneTypeList);
                LookupList addrTypeList = new LookupList(db, "lookup_contactaddress_types");
                context.getRequest().setAttribute("OrgAddressTypeList", (Object)addrTypeList);
                LookupList emailTypeList = new LookupList(db, "lookup_contactemail_types");
                context.getRequest().setAttribute("OrgEmailTypeList", (Object)emailTypeList);
            }
        }
        catch (Exception errorMessage) {
        }
        finally {
            this.freeConnection(context, db);
        }
        return "RebuildElementsOK";
    }

    public String executeCommandOwnerJSList(ActionContext context) {
        int siteId = -1;
        String siteIdString = context.getRequest().getParameter("siteId");
        if (siteIdString != null || !"".equals(siteIdString)) {
            siteId = Integer.parseInt(siteIdString);
        }
        if (!Accounts.isSiteAccessPermitted(context, String.valueOf(siteId))) {
            return "PermissionError";
        }
        UserList userList = new UserList();
        HtmlSelect userListSelect = new HtmlSelect();
        try {
            userList = this.filterOwnerListForSite(context, siteId);
            userListSelect = userList.getHtmlSelectObj("userId", this.getUserId(context));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            return "SystemError";
        }
        context.getRequest().setAttribute("UserListSelect", (Object)userListSelect);
        return "OwnerJsListOK";
    }

    private UserList filterOwnerListForSite(ActionContext context, int siteId) throws Exception {
        User tmpUser;
        Iterator itr;
        UserBean thisUser = (UserBean)((Object)context.getSession().getAttribute("User"));
        User thisRec = thisUser.getUserRecord();
        UserList shortChildList = thisRec.getShortChildList();
        UserList userList = thisRec.getFullChildList(shortChildList, new UserList());
        userList.setMyId(this.getUserId(context));
        userList.setMyValue(thisUser.getContact().getNameLastFirst());
        userList.setIncludeMe(true);
        userList.setExcludeDisabledIfUnselected(true);
        userList.setExcludeExpiredIfUnselected(true);
        if (siteId != -1) {
            itr = userList.iterator();
            while (itr.hasNext()) {
                tmpUser = (User)((Object)itr.next());
                if (tmpUser.getSiteId() == -1 || siteId == tmpUser.getSiteId()) continue;
                itr.remove();
            }
        }
        if (siteId == -1) {
            itr = userList.iterator();
            while (itr.hasNext()) {
                tmpUser = (User)((Object)itr.next());
                if (siteId == tmpUser.getSiteId()) continue;
                itr.remove();
            }
        }
        return userList;
    }

    protected void deleteRecentItems(ActionContext context, Connection db, Organization organization) throws SQLException {
        ContactList contactList = new ContactList();
        contactList.setOrgId(organization.getOrgId());
        contactList.setIncludeOnlyTrashed(true);
        contactList.buildList(db);
        this.deleteRecentItems(context, contactList.iterator());
        for (Contact contact : contactList) {
            OpportunityHeaderList oppList = new OpportunityHeaderList();
            oppList.setContactId(contact.getId());
            oppList.setIncludeOnlyTrashed(true);
            oppList.buildList(db);
            this.deleteRecentItems(context, oppList.iterator());
        }
        OpportunityHeaderList opportunityList = new OpportunityHeaderList();
        opportunityList.setOrgId(organization.getOrgId());
        opportunityList.setIncludeOnlyTrashed(true);
        opportunityList.buildList(db);
        this.deleteRecentItems(context, opportunityList.iterator());
        TicketList ticketList = new TicketList();
        ticketList.setOrgId(organization.getOrgId());
        ticketList.setIncludeOnlyTrashed(true);
        ticketList.buildList(db);
        this.deleteRecentItems(context, ticketList.iterator());
    }

    public String executeCommandStates(ActionContext context) {
        String country = context.getRequest().getParameter("country");
        String form = context.getRequest().getParameter("form");
        String obj = context.getRequest().getParameter("obj");
        String stateObj = context.getRequest().getParameter("stateObj");
        String defaultValue = context.getRequest().getParameter("selected");
        SystemStatus systemStatus = this.getSystemStatus(context);
        StateSelect stateSelect = new StateSelect(systemStatus, country);
        context.getRequest().setAttribute("stateSelect", (Object)stateSelect.getHtmlSelectObj(country));
        context.getRequest().setAttribute("form", (Object)form);
        context.getRequest().setAttribute("obj", (Object)obj);
        context.getRequest().setAttribute("stateObj", (Object)stateObj);
        if (defaultValue != null) {
            context.getRequest().setAttribute("selected", (Object)defaultValue);
        }
        return "StatesOK";
    }
}

