/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.assets.base.Asset;
import org.aspcfs.modules.assets.base.AssetList;
import org.aspcfs.modules.assets.base.AssetMaterialList;
import org.aspcfs.modules.base.CategoryList;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.servicecontracts.base.ServiceContract;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public class AccountsAssets
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandList(ActionContext context) {
        if (!this.hasPermission(context, "accounts-assets-view")) {
            return "PermissionError";
        }
        String parentId = context.getRequest().getParameter("parentId");
        AssetList assetList = new AssetList();
        String orgId = context.getRequest().getParameter("orgId");
        PagedListInfo assetListInfo = this.getPagedListInfo(context, "AssetListInfo");
        assetListInfo.setLink("AccountsAssets.do?command=List&orgId=" + orgId + "&parentId=" + (parentId != null ? parentId : ""));
        Connection db = null;
        try {
            Organization tmpOrganization;
            db = this.getConnection(context);
            if (!AccountsAssets.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            this.setOrganization(context, db);
            assetList.setPagedListInfo(assetListInfo);
            assetList.setOrgId(Integer.parseInt(orgId));
            if (parentId != null && !"".equals(parentId.trim()) && !"-1".equals(parentId.trim())) {
                assetList.setParentId(parentId);
                Asset parent = new Asset();
                parent.setBuildCompleteParentList(true);
                parent.setIncludeMe(true);
                parent.queryRecord(db, Integer.parseInt(parentId));
                context.getRequest().setAttribute("parent", (Object)parent);
            }
            if ((tmpOrganization = (Organization)((Object)context.getRequest().getAttribute("OrgDetails"))).isTrashed()) {
                assetList.setIncludeOnlyTrashed(true);
            }
            assetList.buildList(db);
            this.buildFormElements(context, db);
            this.buildCategories(context, db, null);
            context.getRequest().setAttribute("assetList", (Object)assetList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsAssets.getReturn(context, "AccountsAssetsList");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAdd(ActionContext context) {
        if (!this.hasPermission(context, "accounts-assets-add")) {
            return "PermissionError";
        }
        String parentId = context.getRequest().getParameter("parentId");
        Connection db = null;
        String orgId = context.getRequest().getParameter("orgId");
        try {
            db = this.getConnection(context);
            if (!AccountsAssets.isRecordAccessPermitted(context, db, Integer.parseInt(orgId))) {
                String string = "PermissionError";
                return string;
            }
            this.setOrganization(context, db);
            Asset thisAsset = (Asset)((Object)context.getFormBean());
            this.buildFormElements(context, db);
            this.buildCategories(context, db, thisAsset);
            if (parentId != null && !"".equals(parentId.trim()) && !"-1".equals(parentId.trim())) {
                if (thisAsset.getParentId() == -1) {
                    thisAsset.setParentId(parentId);
                }
                Asset parent = new Asset();
                parent.setBuildCompleteParentList(true);
                parent.setIncludeMe(true);
                parent.queryRecord(db, Integer.parseInt(parentId));
                context.getRequest().setAttribute("parent", (Object)parent);
            }
            Organization orgDetails = (Organization)((Object)context.getRequest().getAttribute("OrgDetails"));
            ContactList contactList = new ContactList();
            contactList.setOrgId(orgId);
            contactList.buildList(db);
            contactList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("contactList", (Object)contactList);
            String currentDate = AccountsAssets.getCurrentDateAsString(context);
            context.getRequest().setAttribute("currentDate", (Object)currentDate);
            context.getRequest().setAttribute("asset", (Object)thisAsset);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsAssets.getReturn(context, "AccountsAssetsAdd");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "accounts-assets-add")) {
            return "PermissionError";
        }
        Connection db = null;
        boolean inserted = false;
        boolean isValid = false;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            Asset thisAsset = (Asset)((Object)context.getFormBean());
            if (!AccountsAssets.isRecordAccessPermitted(context, db, thisAsset.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            thisAsset.setEnteredBy(this.getUserId(context));
            thisAsset.setModifiedBy(this.getUserId(context));
            isValid = this.validateObject(context, db, (Object)thisAsset);
            if (isValid) {
                inserted = thisAsset.insert(db);
            }
            if (inserted) {
                thisAsset = new Asset(db, "" + thisAsset.getId());
                if (thisAsset.getStatusName() == null || "".equals(thisAsset.getStatusName())) {
                    thisAsset.setStatusName(systemStatus.getLabel("accounts.accounts_contacts_calls_details_followup_include.None"));
                }
                this.processInsertHook(context, (Object)thisAsset);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (inserted) {
            return this.executeCommandList(context);
        }
        return this.executeCommandAdd(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-assets-edit")) {
            return "PermissionError";
        }
        Connection db = null;
        String orgId = context.getRequest().getParameter("orgId");
        if (orgId == null || "".equals(orgId)) {
            orgId = (String)context.getRequest().getAttribute("orgId");
        }
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            int assetId = Integer.parseInt(context.getRequest().getParameter("id"));
            Asset thisAsset = (Asset)((Object)context.getFormBean());
            if (thisAsset.getId() == -1) {
                thisAsset.setBuildMaterials(true);
                thisAsset.queryRecord(db, assetId);
            }
            if (!AccountsAssets.isRecordAccessPermitted(context, db, thisAsset.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            this.buildFormElements(context, db);
            this.buildCategories(context, db, thisAsset);
            thisAsset.buildCompleteParentList(db);
            context.getRequest().setAttribute("return", (Object)context.getRequest().getParameter("return"));
            Organization orgDetails = (Organization)((Object)context.getRequest().getAttribute("OrgDetails"));
            ContactList contactList = new ContactList();
            contactList.setOrgId(orgDetails.getOrgId());
            contactList.setDefaultContactId(thisAsset.getContactId());
            contactList.buildList(db);
            contactList.setEmptyHtmlSelectRecord(this.getSystemStatus(context).getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("contactList", (Object)contactList);
            context.getRequest().setAttribute("asset", (Object)thisAsset);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsAssets.getReturn(context, "AccountsAssetsModify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandUpdate(ActionContext context) {
        if (!this.hasPermission(context, "accounts-assets-edit")) {
            return "PermissionError";
        }
        boolean isValid = false;
        Connection db = null;
        int resultCount = -1;
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            Asset thisAsset = (Asset)((Object)context.getFormBean());
            if (!AccountsAssets.isRecordAccessPermitted(context, db, thisAsset.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            Asset previousAsset = new Asset(db, "" + thisAsset.getId());
            thisAsset.setModifiedBy(this.getUserId(context));
            thisAsset.buildCompleteParentList(db);
            isValid = this.validateObject(context, db, (Object)thisAsset);
            if (isValid) {
                resultCount = thisAsset.update(db);
            }
            if (resultCount > 0) {
                thisAsset = new Asset(db, "" + thisAsset.getId());
                if (thisAsset.getStatusName() == null || "".equals(thisAsset.getStatusName())) {
                    thisAsset.setStatusName(systemStatus.getLabel("accounts.accounts_contacts_calls_details_followup_include.None"));
                }
                this.processUpdateHook(context, (Object)previousAsset, (Object)thisAsset);
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return this.executeCommandList(context);
            }
            return this.executeCommandView(context);
        }
        if (resultCount == -1 || !isValid) {
            return this.executeCommandModify(context);
        }
        context.getRequest().setAttribute("Error", (Object)"<b>This record could not be updated because someone else updated it first.</b><p>You can hit the back button to review the changes that could not be committed, but you must reload the record and make the changes again.");
        return "UserError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-assets-delete")) {
            return "PermissionError";
        }
        Exception errorMessage = null;
        Connection db = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String id = context.getRequest().getParameter("id");
        String orgId = context.getRequest().getParameter("orgId");
        try {
            db = this.getConnection(context);
            Asset thisAsset = new Asset(db, id);
            if (!AccountsAssets.isRecordAccessPermitted(context, db, thisAsset.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            DependencyList dependencies = thisAsset.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
            if (dependencies.canDelete()) {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.header"));
                htmlDialog.addButton(systemStatus.getLabel("button.deleteAll"), "javascript:window.location.href='AccountsAssets.do?command=Trash&action=delete&orgId=" + orgId + "&id=" + id + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType") + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            } else {
                htmlDialog.setHeader(systemStatus.getLabel("confirmdelete.unableHeader"));
                htmlDialog.addButton(systemStatus.getLabel("button.delete"), "javascript:window.location.href='AccountsAssets.do?command=Trash&action=delete&orgId=" + orgId + "&id=" + id + "&forceDelete=true" + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType") + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            errorMessage = e;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errorMessage == null) {
            context.getSession().setAttribute("Dialog", (Object)htmlDialog);
            return "ConfirmDeleteOK";
        }
        context.getRequest().setAttribute("Error", (Object)errorMessage);
        return "SystemError";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        boolean inline;
        if (!this.hasPermission(context, "accounts-assets-delete")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean recordUpdated = false;
        Connection db = null;
        Asset thisAsset = null;
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            thisAsset = new Asset();
            thisAsset.setId(context.getRequest().getParameter("id"));
            recordUpdated = thisAsset.updateStatus(db, true, this.getUserId(context));
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean bl = inline = context.getRequest().getParameter("popupType") != null && "inline".equals(context.getRequest().getParameter("popupType"));
        if (recordUpdated) {
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountsAssets.do?command=List&orgId=" + context.getRequest().getParameter("orgId") + (inline ? "&popup=true" : "")));
            return "DeleteOK";
        }
        this.processErrors(context, thisAsset.getErrors());
        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.assetDeletion"));
        context.getRequest().setAttribute("refreshUrl", (Object)("AccountsAssets.do?command=View&orgId=" + context.getRequest().getParameter("orgId") + (inline ? "&popup=true" : "")));
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-assets-delete")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        boolean recordDeleted = false;
        Connection db = null;
        Asset thisAsset = null;
        try {
            db = this.getConnection(context);
            this.setOrganization(context, db);
            thisAsset = new Asset(db, context.getRequest().getParameter("id"));
            if (!AccountsAssets.isRecordAccessPermitted(context, db, thisAsset.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            recordDeleted = thisAsset.delete(db, AccountsAssets.getDbNamePath(context));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordDeleted) {
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountsAssets.do?command=List&orgId=" + context.getRequest().getParameter("orgId")));
            return AccountsAssets.getReturn(context, "Delete");
        }
        boolean inline = context.getRequest().getParameter("popupType") != null && "inline".equals(context.getRequest().getParameter("popupType"));
        this.processErrors(context, thisAsset.getErrors());
        context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.assetDeletion"));
        context.getRequest().setAttribute("refreshUrl", (Object)("AccountsAssets.do?command=View&orgId=" + context.getRequest().getParameter("orgId")));
        return AccountsAssets.getReturn(context, "Delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "accounts-assets-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String id = context.getRequest().getParameter("id");
            if (id == null || "".equals(id)) {
                id = (String)context.getRequest().getAttribute("id");
            }
            Asset thisAsset = new Asset();
            thisAsset.setBuildMaterials(true);
            thisAsset.setBuildCompleteParentList(true);
            thisAsset.queryRecord(db, Integer.parseInt(id));
            if (!AccountsAssets.isRecordAccessPermitted(context, db, thisAsset.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            Organization thisOrganization = new Organization(db, thisAsset.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            ServiceContract thisContract = new ServiceContract();
            thisContract.queryRecord(db, thisAsset.getContractId());
            if (!AccountsAssets.isRecordAccessPermitted(context, db, thisAsset.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            if (thisAsset.getContactId() > -1) {
                Contact thisContact = new Contact(db, thisAsset.getContactId());
                context.getRequest().setAttribute("assetContact", (Object)thisContact);
            }
            this.buildFormElements(context, db);
            this.buildCategories(context, db, thisAsset);
            context.getRequest().setAttribute("asset", (Object)thisAsset);
            context.getRequest().setAttribute("serviceContract", (Object)thisContract);
            String string = AccountsAssets.getReturn(context, "AccountsAssetsView");
            return string;
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandHistory(ActionContext context) {
        if (!this.hasPermission(context, "accounts-assets-view")) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            String id = context.getRequest().getParameter("id");
            Asset thisAsset = new Asset(db, id);
            if (!AccountsAssets.isRecordAccessPermitted(context, db, thisAsset.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            Organization thisOrganization = new Organization(db, thisAsset.getOrgId());
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            PagedListInfo assetHistoryInfo = this.getPagedListInfo(context, "AssetHistoryInfo");
            assetHistoryInfo.setLink("AccountsAssets.do?command=History&id=" + thisAsset.getId() + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType"));
            TicketList ticketList = new TicketList();
            ticketList.setPagedListInfo(assetHistoryInfo);
            ticketList.setAssetId(thisAsset.getId());
            ticketList.buildList(db);
            context.getRequest().setAttribute("ticketList", (Object)ticketList);
            thisAsset.buildCompleteParentList(db);
            context.getRequest().setAttribute("asset", (Object)thisAsset);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsAssets.getReturn(context, "AccountsAssetsHistory");
    }

    public void buildFormElements(ActionContext context, Connection db) throws SQLException {
        SystemStatus thisSystem = this.getSystemStatus(context);
        LookupList assetStatusList = new LookupList(db, "lookup_asset_status");
        assetStatusList.addItem(-1, thisSystem.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("assetStatusList", (Object)assetStatusList);
        LookupList assetVendorList = new LookupList(db, "lookup_asset_vendor");
        assetVendorList.addItem(-1, "-- None --");
        context.getRequest().setAttribute("assetVendorList", (Object)assetVendorList);
        LookupList assetManufacturerList = new LookupList(db, "lookup_asset_manufacturer");
        assetManufacturerList.addItem(-1, "-- None --");
        context.getRequest().setAttribute("assetManufacturerList", (Object)assetManufacturerList);
        LookupList responseModelList = new LookupList(db, "lookup_response_model");
        responseModelList.addItem(-1, thisSystem.getLabel("accounts.assets.contractDefault"));
        context.getRequest().setAttribute("responseModelList", (Object)responseModelList);
        LookupList phoneModelList = new LookupList(db, "lookup_phone_model");
        phoneModelList.addItem(-1, thisSystem.getLabel("accounts.assets.contractDefault"));
        context.getRequest().setAttribute("phoneModelList", (Object)phoneModelList);
        LookupList onsiteModelList = new LookupList(db, "lookup_onsite_model");
        onsiteModelList.addItem(-1, thisSystem.getLabel("accounts.assets.contractDefault"));
        context.getRequest().setAttribute("onsiteModelList", (Object)onsiteModelList);
        LookupList assetMaterialList = new LookupList(db, "lookup_asset_materials");
        context.getRequest().setAttribute("assetMaterialList", (Object)assetMaterialList);
        LookupList emailModelList = new LookupList(db, "lookup_email_model");
        emailModelList.addItem(-1, thisSystem.getLabel("accounts.assets.contractDefault"));
        context.getRequest().setAttribute("emailModelList", (Object)emailModelList);
    }

    public void buildCategories(ActionContext context, Connection db, Asset thisAsset) throws SQLException {
        Organization orgDetails = (Organization)((Object)context.getRequest().getAttribute("OrgDetails"));
        CategoryList categoryList1 = new CategoryList("asset_category");
        categoryList1.setCatLevel(0);
        categoryList1.setParentCode(0);
        categoryList1.setSiteId(orgDetails.getSiteId());
        categoryList1.setExclusiveToSite(true);
        categoryList1.buildList(db);
        categoryList1.setHtmlJsEvent("onChange=\"javascript:updateCategoryList('1');\"");
        categoryList1.getCatListSelect().addItem(-1, "Undetermined");
        context.getRequest().setAttribute("categoryList1", (Object)categoryList1);
        CategoryList categoryList2 = new CategoryList("asset_category");
        categoryList2.setCatLevel(1);
        categoryList2.setSiteId(orgDetails.getSiteId());
        if (thisAsset == null) {
            categoryList2.buildList(db);
        } else if (thisAsset.getLevel1() > -1) {
            categoryList2.setParentCode(thisAsset.getLevel1());
            categoryList2.buildList(db);
        }
        categoryList2.setSiteId(orgDetails.getSiteId());
        categoryList2.setExclusiveToSite(true);
        categoryList2.setHtmlJsEvent("onChange=\"javascript:updateCategoryList('2');\"");
        categoryList2.getCatListSelect().addItem(-1, "Undetermined");
        context.getRequest().setAttribute("categoryList2", (Object)categoryList2);
        CategoryList categoryList3 = new CategoryList("asset_category");
        categoryList3.setCatLevel(2);
        categoryList3.setSiteId(orgDetails.getSiteId());
        if (thisAsset == null) {
            categoryList3.buildList(db);
        } else if (thisAsset.getLevel2() > -1) {
            categoryList3.setParentCode(thisAsset.getLevel2());
            categoryList3.buildList(db);
        }
        categoryList3.setSiteId(orgDetails.getSiteId());
        categoryList3.setExclusiveToSite(true);
        categoryList3.getCatListSelect().addItem(-1, "Undetermined");
        context.getRequest().setAttribute("categoryList3", (Object)categoryList3);
    }

    public void setOrganization(ActionContext context, Connection db) throws SQLException {
        Organization thisOrganization = null;
        String orgId = context.getRequest().getParameter("orgId");
        if (orgId == null || "".equals(orgId)) {
            String contactId = context.getRequest().getParameter("contactId");
            Contact contact = new Contact(db, Integer.parseInt(contactId));
            orgId = "" + contact.getOrgId();
            context.getRequest().setAttribute("orgId", (Object)orgId);
        }
        thisOrganization = new Organization(db, Integer.parseInt(orgId));
        context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCategoryJSList(ActionContext context) {
        Connection db = null;
        try {
            int level = Integer.parseInt(context.getRequest().getParameter("level"));
            int code = Integer.parseInt(context.getRequest().getParameter("code"));
            int orgId = Integer.parseInt(context.getRequest().getParameter("orgId"));
            db = this.getConnection(context);
            Organization orgDetails = new Organization(db, orgId);
            CategoryList categoryList = new CategoryList("asset_category");
            categoryList.setCatLevel(level);
            categoryList.setSiteId(orgDetails.getSiteId());
            categoryList.setExclusiveToSite(true);
            categoryList.setParentCode(code);
            if (code > 0) {
                db = this.getConnection(context);
                categoryList.buildList(db);
            }
            context.getRequest().setAttribute("categoryList", (Object)categoryList);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.freeConnection(context, db);
        }
        return "CategoryJSListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewMaterials(ActionContext context) {
        Connection db = null;
        HashMap map = new HashMap();
        LookupList list = new LookupList();
        SystemStatus systemStatus = this.getSystemStatus(context);
        try {
            String assetId = context.getRequest().getParameter("assetId");
            if (assetId == null || "".equals(assetId)) {
                assetId = (String)context.getRequest().getAttribute("assetId");
            }
            String materials = context.getRequest().getParameter("materials");
            db = this.getConnection(context);
            if (materials != null && !"".equals(materials)) {
                list = systemStatus.getLookupList(db, "lookup_asset_materials");
                map = AssetMaterialList.getQuantityMap(materials);
            }
            context.getRequest().setAttribute("materialTypeList", (Object)list);
            context.getRequest().setAttribute("materialMap", map);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsAssets.getReturn(context, "ViewMaterials");
    }
}

