/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.accounts.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.contacts.base.Call;
import org.aspcfs.modules.contacts.base.CallList;
import org.aspcfs.modules.contacts.base.CallResult;
import org.aspcfs.modules.contacts.base.CallResultList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.mycfs.base.CFSNote;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;
import org.aspcfs.utils.web.RequestUtils;

public final class AccountsCalls
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        int MINIMIZED_ITEMS_PER_PAGE = 5;
        if (!this.hasPermission(context, "accounts-accounts-contacts-calls-view")) {
            return "PermissionError";
        }
        String orgId = context.getRequest().getParameter("orgId");
        if ("true".equals(context.getRequest().getParameter("resetList"))) {
            context.getSession().removeAttribute("AccountContactCallsListInfo");
            context.getSession().removeAttribute("AccountContactCompletedCallsListInfo");
        }
        String sectionId = null;
        if (context.getRequest().getParameter("pagedListSectionId") != null) {
            sectionId = context.getRequest().getParameter("pagedListSectionId");
        }
        this.addModuleBean(context, "Activities", "View Activities");
        Connection db = null;
        CallList callList = new CallList();
        String pendingPagedListId = "AccountContactCallsListInfo";
        if (sectionId == null || pendingPagedListId.equals(sectionId)) {
            PagedListInfo callListInfo = this.getPagedListInfo(context, pendingPagedListId, "c.alertdate", null);
            callListInfo.setLink("AccountsCalls.do?command=View&orgId=" + orgId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId"));
            if (sectionId == null) {
                if (!callListInfo.getExpandedSelection()) {
                    if (callListInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                        callListInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                    }
                } else if (callListInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                    callListInfo.setItemsPerPage(10);
                }
            } else if (sectionId.equals(callListInfo.getId())) {
                callListInfo.setExpandedSelection(true);
            }
            callList.setPagedListInfo(callListInfo);
            callList.setOnlyPending(true);
            callList.setOrgId(orgId);
            callList.setAllContactsInAccount(true, Integer.parseInt(orgId));
        }
        CallList completedCallList = new CallList();
        String completedPagedListId = "AccountContactCompletedCallsListInfo";
        if (sectionId == null || completedPagedListId.equals(sectionId)) {
            PagedListInfo completedCallListInfo = this.getPagedListInfo(context, completedPagedListId, "c.entered", "desc");
            completedCallListInfo.setLink("AccountsCalls.do?command=View&orgId=" + orgId + RequestUtils.addLinkParams(context.getRequest(), "popup|popupType|actionId"));
            if (sectionId == null) {
                if (!completedCallListInfo.getExpandedSelection()) {
                    if (completedCallListInfo.getItemsPerPage() != MINIMIZED_ITEMS_PER_PAGE) {
                        completedCallListInfo.setItemsPerPage(MINIMIZED_ITEMS_PER_PAGE);
                    }
                } else if (completedCallListInfo.getItemsPerPage() == MINIMIZED_ITEMS_PER_PAGE) {
                    completedCallListInfo.setItemsPerPage(10);
                }
            } else if (sectionId.equals(completedCallListInfo.getId())) {
                completedCallListInfo.setExpandedSelection(true);
            }
            completedCallList.setPagedListInfo(completedCallListInfo);
            completedCallList.setOrgId(orgId);
            completedCallList.setAllContactsInAccount(true, Integer.parseInt(orgId));
            completedCallList.setOnlyCompletedOrCanceled(true);
        }
        try {
            db = this.getConnection(context);
            this.addFormElements(context, db);
            Organization tmpOrganization = (Organization)((Object)context.getRequest().getAttribute("OrgDetails"));
            if (!AccountsCalls.isRecordAccessPermitted(context, db, tmpOrganization.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            if (tmpOrganization.isTrashed()) {
                callList.setIncludeOnlyTrashed(true);
            } else {
                callList.setAvoidDisabledContacts(1);
            }
            if (sectionId == null || pendingPagedListId.equals(sectionId)) {
                callList.buildList(db);
            }
            if (tmpOrganization.isTrashed()) {
                completedCallList.setIncludeOnlyTrashed(true);
            } else {
                completedCallList.setAvoidDisabledContacts(1);
            }
            if (sectionId == null || completedPagedListId.equals(sectionId)) {
                completedCallList.buildList(db);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("CallList", (Object)callList);
        context.getRequest().setAttribute("trailSource", (Object)"accounts");
        context.getRequest().setAttribute("CompletedCallList", (Object)completedCallList);
        return AccountsCalls.getReturn(context, "View");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandLog(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-calls-add")) {
            return "PermissionError";
        }
        String orgId = context.getRequest().getParameter("orgId");
        this.addModuleBean(context, "View Accounts", "Log an Activity");
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.addFormElements(context, db);
            ContactList cl = new ContactList();
            cl.setOrgId(orgId);
            cl.buildList(db);
            context.getRequest().setAttribute("contactList", (Object)cl);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
            reminderList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("actionSource", (Object)"accountItem");
        context.getRequest().setAttribute("trailSource", (Object)"accounts");
        return AccountsCalls.getReturn(context, "Log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSchedule(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-calls-add")) {
            return "PermissionError";
        }
        String orgId = context.getRequest().getParameter("orgId");
        this.addModuleBean(context, "View Accounts", "Log an Activity");
        Connection db = null;
        try {
            db = this.getConnection(context);
            this.addFormElements(context, db);
            ContactList cl = new ContactList();
            cl.setOrgId(orgId);
            cl.buildList(db);
            context.getRequest().setAttribute("contactList", (Object)cl);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
            reminderList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("actionSource", (Object)"accountItem");
        context.getRequest().setAttribute("trailSource", (Object)"accounts");
        context.getRequest().setAttribute("action", (Object)"schedule");
        return AccountsCalls.getReturn(context, "Schedule");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-calls-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Activities");
        String callId = context.getRequest().getParameter("id");
        Connection db = null;
        Call thisCall = null;
        try {
            db = this.getConnection(context);
            this.addFormElements(context, db);
            thisCall = new Call(db, callId);
            if (thisCall.getAlertDate() != null) {
                SystemStatus systemStatus = this.getSystemStatus(context);
                LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
                context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
            }
            CallResult thisResult = null;
            if (thisCall.getResultId() > 0) {
                thisResult = new CallResult(db, thisCall.getResultId());
            }
            context.getRequest().setAttribute("CallResult", thisResult);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("CallDetails", (Object)thisCall);
        return AccountsCalls.getReturn(context, "Details");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        String permission = "accounts-accounts-contacts-calls-add";
        boolean recordInserted = false;
        boolean isValid = false;
        int resultCount = -1;
        Call parentCall = null;
        Call previousCall = null;
        int tmpStatusId = -1;
        this.addModuleBean(context, "View Accounts", "Save an Activity");
        String contactId = context.getRequest().getParameter("contactId");
        String followupContactId = context.getRequest().getParameter("followupContactId");
        String parentId = context.getRequest().getParameter("parentId");
        String action = context.getRequest().getParameter("action");
        Call thisCall = (Call)((Object)context.getFormBean());
        Call previousParentCall = null;
        thisCall.setModifiedBy(this.getUserId(context));
        thisCall.setContactId(contactId);
        if (followupContactId != null && !"".equals(followupContactId)) {
            thisCall.setFollowupContactId(followupContactId);
        }
        if (thisCall.getId() > 0) {
            permission = "accounts-accounts-contacts-calls-edit";
        }
        if (!this.hasPermission(context, permission)) {
            return "PermissionError";
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (parentId != null && Integer.parseInt(parentId) > -1) {
                parentCall = new Call(db, Integer.parseInt(parentId));
            }
            if ((tmpStatusId = thisCall.getStatusId()) == 3 && !"pending".equals(context.getRequest().getParameter("view"))) {
                thisCall.setCheckAlertDate(false);
            }
            if (thisCall.getId() > 0) {
                previousCall = new Call(db, thisCall.getId());
                if (thisCall.getStatusId() == 2 && previousCall.getAlertDate() == null && thisCall.getAlertDate() != null) {
                    thisCall.setStatusId(3);
                }
                if (isValid = this.validateObject(context, db, (Object)thisCall)) {
                    resultCount = thisCall.update(db, context);
                }
            } else {
                if (thisCall.getId() == -1) {
                    if ("cancel".equals(action)) {
                        thisCall.setStatusId(1);
                    } else if (thisCall.getAlertDate() != null) {
                        thisCall.setStatusId(3);
                    } else {
                        thisCall.setStatusId(2);
                    }
                }
                thisCall.setEnteredBy(this.getUserId(context));
                if (parentCall != null && parentCall.getOppHeaderId() != -1) {
                    thisCall.setOppHeaderId(parentCall.getOppHeaderId());
                }
                thisCall.setAction(context.getRequest().getParameter("action"));
                isValid = this.validateObject(context, db, (Object)thisCall);
                if (isValid) {
                    recordInserted = thisCall.insert(db, context);
                }
            }
            if ("schedule".equals(context.getRequest().getParameter("action"))) {
                context.getRequest().setAttribute("actionSource", (Object)"accountItem");
                context.getRequest().setAttribute("action", (Object)"schedule");
            }
            this.addFormElements(context, db);
            ContactList cl = new ContactList();
            cl.setOrgId(thisCall.getOrgId());
            cl.buildList(db);
            context.getRequest().setAttribute("contactList", (Object)cl);
            if (!recordInserted && resultCount == -1) {
                thisCall.setStatusId(tmpStatusId);
                if (thisCall.getAlertText() != null && !"".equals(thisCall.getAlertText())) {
                    thisCall.setHasFollowup(true);
                }
                if (thisCall.getId() > 0) {
                    Call tempCall = new Call(db, thisCall.getId());
                    thisCall.setCallType(tempCall.getCallType());
                    this.addModifyFormElements(db, context, thisCall);
                    if (resultCount == 0) {
                        HashMap<String, String> errors = new HashMap<String, String>();
                        SystemStatus systemStatus = this.getSystemStatus(context);
                        errors.put("actionError", systemStatus.getLabel("object.validation.recordUpdatedByAnotherUser"));
                        this.processErrors(context, errors);
                        context.getRequest().setAttribute("CallDetails", (Object)tempCall);
                    }
                }
            } else {
                if (parentCall != null) {
                    previousParentCall = new Call(db, parentCall.getId());
                    parentCall.setStatusId(2);
                    parentCall.update(db, context);
                    this.processUpdateHook(context, (Object)previousParentCall, (Object)parentCall);
                }
                thisCall = new Call(db, thisCall.getId());
                if (recordInserted) {
                    this.processInsertHook(context, (Object)thisCall);
                } else if (resultCount == 1) {
                    this.processUpdateHook(context, (Object)previousCall, (Object)thisCall);
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (recordInserted) {
            if (context.getRequest().getParameter("actionSource") != null) {
                return AccountsCalls.getReturn(context, "InsertCall");
            }
            return "ListOK";
        }
        if (resultCount == 1) {
            if ("list".equals(context.getRequest().getParameter("return"))) {
                return "ListOK";
            }
            return AccountsCalls.getReturn(context, "Update");
        }
        if (parentId != null && Integer.parseInt(parentId) > -1) {
            if (action != null && "cancel".equals(action)) {
                return this.executeCommandCancel(context);
            }
            return this.executeCommandComplete(context);
        }
        if (thisCall.getId() > 0) {
            return AccountsCalls.getReturn(context, "Modify");
        }
        return this.executeCommandLog(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-calls-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Modify an Activity");
        String contactId = context.getRequest().getParameter("contactId");
        String orgId = context.getRequest().getParameter("orgId");
        int callId = Integer.parseInt(context.getRequest().getParameter("id"));
        Connection db = null;
        Call thisCall = null;
        try {
            db = this.getConnection(context);
            thisCall = new Call(db, callId);
            Contact thisContact = this.addFormElements(context, db);
            ContactList cl = new ContactList();
            cl.setOrgId(orgId);
            cl.buildList(db);
            context.getRequest().setAttribute("contactList", (Object)cl);
            this.addModifyFormElements(db, context, thisCall);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("CallDetails", (Object)thisCall);
        context.getRequest().setAttribute("action", (Object)context.getRequest().getParameter("action"));
        context.getRequest().setAttribute("actionSource", (Object)"accountItem");
        return AccountsCalls.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandComplete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-calls-edit")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Complete Activity");
        String contactId = context.getRequest().getParameter("contactId");
        int callId = -1;
        callId = context.getRequest().getParameter("parentId") != null && !"".equals(context.getRequest().getParameter("parentId")) ? Integer.parseInt(context.getRequest().getParameter("parentId")) : Integer.parseInt(context.getRequest().getParameter("id"));
        Connection db = null;
        Call thisCall = null;
        try {
            db = this.getConnection(context);
            thisCall = new Call(db, callId);
            context.getRequest().setAttribute("PreviousCallDetails", (Object)thisCall);
            Contact thisContact = this.addFormElements(context, db);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
            LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
            context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return AccountsCalls.getReturn(context, "Log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCancel(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-calls-delete")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Accounts", "Cancel Activity");
        String contactId = context.getRequest().getParameter("contactId");
        int callId = -1;
        callId = context.getRequest().getParameter("parentId") != null && !"".equals(context.getRequest().getParameter("parentId")) ? Integer.parseInt(context.getRequest().getParameter("parentId")) : Integer.parseInt(context.getRequest().getParameter("id"));
        Connection db = null;
        Call thisCall = null;
        try {
            db = this.getConnection(context);
            thisCall = new Call(db, callId);
            context.getRequest().setAttribute("PreviousCallDetails", (Object)thisCall);
            Call nextCall = new Call();
            nextCall.setCallTypeId(thisCall.getAlertCallTypeId());
            nextCall.setSubject(thisCall.getAlertText());
            nextCall.setNotes(thisCall.getFollowupNotes());
            nextCall.setContactId(thisCall.getFollowupContactId());
            context.getRequest().setAttribute("CallDetails", (Object)nextCall);
            Contact thisContact = this.addFormElements(context, db);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
            callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
            ContactList cl = new ContactList();
            cl.setOrgId(thisCall.getOrgId());
            cl.buildList(db);
            context.getRequest().setAttribute("contactList", (Object)cl);
            LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
            context.getRequest().setAttribute("PriorityList", (Object)priorityList);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("action", (Object)context.getRequest().getParameter("action"));
        return AccountsCalls.getReturn(context, "Log");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-calls-delete")) {
            return "PermissionError";
        }
        boolean recordDeleted = false;
        String contactId = context.getRequest().getParameter("contactId");
        Call thisCall = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        try {
            db = this.getConnection(context);
            Contact thisContact = new Contact(db, contactId);
            thisCall = new Call(db, context.getRequest().getParameter("id"));
            recordDeleted = thisCall.delete(db);
            if (!recordDeleted) {
                thisCall.getErrors().put("actionError", systemStatus.getLabel("obejct.validation.actionError.callDeletion"));
                this.processErrors(context, thisCall.getErrors());
            }
            this.addFormElements(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        boolean inLinePopup = "inline".equals(context.getRequest().getParameter("popupType"));
        if (recordDeleted) {
            context.getRequest().setAttribute("contactId", (Object)contactId);
            context.getRequest().setAttribute("refreshUrl", (Object)("AccountContactsCalls.do?command=View&contactId=" + contactId + RequestUtils.addLinkParams(context.getRequest(), "popupType|actionId" + (inLinePopup ? "|popup" : ""))));
            return AccountsCalls.getReturn(context, "Delete");
        }
        this.processErrors(context, thisCall.getErrors());
        return this.executeCommandView(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandForwardCall(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-calls-view")) {
            return "PermissionError";
        }
        int noteType = -1;
        String msgId = context.getRequest().getParameter("id");
        CFSNote newNote = null;
        this.addModuleBean(context, "View Accounts", "Forward Activity");
        Connection db = null;
        Call thisCall = null;
        try {
            noteType = Integer.parseInt(context.getRequest().getParameter("forwardType"));
            context.getRequest().setAttribute("forwardType", (Object)"15");
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            newNote = new CFSNote();
            thisCall = new Call(db, msgId);
            String contactName = systemStatus.getLabel("mail.label.contactName");
            String type = systemStatus.getLabel("mail.label.type");
            String length = systemStatus.getLabel("mail.label.length");
            String subject = systemStatus.getLabel("mail.label.subject.colon");
            String notes = systemStatus.getLabel("mail.label.notes");
            String entered = systemStatus.getLabel("mail.label.entered");
            String modified = systemStatus.getLabel("mail.label.modified");
            newNote.setBody(contactName + StringUtils.toString(thisCall.getContactName()) + "\n" + type + StringUtils.toString(thisCall.getCallType()) + "\n" + length + StringUtils.toString(thisCall.getLengthText()) + "\n" + subject + StringUtils.toString(thisCall.getSubject()) + (!StringUtils.toString(thisCall.getSubject()).equals(StringUtils.toString(thisCall.getAlertText())) && !"".equals(StringUtils.toString(thisCall.getAlertText())) ? "\\" + StringUtils.toString(thisCall.getAlertText()) : "") + "\n" + notes + StringUtils.toString(thisCall.getNotes()) + "\n" + entered + StringUtils.toString(thisCall.getEnteredName()) + " - " + DateUtils.getServerToUserDateTimeString(this.getUserTimeZone(context), 3, 1, thisCall.getEntered()) + "\n" + modified + StringUtils.toString(thisCall.getModifiedName()) + " - " + DateUtils.getServerToUserDateTimeString(this.getUserTimeZone(context), 3, 1, thisCall.getModified()));
            this.addFormElements(context, db);
            this.freeConnection(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("action", (Object)context.getRequest().getParameter("action"));
        context.getRequest().setAttribute("Note", (Object)newNote);
        return AccountsCalls.getReturn(context, "ForwardMessage");
    }

    public Contact addFormElements(ActionContext context, Connection db) throws SQLException {
        String contactId = context.getRequest().getParameter("contactId");
        String orgId = context.getRequest().getParameter("orgId");
        Contact thisContact = (Contact)((Object)context.getRequest().getAttribute("ContactDetails"));
        Organization thisOrganization = null;
        if (thisContact == null && contactId != null && !"-1".equals(contactId)) {
            thisContact = new Contact(db, contactId);
            context.getRequest().setAttribute("ContactDetails", (Object)thisContact);
            if (thisContact.getOrgId() > -1) {
                thisOrganization = new Organization(db, thisContact.getOrgId());
                context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
            }
        } else if (orgId != null && !"-1".equals(orgId)) {
            thisOrganization = new Organization(db, Integer.parseInt(orgId));
            context.getRequest().setAttribute("OrgDetails", (Object)thisOrganization);
        }
        return thisContact;
    }

    private void addModifyFormElements(Connection db, ActionContext context, Call thisCall) throws SQLException {
        SystemStatus systemStatus = this.getSystemStatus(context);
        LookupList callTypeList = systemStatus.getLookupList(db, "lookup_call_types");
        callTypeList.addItem(0, systemStatus.getLabel("calendar.none.4dashes"));
        context.getRequest().setAttribute("CallTypeList", (Object)callTypeList);
        LookupList reminderList = systemStatus.getLookupList(db, "lookup_call_reminder");
        context.getRequest().setAttribute("ReminderTypeList", (Object)reminderList);
        LookupList priorityList = systemStatus.getLookupList(db, "lookup_call_priority");
        context.getRequest().setAttribute("PriorityList", (Object)priorityList);
        if ("pending".equals(context.getRequest().getParameter("view")) || thisCall.getStatusId() == 2 && (thisCall.getAlertDate() == null || context.getRequest().getAttribute("alertDateWarning") != null)) {
            if (thisCall.getResultId() != -1) {
                CallResult thisResult = new CallResult(db, thisCall.getResultId());
                context.getRequest().setAttribute("CallResult", (Object)thisResult);
            }
            if (!"pending".equals(context.getRequest().getParameter("view"))) {
                CallResultList resultList = new CallResultList();
                resultList.buildList(db);
                context.getRequest().setAttribute("callResultList", (Object)resultList);
            }
        } else {
            CallResultList resultList = new CallResultList();
            resultList.buildList(db);
            context.getRequest().setAttribute("callResultList", (Object)resultList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSuggestCall(ActionContext context) {
        String resultId = context.getRequest().getParameter("resultId");
        Connection db = null;
        try {
            db = this.getConnection(context);
            CallResult thisResult = new CallResult(db, Integer.parseInt(resultId));
            context.getRequest().setAttribute("CallResult", (Object)thisResult);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("action", (Object)context.getRequest().getParameter("action"));
        return AccountsCalls.getReturn(context, "SuggestCall");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSendCall(ActionContext context) {
        if (!this.hasPermission(context, "accounts-accounts-contacts-calls-view")) {
            return "PermissionError";
        }
        String callId = context.getRequest().getParameter("id");
        this.addModuleBean(context, "View Accounts", "Send Activity");
        Connection db = null;
        try {
            db = this.getConnection(context);
            Call thisCall = new Call(db, callId);
            context.getRequest().setAttribute("CallDetails", (Object)thisCall);
            this.addFormElements(context, db);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("action", (Object)context.getRequest().getParameter("action"));
        return "SendCallOK";
    }
}

